/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.udp;

import gama.core.messaging.GamaMessage;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.extension.network.common.Connector;
import gama.extension.network.common.ConnectorMessage;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.udp.MultiThreadedUDPSocketServer;
import gama.gaml.operators.Cast;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UDPConnector
extends Connector {
    public static final String _UDP_SERVER = "__udp_server";
    private boolean is_server = false;

    public UDPConnector(IScope iScope, boolean bl) {
        this.is_server = bl;
    }

    @Override
    public List<ConnectorMessage> fetchMessageBox(IAgent iAgent) {
        return super.fetchMessageBox(iAgent);
    }

    @Override
    public Map<IAgent, LinkedList<ConnectorMessage>> fetchAllMessages() {
        for (IAgent iAgent : this.receivedMessage.keySet()) {
            IList iList = (IList)iAgent.getAttribute("messages" + String.valueOf(iAgent));
            if (iList == null) continue;
            ((LinkedList)this.receivedMessage.get(iAgent)).addAll(iList);
            iList.clear();
            iAgent.setAttribute("message" + String.valueOf(iAgent), (Object)iList);
        }
        return super.fetchAllMessages();
    }

    public void openServerSocket(IAgent iAgent) {
        Integer n = Cast.asInt((IScope)iAgent.getScope(), (Object)this.getConfigurationParameter("SERVER_PORT"));
        if (iAgent.getSimulation().getAttribute(_UDP_SERVER + String.valueOf(n)) == null) {
            try {
                DatagramSocket datagramSocket = new DatagramSocket(n);
                MultiThreadedUDPSocketServer multiThreadedUDPSocketServer = new MultiThreadedUDPSocketServer(iAgent, datagramSocket, this.getConfigurationParameter("PACKET_SIZE"));
                multiThreadedUDPSocketServer.start();
                iAgent.getSimulation().setAttribute(_UDP_SERVER + String.valueOf(n), (Object)multiThreadedUDPSocketServer);
            }
            catch (Exception exception) {
                throw GamaRuntimeException.create((Throwable)exception, (IScope)iAgent.getScope());
            }
        }
    }

    @Override
    protected void connectToServer(IAgent iAgent) throws GamaNetworkException {
        if (this.is_server) {
            this.openServerSocket(iAgent);
        }
    }

    @Override
    protected void sendMessage(IAgent iAgent, String string, String string2) throws GamaNetworkException {
        String string3 = string2.replace("\b\r", "@b@@r@");
        string3 = string3.replace("\n", "@n@");
        String string4 = this.getConfigurationParameter("SERVER_PORT");
        Integer n = Cast.asInt((IScope)iAgent.getScope(), (Object)string4);
        String string5 = this.getConfigurationParameter("SERVER_URL");
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (DatagramSocket datagramSocket = new DatagramSocket();){
                InetAddress inetAddress = InetAddress.getByName(string5);
                byte[] byArray = string3.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
                datagramPacket.setData(byArray);
                datagramSocket.send(datagramPacket);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void send(IAgent iAgent, String string, GamaMessage gamaMessage) {
        this.sendMessage(iAgent, string, (String)gamaMessage.getContents(iAgent.getScope()));
    }

    @Override
    protected void subscribeToGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected void unsubscribeGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected boolean isAlive(IAgent iAgent) throws GamaNetworkException {
        String string = this.getConfigurationParameter("SERVER_PORT");
        Integer n = Cast.asInt((IScope)iAgent.getScope(), (Object)string);
        Thread thread = (Thread)iAgent.getSimulation().getAttribute(_UDP_SERVER + String.valueOf(n));
        return thread != null && thread.isAlive();
    }

    @Override
    protected void releaseConnection(IScope iScope) throws GamaNetworkException {
        String string = this.getConfigurationParameter("SERVER_PORT");
        Integer n = Cast.asInt((IScope)iScope, (Object)string);
        MultiThreadedUDPSocketServer multiThreadedUDPSocketServer = (MultiThreadedUDPSocketServer)iScope.getSimulation().getAttribute(_UDP_SERVER + String.valueOf(n));
        try {
            if (multiThreadedUDPSocketServer != null) {
                multiThreadedUDPSocketServer.getMyServerSocket().close();
                multiThreadedUDPSocketServer.interrupt();
                iScope.getSimulation().setAttribute(_UDP_SERVER + String.valueOf(n), null);
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)iScope);
        }
    }

    @Override
    public SocketService getSocketService() {
        return null;
    }
}

