/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.httprequest;

import gama.core.messaging.GamaMailbox;
import gama.core.messaging.GamaMessage;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaList;
import gama.core.util.IMap;
import gama.extension.network.common.Connector;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.httprequest.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class HTTPRequestConnector
extends Connector {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "80";
    String host;
    String port;
    private HttpRequest request;

    public HTTPRequestConnector(IScope iScope) {
    }

    @Override
    protected void connectToServer(IAgent iAgent) throws GamaNetworkException {
        String string = this.getConfigurationParameter("SERVER_URL");
        String string2 = this.getConfigurationParameter("SERVER_PORT");
        this.host = string == null ? DEFAULT_HOST : string;
        this.port = string2 == null ? DEFAULT_PORT : string2;
    }

    @Override
    protected boolean isAlive(IAgent iAgent) throws GamaNetworkException {
        return false;
    }

    @Override
    protected void subscribeToGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected void unsubscribeGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected void releaseConnection(IScope iScope) throws GamaNetworkException {
    }

    @Override
    public void send(IAgent iAgent, String string, GamaMessage gamaMessage) {
        Object object = gamaMessage.getContents(iAgent.getScope());
        try {
            if (!(object instanceof GamaList)) {
                throw GamaNetworkException.cannotSendMessage(null, "The content expected to be sent is well formatted, a list [method,body,headers] is expected.");
            }
            GamaList gamaList = (GamaList)object;
            URI uRI = null;
            try {
                uRI = Utils.buildURI(this.host, this.port, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI);
            IMap iMap = null;
            String string2 = "";
            String string3 = (String)gamaList.get(0);
            if ("GET".equals(string3) || "DELETE".equals(string3)) {
                IMap iMap2 = iMap = gamaList.size() > 1 ? (IMap)gamaList.get(1) : null;
                if (gamaList.size() > 2) {
                    throw GamaNetworkException.cannotSendMessage(null, String.valueOf(uRI) + ". GET/DELETE HTTP method are expecting [method] or [method,headers] only. No body.");
                }
            } else {
                if (gamaList.size() <= 1) {
                    throw GamaNetworkException.cannotSendMessage(null, String.valueOf(uRI) + ". POST/PUT HTTP method are expecting a body.");
                }
                string2 = (String)gamaList.get(1);
                IMap iMap3 = iMap = gamaList.size() > 2 ? (IMap)gamaList.get(2) : null;
            }
            if (iMap != null) {
                for (String string4 : iMap.keySet()) {
                    builder.header(string4, (String)iMap.get((Object)string4));
                }
            }
            this.request = switch (string3) {
                case "GET" -> builder.GET().build();
                case "POST" -> builder.POST(HttpRequest.BodyPublishers.ofString(string2)).build();
                case "PUT" -> builder.PUT(HttpRequest.BodyPublishers.ofString(string2)).build();
                case "DELETE" -> builder.DELETE().build();
                default -> throw GamaNetworkException.cannotSendMessage(null, "Bad HTTP action");
            };
            this.sendMessage(iAgent, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void sendMessage(IAgent iAgent, String string, String string2) throws GamaNetworkException {
        try {
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(this.request, HttpResponse.BodyHandlers.ofString());
            IMap<String, Object> iMap = Utils.formatResponse(httpResponse);
            GamaMailbox gamaMailbox = (GamaMailbox)iAgent.getAttribute("messaging_skill_mailbox");
            if (gamaMailbox == null) {
                gamaMailbox = new GamaMailbox();
                iAgent.setAttribute("messaging_skill_mailbox", (Object)gamaMailbox);
            }
            GamaMessage gamaMessage = new GamaMessage(iAgent.getScope(), (Object)"HTTP", (Object)iAgent.getName(), iMap);
            gamaMailbox.add((Object)gamaMessage);
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public SocketService getSocketService() {
        return null;
    }
}

