/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.websocket;

import gama.core.metamodel.agent.IAgent;
import gama.extension.network.common.IConnector;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.tcp.ServerService;
import gama.extension.network.websocket.GamaServer;
import gama.extension.network.websocket.WebSocketConnector;
import java.io.IOException;
import java.net.UnknownHostException;

public class WebSocketServerService
extends ServerService {
    protected GamaServer gamaServer;

    public WebSocketServerService(IAgent iAgent, int n, IConnector iConnector) {
        super(iAgent, n, iConnector);
    }

    @Override
    public void startService() throws UnknownHostException, IOException {
        this.gamaServer = new GamaServer(this.port, this);
        this.isAlive = true;
        this.isOnline = true;
        this.start();
        this.gamaServer.start();
    }

    @Override
    public void run() {
        while (this.isAlive) {
            this.isOnline = true;
        }
        try {
            this.myAgent.setAttribute("__tcp_server" + this.gamaServer.getPort(), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void sendMessage(String string) throws IOException {
        String string2 = string;
        if (this.gamaServer == null || !this.isOnline()) {
            return;
        }
        if (!this.connector.isRaw()) {
            string2 = string2.replace("\n", "@n@");
            string2 = string2.replace("\b\r", "@b@@r@");
        }
        this.gamaServer.broadcast(string2);
    }

    @Override
    public void receivedMessage(String string, String string2) {
        MessageFactory.MessageType messageType = MessageFactory.identifyMessageType(string2);
        if (messageType.equals((Object)MessageFactory.MessageType.COMMAND_MESSAGE)) {
            ((WebSocketConnector)this.connector).extractAndApplyCommand(string, string2);
        } else {
            String string3 = ((WebSocketConnector)this.connector).isRaw() ? string2 : MessageFactory.unpackReceiverName(string2);
            ((WebSocketConnector)this.connector).storeMessage(string, string3, string2);
        }
    }

    @Override
    public void stopService() {
        this.isOnline = false;
        this.isAlive = false;
        if (this.sender != null) {
            this.sender.close();
        }
        if (this.gamaServer != null) {
            try {
                this.gamaServer.stop(1000);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.interrupt();
    }
}

