/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.serial;

import gama.core.messaging.GamaMailbox;
import gama.core.messaging.GamaMessage;
import gama.core.metamodel.agent.IAgent;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.extension.network.serial.MyArduino;

public class MultiThreadedArduinoReceiver
extends Thread {
    private final IAgent myAgent;
    private volatile boolean closed = false;
    private int timer = 1000;
    private final MyArduino arduino;

    static {
        DEBUG.ON();
    }

    public MultiThreadedArduinoReceiver(IAgent iAgent, int n, MyArduino myArduino) {
        this.myAgent = iAgent;
        this.arduino = myArduino;
        this.timer = n;
    }

    @Override
    public void run() {
        System.out.println("START OF THE THREAD");
        while (!this.closed) {
            System.out.println("enter while");
            try {
                if (this.myAgent.dead()) {
                    this.interrupt();
                }
                String string = this.arduino.serialRead(1);
                GamaMailbox gamaMailbox = (GamaMailbox)this.myAgent.getAttribute("messaging_skill_mailbox");
                if (gamaMailbox == null) {
                    gamaMailbox = new GamaMailbox();
                    this.myAgent.setAttribute("messaging_skill_mailbox", (Object)gamaMailbox);
                }
                if (this.myAgent.dead()) {
                    this.interrupt();
                }
                GamaMessage gamaMessage = new GamaMessage(this.myAgent.getScope(), (Object)"Arduino", (Object)this.myAgent.getName(), (Object)string);
                gamaMailbox.add((Object)gamaMessage);
            }
            catch (Exception exception) {
                this.closed = true;
                this.interrupt();
                exception.printStackTrace();
            }
            THREADS.WAIT((long)this.timer, (String[])new String[0]);
        }
    }
}

