/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.common;

import gama.core.messaging.GamaMessage;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.extension.network.common.CompositeGamaMessage;
import gama.extension.network.common.ConnectorMessage;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.IConnector;
import gama.extension.network.common.LocalMessage;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.common.NetworkMessage;
import gama.extension.serialize.binary.BinarySerialisation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Connector
implements IConnector {
    private static final int FETCH_ALL_MESSAGE_THREAD_SAFE_ACTION = 5;
    private static final int PUSH_RECEIVED_MESSAGE_THREAD_SAFE_ACTION = 8;
    protected Map<String, String> connectionParameter;
    protected Map<String, ArrayList<IAgent>> boxFollower;
    protected Map<IAgent, LinkedList<ConnectorMessage>> receivedMessage;
    protected Map<String, IAgent> localMemberNames;
    protected List<String> topicSuscribingPending;
    protected boolean isConnected = false;
    Object lockGroupManagment = new Object();
    boolean forceNetworkUse = false;
    private boolean isRaw = false;

    protected Connector() {
        this.boxFollower = new HashMap<String, ArrayList<IAgent>>();
        this.topicSuscribingPending = Collections.synchronizedList(new ArrayList());
        this.connectionParameter = new HashMap<String, String>();
        this.receivedMessage = new HashMap<IAgent, LinkedList<ConnectorMessage>>();
        this.localMemberNames = new HashMap<String, IAgent>();
    }

    @Override
    public void forceNetworkUse(boolean bl) {
        this.forceNetworkUse = bl;
    }

    @Override
    public void configure(String string, String string2) {
        this.connectionParameter.put(string, string2);
    }

    protected String getConfigurationParameter(String string) {
        return this.connectionParameter.get(string);
    }

    protected void setConnected() {
        this.isConnected = true;
    }

    @Override
    public List<ConnectorMessage> fetchMessageBox(IAgent iAgent) {
        List list = this.receivedMessage.get(iAgent);
        this.receivedMessage.put(iAgent, new LinkedList());
        return list;
    }

    public void storeMessage(String string, String string2, String string3) throws GamaNetworkException {
        NetworkMessage networkMessage = MessageFactory.unPackNetworkMessage(string, string2, string3);
        if (!this.localMemberNames.containsKey(networkMessage.getSender())) {
            this.pushAndFetchthreadSafe(8, networkMessage.getReceiver(), networkMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IAgent, LinkedList<ConnectorMessage>> pushAndFetchthreadSafe(int n, String string, ConnectorMessage connectorMessage) {
        Object object = this.lockGroupManagment;
        synchronized (object) {
            switch (n) {
                case 5: {
                    IAgent iAgent2;
                    HashMap<IAgent, LinkedList<ConnectorMessage>> hashMap = new HashMap<IAgent, LinkedList<ConnectorMessage>>();
                    for (IAgent iAgent2 : this.receivedMessage.keySet()) {
                        hashMap.put(iAgent2, new LinkedList());
                    }
                    iAgent2 = this.receivedMessage;
                    this.receivedMessage = hashMap;
                    return iAgent2;
                }
                case 8: {
                    ArrayList<IAgent> arrayList = this.boxFollower.get(string) == null ? this.boxFollower.get("ALL") : this.boxFollower.get(string);
                    for (IAgent iAgent : arrayList) {
                        LinkedList<ConnectorMessage> linkedList = this.receivedMessage.get(iAgent);
                        if (linkedList == null) continue;
                        linkedList.add(connectorMessage);
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public void send(IAgent iAgent, String string, GamaMessage gamaMessage) {
        if (!this.forceNetworkUse && this.boxFollower.containsKey(string)) {
            LocalMessage localMessage = new LocalMessage((String)iAgent.getAttribute("network_name"), string, gamaMessage);
            this.pushAndFetchthreadSafe(8, string, localMessage);
            return;
        }
        if (!this.localMemberNames.containsKey(string)) {
            if (!this.isRaw()) {
                CompositeGamaMessage compositeGamaMessage = new CompositeGamaMessage(iAgent.getScope(), gamaMessage);
                if (compositeGamaMessage.getSender() instanceof IAgent) {
                    compositeGamaMessage.setSender(iAgent.getAttribute("network_name"));
                }
                NetworkMessage networkMessage = MessageFactory.buildNetworkMessage((String)iAgent.getAttribute("network_name"), string, BinarySerialisation.saveToString((IScope)iAgent.getScope(), (Object)((Object)compositeGamaMessage)));
                this.sendMessage(iAgent, string, MessageFactory.packMessage(networkMessage));
            } else {
                this.sendMessage(iAgent, string, gamaMessage.getContents(iAgent.getScope()).toString());
            }
        }
    }

    @Override
    public Map<IAgent, LinkedList<ConnectorMessage>> fetchAllMessages() {
        return this.pushAndFetchthreadSafe(5, null, null);
    }

    @Override
    public void close(IScope iScope) throws GamaNetworkException {
        this.releaseConnection(iScope);
        this.topicSuscribingPending.clear();
        this.boxFollower.clear();
        this.receivedMessage.clear();
        this.isConnected = false;
    }

    @Override
    public void leaveTheGroup(IAgent iAgent, String string) {
        this.unsubscribeGroup(iAgent, string);
        ArrayList<IAgent> arrayList = this.boxFollower.get(string);
        if (arrayList != null) {
            arrayList.remove(iAgent);
            if (arrayList.size() == 0) {
                this.boxFollower.remove(string);
            }
        }
    }

    @Override
    public void joinAGroup(IAgent iAgent, String string) {
        ArrayList<Object> arrayList;
        if (!this.receivedMessage.containsKey(iAgent)) {
            this.receivedMessage.put(iAgent, new LinkedList());
        }
        if ((arrayList = this.boxFollower.get(string)) == null) {
            this.subscribeToGroup(iAgent, string);
            arrayList = new ArrayList();
            this.boxFollower.put(string, arrayList);
        }
        if (!arrayList.contains(iAgent)) {
            arrayList.add(iAgent);
            this.subscribeToGroup(iAgent, string);
        }
    }

    @Override
    public void connect(IAgent iAgent) throws GamaNetworkException {
        String string = (String)iAgent.getAttribute("network_name");
        if (!this.forceNetworkUse && !this.localMemberNames.containsKey(string)) {
            this.localMemberNames.put(string, iAgent);
        }
        if (!this.isConnected) {
            this.connectToServer(iAgent);
        }
        if (this.receivedMessage.get(iAgent) == null && !this.isRaw()) {
            this.joinAGroup(iAgent, string);
        }
    }

    @Override
    public boolean isRaw() {
        return this.isRaw;
    }

    @Override
    public void setRaw(boolean bl) {
        this.isRaw = bl;
    }

    protected abstract void connectToServer(IAgent var1) throws GamaNetworkException;

    protected abstract boolean isAlive(IAgent var1) throws GamaNetworkException;

    protected abstract void subscribeToGroup(IAgent var1, String var2) throws GamaNetworkException;

    protected abstract void unsubscribeGroup(IAgent var1, String var2) throws GamaNetworkException;

    protected abstract void releaseConnection(IScope var1) throws GamaNetworkException;

    protected abstract void sendMessage(IAgent var1, String var2, String var3) throws GamaNetworkException;
}

