/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.websocket;

import gama.extension.network.common.IConnector;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.tcp.ClientService;
import gama.extension.network.websocket.GamaClient;
import gama.extension.network.websocket.WebSocketConnector;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class WebSocketClientService
extends ClientService {
    protected GamaClient client;

    public WebSocketClientService(Socket socket, IConnector iConnector) {
        super(socket, iConnector);
    }

    public WebSocketClientService(String string, int n, IConnector iConnector) {
        super(string, n, iConnector);
    }

    @Override
    public void startService() throws UnknownHostException, IOException {
        if (this.socket == null) {
            try {
                URI uRI = new URI("ws://" + this.server + ":" + this.port);
                this.client = new GamaClient(uRI, this);
                this.client.connectBlocking();
                this.socket = this.client.getSocket();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.isAlive = true;
        this.start();
    }

    @Override
    public void run() {
        while (this.isAlive) {
        }
    }

    @Override
    public void receivedMessage(String string, String string2) {
        MessageFactory.MessageType messageType = MessageFactory.identifyMessageType(string2);
        if (messageType.equals((Object)MessageFactory.MessageType.COMMAND_MESSAGE)) {
            ((WebSocketConnector)this.connector).extractAndApplyCommand(string, string2);
        } else {
            String string3 = ((WebSocketConnector)this.connector).isRaw() ? string2 : MessageFactory.unpackReceiverName(string2);
            ((WebSocketConnector)this.connector).storeMessage(string, string3, string2);
        }
    }

    @Override
    public void stopService() {
        this.isAlive = false;
        if (this.sender != null) {
            this.sender.close();
        }
        try {
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void sendMessage(String string, String string2) throws IOException {
        this.sendMessage(string);
    }

    @Override
    public void sendMessage(String string) throws IOException {
        if (this.socket == null || !this.isOnline()) {
            return;
        }
        this.sender = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
        Object object = string;
        if (!this.connector.isRaw()) {
            object = string.replaceAll("\n", "@n@").replaceAll("\b\r", "@b@@r@") + "\n";
        }
        this.client.send((String)object);
    }
}

