/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.common;

import gama.extension.network.common.CommandMessage;
import gama.extension.network.common.NetworkMessage;

public final class MessageFactory {
    private static final byte[] keyChain = new byte[]{3, 5, 8, 13};
    private static final int MAX_HEADER_SIZE = 1024;

    public static NetworkMessage buildNetworkMessage(String string, String string2, String string3) {
        return new NetworkMessage(string, string2, string3);
    }

    public static NetworkMessage buildNetworkMessage(String string, String string2) {
        return new NetworkMessage(string, string2);
    }

    public static CommandMessage buildCommandMessage(String string, String string2, CommandMessage.CommandType commandType, String string3) {
        return new CommandMessage(string, string2, commandType, string3);
    }

    public static String packMessage(NetworkMessage networkMessage) {
        String string = new String(keyChain);
        return string + networkMessage.getSender() + string + networkMessage.getReceiver() + string + networkMessage.getPlainContents();
    }

    public static String packMessage(CommandMessage commandMessage) {
        String string = new String(keyChain);
        return string + string + commandMessage.getSender() + string + commandMessage.getReceiver() + string + commandMessage.getCommand().ordinal() + string + commandMessage.getPlainContents();
    }

    public static MessageType identifyMessageType(String string) {
        String string2 = new String(keyChain);
        if (string != null) {
            if (string.length() >= keyChain.length * 2 && string.substring(0, keyChain.length * 2).equals(string2 + string2)) {
                return MessageType.COMMAND_MESSAGE;
            }
            if (string.length() >= keyChain.length && string.substring(0, keyChain.length).equals(string2)) {
                return MessageType.NETWORK_MESSAGE;
            }
        }
        return MessageType.PLAIN_MESSAGE;
    }

    public static NetworkMessage unPackNetworkMessage(String string, String string2, String string3) {
        String string4 = new String(keyChain);
        MessageType messageType = MessageFactory.identifyMessageType(string3);
        if (messageType == MessageType.COMMAND_MESSAGE) {
            return null;
        }
        if (messageType == MessageType.PLAIN_MESSAGE) {
            return new NetworkMessage(string, string2, string3, true);
        }
        int n = 1024 < string3.length() ? 1024 : string3.length();
        String string5 = string3.substring(0, n);
        String[] stringArray = string5.split(string4);
        String string6 = stringArray[1];
        String string7 = stringArray[2];
        String string8 = string3.substring(string6.length() + string7.length() + 3 * string4.length());
        return new NetworkMessage(string6, string7, string8);
    }

    public static CommandMessage unPackCommandMessage(String string, String string2) {
        String string3 = new String(keyChain);
        if (MessageFactory.identifyMessageType(string2) != MessageType.COMMAND_MESSAGE) {
            return null;
        }
        int n = 1024 < string2.length() ? 1024 : string2.length();
        String string4 = string2.substring(0, n);
        String[] stringArray = string4.split(string3);
        String string5 = stringArray[2];
        String string6 = stringArray[3];
        int n2 = Integer.parseInt(stringArray[4]);
        String string7 = string2.substring(string5.length() + string6.length() + stringArray[4].length() + 5 * string3.length());
        return new CommandMessage(string5, string6, CommandMessage.CommandType.values()[n2], string7);
    }

    public static String unpackReceiverName(String string) {
        String string2 = new String(keyChain);
        Object object = "";
        MessageType messageType = MessageFactory.identifyMessageType(string);
        if (messageType == MessageType.COMMAND_MESSAGE) {
            object = string2 + string2;
        }
        if (messageType == MessageType.NETWORK_MESSAGE) {
            object = string2;
        }
        if (messageType == MessageType.PLAIN_MESSAGE) {
            return "undefined";
        }
        String string3 = string.substring(((String)object).length());
        return string3.split(string2)[1];
    }

    public static enum MessageType {
        COMMAND_MESSAGE,
        NETWORK_MESSAGE,
        PLAIN_MESSAGE;

    }
}

