/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.tcp;

import gama.dev.DEBUG;
import gama.extension.network.common.Connector;
import gama.extension.network.common.IConnector;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.tcp.TCPConnector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ClientService
extends Thread
implements SocketService {
    protected Socket socket;
    protected final String server;
    protected final int port;
    protected BufferedReader receiver;
    protected PrintWriter sender;
    protected boolean isAlive;
    protected IConnector connector;

    public ClientService(String string, int n, IConnector iConnector) {
        this.port = n;
        this.server = string;
        this.connector = iConnector;
    }

    public ClientService(Socket socket, IConnector iConnector) {
        this.socket = socket;
        this.server = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        this.connector = iConnector;
    }

    @Override
    public String getRemoteAddress() {
        if (this.socket == null) {
            return null;
        }
        return String.valueOf(this.socket.getInetAddress()) + ":" + this.port;
    }

    @Override
    public String getLocalAddress() {
        if (this.socket == null) {
            return null;
        }
        return String.valueOf(this.socket.getLocalAddress()) + ":" + this.port;
    }

    @Override
    public void startService() throws UnknownHostException, IOException {
        if (this.socket == null) {
            this.socket = new Socket(this.server, this.port);
        }
        this.isAlive = true;
        this.start();
    }

    @Override
    public void stopService() {
        this.isAlive = false;
        if (this.sender != null) {
            this.sender.close();
        }
        try {
            if (this.receiver != null) {
                this.receiver.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean isOnline() {
        return this.isAlive;
    }

    @Override
    public void run() {
        try {
            while (this.isAlive) {
                this.receiver = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String string = this.receiver.readLine();
                if (string == null) continue;
                string = string.replaceAll("@n@", "\n");
                string = string.replaceAll("@b@@r@", "\b\r");
                this.receivedMessage(this.socket.toString(), string);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            DEBUG.LOG((Object)"Socket timeout");
        }
        catch (SocketException socketException) {
            DEBUG.LOG((Object)"Socket closed");
        }
        catch (IOException iOException) {
            DEBUG.LOG((Object)("Socket error" + String.valueOf(iOException)));
        }
    }

    @Override
    public void receivedMessage(String string, String string2) {
        MessageFactory.MessageType messageType = MessageFactory.identifyMessageType(string2);
        if (messageType.equals((Object)MessageFactory.MessageType.COMMAND_MESSAGE)) {
            ((TCPConnector)this.connector).extractAndApplyCommand(string, string2);
        } else {
            String string3 = this.connector.isRaw() ? string2 : MessageFactory.unpackReceiverName(string2);
            ((Connector)this.connector).storeMessage(string, string3, string2);
        }
    }

    @Override
    public void sendMessage(String string, String string2) throws IOException {
        if (this.socket == null || !this.isOnline()) {
            return;
        }
        this.sender = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
        if (this.connector.isRaw()) {
            this.sender.print(string);
            this.sender.flush();
        } else {
            String string3 = string.replaceAll("\n", "@n@").replaceAll("\b\r", "@b@@r@") + "\n";
            this.sender.println(string3);
        }
    }

    @Override
    public void sendMessage(String string) throws IOException {
        this.sendMessage(string, null);
    }
}

