/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.serial;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.network.common.Connector;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.serial.MultiThreadedArduinoReceiver;
import gama.extension.network.serial.MyArduino;
import gama.extension.network.serial.MyPortDropdownMenu;

public class ArduinoConnector
extends Connector {
    MyArduino arduino;
    String PORT = "";
    int BAUD = 9600;
    MultiThreadedArduinoReceiver ssThread;

    public ArduinoConnector(IScope iScope) {
    }

    @Override
    protected void connectToServer(IAgent iAgent) throws GamaNetworkException {
        MyPortDropdownMenu myPortDropdownMenu = new MyPortDropdownMenu();
        myPortDropdownMenu.refreshMenu();
        int n = 0;
        while (n < myPortDropdownMenu.getItemCount()) {
            System.out.println((String)myPortDropdownMenu.getItemAt(n));
            if (((String)myPortDropdownMenu.getItemAt(n)).contains("cu.usbmodem")) {
                System.out.println((String)myPortDropdownMenu.getItemAt(n));
                this.PORT = (String)myPortDropdownMenu.getItemAt(n);
            }
            ++n;
        }
        if ("".equals(this.PORT)) {
            this.PORT = this.getConfigurationParameter("SERVER_URL");
        }
        try {
            this.arduino = new MyArduino(this.PORT, this.BAUD);
        }
        catch (Exception exception) {
            GAMA.reportError((IScope)iAgent.getScope(), (GamaRuntimeException)GamaRuntimeException.warning((String)("Cannot connect Arduino to Port: " + this.PORT + " exception: " + exception.getMessage()), (IScope)iAgent.getScope()), (boolean)false);
            return;
        }
        if (this.arduino == null) {
            GAMA.reportError((IScope)iAgent.getScope(), (GamaRuntimeException)GamaRuntimeException.warning((String)("Cannot connect Arduino to Port: " + this.PORT), (IScope)iAgent.getScope()), (boolean)false);
            return;
        }
        if (this.arduino.openConnection()) {
            System.out.println("CONNECTION OPENED");
        }
        this.ssThread = new MultiThreadedArduinoReceiver(iAgent, 100, this.arduino);
        this.ssThread.start();
    }

    @Override
    protected boolean isAlive(IAgent iAgent) throws GamaNetworkException {
        return true;
    }

    @Override
    protected void subscribeToGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected void unsubscribeGroup(IAgent iAgent, String string) throws GamaNetworkException {
    }

    @Override
    protected void releaseConnection(IScope iScope) throws GamaNetworkException {
        if (this.ssThread != null) {
            this.ssThread.interrupt();
        }
        if (this.arduino != null) {
            this.arduino.closeConnection();
            System.out.println("CONNECTION CLOSED");
        }
    }

    @Override
    protected void sendMessage(IAgent iAgent, String string, String string2) throws GamaNetworkException {
    }

    @Override
    public SocketService getSocketService() {
        return null;
    }
}

