/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.mqtt;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.extension.network.common.Connector;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.socket.SocketService;
import java.util.Calendar;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public final class MQTTConnector
extends Connector {
    public static final String DEFAULT_USER = "gama_demo";
    public static final String DEFAULT_LOCAL_NAME;
    public static final String DEFAULT_PASSWORD = "gama_demo";
    public static final String DEFAULT_HOST = "broker.mqtt.cool";
    public static final String DEFAULT_PORT = "1883";
    protected MqttClient sendConnection = null;
    protected IScope simulationScope;

    static {
        DEBUG.OFF();
        DEFAULT_LOCAL_NAME = "gama-" + Calendar.getInstance().getTimeInMillis() + "@";
    }

    public MQTTConnector(IScope iScope, boolean bl) {
        this.simulationScope = iScope;
        this.setRaw(bl);
    }

    @Override
    protected void releaseConnection(IScope iScope) {
        try {
            if (this.sendConnection != null && this.sendConnection.isConnected()) {
                this.sendConnection.disconnect();
                this.sendConnection = null;
            }
        }
        catch (MqttException mqttException) {
            throw GamaNetworkException.cannotBeDisconnectedFailure(iScope);
        }
    }

    @Override
    protected void sendMessage(IAgent iAgent, String string, String string2) {
        MqttMessage mqttMessage = new MqttMessage(string2.getBytes());
        try {
            DEBUG.OUT((Object)("is connected " + this.sendConnection.isConnected()));
            this.sendConnection.publish(string, mqttMessage);
        }
        catch (MqttException mqttException) {
            DEBUG.OUT((Object)((Object)GamaNetworkException.cannotSendMessage(iAgent.getScope(), string)));
            throw GamaNetworkException.cannotSendMessage(iAgent.getScope(), string);
        }
    }

    @Override
    protected void subscribeToGroup(IAgent iAgent, String string) {
        try {
            this.sendConnection.subscribe(string);
        }
        catch (MqttException mqttException) {
            mqttException.printStackTrace();
            throw GamaNetworkException.cannotSubscribeToTopic(iAgent.getScope(), mqttException.toString());
        }
    }

    @Override
    public void unsubscribeGroup(IAgent iAgent, String string) throws GamaNetworkException {
        try {
            this.sendConnection.unsubscribe(string);
        }
        catch (MqttException mqttException) {
            throw GamaNetworkException.cannotUnsuscribeToTopic(this.simulationScope, string);
        }
    }

    @Override
    protected boolean isAlive(IAgent iAgent) throws GamaNetworkException {
        return this.sendConnection.isConnected();
    }

    @Override
    protected void connectToServer(IAgent iAgent) throws GamaNetworkException {
        if (this.sendConnection == null) {
            String string = this.getConfigurationParameter("SERVER_URL");
            String string2 = this.getConfigurationParameter("SERVER_PORT");
            String string3 = this.getConfigurationParameter("LOGIN");
            String string4 = this.getConfigurationParameter("PASSWORD");
            String string5 = this.getConfigurationParameter("LOCAL_NAME");
            string = string == null ? DEFAULT_HOST : string;
            string2 = string2 == null ? DEFAULT_PORT : string2;
            string3 = string3 == null ? "gama_demo" : string3;
            string4 = string4 == null ? "gama_demo" : string4;
            string5 = string5 == null ? DEFAULT_LOCAL_NAME + string : string5;
            DEBUG.OUT((Object)("url tcp://" + string + ":" + string2));
            try {
                this.sendConnection = new MqttClient("tcp://" + string + ":" + string2, string5, (MqttClientPersistence)new MemoryPersistence());
                MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                mqttConnectOptions.setCleanSession(true);
                this.sendConnection.setCallback((MqttCallback)new Callback());
                mqttConnectOptions.setCleanSession(true);
                mqttConnectOptions.setKeepAliveInterval(30);
                mqttConnectOptions.setUserName(string3);
                mqttConnectOptions.setPassword(string4.toCharArray());
                this.sendConnection.connect(mqttConnectOptions);
                DEBUG.OUT((Object)("is connected  start " + this.sendConnection.isConnected()));
            }
            catch (MqttException mqttException) {
                throw GamaNetworkException.cannotBeConnectedFailure(this.simulationScope);
            }
        }
    }

    @Override
    public SocketService getSocketService() {
        return null;
    }

    class Callback
    implements MqttCallback {
        Callback() {
        }

        public void connectionLost(Throwable throwable) {
            throw GamaNetworkException.cannotBeConnectedFailure(GAMA.getSimulation().getScope());
        }

        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
            DEBUG.OUT((Object)"message sended");
        }

        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
            String string2 = mqttMessage.toString();
            MQTTConnector.this.storeMessage("unknown", string, string2);
        }
    }
}

