/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.messaging.GamaMailbox;
import gama.core.messaging.GamaMessage;
import gama.core.messaging.MessagingSkill;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.network.common.ConnectorMessage;
import gama.extension.network.common.IConnector;
import gama.extension.network.httprequest.HTTPRequestConnector;
import gama.extension.network.mqtt.MQTTConnector;
import gama.extension.network.serial.ArduinoConnector;
import gama.extension.network.skills.INetworkSkill;
import gama.extension.network.tcp.TCPConnector;
import gama.extension.network.udp.UDPConnector;
import gama.extension.network.websocket.WebSocketConnector;
import gama.gaml.operators.Cast;
import gama.gaml.operators.System;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="network_name", type=4, doc={@GamlAnnotations.doc(value="Net ID of the agent")}), @GamlAnnotations.variable(name="network_groups", type=5, doc={@GamlAnnotations.doc(value="The set of groups the agent belongs to")}), @GamlAnnotations.variable(name="network_server", type=5, doc={@GamlAnnotations.doc(value="The list of all the servers to which the agent is connected")})})
@GamlAnnotations.skill(name="network", concept={"network", "communication", "skill"})
@GamlAnnotations.doc(value="The network skill provides new features to let agents exchange message through network. Sending and receiving data is done with the messaging skill's actions.")
public class NetworkSkill
extends MessagingSkill {
    static final String REGISTERED_AGENTS = "registered_agents";
    static final String REGISTERED_SERVER = "registered_servers";

    static {
        DEBUG.OFF();
    }

    @GamlAnnotations.action(name="execute", args={@GamlAnnotations.arg(name="command", type=4, doc={@GamlAnnotations.doc(value="command to execute")})}, doc={@GamlAnnotations.doc(deprecated="use 'command' instead", value="Action that executes a command in the OS, as if it is executed from a terminal.", returns="The error message if any")})
    public String systemExec(IScope iScope) {
        String string = (String)iScope.getArg("command", 4);
        return System.console((IScope)iScope, (String)string);
    }

    @GamlAnnotations.action(name="connect", args={@GamlAnnotations.arg(name="protocol", type=4, doc={@GamlAnnotations.doc(value="protocol type (MQTT (by default), TCP, UDP, websocket, arduino): the possible value ares 'udp_server', 'udp_emitter', 'tcp_server', 'tcp_client', 'websocket_server', 'websocket_client', 'http', 'arduino', otherwise the MQTT protocol is used.")}), @GamlAnnotations.arg(name="port", type=1, doc={@GamlAnnotations.doc(value="Port number")}), @GamlAnnotations.arg(name="raw", type=3, doc={@GamlAnnotations.doc(value="message type raw or rich")}), @GamlAnnotations.arg(name="with_name", type=4, optional=true, doc={@GamlAnnotations.doc(value="ID of the agent (its name) for the simulation")}), @GamlAnnotations.arg(name="login", type=4, optional=true, doc={@GamlAnnotations.doc(value="login for the connection to the server")}), @GamlAnnotations.arg(name="password", type=4, optional=true, doc={@GamlAnnotations.doc(value="password associated to the login")}), @GamlAnnotations.arg(name="force_network_use", type=3, optional=true, doc={@GamlAnnotations.doc(value="force the use of the network even interaction between local agents")}), @GamlAnnotations.arg(name="to", type=4, optional=true, doc={@GamlAnnotations.doc(value="server URL (localhost or a server URL)")}), @GamlAnnotations.arg(name="size_packet", type=1, optional=true, doc={@GamlAnnotations.doc(value="For UDP connection, it sets the maximum size of received packets (default = 1024bits).")})}, doc={@GamlAnnotations.doc(value="Action used by a networking agent to connect to a server or to create a server.", examples={@GamlAnnotations.example(value=" do connect with_name:\"any_name\";"), @GamlAnnotations.example(value=" do connect to:\"localhost\" port:9876 with_name:\"any_name\";"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"MQTT\" port:9876 with_name:\"any_name\";"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"udp_server\" port:9876 with_name:\"Server\";"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"udp_client\" port:9876 with_name:\"Client\";"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"udp_server\" port:9877 size_packet: 4096;"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"tcp_client\" port:9876;"), @GamlAnnotations.example(value=" do connect to:\"localhost\" protocol:\"tcp_server\" port:9876 raw:true;"), @GamlAnnotations.example(value=" do connect to: \"https://openlibrary.org\" protocol: \"http\" port: 443 raw: true;"), @GamlAnnotations.example(value=" do connect protocol: \"arduino\";")})})
    public boolean connectToServer(IScope iScope) throws GamaRuntimeException {
        ArrayList<String> arrayList;
        if (!iScope.getExperiment().hasAttribute(REGISTERED_SERVER)) {
            this.startSkill(iScope);
        }
        IAgent iAgent = iScope.getAgent();
        String string = (String)iScope.getArg("to", 4);
        String string2 = (String)iScope.getArg("login", 4);
        String string3 = (String)iScope.getArg("password", 4);
        String string4 = (String)iScope.getArg("with_name", 4);
        String string5 = (String)iScope.getArg("protocol", 4);
        Boolean bl = (Boolean)iScope.getArg("force_network_use", 3);
        Boolean bl2 = (Boolean)iScope.getArg("raw", 3);
        Integer n = (Integer)iScope.getArg("port", 1);
        String string6 = (String)iScope.getArg("size_packet", 4);
        String string7 = NetworkSkill.createServerKey(string, n);
        Map<String, IConnector> map = this.getRegisteredServers(iScope);
        IConnector iConnector = map.get(string7);
        if (iConnector == null) {
            arrayList = string5;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"udp_server", "udp_emitter", "websocket_server", "websocket_client", "tcp_server", "tcp_client", "arduino", "http"}, (Object)arrayList, n2)) {
                case 0: {
                    DEBUG.OUT((Object)"create UDP server");
                    iConnector = new UDPConnector(iScope, true);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    iConnector.configure("PACKET_SIZE", string6);
                    break;
                }
                case 1: {
                    DEBUG.OUT((Object)"create UDP client");
                    iConnector = new UDPConnector(iScope, false);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    iConnector.configure("PACKET_SIZE", string6);
                    break;
                }
                case 2: {
                    DEBUG.OUT((Object)"create WebSocket server");
                    iConnector = new WebSocketConnector(iScope, true, bl2);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                case 3: {
                    DEBUG.OUT((Object)"create WebSocket client");
                    iConnector = new WebSocketConnector(iScope, false, bl2);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                case 4: {
                    DEBUG.OUT((Object)"create TCP serveur");
                    iConnector = new TCPConnector(iScope, true, bl2);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                case 5: {
                    DEBUG.OUT((Object)"create TCP client");
                    iConnector = new TCPConnector(iScope, false, bl2);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                case 6: {
                    iConnector = new ArduinoConnector(iScope);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                case 7: {
                    iConnector = new HTTPRequestConnector(iScope);
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", String.valueOf(n));
                    break;
                }
                default: {
                    iConnector = new MQTTConnector(iScope, bl2);
                    DEBUG.OUT((Object)("create MQTT server " + string2 + " " + string3));
                    if (string == null) break;
                    iConnector.configure("SERVER_URL", string);
                    iConnector.configure("SERVER_PORT", n == 0 ? "1883" : n.toString());
                    if (string2 != null) {
                        iConnector.configure("LOGIN", string2);
                    }
                    if (string3 == null) break;
                    iConnector.configure("PASSWORD", string3);
                }
            }
            if (bl != null) {
                iConnector.forceNetworkUse(bl);
            }
            map.put(string7, iConnector);
        }
        if (iAgent.getAttribute("network_name") == null) {
            iAgent.setAttribute("network_name", (Object)string4);
        }
        if ((arrayList = (List)iAgent.getAttribute("network_server")) == null) {
            arrayList = new ArrayList<String>();
            iAgent.setAttribute("network_server", arrayList);
        }
        DEBUG.OUT((Object)("connector " + String.valueOf(iConnector)));
        try {
            iConnector.connect(iAgent);
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return false;
        }
        arrayList.add(string7);
        String[] stringArray = INetworkSkill.DEFAULT_GROUP;
        int n3 = INetworkSkill.DEFAULT_GROUP.length;
        int n4 = 0;
        while (n4 < n3) {
            String string8 = stringArray[n4];
            this.joinAGroup(iScope, iAgent, string8);
            DEBUG.OUT((Object)string8);
            ++n4;
        }
        return true;
    }

    @GamlAnnotations.action(name="disconnect", doc={@GamlAnnotations.doc(value="Disconnects from all the servers previously connected to. Will return true if everything went well, false in case of an error.")})
    public Boolean disconnect(IScope iScope) {
        Map<String, IConnector> map = this.getRegisteredServers(iScope);
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, IConnector> object : map.entrySet()) {
            try {
                IConnector iConnector = object.getValue();
                iConnector.close(iScope);
                iConnector.leaveTheGroup(iScope.getAgent(), REGISTERED_AGENTS);
                arrayList.add(object.getKey());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        for (String string : arrayList) {
            map.remove(string);
        }
        return bl;
    }

    private static String createServerKey(String string, Integer n) {
        return string + "@@" + String.valueOf(n);
    }

    @GamlAnnotations.action(name="fetch_message", doc={@GamlAnnotations.doc(value="Fetch the first message from the mailbox (and remove it from the mailing box). If the mailbox is empty, it returns a nil message.", examples={@GamlAnnotations.example(value="message mess <- fetch_message();"), @GamlAnnotations.example(value="loop while:has_more_message(){ \n\tmessage mess <- fetch_message();\n\twrite message.contents;\n}")})})
    public GamaMessage fetchMessage(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        GamaMailbox gamaMailbox = this.getMailbox(iScope, iAgent);
        GamaMessage gamaMessage = null;
        if (!gamaMailbox.isEmpty()) {
            gamaMessage = (GamaMessage)gamaMailbox.get(0);
            gamaMailbox.remove(0);
        }
        return gamaMessage;
    }

    @GamlAnnotations.action(name="has_more_message", doc={@GamlAnnotations.doc(value="Check whether the mailbox contains any message.", examples={@GamlAnnotations.example(value="bool mailbox_contain_messages <- has_more_message();"), @GamlAnnotations.example(value="loop while:has_more_message(){ \n\tmessage mess <- fetch_message();\n\twrite message.contents;\n}")})})
    public boolean hasMoreMessage(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        GamaMailbox gamaMailbox = this.getMailbox(iScope, iAgent);
        return !gamaMailbox.isEmpty();
    }

    @GamlAnnotations.action(name="join_group", args={@GamlAnnotations.arg(name="with_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the group")})}, doc={@GamlAnnotations.doc(value="Allow an agent to join a group of agents in order to broadcast messages to other members or to receive messages sent by other members. Note that all members of the group called : \"ALL\".", examples={@GamlAnnotations.example(value="do join_group with_name:\"group name\";"), @GamlAnnotations.example(value="do join_group with_name:\"group name\";\ndo send to:\"group name\" contents:\"I am new in this group\";")})})
    public boolean registerToGroup(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        String string = (String)iScope.getArg("with_name", 4);
        if (string != null) {
            this.joinAGroup(iScope, iAgent, string);
            return true;
        }
        return false;
    }

    private IList<String> getGroups(IScope iScope, IAgent iAgent) {
        IList iList = Cast.asList((IScope)iScope, (Object)iAgent.getAttribute("network_groups"));
        if (iList == null) {
            iList = GamaListFactory.create();
            iAgent.setAttribute("network_groups", (Object)iList);
        }
        return iList;
    }

    public void joinAGroup(IScope iScope, IAgent iAgent, String string) {
        IList<String> iList = this.getGroups(iScope, iAgent);
        iList.add((Object)string);
        Collection<IConnector> collection = this.getRegisteredServers(iScope).values();
        for (IConnector iConnector : collection) {
            iConnector.joinAGroup(iAgent, string);
        }
    }

    @GamlAnnotations.action(name="leave_group", args={@GamlAnnotations.arg(name="with_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the group the agent wants to leave")})}, doc={@GamlAnnotations.doc(value="leave a group of agents. The leaving agent will not receive any message from the group. Otherwise, it can send messages to the left group", examples={@GamlAnnotations.example(value=" do leave_group with_name:\"my_group\";")})})
    public boolean leaveTheGroup(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        String string = (String)iScope.getArg("with_name", 4);
        if (string == null) {
            return false;
        }
        IList<String> iList = this.getGroups(iScope, iAgent);
        iList.remove((Object)string);
        Collection<IConnector> collection = this.getRegisteredServers(iScope).values();
        for (IConnector iConnector : collection) {
            iConnector.leaveTheGroup(iAgent, string);
        }
        return true;
    }

    protected void effectiveSend(IScope iScope, GamaMessage gamaMessage, Object object) {
        String string2;
        if (object instanceof IList) {
            for (String string2 : ((IList)object).iterable(iScope)) {
                this.effectiveSend(iScope, gamaMessage.copy(iScope), string2);
            }
        }
        string2 = object.toString();
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            if (this.getRegisteredAgents(iScope).contains(object)) {
                string2 = (String)iAgent.getAttribute("network_server");
            }
        }
        IAgent iAgent = iScope.getAgent();
        List list = (List)iAgent.getAttribute("network_server");
        Map<String, IConnector> map = this.getRegisteredServers(iScope);
        for (String string3 : list) {
            map.get(string3).send(iAgent, string2, gamaMessage);
        }
    }

    @GamlAnnotations.action(name="fetch_message_from_network", doc={@GamlAnnotations.doc(value="Fetch all messages from network to mailbox. Use this in specific case only, this action is done at the end of each step. ", examples={@GamlAnnotations.example(value="do fetch_message_from_network;//forces gama to get all the new messages since the begining of the cycle\nloop while: has_more_message(){ \n\tmessage mess <- fetch_message();\n\twrite message.contents;\n}")})})
    public boolean fetchMessagesOfAgents(IScope iScope) {
        for (IConnector iConnector : this.getRegisteredServers(iScope).values()) {
            Map<IAgent, LinkedList<ConnectorMessage>> map = iConnector.fetchAllMessages();
            for (IAgent iAgent : map.keySet()) {
                LinkedList<ConnectorMessage> linkedList;
                GamaMailbox gamaMailbox = (GamaMailbox)iAgent.getAttribute("messaging_skill_mailbox");
                LinkedList<ConnectorMessage> linkedList2 = linkedList = map.containsKey(iAgent) ? map.get(iAgent) : null;
                if (linkedList == null) {
                    return true;
                }
                for (ConnectorMessage connectorMessage : map.get(iAgent)) {
                    gamaMailbox.addMessage(iScope, connectorMessage.getContents(iScope));
                }
            }
        }
        return true;
    }

    protected List<IAgent> getRegisteredAgents(IScope iScope) {
        return (List)iScope.getExperiment().getAttribute(REGISTERED_AGENTS);
    }

    protected Map<String, IConnector> getRegisteredServers(IScope iScope) {
        return (Map)iScope.getExperiment().getAttribute(REGISTERED_SERVER);
    }

    private void initialize(IScope iScope) {
        iScope.getExperiment().setAttribute(REGISTERED_AGENTS, new ArrayList());
        iScope.getExperiment().setAttribute(REGISTERED_SERVER, new HashMap());
    }

    protected void startSkill(IScope iScope) {
        this.initialize(iScope);
        this.registerSimulationEvent(iScope);
    }

    private void registerSimulationEvent(IScope iScope2) {
        iScope2.getSimulation().postEndAction(iScope -> {
            this.fetchMessagesOfAgents(iScope);
            return null;
        });
        iScope2.getSimulation().postDisposeAction(iScope -> {
            this.closeAllConnection(iScope);
            return null;
        });
    }

    private void closeAllConnection(IScope iScope) {
        for (IConnector iConnector : this.getRegisteredServers(iScope).values()) {
            iConnector.close(iScope);
        }
        this.initialize(iScope);
    }
}

