/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pedestrian.operator;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.extension.pedestrian.operator.PedestrianNetwork;

public class Operators {
    @GamlAnnotations.operator(value={"generate_pedestrian_network"}, category={"Pedestrian"}, concept={"network"})
    @GamlAnnotations.doc(value="The method allows to build a network of corridors to be used by pedestrian while traveling around a space made of obstacles and other users. It makes it possible to avoide collision with other agents (e.g. buildings) including other pedestrians and in the same time managing a path to a destination in a complex environment (e.g. a city). The method  is highly customizable, with many parameters listed as below: <p> <ol>   <li> obstacles : a list containing the lists of geometries or agents that are obstacles for pedestrians (e.g. walls, cars). </li>   <li> bounds : a list of geometries that represent the spatial boundary of the network (i.e. the enclosing space of the network). </li>   <li> open : a boolean expression that will add nodes in the network within open areas. More precisely, new invisible points are added to improve triangulation in areas with very few obstacles.</li>   <li> randomDist : a boolean expression, related to the previous 'open' parameter, that allows to switch between a random (true) spatial distribution or a distribution (false) that build upon a equidistant repartition of points all around the area. </li>  <li> open area : a float in meters representing the minimum distance for an area to be considered as an open area (i.e. euclidian distance between centroid and farest obstacle) </li>  <li> density point : a float representing the density of points per meter within open areas.</li>  <li> clean network : a boolean expression that allows to enhance the network (true) or living as it is generated (false). Enhancement includes filling very small gaps between edges and nodes. </li>  <li> cliping : tolerance for the cliping in triangulation (float; distance) - see skeletonize operator </li>  <li> tolerance : tolerance for the triangulation (float) </li>  <li> min dist obstacle : minimal distance to obstacles to keep a path (float; if 0.0, no filtering) </li>  <li> simplification : simplification distance for the final geometries</li>  <li> square size : size of squares for decomposition (optimization) </li> </ol> </p>", returns="A Graph, i.e. the generated pedestrian network", examples={@GamlAnnotations.example(value="generate_pedestrian_network([wall], [world],true,false,3.0,0.1, true,0.1,0.0,0.0,0.0,50.0)", equals="a list of polylines corresponding to the pedestrian paths", isExecutable=false)})
    public static IList<IShape> generateNetwork(IScope iScope, IList<IContainer<?, ? extends IShape>> iList, IContainer<?, ? extends IShape> iContainer, Boolean bl, boolean bl2, double d, double d2, Boolean bl3, double d3, double d4, double d5, double d6, double d7) {
        return PedestrianNetwork.generateNetwork(iScope, iList, iContainer, null, bl, bl2, d, d2, bl3, d3, d4, d5, d6, d7);
    }

    @GamlAnnotations.operator(value={"generate_pedestrian_network"}, category={"Pedestrian"}, concept={"network"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="The method allows to build a network of corridors to be used by pedestrian while traveling around a space made of obstacles and other users. It makes it possible to avoide collision with other agents (e.g. buildings) including other pedestrians and in the same time managing a path to a destination in a complex environment (e.g. a city). The method  is highly customizable, with many parameters listed as below: <p> <ol>   <li> obstacles : a list containing the lists of geometries or agents that are obstacles for pedestrians (e.g. walls, cars). </li>   <li> bounds : a list of geometries that represent the spatial boundary of the network (i.e. the enclosing space of the network). </li>   <li> open : a boolean expression that will add nodes in the network within open areas. More precisely, new invisible points are added to improve triangulation in areas with very few obstacles.</li>   <li> randomDist : a boolean expression, related to the previous 'open' parameter, that allows to switch between a random (true) spatial distribution or a distribution (false) that build upon a equidistant repartition of points all around the area. </li>  <li> open area : a float in meters representing the minimum distance for an area to be considered as an open area (i.e. euclidian distance between centroid and farest obstacle) </li>  <li> density point : a float representing the density of points per meter within open areas.</li>  <li> clean network : a boolean expression that allows to enhance the network (true) or living as it is generated (false). Enhancement includes filling very small gaps between edges and nodes. </li>  <li> cliping : tolerance for the cliping in triangulation (float; distance) - see skeletonize operator </li>  <li> tolerance : tolerance for the triangulation (float) </li>  <li> min dist obstacle : minimal distance to obstacles to keep a path (float; if 0.0, no filtering) </li>  <li> simplification : simplification distance for the final geometries</li> </ol> </p>")}, examples={@GamlAnnotations.example(value="generate_pedestrian_network([wall], [world],true,false,3.0,0.1, true,0.1,0.0,0.0,0.0,0.0)", equals="a list of polylines corresponding to the pedestrian paths", isExecutable=false)})
    public static IList<IShape> generateNetwork(IScope iScope, IList<IContainer<?, ? extends IShape>> iList, IContainer<?, ? extends IShape> iContainer, Boolean bl, boolean bl2, double d, double d2, Boolean bl3, double d3, double d4, double d5, double d6) {
        return PedestrianNetwork.generateNetwork(iScope, iList, iContainer, null, bl, bl2, d, d2, bl3, d3, d4, d5, d6, 0.0);
    }

    @GamlAnnotations.operator(value={"generate_pedestrian_network"}, category={"Pedestrian"}, concept={"network"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="The method allows to build a network of corridors to be used by pedestrian while traveling around a space made of obstacles and other users. It makes it possible to avoide collision with other agents (e.g. buildings) including other pedestrians and in the same time managing a path to a destination in a complex environment (e.g. a city). The method  is highly customizable, with many parameters listed as below: <p> <ol>   <li> obstacles : a list containing the lists of geometries or agents that are obstacles for pedestrians (e.g. walls, cars). </li>   <li> bounds : a list of geometries that represent the spatial boundary of the network (i.e. the enclosing space of the network). </li>   <li> regular network : allows to combine the generated network with a simplified car user oriented network. More specifically, the network generated will combine enhance pedestrian oriented generated network with the given network: The property of the latter does not allows pedestrian to avoid collision (1D) when using its edges (while moving in 2D space and avoiding collision in the former).</li>  <li> open : a boolean expression that will add nodes in the network within open areas. More precisely, new invisible points are added to improve triangulation in areas with very few obstacles.</li>   <li> randomDist : a boolean expression, related to the previous 'open' parameter, that allows to switch between a random (true) spatial distribution or a distribution (false) that build upon a equidistant repartition of points all around the area. </li>  <li> open area : a float in meters representing the minimum distance for an area to be considered as an open area (i.e. euclidian distance between centroid and farest obstacle) </li>  <li> density point : a float representing the density of points per meter within open areas.</li>  <li> clean network : a boolean expression that allows to enhance the network (true) or living as it is generated (false). Enhancement includes filling very small gaps between edges and nodes. </li>  <li> cliping : tolerance for the cliping in triangulation (float; distance) - see skeletonize operator </li>  <li> tolerance : tolerance for the triangulation (float) </li>  <li> min dist obstacle : minimal distance to obstacles to keep a path (float; if 0.0, no filtering) </li>  <li> simplification : simplification distance for the final geometries</li> </ol> </p>")}, examples={@GamlAnnotations.example(value="generate_pedestrian_network([wall], [world], [road], true,false,3.0,0.1, true,0.1,0.0,0.0,0.0,50.0)", equals="a list of polylines corresponding to the pedestrian paths", isExecutable=false)})
    public static IList<IShape> generateNetwork(IScope iScope, IList<IContainer<?, ? extends IShape>> iList, IContainer<?, ? extends IShape> iContainer, IContainer<?, ? extends IShape> iContainer2, Boolean bl, boolean bl2, double d, double d2, Boolean bl3, double d3, double d4, double d5, double d6, double d7) {
        return PedestrianNetwork.generateNetwork(iScope, iList, iContainer, iContainer2, bl, bl2, d, d2, bl3, d3, d4, d5, d6, d7);
    }

    @GamlAnnotations.operator(value={"generate_pedestrian_network"}, category={"Pedestrian"}, concept={"network"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="The method allows to build a network of corridors to be used by pedestrian while traveling around a space made of obstacles and other users. It makes it possible to avoide collision with other agents (e.g. buildings) including other pedestrians and in the same time managing a path to a destination in a complex environment (e.g. a city). The method  is highly customizable, with many parameters listed as below: <p> <ol>   <li> obstacles : a list containing the lists of geometries or agents that are obstacles for pedestrians (e.g. walls, cars). </li>   <li> bounds : a list of geometries that represent the spatial boundary of the network (i.e. the enclosing space of the network). </li>   <li> regular network : allows to combine the generated network with a simplified car user oriented network. More specifically, the network generated will combine enhance pedestrian oriented generated network with the given network: The property of the latter does not allows pedestrian to avoid collision (1D) when using its edges (while moving in 2D space and avoiding collision in the former).</li>  <li> open : a boolean expression that will add nodes in the network within open areas. More precisely, new invisible points are added to improve triangulation in areas with very few obstacles.</li>   <li> randomDist : a boolean expression, related to the previous 'open' parameter, that allows to switch between a random (true) spatial distribution or a distribution (false) that build upon a equidistant repartition of points all around the area. </li>  <li> open area : a float in meters representing the minimum distance for an area to be considered as an open area (i.e. euclidian distance between centroid and farest obstacle) </li>  <li> density point : a float representing the density of points per meter within open areas.</li>  <li> clean network : a boolean expression that allows to enhance the network (true) or living as it is generated (false). Enhancement includes filling very small gaps between edges and nodes. </li>  <li> cliping : tolerance for the cliping in triangulation (float; distance) - see skeletonize operator </li>  <li> tolerance : tolerance for the triangulation (float) </li>  <li> min dist obstacle : minimal distance to obstacles to keep a path (float; if 0.0, no filtering) </li> </ol> </p>")}, examples={@GamlAnnotations.example(value="generate_pedestrian_network([wall], [world], [road], true,false,3.0,0.1, true,0.1,0.0,0.0,0.0)", equals="a list of polylines corresponding to the pedestrian paths", isExecutable=false)})
    public static IList<IShape> generateNetwork(IScope iScope, IList<IContainer<?, ? extends IShape>> iList, IContainer<?, ? extends IShape> iContainer, IContainer<?, ? extends IShape> iContainer2, Boolean bl, boolean bl2, double d, double d2, Boolean bl3, double d3, double d4, double d5, double d6) {
        return PedestrianNetwork.generateNetwork(iScope, iList, iContainer, iContainer2, bl, bl2, d, d2, bl3, d3, d4, d6, d5, 0.0);
    }
}

