/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pedestrian.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.IGraph;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.skills.Skill;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

@GamlAnnotations.skill(name="pedestrian_road", concept={"transport", "skill"}, doc={@GamlAnnotations.doc(value="A skill for agents representing pedestrian roads")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="agents_on", type=5, of=11, init="[]", doc={@GamlAnnotations.doc(value="for each people on the road")}), @GamlAnnotations.variable(name="free_space", type=13, init="nil", doc={@GamlAnnotations.doc(value="for each people on the road")}), @GamlAnnotations.variable(name="road_status", type=1, init="1", doc={@GamlAnnotations.doc(value="When road status equals 1 it has 2D continuous space property for pedestrian; when equal to 2 is simply a 1D road")}), @GamlAnnotations.variable(name="intersection_areas", type=10, init="[]", doc={@GamlAnnotations.doc(value="map of geometries to connect segments linked to this road")}), @GamlAnnotations.variable(name="linked_pedestrian_roads", type=5, of=11, init="[]", doc={@GamlAnnotations.doc(value="the close pedestrian roads")}), @GamlAnnotations.variable(name="exit_nodes", type=10, init="[]", doc={@GamlAnnotations.doc(value="The exit hub (several exit connected to each road extremities) that makes it possible to reduce angular distance when travelling to connected pedestrian roads")})})
public class PedestrianRoadSkill
extends Skill {
    public static final String PEDESTRIAN_ROAD_SKILL = "pedestrian_road";
    public static final String LINKED_PEDESTRIAN_ROADS = "linked_pedestrian_roads";
    public static final String AGENTS_ON = "agents_on";
    public static final String FREE_SPACE = "free_space";
    public static final String PEDESTRIAN_ROAD_STATUS = "road_status";
    public static final String EXIT_NODES_HUB = "exit_nodes";
    public static final String DISTANCE = "distance";
    public static final String INTERSECTION_AREAS = "intersection_areas";
    public static final int SIMPLE_STATUS = 0;
    public static final int COMPLEX_STATUS = 1;

    @GamlAnnotations.getter(value="agents_on")
    public static IList<IAgent> getAgentsOn(IAgent iAgent) {
        return (IList)iAgent.getAttribute(AGENTS_ON);
    }

    @GamlAnnotations.getter(value="linked_pedestrian_roads")
    public static IList<IAgent> getLinkedPedestrianRoads(IAgent iAgent) {
        return (IList)iAgent.getAttribute(LINKED_PEDESTRIAN_ROADS);
    }

    @GamlAnnotations.getter(value="exit_nodes")
    public static IMap<GamaPoint, IList<GamaPoint>> getExitNodesHub(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(EXIT_NODES_HUB);
    }

    @GamlAnnotations.setter(value="exit_nodes")
    public static void setExitNodesHub(IAgent iAgent, IMap<GamaPoint, IList<GamaPoint>> iMap) {
        iAgent.setAttribute(EXIT_NODES_HUB, iMap);
    }

    @GamlAnnotations.getter(value="intersection_areas")
    public static IMap<IAgent, IShape> getConnectedSegmentsIntersection(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(INTERSECTION_AREAS);
    }

    @GamlAnnotations.setter(value="intersection_areas")
    public static void setConnectedSegmentsIntersection(IAgent iAgent, IMap<IAgent, IShape> iMap) {
        iAgent.setAttribute(INTERSECTION_AREAS, iMap);
    }

    @GamlAnnotations.getter(value="road_status")
    public static int getPedestrianRoadStatus(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(PEDESTRIAN_ROAD_STATUS);
    }

    @GamlAnnotations.setter(value="road_status")
    public static void setPedestrianRoadStatus(IAgent iAgent, int n) {
        iAgent.setAttribute(PEDESTRIAN_ROAD_STATUS, (Object)n);
    }

    @GamlAnnotations.getter(value="free_space")
    public static IShape getFreeSpace(IAgent iAgent) {
        return (IShape)iAgent.getAttribute(FREE_SPACE);
    }

    @GamlAnnotations.setter(value="free_space")
    public static void setFreeSpace(IAgent iAgent, IShape iShape) {
        iAgent.setAttribute(FREE_SPACE, (Object)iShape);
    }

    @GamlAnnotations.setter(value="distance")
    public static void setDistance(IAgent iAgent, Double d) {
        iAgent.setAttribute(DISTANCE, (Object)d);
    }

    @GamlAnnotations.getter(value="distance")
    public static Double getDistance(IAgent iAgent) {
        return (Double)iAgent.getAttribute(DISTANCE);
    }

    public static IList<IAgent> getCloseAgents(IAgent iAgent) {
        IList iList = GamaListFactory.create();
        iList.addAll(PedestrianRoadSkill.getAgentsOn(iAgent));
        for (IAgent iAgent2 : PedestrianRoadSkill.getLinkedPedestrianRoads(iAgent)) {
            iList.addAll(PedestrianRoadSkill.getAgentsOn(iAgent2));
        }
        return iList;
    }

    @GamlAnnotations.action(name="initialize", args={@GamlAnnotations.arg(name="distance", type=2, optional=true, doc={@GamlAnnotations.doc(value="the maximal distance to the road")}), @GamlAnnotations.arg(name="obstacles", type=16, optional=true, doc={@GamlAnnotations.doc(value="the list of species to consider as obstacles to remove from the free space")}), @GamlAnnotations.arg(name="distance_extremity", type=2, optional=true, doc={@GamlAnnotations.doc(value="the distance added to the extremimity to connect to other road (in meters)")}), @GamlAnnotations.arg(name="bounds", type=16, optional=true, doc={@GamlAnnotations.doc(value="the geometries (the localized entity geometries) that restrains the agent movement (the agent moves inside this geometry")}), @GamlAnnotations.arg(name="masked_by", type=16, optional=true, doc={@GamlAnnotations.doc(value="if defined, keep only the part of the geometry that is visible from the location of the road considering the given obstacles")}), @GamlAnnotations.arg(name="masked_by_precision", type=1, optional=true, doc={@GamlAnnotations.doc(value="if masked_by is defined, number of triangles used to compute the visible geometries (default: 120)")}), @GamlAnnotations.arg(name="status", type=1, optional=true, doc={@GamlAnnotations.doc(value="the status (int) of the road: 1 (default) for roads where agent move on a continuous 2D space and 0 for 1D roads with queu-in queu-out like movement")})}, doc={@GamlAnnotations.doc(value="action to initialize the free space of roads", examples={@GamlAnnotations.example(value="do initialize distance: 10.0 obstacles: [building];")})})
    public boolean primInitialize(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        int n = iScope.hasArg("status") ? iScope.getIntArg("status") : (iAgent.getGeometry().hasAttribute(PEDESTRIAN_ROAD_STATUS) ? GamaIntegerType.staticCast((IScope)iScope, (Object)iAgent.getGeometry().getAttribute(PEDESTRIAN_ROAD_STATUS), null, (boolean)false) : 1);
        PedestrianRoadSkill.setPedestrianRoadStatus(iAgent, n);
        double d = iScope.hasArg("distance_extremity") ? iScope.getFloatArg("distance_extremity") : 0.0;
        IShape iShape = iAgent.getGeometry().copy(iScope);
        iShape = SpatialTransformations.scaled_by((IScope)iScope, (IShape)iShape, (Double)((iShape.getPerimeter() + d) / iShape.getPerimeter()));
        if (n == 1) {
            Object object6;
            Iterator iterator;
            IList iList;
            Iterator iterator22;
            Object object2;
            IShape iShape2;
            IContainer iContainer;
            double d2 = iScope.hasArg(DISTANCE) ? iScope.getFloatArg(DISTANCE) : 0.0;
            PedestrianRoadSkill.setDistance(iAgent, d2);
            if (d2 > 0.0) {
                iShape = SpatialTransformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)d2, (Integer)8, (Integer)2);
            }
            if (iScope.hasArg("obstacles")) {
                iContainer = (IContainer)iScope.getArg("obstacles", 16);
                if (iContainer instanceof ISpecies) {
                    iShape2 = SpatialQueries.overlapping((IScope)iScope, (IContainer)iContainer, (IShape)iShape);
                    object2 = SpatialOperators.union((IScope)iScope, (IContainer)iShape2);
                    object2 = SpatialTransformations.enlarged_by((IScope)iScope, (IShape)object2, (Double)(d2 / 1000.0));
                    iShape = SpatialOperators.minus((IScope)iScope, (IShape)iShape, (IShape)object2);
                } else {
                    iShape2 = iContainer.listValue(iScope, Types.NO_TYPE, false);
                    if (!iShape2.isEmpty()) {
                        Object object3 = object2 = iShape2.get(0) instanceof ISpecies ? iShape2 : null;
                        if (object2 != null) {
                            iterator22 = object2.iterator();
                            while (iterator22.hasNext()) {
                                iList = (ISpecies)iterator22.next();
                                iterator = SpatialQueries.overlapping((IScope)iScope, (IContainer)iList, (IShape)iShape);
                                object6 = SpatialOperators.union((IScope)iScope, (IContainer)iterator);
                                object6 = SpatialTransformations.enlarged_by((IScope)iScope, (IShape)object6, (Double)(d2 / 1000.0));
                                iShape = SpatialOperators.minus((IScope)iScope, (IShape)iShape, (IShape)object6);
                            }
                        } else {
                            iList = GamaListFactory.create();
                            for (Iterator iterator22 : iShape2) {
                                if (!(iterator22 instanceof IShape)) continue;
                                iList.add((Object)((IShape)iterator22));
                            }
                            iterator22 = SpatialQueries.overlapping((IScope)iScope, (IContainer)iList, (IShape)iShape);
                            iterator = SpatialOperators.union((IScope)iScope, (IContainer)iterator22);
                            iterator = SpatialTransformations.enlarged_by((IScope)iScope, (IShape)iterator, (Double)(d2 / 1000.0));
                            iShape = SpatialOperators.minus((IScope)iScope, (IShape)iShape, (IShape)iterator);
                        }
                    }
                }
            }
            IContainer iContainer2 = iContainer = iScope.hasArg("bounds") ? (IContainer)iScope.getArg("bounds", 16) : null;
            if (iContainer != null && (object2 = SpatialOperators.inter((IScope)iScope, (IShape)iShape, (IShape)(iShape2 = SpatialOperators.union((IScope)iScope, (IContainer)iContainer)))) != null) {
                iShape = object2;
            }
            if (iShape == null) {
                return false;
            }
            if (iShape.getGeometries().size() > 1) {
                object2 = iShape.getGeometries().iterator();
                while (object2.hasNext()) {
                    iShape2 = (IShape)object2.next();
                    if (!iAgent.intersects(iShape2)) continue;
                    iShape = iShape2;
                    break;
                }
            }
            if (iScope.hasArg("masked_by")) {
                iShape2 = (IContainer)iScope.getArg("masked_by", 16);
                Object object4 = object2 = iScope.hasArg("masked_by_precision") ? iScope.getIntArg("masked_by_precision") : null;
                if (iShape2 instanceof ISpecies) {
                    iShape = SpatialOperators.masked_by((IScope)iScope, (IShape)iShape, (IContainer)iShape2, (Integer)object2);
                } else {
                    iList = iShape2.listValue(iScope, Types.NO_TYPE, false);
                    if (!iList.isEmpty()) {
                        iterator22 = GamaListFactory.create();
                        Object object5 = iterator = iList.get(0) instanceof ISpecies ? iList : null;
                        if (iterator != null) {
                            Iterator iterator3 = iterator.iterator();
                            while (iterator3.hasNext()) {
                                object6 = (ISpecies)iterator3.next();
                                iterator22.addAll(object6.getPopulations(iScope));
                            }
                        } else {
                            for (Object object6 : iList) {
                                if (!(object6 instanceof IShape)) continue;
                                iterator22.add(object6);
                            }
                        }
                        iShape = SpatialOperators.masked_by((IScope)iScope, (IShape)iShape, (IContainer)iterator22, (Integer)object2);
                    }
                }
            }
        }
        PedestrianRoadSkill.setFreeSpace(iAgent, iShape);
        return true;
    }

    @GamlAnnotations.action(name="build_intersection_areas", args={@GamlAnnotations.arg(name="pedestrian_graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="The pedestrian network from which to find connected corridors")})}, doc={@GamlAnnotations.doc(value="Build intersection areas with connected roads", examples={@GamlAnnotations.example(value="do build_intersection_areas pedestrian_graph: pedestrian_network;")})})
    public boolean primIntersectionAreas(IScope iScope) {
        IAgent iAgent;
        IAgent iAgent2 = this.getCurrentAgent(iScope);
        if (!iAgent2.isInstanceOf(PEDESTRIAN_ROAD_SKILL, true)) {
            throw GamaRuntimeException.error((String)("Trying to manipulate agent with pedestrian_road while being " + String.valueOf(iAgent2)), (IScope)iScope);
        }
        IShape iShape = PedestrianRoadSkill.getFreeSpace(iAgent2);
        IGraph iGraph = (IGraph)iScope.getVarValue("pedestrian_graph");
        IMap iMap = GamaMapFactory.create();
        IShape iShape2 = (IShape)iGraph.getEdgeTarget((Object)iAgent2);
        IShape iShape3 = (IShape)iGraph.getEdgeSource((Object)iAgent2);
        IList<IAgent> iList = PedestrianRoadSkill.getLinkedPedestrianRoads(iAgent2);
        for (Object object : iGraph.outgoingEdgesOf((Object)iShape3)) {
            iAgent = (IAgent)object;
            iMap.put((Object)iAgent, (Object)SpatialOperators.inter((IScope)iScope, (IShape)iShape, (IShape)PedestrianRoadSkill.getFreeSpace(iAgent)));
        }
        for (Object object : iGraph.incomingEdgesOf((Object)iShape3)) {
            iAgent = (IAgent)object;
            iMap.put((Object)iAgent, (Object)SpatialOperators.inter((IScope)iScope, (IShape)iShape, (IShape)PedestrianRoadSkill.getFreeSpace(iAgent)));
        }
        for (Object object : iGraph.outgoingEdgesOf((Object)iShape2)) {
            iAgent = (IAgent)object;
            iMap.put((Object)iAgent, (Object)SpatialOperators.inter((IScope)iScope, (IShape)iShape, (IShape)PedestrianRoadSkill.getFreeSpace(iAgent)));
        }
        for (Object object : iGraph.incomingEdgesOf((Object)iShape2)) {
            iAgent = (IAgent)object;
            iMap.put((Object)iAgent, (Object)SpatialOperators.inter((IScope)iScope, (IShape)iShape, (IShape)PedestrianRoadSkill.getFreeSpace(iAgent)));
        }
        iMap.remove((Object)iAgent2);
        for (Object object : iAgent2.getSpecies().getPopulation(iScope)) {
            if (object == iAgent2 || !PedestrianRoadSkill.getFreeSpace(object).intersects(iShape)) continue;
            iList.add(object);
        }
        PedestrianRoadSkill.setConnectedSegmentsIntersection(iAgent2, (IMap<IAgent, IShape>)iMap);
        return true;
    }

    @GamlAnnotations.action(name="build_exit_hub", args={@GamlAnnotations.arg(name="pedestrian_graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="The pedestrian network from which to find connected corridors")}), @GamlAnnotations.arg(name="distance_between_targets", type=2, optional=false, doc={@GamlAnnotations.doc(value="min distances between 2 targets")})}, doc={@GamlAnnotations.doc(value="Add exit hub to pedestrian corridor to reduce angular distance between node of the network", examples={@GamlAnnotations.example(value="do build_exit_hub pedestrian_graph: pedestrian_network distance_between_targets: 10.0;")})})
    public boolean primExitHubEscape(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (!iAgent.isInstanceOf(PEDESTRIAN_ROAD_SKILL, true)) {
            throw GamaRuntimeException.error((String)("Trying to manipulate agent with pedestrian_road while being " + String.valueOf(iAgent)), (IScope)iScope);
        }
        Double d = iScope.getFloatArg("distance_between_targets");
        IMap iMap = GamaMapFactory.create();
        IShape iShape = SpatialTransformations.reduced_by((IScope)iScope, (IShape)PedestrianRoadSkill.getFreeSpace(iAgent), (Double)d);
        if (PedestrianRoadSkill.getRoadStatus(iScope, (IShape)iAgent) == 0) {
            Iterator iterator = iAgent.getPoints().iterator();
            while (iterator.hasNext()) {
                GamaPoint gamaPoint;
                GamaPoint gamaPoint2 = gamaPoint = (GamaPoint)iterator.next();
                IList iList = GamaListFactory.create();
                iList.add((Object)gamaPoint2);
                iMap.put((Object)gamaPoint2, (Object)iList);
            }
        } else {
            int n = 0;
            while (n < iAgent.getPoints().size()) {
                GamaPoint gamaPoint = ((GamaPoint)iAgent.getPoints().get(n)).copy(iScope);
                GamaPoint gamaPoint3 = n == 0 ? (GamaPoint)iAgent.getPoints().get(n + 1) : (GamaPoint)iAgent.getPoints().get(n - 1);
                iMap.put((Object)((GamaPoint)iAgent.getPoints().get(n)), this.connectedRoads(iScope, iAgent, d, gamaPoint, gamaPoint3, iShape));
                ++n;
            }
        }
        PedestrianRoadSkill.setExitNodesHub(iAgent, (IMap<GamaPoint, IList<GamaPoint>>)iMap);
        return true;
    }

    public static IShape getFreeSpace(IScope iScope, IShape iShape) {
        return (IShape)iShape.getAttribute(FREE_SPACE);
    }

    public static int getRoadStatus(IScope iScope, IShape iShape) {
        return (Integer)iShape.getAttribute(PEDESTRIAN_ROAD_STATUS);
    }

    public static IList<GamaPoint> getConnectedOutput(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        if (!iShape.hasAttribute(EXIT_NODES_HUB)) {
            throw GamaRuntimeException.error((String)("Looking for exit hub related to " + String.valueOf(iShape) + " but there is none"), (IScope)iScope);
        }
        IMap iMap = (IMap)iShape.getAttribute(EXIT_NODES_HUB);
        if (iMap.containsKey((Object)gamaPoint)) {
            return (IList)iMap.get((Object)gamaPoint);
        }
        return GamaListFactory.create((IType)Types.POINT, Stream.of(gamaPoint));
    }

    public static void register(IScope iScope, IAgent iAgent, IAgent iAgent2) {
        ((IList)iAgent.getAttribute(AGENTS_ON)).add((Object)iAgent2);
        if (!iAgent2.getLocation().intersects(PedestrianRoadSkill.getFreeSpace(iAgent))) {
            iAgent2.setLocation(SpatialPunctal._closest_point_to((GamaPoint)iAgent2.getLocation(), (IShape)PedestrianRoadSkill.getFreeSpace(iAgent)));
        }
        iAgent2.setAttribute("current_edge", (Object)iAgent);
    }

    public static boolean unregister(IScope iScope, IAgent iAgent, IAgent iAgent2) {
        ((IList)iAgent.getAttribute(AGENTS_ON)).remove((Object)iAgent2);
        iAgent2.setAttribute("current_edge", null);
        return true;
    }

    private IList<GamaPoint> connectedRoads(IScope iScope, IAgent iAgent, Double d, GamaPoint gamaPoint2, GamaPoint gamaPoint3, IShape iShape) {
        IList iList = GamaListFactory.create();
        iList.add((Object)gamaPoint2.copy(iScope));
        double d2 = PedestrianRoadSkill.getDistance(iAgent);
        if (d2 <= 0.0 || iShape == null || iShape.getArea() <= 0.001) {
            return iList;
        }
        GamaPoint gamaPoint4 = gamaPoint2.minus(gamaPoint3);
        GamaPoint gamaPoint5 = null;
        if (gamaPoint4.x == 0.0) {
            gamaPoint5 = new GamaPoint(1.0, 0.0);
        } else if (gamaPoint4.y == 0.0) {
            gamaPoint5 = new GamaPoint(0.0, 1.0);
        } else {
            double d3 = -gamaPoint4.y / gamaPoint4.x;
            double d4 = Math.sqrt(d3 * d3 + 1.0);
            gamaPoint5 = new GamaPoint(d3 / d4, 1.0 / d4);
        }
        gamaPoint5 = gamaPoint5.multiplyBy(d2);
        IList iList2 = GamaListFactory.create();
        iList2.add((Object)gamaPoint2.minus(gamaPoint5));
        iList2.add((Object)gamaPoint2.add(gamaPoint5));
        IShape iShape2 = SpatialCreation.line((IScope)iScope, (IContainer)iList2);
        if (iShape2 == null || iShape2.getPerimeter() <= d) {
            return iList;
        }
        IList iList3 = SpatialPunctal.points_on((IShape)iShape2, (Double)d);
        iList3.removeIf(gamaPoint -> gamaPoint == null || !iShape.intersects((IShape)gamaPoint));
        iList.addAll((Collection)iList3);
        return iList;
    }
}

