/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pedestrian.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GraphTopology;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.IPath;
import gama.extension.pedestrian.skills.PedestrianRoadSkill;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.operators.Points;
import gama.gaml.operators.Random;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialProperties;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.skills.MovingSkill;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;

@GamlAnnotations.skill(name="pedestrian", concept={"transport", "skill"}, doc={@GamlAnnotations.doc(value="A skill that provides agent with the ability to walk on continuous space while finding their way on a virtual network")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="shoulder_length", type=2, init="0.45", doc={@GamlAnnotations.doc(value="The width of the pedestrian (in meters) - classic values: [0.39, 0.515]")}), @GamlAnnotations.variable(name="minimal_distance", type=2, init="0.0", doc={@GamlAnnotations.doc(value="Minimal distance between pedestrians")}), @GamlAnnotations.variable(name="pedestrian_consideration_distance", type=2, init="2.0", doc={@GamlAnnotations.doc(value="Distance of consideration of other pedestrians (to compute the nearby obstacles, used as distance, the max between this value and (step * speed) - classic value: 3.5m")}), @GamlAnnotations.variable(name="obstacle_consideration_distance", type=2, init="2.0", doc={@GamlAnnotations.doc(value="Distance of consideration of obstacles (to compute the nearby obstacles, used as distance, the max between this value and (step * speed) - classic value: 3.5m")}), @GamlAnnotations.variable(name="avoid_other", type=3, init="true", doc={@GamlAnnotations.doc(value="has the pedestrian to avoid other pedestrians?")}), @GamlAnnotations.variable(name="obstacle_species", type=5, init="[]", doc={@GamlAnnotations.doc(value="the list of species that are considered as obstacles")}), @GamlAnnotations.variable(name="pedestrian_species", type=5, init="[]", doc={@GamlAnnotations.doc(value="the list of species that are considered as pedestrians")}), @GamlAnnotations.variable(name="proba_detour", type=2, init="0.1", doc={@GamlAnnotations.doc(value="probability to accept to do a detour")}), @GamlAnnotations.variable(name="A_pedestrians_SFM", type=2, init="4.5", doc={@GamlAnnotations.doc(value="Value of A in the SFM model for pedestrians - the force of repulsive interactions (classic values : mean = 4.5, std = 0.3)")}), @GamlAnnotations.variable(name="A_obstacles_SFM", type=2, init="4.5", doc={@GamlAnnotations.doc(value="Value of A in the SFM model for obstacles - the force of repulsive interactions (classic values : mean = 4.5, std = 0.3)")}), @GamlAnnotations.variable(name="B_pedestrians_SFM", type=2, init="2.0", doc={@GamlAnnotations.doc(value="Value of B in the SFM model for pedestrians - the range (in meters) of repulsive interactions")}), @GamlAnnotations.variable(name="B_obstacles_SFM", type=2, init="2.0", doc={@GamlAnnotations.doc(value="Value of B in the SFM model for obstacles - the range (in meters) of repulsive interactions")}), @GamlAnnotations.variable(name="k_SFM", type=2, init="200", doc={@GamlAnnotations.doc(value="Value of k in the SFM model: force counteracting body compression")}), @GamlAnnotations.variable(name="kappa_SFM", type=2, init="400", doc={@GamlAnnotations.doc(value="Value of kappa in the SFM model: friction counteracting body compression")}), @GamlAnnotations.variable(name="relaxion_SFM", type=2, init="0.54", doc={@GamlAnnotations.doc(value="Value of relaxion in the SFM model - the amount of delay time for an agent to adapt.(classic values : mean = 0.54, std = 0.05)")}), @GamlAnnotations.variable(name="gama_SFM", type=2, init="0.35", doc={@GamlAnnotations.doc(value="Value of gama in the SFM model  the amount of normal social force added in tangential direction. between 0.0 and 1.0 (classic values : mean = 0.35, std = 0.01)")}), @GamlAnnotations.variable(name="lambda_SFM", type=2, init="0.5", doc={@GamlAnnotations.doc(value="Value of lambda in the SFM model - the (an-)isotropy (between 0.0 and 1.0)")}), @GamlAnnotations.variable(name="n_SFM", type=2, init="2.0", doc={@GamlAnnotations.doc(value="Value of n in the SFM model (classic values : mean = 2.0, std = 0.1)")}), @GamlAnnotations.variable(name="n_prime_SFM", type=2, init="3.0", doc={@GamlAnnotations.doc(value="Value of n' in the SFM model (classic values : mean = 3.0, std = 0.7)")}), @GamlAnnotations.variable(name="pedestrian_model", type=4, init="'simple'", doc={@GamlAnnotations.doc(value="Model use for the movement of agents (Social Force Model). Can be either \"simple\" or \"advanced\" (default) for different versions of SFM Helbing model")}), @GamlAnnotations.variable(name="velocity", type=7, init="{0,0,0}", doc={@GamlAnnotations.doc(value="The velocity of the pedestrian (in meters)")}), @GamlAnnotations.variable(name="forces", type=10, init="[]", doc={@GamlAnnotations.doc(value="the map of forces")}), @GamlAnnotations.variable(name="final_waypoint", type=13, init="nil", doc={@GamlAnnotations.doc(value="the final waypoint of the agent")}), @GamlAnnotations.variable(name="current_waypoint", type=13, init="nil", doc={@GamlAnnotations.doc(value="the current waypoint of the agent")}), @GamlAnnotations.variable(name="current_index", type=1, init="0", doc={@GamlAnnotations.doc(value="the current index of the agent waypoint (according to the waypoint list)")}), @GamlAnnotations.variable(name="waypoints", type=5, of=13, init="[]", doc={@GamlAnnotations.doc(value="the current list of points/shape that the agent has to reach (path)")}), @GamlAnnotations.variable(name="roads_waypoints", type=10, init="[]", doc={@GamlAnnotations.doc(value="for each waypoint, the associated road")}), @GamlAnnotations.variable(name="use_geometry_waypoint", type=3, init="false", doc={@GamlAnnotations.doc(value="use geometries as waypoint instead of points")}), @GamlAnnotations.variable(name="tolerance_waypoint", type=2, init="1.0", doc={@GamlAnnotations.doc(value="distance to a waypoint (in meters) to consider that an agent is arrived at the waypoint")})})
public class PedestrianSkill
extends MovingSkill {
    public static final String PEDESTRIAN_MODEL = "pedestrian_model";
    public static final String SHOULDER_LENGTH = "shoulder_length";
    public static final String MINIMAL_DISTANCE = "minimal_distance";
    public static final String CURRENT_TARGET = "current_waypoint";
    public static final String OBSTACLE_CONSIDERATION_DISTANCE = "obstacle_consideration_distance";
    public static final String PEDESTRIAN_CONSIDERATION_DISTANCE = "pedestrian_consideration_distance";
    public static final String PROBA_DETOUR = "proba_detour";
    public static final String AVOID_OTHER = "avoid_other";
    public static final String OBSTACLE_SPECIES = "obstacle_species";
    public static final String PEDESTRIAN_SPECIES = "pedestrian_species";
    public static final String VELOCITY = "velocity";
    public static final String FORCES = "forces";
    public static final String A_PEDESTRIAN_SFM = "A_pedestrians_SFM";
    public static final String A_OBSTACLES_SFM = "A_obstacles_SFM";
    public static final String B_PEDESTRIAN_SFM = "B_pedestrians_SFM";
    public static final String B_OBSTACLES_SFM = "B_obstacles_SFM";
    public static final String K_SFM = "k_SFM";
    public static final String KAPPA_SFM = "kappa_SFM";
    public static final String RELAXION_SFM = "relaxion_SFM";
    public static final String GAMA_SFM = "gama_SFM";
    public static final String lAMBDA_SFM = "lambda_SFM";
    public static final String N_SFM = "n_SFM";
    public static final String N_PRIME_SFM = "n_prime_SFM";
    public static final String CURRENT_TARGET_GEOM = "current_waypoint_geom";
    public static final String CURRENT_INDEX = "current_index";
    public static final String FINAL_TARGET = "final_waypoint";
    public static final String CURRENT_PATH = "current_path";
    public static final String PEDESTRIAN_GRAPH = "pedestrian_graph";
    public static final String TOLERANCE_TARGET = "tolerance_waypoint";
    public static final String USE_GEOMETRY_TARGET = "use_geometry_waypoint";
    public static final String COMPUTE_VIRTUAL_PATH = "compute_virtual_path";
    public static final String WALK = "walk";
    public static final String WALK_TO = "walk_to";
    public static final String TARGETS = "waypoints";
    public static final String ROADS_TARGET = "roads_waypoints";

    @GamlAnnotations.getter(value="shoulder_length")
    public double getShoulderLength(IAgent iAgent) {
        return (Double)iAgent.getAttribute(SHOULDER_LENGTH);
    }

    @GamlAnnotations.getter(value="forces")
    public IMap<IShape, GamaPoint> getForces(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(FORCES);
    }

    @GamlAnnotations.setter(value="shoulder_length")
    public void setShoulderLength(IAgent iAgent, double d) {
        iAgent.setAttribute(SHOULDER_LENGTH, (Object)d);
    }

    @GamlAnnotations.getter(value="minimal_distance")
    public double getMinDist(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MINIMAL_DISTANCE);
    }

    @GamlAnnotations.setter(value="minimal_distance")
    public void setMinDist(IAgent iAgent, double d) {
        iAgent.setAttribute(MINIMAL_DISTANCE, (Object)d);
    }

    @GamlAnnotations.getter(value="k_SFM")
    public double getKSFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(K_SFM);
    }

    @GamlAnnotations.setter(value="k_SFM")
    public void setKSFM(IAgent iAgent, double d) {
        iAgent.setAttribute(K_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="kappa_SFM")
    public double getKappaSFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(KAPPA_SFM);
    }

    @GamlAnnotations.setter(value="kappa_SFM")
    public void setKappaSFM(IAgent iAgent, double d) {
        iAgent.setAttribute(KAPPA_SFM, (Object)d);
    }

    @GamlAnnotations.setter(value="n_prime_SFM")
    public void setN_PRIME_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(N_PRIME_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="n_prime_SFM")
    public Double getN_PRIME_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(N_PRIME_SFM);
    }

    @GamlAnnotations.setter(value="n_SFM")
    public void setN_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(N_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="n_SFM")
    public Double getN_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(N_SFM);
    }

    @GamlAnnotations.getter(value="obstacle_species")
    public IList<ISpecies> getObstacleSpecies(IAgent iAgent) {
        return (IList)iAgent.getAttribute(OBSTACLE_SPECIES);
    }

    @GamlAnnotations.setter(value="obstacle_species")
    public void setObstacleSpecies(IAgent iAgent, IList<ISpecies> iList) {
        iAgent.setAttribute(OBSTACLE_SPECIES, iList);
    }

    @GamlAnnotations.getter(value="pedestrian_species")
    public IList<ISpecies> getPedestrianSpecies(IAgent iAgent) {
        return (IList)iAgent.getAttribute(PEDESTRIAN_SPECIES);
    }

    @GamlAnnotations.setter(value="pedestrian_species")
    public void setPedestrianSpecies(IAgent iAgent, IList<ISpecies> iList) {
        iAgent.setAttribute(PEDESTRIAN_SPECIES, iList);
    }

    @GamlAnnotations.getter(value="current_waypoint")
    public IShape getCurrentTarget(IAgent iAgent) {
        return (IShape)iAgent.getAttribute(CURRENT_TARGET);
    }

    @GamlAnnotations.setter(value="current_waypoint")
    public void setCurrentTarget(IAgent iAgent, IShape iShape) {
        iAgent.setAttribute(CURRENT_TARGET, (Object)iShape);
    }

    @GamlAnnotations.getter(value="obstacle_consideration_distance")
    public Double getObstacleConsiderationDistance(IAgent iAgent) {
        return (Double)iAgent.getAttribute(OBSTACLE_CONSIDERATION_DISTANCE);
    }

    @GamlAnnotations.setter(value="obstacle_consideration_distance")
    public void setObstacleConsiderationDistance(IAgent iAgent, Double d) {
        iAgent.setAttribute(OBSTACLE_CONSIDERATION_DISTANCE, (Object)d);
    }

    @GamlAnnotations.getter(value="pedestrian_consideration_distance")
    public Double getPedestrianConsiderationDistance(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PEDESTRIAN_CONSIDERATION_DISTANCE);
    }

    @GamlAnnotations.setter(value="pedestrian_consideration_distance")
    public void setPedestrianConsiderationDistance(IAgent iAgent, Double d) {
        iAgent.setAttribute(PEDESTRIAN_CONSIDERATION_DISTANCE, (Object)d);
    }

    @GamlAnnotations.getter(value="proba_detour")
    public Double getProbaDetour(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBA_DETOUR);
    }

    @GamlAnnotations.setter(value="lambda_SFM")
    public void setlAMBDA_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(lAMBDA_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="lambda_SFM")
    public Double getlAMBDA_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(lAMBDA_SFM);
    }

    @GamlAnnotations.setter(value="gama_SFM")
    public void setGAMA_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(GAMA_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="gama_SFM")
    public Double getGAMA_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(GAMA_SFM);
    }

    @GamlAnnotations.setter(value="proba_detour")
    public void setProbaDetour(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBA_DETOUR, (Object)d);
    }

    @GamlAnnotations.getter(value="relaxion_SFM")
    public Double getRELAXION_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(RELAXION_SFM);
    }

    @GamlAnnotations.setter(value="relaxion_SFM")
    public void setRELAXION_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(RELAXION_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="A_pedestrians_SFM")
    public Double getAPedestrian_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(A_PEDESTRIAN_SFM);
    }

    @GamlAnnotations.setter(value="A_pedestrians_SFM")
    public void setAPedestrian_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(A_PEDESTRIAN_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="A_obstacles_SFM")
    public Double getAObstSFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(A_OBSTACLES_SFM);
    }

    @GamlAnnotations.setter(value="A_obstacles_SFM")
    public void setAObstSFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(A_OBSTACLES_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="B_pedestrians_SFM")
    public Double getB_SFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(B_PEDESTRIAN_SFM);
    }

    @GamlAnnotations.setter(value="B_pedestrians_SFM")
    public void setB_SFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(B_PEDESTRIAN_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="B_obstacles_SFM")
    public Double getBObstSFM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(B_OBSTACLES_SFM);
    }

    @GamlAnnotations.setter(value="B_obstacles_SFM")
    public void setBObstSFM(IAgent iAgent, Double d) {
        iAgent.setAttribute(B_OBSTACLES_SFM, (Object)d);
    }

    @GamlAnnotations.getter(value="avoid_other")
    public Boolean getAvoidOther(IAgent iAgent) {
        return (Boolean)iAgent.getAttribute(AVOID_OTHER);
    }

    @GamlAnnotations.setter(value="avoid_other")
    public void setAvoidOther(IAgent iAgent, Boolean bl) {
        iAgent.setAttribute(AVOID_OTHER, (Object)bl);
    }

    @GamlAnnotations.setter(value="velocity")
    public void setVelocity(IAgent iAgent, GamaPoint gamaPoint) {
        iAgent.setAttribute(VELOCITY, (Object)gamaPoint);
    }

    @GamlAnnotations.getter(value="velocity")
    public GamaPoint getVelocity(IAgent iAgent) {
        return (GamaPoint)iAgent.getAttribute(VELOCITY);
    }

    @GamlAnnotations.getter(value="tolerance_waypoint")
    public double getToleranceTarget(IAgent iAgent) {
        return (Double)iAgent.getAttribute(TOLERANCE_TARGET);
    }

    @GamlAnnotations.setter(value="tolerance_waypoint")
    public void setToleranceTarget(IAgent iAgent, double d) {
        iAgent.setAttribute(TOLERANCE_TARGET, (Object)d);
    }

    @GamlAnnotations.getter(value="waypoints")
    public IList<IShape> getTargets(IAgent iAgent) {
        return (IList)iAgent.getAttribute(TARGETS);
    }

    @GamlAnnotations.getter(value="roads_waypoints")
    public IMap getRoadsTargets(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(ROADS_TARGET);
    }

    @GamlAnnotations.setter(value="waypoints")
    public void setTargets(IAgent iAgent, IList<IShape> iList) {
        iAgent.setAttribute(TARGETS, iList);
    }

    @GamlAnnotations.getter(value="final_waypoint")
    public IShape getFinalTarget(IAgent iAgent) {
        return (IShape)iAgent.getAttribute(FINAL_TARGET);
    }

    @GamlAnnotations.setter(value="final_waypoint")
    public void setFinalTarget(IAgent iAgent, IShape iShape) {
        iAgent.setAttribute(FINAL_TARGET, (Object)iShape);
    }

    @GamlAnnotations.getter(value="current_index")
    public Integer getCurrentIndex(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(CURRENT_INDEX);
    }

    @GamlAnnotations.setter(value="current_index")
    public void setCurrentIndex(IAgent iAgent, Integer n) {
        iAgent.setAttribute(CURRENT_INDEX, (Object)n);
    }

    @GamlAnnotations.getter(value="use_geometry_waypoint")
    public Boolean getUseGeometryTarget(IAgent iAgent) {
        return (Boolean)iAgent.getAttribute(USE_GEOMETRY_TARGET);
    }

    @GamlAnnotations.setter(value="use_geometry_waypoint")
    public void setUseGeometryTarget(IAgent iAgent, Boolean bl) {
        iAgent.setAttribute(USE_GEOMETRY_TARGET, (Object)bl);
    }

    @GamlAnnotations.getter(value="pedestrian_model")
    public String getPedestrianModel(IAgent iAgent) {
        return (String)iAgent.getAttribute(PEDESTRIAN_MODEL);
    }

    @GamlAnnotations.setter(value="pedestrian_model")
    public void setPedestrianModel(IAgent iAgent, String string) {
        if (!"advanced".equals(string) && !"simple".equals(string)) {
            throw GamaRuntimeException.error((String)(string + " is not a possible value for pedestrian model; possible values: ['simple', 'advanced']"), (IScope)iAgent.getScope());
        }
        iAgent.setAttribute(PEDESTRIAN_MODEL, (Object)string);
    }

    @GamlAnnotations.action(name="walk_to", args={@GamlAnnotations.arg(name="target", type=13, optional=false, doc={@GamlAnnotations.doc(value="Move toward the target using the SFM model")}), @GamlAnnotations.arg(name="bounds", type=13, optional=true, doc={@GamlAnnotations.doc(value="the geometry (the localized entity geometry) that restrains this move (the agent moves inside this geometry")})}, doc={@GamlAnnotations.doc(value="action to walk toward a target", examples={@GamlAnnotations.example(value="do walk_to {10,10};")})})
    public boolean primWalkTo(IScope iScope) throws GamaRuntimeException {
        Iterator iterator2;
        ISpecies iSpecies2;
        Object object;
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (iAgent == null || iAgent.dead()) {
            return false;
        }
        IShape iShape = this.computeTarget(iScope, iAgent);
        if (iShape == null) {
            return false;
        }
        IShape iShape2 = null;
        if (iScope.hasArg("bounds")) {
            object = iScope.getArg("bounds", 0);
            iShape2 = GamaGeometryType.staticCast((IScope)iScope, object, null, (boolean)false);
        }
        object = this.getObstacleSpecies(iAgent);
        IList iList = null;
        if (object.size() == 1) {
            iList = (IContainer)object.get(0);
        } else {
            iList = GamaListFactory.create((IType)Types.AGENT);
            for (ISpecies iSpecies2 : object) {
                iList.addAll((Collection)Cast.asList((IScope)iScope, (Object)iSpecies2));
            }
        }
        object = this.getPedestrianSpecies(iAgent);
        iSpecies2 = null;
        if (object.size() == 1) {
            iSpecies2 = (IContainer)object.get(0);
        } else {
            iSpecies2 = GamaListFactory.create((IType)Types.AGENT);
            for (Iterator iterator2 : object) {
                ((IList)iSpecies2).addAll((Collection)Cast.asList((IScope)iScope, (Object)iterator2));
            }
        }
        iterator2 = iShape.getLocation();
        double d = this.computeDistance(iScope, iAgent);
        double d2 = this.walkWithForceModel(iScope, iAgent, (IShape)iterator2, this.getAvoidOther(iAgent), iShape2, (IContainer<Integer, ?>)iSpecies2, (IContainer<Integer, ?>)iList, d);
        PedestrianSkill.setRealSpeed((IAgent)iAgent, (double)d2);
        return true;
    }

    public double walkWithForceModel(IScope iScope, IAgent iAgent, IShape iShape, boolean bl, IShape iShape2, IContainer<Integer, ?> iContainer, IContainer<Integer, ?> iContainer2, double d) {
        double d2;
        IList iList;
        GamaPoint gamaPoint = this.getLocation(iAgent).copy(iScope);
        GamaPoint gamaPoint2 = iShape.isPoint() ? iShape.getLocation() : SpatialPunctal._closest_point_to((GamaPoint)gamaPoint, (IShape)iShape);
        gamaPoint2.setZ(gamaPoint2.z);
        double d3 = gamaPoint.distance((Coordinate)gamaPoint2);
        if (d3 == 0.0) {
            return 0.0;
        }
        if (!iShape.isPoint() && iShape2 != null && this.getCurrentEdge(iAgent) != null) {
            iList = GamaListFactory.create();
            iList.add((Object)iAgent.getLocation());
            iList.add((Object)gamaPoint2);
            IShape iShape3 = SpatialCreation.line((IScope)iScope, (IContainer)iList);
            if (!iShape2.covers(iShape3)) {
                gamaPoint2 = SpatialPunctal._closest_point_to((GamaPoint)gamaPoint2, (IShape)this.getCurrentEdge(iAgent));
                iList.clear();
                iList.add((Object)iAgent.getLocation());
                iList.add((Object)gamaPoint2);
                iShape3 = SpatialCreation.line((IScope)iScope, (IContainer)iList);
                if (!iShape2.covers(iShape3)) {
                    gamaPoint2 = SpatialPunctal._closest_point_to((GamaPoint)gamaPoint, (IShape)this.getCurrentEdge(iAgent));
                }
            }
        }
        iList = null;
        if (bl) {
            double d4 = Math.max(d, this.getPedestrianConsiderationDistance(iAgent));
            double d5 = Math.max(d, this.getObstacleConsiderationDistance(iAgent));
            iList = "simple".equals(this.getPedestrianModel(iAgent)) ? this.avoidSFMSimple(iScope, iAgent, gamaPoint, gamaPoint2, d4, d5, iContainer, iContainer2) : this.avoidSFM(iScope, iAgent, gamaPoint, gamaPoint2, d4, d5, iContainer, iContainer2);
            iList = iList.multiplyBy(d3);
        } else {
            iList = gamaPoint2.copy(iScope).minus(gamaPoint);
        }
        GamaPoint gamaPoint3 = iList.copy(iScope).add(gamaPoint);
        double d6 = gamaPoint.euclidianDistanceTo(gamaPoint3);
        if (d6 > 0.0) {
            d2 = Math.min(d / d6, 1.0);
            if (d2 == 1.0) {
                gamaPoint = gamaPoint3;
            } else {
                iList = iList.multiplyBy(d2);
                gamaPoint = gamaPoint.add((GamaPoint)iList);
            }
        }
        if (iShape2 != null && !SpatialProperties.overlaps((IScope)iScope, (IShape)gamaPoint, (IShape)iShape2).booleanValue()) {
            gamaPoint = (GamaPoint)SpatialPunctal.closest_points_with((IShape)gamaPoint, (IShape)iShape2).get(1);
        }
        d2 = 0.0;
        double d7 = this.getProbaDetour(iAgent);
        if (!Random.opFlip((IScope)iScope, (Double)(1.0 - d7)).booleanValue() || gamaPoint.euclidianDistanceTo(gamaPoint2) <= iAgent.getLocation().euclidianDistanceTo(gamaPoint2)) {
            d2 = iAgent.euclidianDistanceTo(gamaPoint) / iScope.getSimulation().getTimeStep(iScope);
            this.setVelocity(iAgent, gamaPoint.copy(iScope).minus(this.getLocation(iAgent)));
            this.setLocation(iAgent, gamaPoint);
        } else {
            this.setVelocity(iAgent, new GamaPoint(0.0, 0.0, 0.0));
        }
        return d2;
    }

    public GamaPoint avoidSFMSimple(IScope iScope, IAgent iAgent, GamaPoint gamaPoint, GamaPoint gamaPoint2, double d, double d2, IContainer iContainer, IContainer iContainer2) {
        GamaPoint gamaPoint3;
        IAgent iAgent22;
        IMap iMap = GamaMapFactory.create();
        GamaPoint gamaPoint4 = this.getVelocity(iAgent).copy(iScope);
        GamaPoint gamaPoint5 = new GamaPoint(0.0, 0.0, 0.0);
        double d3 = gamaPoint.euclidianDistanceTo(gamaPoint2);
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        IList iList2 = GamaListFactory.create((IType)Types.AGENT);
        iList2.addAll((Collection)SpatialQueries.at_distance((IScope)iScope, (IContainer)iContainer, (Double)d));
        iList.addAll((Collection)SpatialQueries.at_distance((IScope)iScope, (IContainer)iContainer2, (Double)d2));
        iList2.remove((Object)iAgent);
        iList2.removeIf(IAgent::dead);
        double d4 = this.getlAMBDA_SFM(iAgent);
        double d5 = this.getGAMA_SFM(iAgent);
        double d6 = this.getAPedestrian_SFM(iAgent);
        double d7 = this.getN_SFM(iAgent);
        double d8 = this.getN_PRIME_SFM(iAgent);
        for (IAgent iAgent22 : iList2) {
            double d9;
            double d10;
            GamaPoint gamaPoint6;
            gamaPoint3 = new GamaPoint(0.0, 0.0, 0.0);
            double d11 = iAgent.euclidianDistanceTo((IShape)iAgent22);
            GamaPoint gamaPoint7 = Points.subtract((GamaPoint)iAgent22.getLocation(), (GamaPoint)iAgent.getLocation());
            gamaPoint7 = gamaPoint7.divideBy(Maths.sqrt((IScope)iScope, (Double)(gamaPoint7.x * gamaPoint7.x + gamaPoint7.y * gamaPoint7.y + gamaPoint7.z * gamaPoint7.z)).doubleValue());
            GamaPoint gamaPoint8 = gamaPoint4.copy(iScope).subtract(this.getVelocity(iAgent22)).multiplyBy(d4).add(gamaPoint7);
            double d12 = Maths.sqrt((IScope)iScope, (Double)(gamaPoint8.x * gamaPoint8.x + gamaPoint8.y * gamaPoint8.y + gamaPoint8.z * gamaPoint8.z));
            double d13 = d5 * d12;
            GamaPoint gamaPoint9 = gamaPoint8.divideBy(d12);
            if (gamaPoint9.x == 0.0) {
                gamaPoint6 = new GamaPoint((double)(gamaPoint9.y > 0.0 ? -1 : 1), 0.0, 0.0);
            } else if (gamaPoint9.y == 0.0) {
                gamaPoint6 = new GamaPoint(0.0, (double)(gamaPoint9.x > 0.0 ? 1 : -1), 0.0);
            } else {
                d10 = -gamaPoint9.y / gamaPoint9.x;
                d9 = Math.sqrt(d10 * d10 + 1.0);
                gamaPoint6 = gamaPoint9.x > 0.0 ? new GamaPoint(-d10 / d9, -1.0 / d9, 0.0) : new GamaPoint(d10 / d9, 1.0 / d9, 0.0);
            }
            d10 = gamaPoint9.x * gamaPoint7.x + gamaPoint9.y * gamaPoint7.y + gamaPoint9.z * gamaPoint7.z;
            d10 = Math.max(Math.min(d10, 1.0), -1.0);
            d9 = Math.abs(Maths.acos((Double)d10) * Math.PI / 180.0);
            if (d9 <= Math.PI) {
                GamaPoint gamaPoint10 = gamaPoint9.multiplyBy(Math.exp(-Math.pow(d8 * d13 * d9, 2.0)));
                GamaPoint gamaPoint11 = gamaPoint6.multiplyBy(Math.exp(-Math.pow(d7 * d13 * d9, 2.0)));
                gamaPoint3 = gamaPoint10.add(gamaPoint11).multiplyBy(-d6 * Math.exp(-d11 / d13));
                gamaPoint5 = gamaPoint5.add(gamaPoint3);
            }
            iMap.put((Object)iAgent22, (Object)gamaPoint3);
        }
        iAgent22 = gamaPoint2.copy(iScope).minus(gamaPoint).divideBy(d3 / Math.min(PedestrianSkill.getSpeed((IAgent)iAgent), d3 / iScope.getSimulation().getClock().getStepInSeconds()));
        Iterator iterator = iAgent22.minus(gamaPoint4).dividedBy(this.getRELAXION_SFM(iAgent).doubleValue());
        iMap.put((Object)iAgent, (Object)iterator);
        iAgent.setAttribute(FORCES, (Object)iMap);
        gamaPoint3 = iterator.add(gamaPoint5);
        return gamaPoint4.add(gamaPoint3).normalize();
    }

    public GamaPoint avoidSFM(IScope iScope, IAgent iAgent, GamaPoint gamaPoint, GamaPoint gamaPoint2, double d, double d2, IContainer iContainer, IContainer iContainer2) {
        Iterator iterator2;
        double d3;
        GamaPoint gamaPoint3;
        GamaPoint gamaPoint4;
        GamaPoint gamaPoint52;
        GamaPoint gamaPoint6 = this.getVelocity(iAgent).copy(iScope);
        double d4 = this.getBObstSFM(iAgent);
        double d5 = this.getB_SFM(iAgent);
        Double d6 = this.getMinDist(iAgent);
        double d7 = this.getShoulderLength(iAgent) / 2.0 + d6;
        IMap iMap = GamaMapFactory.create();
        double d8 = gamaPoint.euclidianDistanceTo(gamaPoint2);
        if (d8 == 0.0 || PedestrianSkill.getSpeed((IAgent)iAgent) <= 0.0) {
            return new GamaPoint(0.0, 0.0, 0.0);
        }
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        IList iList2 = GamaListFactory.create((IType)Types.AGENT);
        iList.addAll((Collection)SpatialQueries.at_distance((IScope)iScope, (IContainer)iContainer2, (Double)d2));
        iList2.addAll((Collection)SpatialQueries.at_distance((IScope)iScope, (IContainer)iContainer, (Double)d));
        iList.remove((Object)iAgent);
        iList.removeIf(IAgent::dead);
        double d9 = this.getlAMBDA_SFM(iAgent);
        double d10 = this.getGAMA_SFM(iAgent);
        double d11 = this.getAPedestrian_SFM(iAgent);
        double d12 = this.getAObstSFM(iAgent);
        double d13 = this.getKSFM(iAgent);
        double d14 = this.getKappaSFM(iAgent);
        GamaPoint gamaPoint7 = gamaPoint6.copy(iScope).normalize();
        GamaPoint gamaPoint8 = gamaPoint2.copy(iScope).minus(gamaPoint).divideBy(d8 / Math.min(PedestrianSkill.getSpeed((IAgent)iAgent), d8 / iScope.getSimulation().getClock().getStepInSeconds()));
        GamaPoint gamaPoint9 = gamaPoint8.minus(gamaPoint6).dividedBy(this.getRELAXION_SFM(iAgent).doubleValue());
        if (gamaPoint7.equals((Object)new GamaPoint())) {
            gamaPoint7 = gamaPoint9;
        }
        GamaPoint gamaPoint10 = new GamaPoint();
        for (GamaPoint gamaPoint52 : iList2) {
            double d15 = iAgent.getLocation().euclidianDistanceTo(gamaPoint52.getLocation());
            GamaPoint gamaPoint11 = new GamaPoint();
            if (d15 > 0.0) {
                double d16 = d11 * Math.exp((d7 + this.getShoulderLength((IAgent)gamaPoint52) / 2.0 - d15) / d5);
                GamaPoint gamaPoint12 = Points.subtract((GamaPoint)iAgent.getLocation(), (GamaPoint)gamaPoint52.getLocation());
                gamaPoint12 = gamaPoint12.dividedBy(d15);
                double d17 = SpatialPunctal.angleInDegreesBetween((IScope)iScope, (GamaPoint)new GamaPoint(), (GamaPoint)gamaPoint7, (GamaPoint)gamaPoint12.copy(iScope).multiplyBy(-1.0));
                GamaPoint gamaPoint13 = gamaPoint12.multiplyBy(d16 * (d9 + (1.0 - d9) * (1.0 + Math.cos(d17)) / 2.0));
                gamaPoint4 = new GamaPoint(-1.0 * gamaPoint12.y, gamaPoint12.x);
                gamaPoint3 = this.getVelocity((IAgent)gamaPoint52).copy(iScope).normalize();
                d3 = GamaPoint.dotProduct((GamaPoint)gamaPoint7, (GamaPoint)gamaPoint3);
                GamaPoint gamaPoint14 = d3 <= 0.0 ? gamaPoint4.multiplyBy(d10 * gamaPoint13.norm()) : new GamaPoint(0.0, 0.0, 0.0);
                GamaPoint gamaPoint15 = gamaPoint13.add(gamaPoint14);
                gamaPoint11 = gamaPoint15.copy(iScope);
                double d18 = d7 + this.getShoulderLength((IAgent)gamaPoint52) / 2.0 - d15;
                if (d18 > 0.0) {
                    GamaPoint gamaPoint16 = new GamaPoint();
                    gamaPoint16 = gamaPoint16.add(gamaPoint12.copy(iScope).multiplyBy(d18 * d13));
                    double d19 = GamaPoint.dotProduct((GamaPoint)this.getVelocity((IAgent)gamaPoint52).copy(iScope).minus(gamaPoint6), (GamaPoint)gamaPoint4);
                    gamaPoint16 = gamaPoint16.add(gamaPoint4.copy(iScope).multiplyBy(d18 * d14 * d19));
                    gamaPoint11 = gamaPoint11.add(gamaPoint16);
                }
            }
            gamaPoint10 = gamaPoint10.add(gamaPoint11);
            iMap.put((Object)gamaPoint52, (Object)gamaPoint11);
        }
        gamaPoint52 = new GamaPoint();
        for (Iterator iterator2 : iList) {
            double d20 = iAgent.euclidianDistanceTo((IShape)iterator2);
            GamaPoint gamaPoint17 = null;
            GamaPoint gamaPoint18 = new GamaPoint();
            gamaPoint17 = d20 == 0.0 ? SpatialPunctal._closest_point_to((GamaPoint)iAgent.getLocation(), (IShape)iterator2.getGeometry().getExteriorRing(iScope)) : SpatialPunctal._closest_point_to((GamaPoint)iAgent.getLocation(), (IShape)iterator2);
            if (d20 > 0.0) {
                double d21 = d12 * Math.exp((d7 - d20) / d4);
                double d22 = d7 - d20;
                if (d22 > 0.0) {
                    d21 += d13 * d22;
                }
                gamaPoint4 = Points.subtract((GamaPoint)iAgent.getLocation(), (GamaPoint)gamaPoint17.getLocation());
                gamaPoint4 = gamaPoint4.normalize();
                gamaPoint18 = gamaPoint4.multiplyBy(d21);
                if (d22 > 0.0) {
                    gamaPoint3 = new GamaPoint(-1.0 * gamaPoint4.y, gamaPoint4.x);
                    d3 = GamaPoint.dotProduct((GamaPoint)gamaPoint6, (GamaPoint)gamaPoint3);
                    gamaPoint18 = gamaPoint18.minus(gamaPoint3.multiplyBy(d22 * d14 * d3));
                }
            }
            gamaPoint52.add(gamaPoint18);
            iMap.put((Object)iterator2, (Object)gamaPoint18);
        }
        iMap.put((Object)iAgent, (Object)gamaPoint9);
        iAgent.setAttribute(FORCES, (Object)iMap);
        iterator2 = gamaPoint9.add(gamaPoint10).add(gamaPoint52);
        return gamaPoint6.add((GamaPoint)iterator2).normalize();
    }

    @GamlAnnotations.action(name="compute_virtual_path", args={@GamlAnnotations.arg(name="pedestrian_graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="the graph on wich compute the path")}), @GamlAnnotations.arg(name="target", type=13, optional=false, doc={@GamlAnnotations.doc(value="the target to reach, can be any agent")})}, doc={@GamlAnnotations.doc(value="action to compute a path to a location according to a given graph", returns="the computed path, return nil if no path can be taken", examples={@GamlAnnotations.example(value="do compute_virtual_path graph: pedestrian_network target: any_point;")})})
    public IPath primComputeVirtualPath(IScope iScope) throws GamaRuntimeException {
        IShape iShape;
        IShape iShape2;
        GamaSpatialPath gamaSpatialPath = null;
        ISpatialGraph iSpatialGraph = (ISpatialGraph)iScope.getArg(PEDESTRIAN_GRAPH, 15);
        IAgent iAgent = this.getCurrentAgent(iScope);
        boolean bl = this.getUseGeometryTarget(iAgent);
        IShape iShape3 = (IShape)iScope.getArg("target", 13);
        GamaPoint gamaPoint = iAgent.getLocation();
        gamaSpatialPath = ((GraphTopology)iSpatialGraph.getTopology(iScope)).pathBetween(iScope, (IShape)gamaPoint, iShape3);
        if (gamaSpatialPath == null) {
            return gamaSpatialPath;
        }
        IMap iMap = GamaMapFactory.create();
        IList iList = GamaListFactory.create();
        IList iList2 = gamaSpatialPath.getEdgeGeometry();
        int n = 0;
        while (n < iList2.size()) {
            iShape2 = (IShape)iList2.get(n);
            iShape = gamaSpatialPath.getRealObject((Object)iShape2);
            IMap<IAgent, IShape> iMap2 = PedestrianRoadSkill.getConnectedSegmentsIntersection((IAgent)iShape);
            IShape iShape4 = null;
            IShape iShape5 = null;
            IShape iShape6 = null;
            if (bl) {
                iShape4 = PedestrianRoadSkill.getFreeSpace(iShape.getAgent());
                if (n < iList2.size() - 1) {
                    iShape5 = gamaSpatialPath.getRealObject(iList2.get(n + 1));
                    iShape6 = PedestrianRoadSkill.getFreeSpace(iShape5.getAgent());
                }
            }
            IList iList3 = iShape2.getPoints();
            int n2 = 1;
            while (n2 < iList3.size()) {
                GamaPoint gamaPoint2 = (GamaPoint)iList3.get(n2);
                GamaPoint gamaPoint3 = null;
                gamaPoint3 = gamaPoint2;
                if (bl) {
                    gamaPoint3 = null;
                    if (iShape6 != null) {
                        gamaPoint3 = iMap2 != null && iMap2.contains(iScope, (Object)iShape5) ? (IShape)iMap2.get((Object)iShape5) : SpatialOperators.inter((IScope)iScope, (IShape)iShape4, (IShape)iShape6);
                    }
                    if (gamaPoint3 == null) {
                        gamaPoint3 = gamaPoint2;
                    }
                }
                iList.add((Object)gamaPoint3);
                iMap.put((Object)gamaPoint3, (Object)iShape);
                ++n2;
            }
            ++n;
        }
        IShape iShape7 = (IShape)iList.get(0);
        iShape2 = (IAgent)iMap.get((Object)iShape7);
        if (iShape2 != null) {
            PedestrianRoadSkill.register(iScope, (IAgent)iShape2, iAgent);
        }
        if (!((IShape)iList.get(0)).getLocation().equals((Object)iAgent.getLocation())) {
            if (iShape2 == null) {
                iAgent.setLocation(((IShape)iList.get(0)).getLocation());
            } else {
                iShape = PedestrianRoadSkill.getFreeSpace((IAgent)iShape2);
                if (!iShape.intersects((IShape)iAgent.getLocation())) {
                    iAgent.setLocation(SpatialPunctal._closest_point_to((GamaPoint)iAgent.getLocation(), (IShape)iShape));
                }
            }
        }
        iAgent.setAttribute(ROADS_TARGET, (Object)iMap);
        this.setCurrentIndex(iAgent, 0);
        this.setTargets(iAgent, (IList<IShape>)iList);
        this.setFinalTarget(iAgent, iShape3);
        this.setCurrentTarget(iAgent, iShape7);
        iAgent.setAttribute(CURRENT_PATH, (Object)gamaSpatialPath);
        return gamaSpatialPath;
    }

    @GamlAnnotations.action(name="release_path", args={@GamlAnnotations.arg(name="current_road", type=11, optional=true, doc={@GamlAnnotations.doc(value="current road on which the agent is located (can be nil)")})}, doc={@GamlAnnotations.doc(value="clean all the interne state of the agent")})
    public boolean primArrivedAtDestination(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IAgent iAgent2 = (IAgent)iScope.getArg("current_road", 11);
        this.setCurrentIndex(iAgent, 0);
        this.setCurrentTarget(iAgent, null);
        this.setTargets(iAgent, (IList<IShape>)GamaListFactory.create());
        this.setFinalTarget(iAgent, null);
        PedestrianSkill.setCurrentPath((IAgent)iAgent, null);
        this.setCurrentEdge(iAgent, null);
        PedestrianSkill.setRealSpeed((IAgent)iAgent, (double)0.0);
        if (iAgent2 != null) {
            return PedestrianRoadSkill.unregister(iScope, iAgent2, iAgent);
        }
        return false;
    }

    @GamlAnnotations.action(name="walk", doc={@GamlAnnotations.doc(value="action to walk toward the final target using the current_path (requires to use the compute_virtual_path action before)", examples={@GamlAnnotations.example(value="do walk;")})})
    public boolean primWalk(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (iAgent == null || iAgent.dead()) {
            return false;
        }
        IShape iShape = this.getFinalTarget(iAgent);
        if (iShape == null) {
            return false;
        }
        IList<IShape> iList = this.getTargets(iAgent);
        if (iList == null || iList.isEmpty()) {
            return false;
        }
        GamaPoint gamaPoint = this.getLocation(iAgent).copy(iScope);
        double d = this.computeDistance(iScope, iAgent);
        boolean bl = true;
        int n = iList.size() - 1;
        while (bl) {
            GamaPoint gamaPoint22;
            bl = false;
            int n2 = this.getCurrentIndex(iAgent);
            IShape iShape2 = this.getCurrentTarget(iAgent);
            IAgent iAgent2 = (IAgent)this.getRoadsTargets(iAgent).get((Object)iShape2);
            IShape iShape3 = null;
            boolean bl2 = this.getAvoidOther(iAgent);
            if (iAgent2 != null) {
                bl2 = PedestrianRoadSkill.getRoadStatus(iScope, (IShape)iAgent2) == 0 ? false : bl2;
                iShape3 = PedestrianRoadSkill.getFreeSpace(iScope, (IShape)iAgent2);
            }
            IList<IAgent> iList2 = iAgent2 == null ? GamaListFactory.create() : PedestrianRoadSkill.getCloseAgents(iAgent2);
            IList<ISpecies> iList3 = this.getObstacleSpecies(iAgent);
            IList iList4 = null;
            if (iList3.size() == 1) {
                iList4 = (IContainer)iList3.get(0);
            } else {
                iList4 = GamaListFactory.create((IType)Types.AGENT);
                for (GamaPoint gamaPoint22 : iList3) {
                    iList4.addAll((Collection)Cast.asList((IScope)iScope, (Object)gamaPoint22));
                }
            }
            gamaPoint22 = gamaPoint.copy(iScope);
            this.walkWithForceModel(iScope, iAgent, iShape2, bl2, iShape3, (IContainer<Integer, ?>)iList2, (IContainer<Integer, ?>)iList4, d);
            gamaPoint = iAgent.getLocation();
            if (!this.arrivedAtTarget(iScope, gamaPoint, iShape2, this.getToleranceTarget(iAgent), n2, n, iList)) continue;
            if (iAgent2 != null) {
                PedestrianRoadSkill.unregister(iScope, iAgent2, iAgent);
            }
            if (n2 < n) {
                this.setCurrentIndex(iAgent, ++n2);
                this.setCurrentTarget(iAgent, (IShape)iList.get(n2));
                iAgent2 = (IAgent)this.getRoadsTargets(iAgent).get((Object)this.getCurrentTarget(iAgent));
                if (iAgent2 != null) {
                    PedestrianRoadSkill.register(iScope, iAgent2, iAgent);
                }
                if (!((d -= gamaPoint.distance((Coordinate)gamaPoint22)) > 0.0)) continue;
                bl = true;
                continue;
            }
            Iterator iterator = iAgent.getSpecies();
            IStatement.WithArgs withArgs = iterator.getAction("release_path");
            Arguments arguments = new Arguments();
            arguments.put("current_road", (IExpressionDescription)ConstantExpressionDescription.create((Object)iAgent2));
            withArgs.setRuntimeArgs(iScope, arguments);
            withArgs.executeOn(iScope);
        }
        return true;
    }

    boolean arrivedAtTarget(IScope iScope, GamaPoint gamaPoint, IShape iShape, double d, int n, int n2, IList<IShape> iList) {
        double d2 = gamaPoint.euclidianDistanceTo(iShape);
        return d2 <= d;
    }
}

