/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pedestrian.operator;

import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PedestrianNetwork {
    public static IList<IShape> generateNetwork(IScope iScope, IList<IContainer<?, ? extends IShape>> iList, IContainer<?, ? extends IShape> iContainer, IContainer<?, ? extends IShape> iContainer2, Boolean bl, boolean bl2, double d, double d2, boolean bl3, double d3, double d4, double d5, double d6, double d7) {
        DEBUG.ON();
        DEBUG.OUT((Object)"Start generating pedestrian network");
        double d8 = System.currentTimeMillis();
        boolean bl4 = true;
        IShape iShape = iScope.getSimulation().getGeometry().copy(iScope);
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            bl4 = false;
        } else {
            iShape = SpatialOperators.union((IScope)iScope, iContainer).copy(iScope);
        }
        IShape iShape2 = iShape.copy(iScope);
        double d9 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Processing walking area: " + (d9 - d8)));
        IList iList2 = d7 > 0.0 ? SpatialTransformations.toSquares((IScope)iScope, (IShape)iShape2, (Double)d7, (boolean)true) : null;
        double d10 = System.currentTimeMillis();
        DEBUG.OUT((Object)("|==> Processing squarification : " + (d10 - d9) / 1000.0));
        for (IContainer iContainer3 : iList) {
            for (IShape iShape3 : iContainer3.iterable(iScope)) {
                if (iList2 == null) {
                    iShape2 = SpatialOperators.minus((IScope)iScope, (IShape)iShape2, (IShape)iShape3);
                    continue;
                }
                IList iList3 = SpatialQueries.overlapping((IScope)iScope, (IContainer)iList2, (IShape)iShape3);
                for (IShape iShape4 : iList3) {
                    IShape iShape5 = SpatialOperators.minus((IScope)iScope, (IShape)iShape4, (IShape)iShape3);
                    if (iShape5 == null) continue;
                    iList2.remove((Object)iShape4);
                    iList2.add((Object)iShape5);
                }
            }
        }
        if (iList2 != null) {
            iShape2 = SpatialOperators.union((IScope)iScope, (IContainer)iList2);
        }
        double d11 = System.currentTimeMillis();
        DEBUG.OUT((Object)("|==> Remove obstacle from area : " + (d11 - d10) / 1000.0));
        if (iShape2 == null) {
            throw GamaRuntimeException.error((String)"Get a null area when computing the background geometry", (IScope)iScope);
        }
        iShape2 = PedestrianNetwork.keepMainGeom(iShape2);
        double d12 = System.currentTimeMillis();
        DEBUG.OUT((Object)("|==> Keep main component : " + (d12 - d11) / 1000.0));
        if (bl.booleanValue()) {
            iShape2 = PedestrianNetwork.managementOpenArea(iScope, iShape2, bl2, d, d2);
        }
        double d13 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Processing open area: " + (d13 - d12)));
        double d14 = d3;
        double d15 = d4;
        IList iList4 = SpatialTransformations.skeletonize((IScope)iScope, (IShape)iShape2, (Double)d14, (Double)d15, (boolean)false);
        double d16 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Skeletonization : " + (d16 - d13)));
        double d17 = d5;
        if (d17 > 0.0) {
            GamaShape gamaShape = iShape2.getExteriorRing(iScope);
            iList4.removeIf(arg_0 -> PedestrianNetwork.lambda$0((IShape)gamaShape, d5, arg_0));
        }
        double d18 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Clean skeletonized network : " + (d18 - d16)));
        if (bl4 && iContainer2 != null && !iContainer2.isEmpty(iScope)) {
            return PedestrianNetwork.collapseNetwork(iScope, iShape, iList, -1.0, (IList<IShape>)iList4, (IList<IShape>)iContainer2.listValue(iScope, (IType)Types.GEOMETRY, false));
        }
        double d19 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Processing bi network : " + (d19 - d18)));
        IShape iShape6 = SpatialOperators.union((IScope)iScope, (IContainer)iList4);
        iList4 = SpatialTransformations.clean((IScope)iScope, (IList)iShape6.getGeometries(), (double)0.0, (boolean)true, (boolean)bl3);
        double d20 = System.currentTimeMillis();
        DEBUG.OUT((Object)("Clean final network : " + (d20 - d19)));
        IList iList5 = GamaListFactory.create();
        for (IShape iShape7 : iList4) {
            if (d6 > 0.0) {
                iShape7 = SpatialTransformations.simplification((IScope)iScope, (IShape)iShape7, (Double)d6);
            }
            if (iShape7.getPoints().size() == 2) {
                iList5.add((Object)iShape7);
                continue;
            }
            if (iShape7.getPoints().size() <= 2) continue;
            int n = 0;
            while (n < iShape7.getPoints().size() - 1) {
                IList iList6 = GamaListFactory.create();
                iList6.add((Object)((IShape)iShape7.getPoints().get(n)));
                iList6.add((Object)((IShape)iShape7.getPoints().get(n + 1)));
                IShape iShape8 = SpatialCreation.line((IScope)iScope, (IContainer)iList6);
                iList5.add((Object)iShape8);
                ++n;
            }
        }
        double d21 = System.currentTimeMillis();
        DEBUG.OUT((Object)("To segments : " + (d21 - d20)));
        return iList5;
    }

    public static IShape keepMainGeom(IShape iShape) {
        IShape iShape2 = iShape;
        if (iShape.getGeometries().size() > 1) {
            double d = 0.0;
            IShape iShape3 = null;
            for (IShape iShape4 : iShape.getGeometries()) {
                if (!(iShape4.getArea() > d)) continue;
                d = iShape4.getArea();
                iShape3 = iShape4;
            }
            iShape2 = iShape3;
        }
        return iShape2;
    }

    public static IShape managementOpenArea(IScope iScope, IShape iShape, boolean bl, double d, double d2) {
        IShape iShape2 = SpatialTransformations.reduced_by((IScope)iScope, (IShape)iShape, (Double)d);
        if (iShape2 != null) {
            IList iList = GamaListFactory.create((IType)Types.GEOMETRY);
            for (IShape iShape3 : iShape2.getGeometries()) {
                long l;
                if (iShape3 == null || iShape3.getArea() == 0.0 || (l = Math.round(iShape3.getArea() * d2)) == 0L) continue;
                if (bl) {
                    int n = 0;
                    while ((long)n < l) {
                        iList.add(SpatialPunctal.any_location_in((IScope)iScope, (IShape)iShape3));
                        ++n;
                    }
                    continue;
                }
                double d3 = Math.sqrt(iShape3.getArea() / (double)l);
                IList iList2 = SpatialTransformations.toSquares((IScope)iScope, (IShape)iShape3, (Double)d3);
                for (IShape iShape4 : iList2) {
                    iList.add(iShape4.getCentroid());
                }
            }
            for (IShape iShape3 : iList) {
                iShape = SpatialOperators.minus((IScope)iScope, (IShape)iShape, (IShape)SpatialTransformations.enlarged_by((IScope)iScope, (IShape)iShape3, (Double)0.01, (Integer)5));
            }
        }
        return iShape;
    }

    public static IList<IShape> collapseNetwork(IScope iScope, IShape iShape3, IList<IContainer<?, ? extends IShape>> iList, double d, IList<IShape> iList2, IList<IShape> iList3) {
        Iterator iterator3;
        Iterator iterator2;
        IShape iShape42;
        IList iList4 = GamaListFactory.create();
        DEBUG.OUT((Object)"Clean regular and pedestrian network");
        IList iList5 = SpatialTransformations.clean((IScope)iScope, (IList)SpatialOperators.union((IScope)iScope, iList3).getGeometries(), (double)0.0, (boolean)true, (boolean)false);
        IList iList6 = SpatialTransformations.clean((IScope)iScope, (IList)SpatialOperators.union((IScope)iScope, iList2).getGeometries(), (double)0.0, (boolean)true, (boolean)true);
        DEBUG.OUT((Object)"Remove edges within pedestrian area from regular network");
        IList iList7 = GamaListFactory.create();
        for (IShape iShape42 : iList5) {
            if (iShape3.covers(iShape42)) continue;
            if (!iShape3.intersects(iShape42)) {
                iShape42.setAttribute("road_status", (Object)0);
                iList4.add((Object)iShape42);
                continue;
            }
            iterator2 = SpatialOperators.minus((IScope)iScope, (IShape)iShape42, (IShape)iShape3);
            iterator2.setAttribute("road_status", 0);
            iList4.add((Object)iterator2);
            IShape iShape5 = (IShape)iterator2.getPoints().firstValue(iScope);
            IShape iShape6 = (IShape)iterator2.getPoints().lastValue(iScope);
            iList7.add(iShape5.euclidianDistanceTo(iShape3) < iShape6.euclidianDistanceTo(iShape3) ? iShape5 : iShape6);
        }
        DEBUG.OUT((Object)"Add all pedestrian corridor from pedestrian network");
        for (IShape iShape42 : iList6) {
            iShape42.setAttribute("road_status", (Object)1);
            iList4.add((Object)iShape42);
        }
        iShape42 = GamaListFactory.create();
        for (Iterator iterator3 : iList) {
            for (IShape iShape5 : iterator3.iterable(iScope)) {
                iShape42.add((Object)iShape5);
            }
        }
        iterator3 = SpatialOperators.union((IScope)iScope, (IContainer)iShape42);
        DEBUG.OUT((Object)"Iterate over potential connecting points (corridor that cross the pedestrian area boundaries)");
        iterator2 = (IList)((Set)iList6.stream(iScope).flatMap(iShape -> iShape.getPoints().stream()).collect(Collectors.toSet())).stream().collect(GamaListFactory.toGamaList());
        for (IShape iShape5 : iList7) {
            Map map = (Map)iterator2.stream(iScope).collect(Collectors.toMap(iShape -> iShape, iShape2 -> iShape5.euclidianDistanceTo(iShape2)));
            IList iList8 = GamaListFactory.create();
            if (iList8.isEmpty()) {
                IShape iShape7 = (IShape)Collections.min(map.entrySet(), Comparator.comparing(Map.Entry::getValue)).getKey();
                iList8.add((Object)SpatialCreation.link((IScope)iScope, (IShape)iShape7, (IShape)iShape5));
            }
            for (IShape iShape7 : iList8.stream().filter(arg_0 -> PedestrianNetwork.lambda$5((IShape)iterator3, arg_0)).toList()) {
                iShape7.setAttribute("road_status", (Object)1);
                iList4.add((Object)iShape7);
            }
        }
        return iList4;
    }

    private static /* synthetic */ boolean lambda$0(IShape iShape, double d, IShape iShape2) {
        return iShape.euclidianDistanceTo(iShape2) < d;
    }

    private static /* synthetic */ boolean lambda$5(IShape iShape, IShape iShape2) {
        return !iShape2.crosses(iShape);
    }
}

