/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.collision.shapes.TriangleShape;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

class ConvexTriangleCallback
implements TriangleCallback {
    private final CollisionObject convexBody;
    private final CollisionObject triBody;
    private final Vector3f aabbMin = new Vector3f();
    private final Vector3f aabbMax = new Vector3f();
    private ManifoldResult resultOut;
    private final Dispatcher dispatcher;
    private float collisionMarginTriangle;
    public int triangleCount;
    public PersistentManifold manifoldPtr;
    private final CollisionAlgorithmConstructionInfo ci = new CollisionAlgorithmConstructionInfo();
    private final TriangleShape tm = new TriangleShape();

    public ConvexTriangleCallback(Dispatcher dispatcher, CollisionObject collisionObject, CollisionObject collisionObject2, boolean bl) {
        this.dispatcher = dispatcher;
        this.convexBody = bl ? collisionObject2 : collisionObject;
        this.triBody = bl ? collisionObject : collisionObject2;
        this.manifoldPtr = dispatcher.getNewManifold(this.convexBody, this.triBody);
    }

    public void destroy() {
        this.dispatcher.releaseManifold(this.manifoldPtr);
    }

    public void setTimeStepAndCounters(float f, ManifoldResult manifoldResult) {
        this.collisionMarginTriangle = f;
        this.resultOut = manifoldResult;
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        this.triBody.getWorldTransform(transform);
        transform.inverse();
        Transform transform2 = this.convexBody.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        transform.mul(transform2);
        CollisionShape collisionShape = this.convexBody.getCollisionShape();
        collisionShape.getAabb(transform, this.aabbMin, this.aabbMax);
        float f2 = f;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(f2, f2, f2);
        this.aabbMax.add(vector3f);
        this.aabbMin.sub(vector3f);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform});
    }

    @Override
    public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
        this.ci.dispatcher1 = this.dispatcher;
        CollisionObject collisionObject = this.triBody;
        if (this.convexBody.getCollisionShape().isConvex()) {
            this.tm.init(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
            this.tm.setMargin(this.collisionMarginTriangle);
            CollisionShape collisionShape = collisionObject.getCollisionShape();
            collisionObject.internalSetTemporaryCollisionShape(this.tm);
            CollisionAlgorithm collisionAlgorithm = this.ci.dispatcher1.findAlgorithm(this.convexBody, this.triBody, this.manifoldPtr);
            this.resultOut.setShapeIdentifiers(-1, -1, n, n2);
            collisionAlgorithm.processCollision(this.convexBody, this.triBody, this.resultOut);
            this.ci.dispatcher1.freeCollisionAlgorithm(collisionAlgorithm);
            collisionObject.internalSetTemporaryCollisionShape(collisionShape);
        }
    }

    public Vector3f getAabbMin(Vector3f vector3f) {
        vector3f.set(this.aabbMin);
        return vector3f;
    }

    public Vector3f getAabbMax(Vector3f vector3f) {
        vector3f.set(this.aabbMax);
        return vector3f;
    }
}

