/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import java.io.Serializable;

public class QuantizedBvhNodes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STRIDE = 4;
    private int[] buf;
    private int size = 0;

    public QuantizedBvhNodes() {
        this.resize(16);
    }

    public int add() {
        while (this.size + 1 >= this.capacity()) {
            this.resize(this.capacity() * 2);
        }
        return this.size++;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.buf.length / 4;
    }

    public void clear() {
        this.size = 0;
    }

    public void resize(int n) {
        int[] nArray = this.buf;
        this.buf = new int[n * 4];
        if (nArray != null) {
            System.arraycopy(nArray, 0, this.buf, 0, Math.min(nArray.length, this.buf.length));
        }
    }

    public static int getNodeSize() {
        return 16;
    }

    public void set(int n, QuantizedBvhNodes quantizedBvhNodes, int n2) {
        int[] nArray = this.buf;
        int[] nArray2 = quantizedBvhNodes.buf;
        nArray[n * 4 + 0] = nArray2[n2 * 4 + 0];
        nArray[n * 4 + 1] = nArray2[n2 * 4 + 1];
        nArray[n * 4 + 2] = nArray2[n2 * 4 + 2];
        nArray[n * 4 + 3] = nArray2[n2 * 4 + 3];
    }

    public void swap(int n, int n2) {
        int[] nArray = this.buf;
        int n3 = nArray[n * 4 + 0];
        int n4 = nArray[n * 4 + 1];
        int n5 = nArray[n * 4 + 2];
        int n6 = nArray[n * 4 + 3];
        nArray[n * 4 + 0] = nArray[n2 * 4 + 0];
        nArray[n * 4 + 1] = nArray[n2 * 4 + 1];
        nArray[n * 4 + 2] = nArray[n2 * 4 + 2];
        nArray[n * 4 + 3] = nArray[n2 * 4 + 3];
        nArray[n2 * 4 + 0] = n3;
        nArray[n2 * 4 + 1] = n4;
        nArray[n2 * 4 + 2] = n5;
        nArray[n2 * 4 + 3] = n6;
    }

    public int getQuantizedAabbMin(int n, int n2) {
        switch (n2) {
            default: {
                return this.buf[n * 4 + 0] & 0xFFFF;
            }
            case 1: {
                return this.buf[n * 4 + 0] >>> 16 & 0xFFFF;
            }
            case 2: 
        }
        return this.buf[n * 4 + 1] & 0xFFFF;
    }

    public long getQuantizedAabbMin(int n) {
        return (long)this.buf[n * 4 + 0] & 0xFFFFFFFFL | ((long)this.buf[n * 4 + 1] & 0xFFFFL) << 32;
    }

    public void setQuantizedAabbMin(int n, long l) {
        this.buf[n * 4 + 0] = (int)l;
        this.setQuantizedAabbMin(n, 2, (short)((l & 0xFFFF00000000L) >>> 32));
    }

    public void setQuantizedAabbMax(int n, long l) {
        this.setQuantizedAabbMax(n, 0, (short)l);
        this.buf[n * 4 + 2] = (int)(l >>> 16);
    }

    public void setQuantizedAabbMin(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                this.buf[n * 4 + 0] = this.buf[n * 4 + 0] & 0xFFFF0000 | n3 & 0xFFFF;
                break;
            }
            case 1: {
                this.buf[n * 4 + 0] = this.buf[n * 4 + 0] & 0xFFFF | (n3 & 0xFFFF) << 16;
                break;
            }
            case 2: {
                this.buf[n * 4 + 1] = this.buf[n * 4 + 1] & 0xFFFF0000 | n3 & 0xFFFF;
            }
        }
    }

    public int getQuantizedAabbMax(int n, int n2) {
        switch (n2) {
            default: {
                return this.buf[n * 4 + 1] >>> 16 & 0xFFFF;
            }
            case 1: {
                return this.buf[n * 4 + 2] & 0xFFFF;
            }
            case 2: 
        }
        return this.buf[n * 4 + 2] >>> 16 & 0xFFFF;
    }

    public long getQuantizedAabbMax(int n) {
        return ((long)this.buf[n * 4 + 1] & 0xFFFF0000L) >>> 16 | ((long)this.buf[n * 4 + 2] & 0xFFFFFFFFL) << 16;
    }

    public void setQuantizedAabbMax(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                this.buf[n * 4 + 1] = this.buf[n * 4 + 1] & 0xFFFF | (n3 & 0xFFFF) << 16;
                break;
            }
            case 1: {
                this.buf[n * 4 + 2] = this.buf[n * 4 + 2] & 0xFFFF0000 | n3 & 0xFFFF;
                break;
            }
            case 2: {
                this.buf[n * 4 + 2] = this.buf[n * 4 + 2] & 0xFFFF | (n3 & 0xFFFF) << 16;
            }
        }
    }

    public int getEscapeIndexOrTriangleIndex(int n) {
        return this.buf[n * 4 + 3];
    }

    public void setEscapeIndexOrTriangleIndex(int n, int n2) {
        this.buf[n * 4 + 3] = n2;
    }

    public boolean isLeafNode(int n) {
        return this.getEscapeIndexOrTriangleIndex(n) >= 0;
    }

    public int getEscapeIndex(int n) {
        assert (!this.isLeafNode(n));
        return -this.getEscapeIndexOrTriangleIndex(n);
    }

    public int getTriangleIndex(int n) {
        assert (this.isLeafNode(n));
        return this.getEscapeIndexOrTriangleIndex(n) & 0x1FFFFF;
    }

    public int getPartId(int n) {
        assert (this.isLeafNode(n));
        return this.getEscapeIndexOrTriangleIndex(n) >>> 21;
    }

    public static int getCoord(long l, int n) {
        switch (n) {
            default: {
                return (int)(l & 0xFFFFL) & 0xFFFF;
            }
            case 1: {
                return (int)((l & 0xFFFF0000L) >>> 16) & 0xFFFF;
            }
            case 2: 
        }
        return (int)((l & 0xFFFF00000000L) >>> 32) & 0xFFFF;
    }
}

