/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.extras.gimpact.BoxCollision;
import javax.vecmath.Vector3f;

class BvhDataArray {
    private int size = 0;
    float[] bound = new float[0];
    int[] data = new int[0];

    BvhDataArray() {
    }

    public int size() {
        return this.size;
    }

    public void resize(int n) {
        float[] fArray = new float[n * 6];
        int[] nArray = new int[n];
        System.arraycopy(this.bound, 0, fArray, 0, this.size * 6);
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        this.bound = fArray;
        this.data = nArray;
        this.size = n;
    }

    public void swap(int n, int n2) {
        int n3 = n * 6;
        int n4 = n2 * 6;
        float f = this.bound[n3 + 0];
        float f2 = this.bound[n3 + 1];
        float f3 = this.bound[n3 + 2];
        float f4 = this.bound[n3 + 3];
        float f5 = this.bound[n3 + 4];
        float f6 = this.bound[n3 + 5];
        int n5 = this.data[n];
        this.bound[n3 + 0] = this.bound[n4 + 0];
        this.bound[n3 + 1] = this.bound[n4 + 1];
        this.bound[n3 + 2] = this.bound[n4 + 2];
        this.bound[n3 + 3] = this.bound[n4 + 3];
        this.bound[n3 + 4] = this.bound[n4 + 4];
        this.bound[n3 + 5] = this.bound[n4 + 5];
        this.data[n] = this.data[n2];
        this.bound[n4 + 0] = f;
        this.bound[n4 + 1] = f2;
        this.bound[n4 + 2] = f3;
        this.bound[n4 + 3] = f4;
        this.bound[n4 + 4] = f5;
        this.bound[n4 + 5] = f6;
        this.data[n2] = n5;
    }

    public BoxCollision.AABB getBound(int n, BoxCollision.AABB aABB) {
        int n2 = n * 6;
        aABB.min.set(this.bound[n2 + 0], this.bound[n2 + 1], this.bound[n2 + 2]);
        aABB.max.set(this.bound[n2 + 3], this.bound[n2 + 4], this.bound[n2 + 5]);
        return aABB;
    }

    public Vector3f getBoundMin(int n, Vector3f vector3f) {
        int n2 = n * 6;
        vector3f.set(this.bound[n2 + 0], this.bound[n2 + 1], this.bound[n2 + 2]);
        return vector3f;
    }

    public Vector3f getBoundMax(int n, Vector3f vector3f) {
        int n2 = n * 6;
        vector3f.set(this.bound[n2 + 3], this.bound[n2 + 4], this.bound[n2 + 5]);
        return vector3f;
    }

    public void setBound(int n, BoxCollision.AABB aABB) {
        int n2 = n * 6;
        this.bound[n2 + 0] = aABB.min.x;
        this.bound[n2 + 1] = aABB.min.y;
        this.bound[n2 + 2] = aABB.min.z;
        this.bound[n2 + 3] = aABB.max.x;
        this.bound[n2 + 4] = aABB.max.y;
        this.bound[n2 + 5] = aABB.max.z;
    }

    public int getData(int n) {
        return this.data[n];
    }

    public void setData(int n, int n2) {
        this.data[n] = n2;
    }
}

