/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.extras.gimpact.ClipPolygon;
import com.bulletphysics.extras.gimpact.GeometryOperations;
import com.bulletphysics.extras.gimpact.TriangleContact;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class PrimitiveTriangle {
    private final ArrayList<Vector3f> tmpVecList1 = new ArrayList(16);
    private final ArrayList<Vector3f> tmpVecList2 = new ArrayList(16);
    private final ArrayList<Vector3f> tmpVecList3 = new ArrayList(16);
    public final Vector3f[] vertices;
    public final Vector4f plane;
    public float margin;

    public PrimitiveTriangle() {
        int n = 0;
        while (n < 16) {
            this.tmpVecList1.add(new Vector3f());
            this.tmpVecList2.add(new Vector3f());
            this.tmpVecList3.add(new Vector3f());
            ++n;
        }
        this.vertices = new Vector3f[3];
        this.plane = new Vector4f();
        this.margin = 0.01f;
        n = 0;
        while (n < this.vertices.length) {
            this.vertices[n] = new Vector3f();
            ++n;
        }
    }

    public void set(PrimitiveTriangle primitiveTriangle) {
        throw new UnsupportedOperationException();
    }

    public void buildTriPlane() {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f.sub(this.vertices[1], this.vertices[0]);
        vector3f2.sub(this.vertices[2], this.vertices[0]);
        vector3f3.cross(vector3f, vector3f2);
        vector3f3.normalize();
        this.plane.set(vector3f3.x, vector3f3.y, vector3f3.z, this.vertices[0].dot(vector3f3));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
    }

    public boolean overlap_test_conservative(PrimitiveTriangle primitiveTriangle) {
        float f = this.margin + primitiveTriangle.margin;
        float f2 = ClipPolygon.distance_point_plane(this.plane, primitiveTriangle.vertices[0]) - f;
        float f3 = ClipPolygon.distance_point_plane(this.plane, primitiveTriangle.vertices[1]) - f;
        float f4 = ClipPolygon.distance_point_plane(this.plane, primitiveTriangle.vertices[2]) - f;
        if (f2 > 0.0f && f3 > 0.0f && f4 > 0.0f) {
            return false;
        }
        f2 = ClipPolygon.distance_point_plane(primitiveTriangle.plane, this.vertices[0]) - f;
        f3 = ClipPolygon.distance_point_plane(primitiveTriangle.plane, this.vertices[1]) - f;
        f4 = ClipPolygon.distance_point_plane(primitiveTriangle.plane, this.vertices[2]) - f;
        return !(f2 > 0.0f) || !(f3 > 0.0f) || !(f4 > 0.0f);
    }

    public void get_edge_plane(int n, Vector4f vector4f) {
        Vector3f vector3f = this.vertices[n];
        Vector3f vector3f2 = this.vertices[(n + 1) % 3];
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(this.plane.x, this.plane.y, this.plane.z);
        GeometryOperations.edge_plane(vector3f, vector3f2, vector3f3, vector4f);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    public void applyTransform(Transform transform) {
        transform.transform(this.vertices[0]);
        transform.transform(this.vertices[1]);
        transform.transform(this.vertices[2]);
    }

    public int clip_triangle(PrimitiveTriangle primitiveTriangle, ArrayList<Vector3f> arrayList) {
        ArrayList<Vector3f> arrayList2 = this.tmpVecList1;
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        this.get_edge_plane(0, vector4f);
        int n = ClipPolygon.plane_clip_triangle(vector4f, primitiveTriangle.vertices[0], primitiveTriangle.vertices[1], primitiveTriangle.vertices[2], arrayList2);
        if (n == 0) {
            return 0;
        }
        ArrayList<Vector3f> arrayList3 = this.tmpVecList2;
        this.get_edge_plane(1, vector4f);
        n = ClipPolygon.plane_clip_polygon(vector4f, arrayList2, n, arrayList3);
        if (n == 0) {
            return 0;
        }
        this.get_edge_plane(2, vector4f);
        n = ClipPolygon.plane_clip_polygon(vector4f, arrayList3, n, arrayList);
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f});
        return n;
    }

    public boolean find_triangle_collision_clip_method(PrimitiveTriangle primitiveTriangle, TriangleContact triangleContact) {
        float f = this.margin + primitiveTriangle.margin;
        ArrayList<Vector3f> arrayList = this.tmpVecList3;
        TriangleContact triangleContact2 = (TriangleContact)Pools.CONTACTS.get();
        triangleContact2.separating_normal.set(this.plane);
        int n = this.clip_triangle(primitiveTriangle, arrayList);
        if (n == 0) {
            return false;
        }
        triangleContact2.merge_points(triangleContact2.separating_normal, f, arrayList, n);
        if (triangleContact2.point_count == 0) {
            return false;
        }
        triangleContact2.separating_normal.x *= -1.0f;
        triangleContact2.separating_normal.y *= -1.0f;
        triangleContact2.separating_normal.z *= -1.0f;
        TriangleContact triangleContact3 = (TriangleContact)Pools.CONTACTS.get();
        triangleContact3.separating_normal.set(primitiveTriangle.plane);
        n = primitiveTriangle.clip_triangle(this, arrayList);
        if (n == 0) {
            return false;
        }
        triangleContact3.merge_points(triangleContact3.separating_normal, f, arrayList, n);
        if (triangleContact3.point_count == 0) {
            return false;
        }
        if (triangleContact3.penetration_depth < triangleContact2.penetration_depth) {
            triangleContact.copy_from(triangleContact3);
        } else {
            triangleContact.copy_from(triangleContact2);
        }
        Pools.CONTACTS.release((Object[])new TriangleContact[]{triangleContact2, triangleContact3});
        return true;
    }
}

