/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.BulletStats;

class CProfileNode {
    protected String name;
    protected int totalCalls;
    protected float totalTime;
    protected long startTime;
    protected int recursionCounter;
    protected CProfileNode parent;
    protected CProfileNode child;
    protected CProfileNode sibling;

    public CProfileNode(String string, CProfileNode cProfileNode) {
        this.name = string;
        this.totalCalls = 0;
        this.totalTime = 0.0f;
        this.startTime = 0L;
        this.recursionCounter = 0;
        this.parent = cProfileNode;
        this.child = null;
        this.sibling = null;
        this.reset();
    }

    public CProfileNode getSubNode(String string) {
        CProfileNode cProfileNode = this.child;
        while (cProfileNode != null) {
            if (cProfileNode.name == string) {
                return cProfileNode;
            }
            cProfileNode = cProfileNode.sibling;
        }
        CProfileNode cProfileNode2 = new CProfileNode(string, this);
        cProfileNode2.sibling = this.child;
        this.child = cProfileNode2;
        return cProfileNode2;
    }

    public CProfileNode getParent() {
        return this.parent;
    }

    public CProfileNode getSibling() {
        return this.sibling;
    }

    public CProfileNode getChild() {
        return this.child;
    }

    public void cleanupMemory() {
        this.child = null;
        this.sibling = null;
    }

    public void reset() {
        this.totalCalls = 0;
        this.totalTime = 0.0f;
        BulletStats.gProfileClock.reset();
        if (this.child != null) {
            this.child.reset();
        }
        if (this.sibling != null) {
            this.sibling.reset();
        }
    }

    public void call() {
        ++this.totalCalls;
        if (this.recursionCounter++ == 0) {
            this.startTime = BulletStats.profileGetTicks();
        }
    }

    public boolean Return() {
        if (--this.recursionCounter == 0 && this.totalCalls != 0) {
            long l = BulletStats.profileGetTicks();
            this.totalTime += (float)(l -= this.startTime) / BulletStats.profileGetTickRate();
        }
        return this.recursionCounter == 0;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalCalls() {
        return this.totalCalls;
    }

    public float getTotalTime() {
        return this.totalTime;
    }
}

