/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath.convexhull;

import com.bulletphysics.linearmath.convexhull.HullFlags;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class HullDesc {
    public int flags = HullFlags.DEFAULT;
    public int vcount = 0;
    public ArrayList<Vector3f> vertices;
    int vertexStride = 12;
    public float normalEpsilon = 0.001f;
    public int maxVertices = 4096;
    public int maxFaces = 4096;

    public HullDesc() {
    }

    public HullDesc(int n, int n2, ArrayList<Vector3f> arrayList) {
        this(n, n2, arrayList, 12);
    }

    public HullDesc(int n, int n2, ArrayList<Vector3f> arrayList, int n3) {
        this.flags = n;
        this.vcount = n2;
        this.vertices = arrayList;
        this.vertexStride = n3;
        this.normalEpsilon = 0.001f;
        this.maxVertices = 4096;
    }

    public boolean hasHullFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void setHullFlag(int n) {
        this.flags |= n;
    }

    public void clearHullFlag(int n) {
        this.flags &= ~n;
    }
}

