/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.common;

import com.bulletphysics.ContactAddedCallback;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.dynamics.RigidBody;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import gama.dev.DEBUG;
import gama.extension.physics.common.IBody;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.Manifold;
import org.jbox2d.dynamics.contacts.Contact;

public class UniversalContactAddedListener
implements ContactAddedCallback,
PhysicsCollisionListener,
ContactListener {
    Multimap<IBody, IBody> newContacts = MultimapBuilder.hashKeys().hashSetValues().build();

    static {
        DEBUG.ON();
    }

    private void addContactBetween(IBody iBody, IBody iBody2) {
        if (iBody.isNoNotification() && iBody2.isNoNotification()) {
            return;
        }
        this.newContacts.put((Object)iBody, (Object)iBody2);
    }

    public void collision(PhysicsCollisionEvent physicsCollisionEvent) {
        this.addContactBetween((IBody)physicsCollisionEvent.getObjectA().getUserObject(), (IBody)physicsCollisionEvent.getObjectB().getUserObject());
    }

    public void onContactProcessed(PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, long l) {
        this.addContactBetween((IBody)((PhysicsRigidBody)physicsCollisionObject).getUserObject(), (IBody)((PhysicsRigidBody)physicsCollisionObject2).getUserObject());
    }

    @Override
    public boolean contactAdded(ManifoldPoint manifoldPoint, CollisionObject collisionObject, int n, int n2, CollisionObject collisionObject2, int n3, int n4) {
        this.addContactBetween((IBody)((RigidBody)collisionObject).getUserPointer(), (IBody)((RigidBody)collisionObject2).getUserPointer());
        return true;
    }

    @Override
    public void beginContact(Contact contact) {
        this.addContactBetween((IBody)contact.getFixtureA().getBody().getUserData(), (IBody)contact.getFixtureB().getBody().getUserData());
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void preSolve(Contact contact, Manifold manifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse contactImpulse) {
    }

    public Multimap<? extends IBody, ? extends IBody> getCollectedContacts() {
        return this.newContacts;
    }

    public void clear() {
        this.newContacts.clear();
    }
}

