/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.InternalTriangleIndexCallback;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public abstract class TriangleMeshShape
extends ConcaveShape {
    protected final Vector3f localAabbMin = new Vector3f();
    protected final Vector3f localAabbMax = new Vector3f();
    protected StridingMeshInterface meshInterface;

    protected TriangleMeshShape(StridingMeshInterface stridingMeshInterface) {
        this.meshInterface = stridingMeshInterface;
    }

    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = vector3f2;
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        SupportVertexCallback supportVertexCallback = new SupportVertexCallback(vector3f, transform);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.set(1.0E30f, 1.0E30f, 1.0E30f);
        vector3f3.negate(vector3f5);
        this.processAllTriangles(supportVertexCallback, vector3f3, vector3f5);
        supportVertexCallback.getSupportVertexLocal(vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f5});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        return vector3f2;
    }

    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        assert (false);
        return this.localGetSupportingVertex(vector3f, vector3f2);
    }

    public void recalcLocalAabb() {
        int n = 0;
        while (n < 3) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.set(0.0f, 0.0f, 0.0f);
            VectorUtil.setCoord(vector3f, n, 1.0f);
            Vector3f vector3f2 = this.localGetSupportingVertex(vector3f, (Vector3f)Pools.VECTORS.get());
            VectorUtil.setCoord(this.localAabbMax, n, VectorUtil.getCoord(vector3f2, n) + this.collisionMargin);
            VectorUtil.setCoord(vector3f, n, -1.0f);
            this.localGetSupportingVertex(vector3f, vector3f2);
            VectorUtil.setCoord(this.localAabbMin, n, VectorUtil.getCoord(vector3f2, n) - this.collisionMargin);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
            ++n;
        }
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(this.localAabbMax, this.localAabbMin);
        vector3f4.scale(0.5f);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.add(this.localAabbMax, this.localAabbMin);
        vector3f5.scale(0.5f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get((Object)vector3f5);
        transform.transform(vector3f6);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f3);
        vector3f7.x = vector3f3.dot(vector3f4);
        matrix3f.getRow(1, vector3f3);
        vector3f7.y = vector3f3.dot(vector3f4);
        matrix3f.getRow(2, vector3f3);
        vector3f7.z = vector3f3.dot(vector3f4);
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        vector3f8.set(this.getMargin(), this.getMargin(), this.getMargin());
        vector3f7.add(vector3f8);
        vector3f.sub(vector3f6, vector3f7);
        vector3f2.add(vector3f6, vector3f7);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4, vector3f5, vector3f6, vector3f7, vector3f8});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        FilteredCallback filteredCallback = new FilteredCallback(triangleCallback, vector3f, vector3f2);
        this.meshInterface.internalProcessAllTriangles(filteredCallback, vector3f, vector3f2);
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        assert (false);
        vector3f.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.meshInterface.setScaling(vector3f);
        this.recalcLocalAabb();
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        return this.meshInterface.getScaling(vector3f);
    }

    public StridingMeshInterface getMeshInterface() {
        return this.meshInterface;
    }

    public Vector3f getLocalAabbMin(Vector3f vector3f) {
        vector3f.set(this.localAabbMin);
        return vector3f;
    }

    public Vector3f getLocalAabbMax(Vector3f vector3f) {
        vector3f.set(this.localAabbMax);
        return vector3f;
    }

    @Override
    public String getName() {
        return "TRIANGLEMESH";
    }

    private static class FilteredCallback
    implements InternalTriangleIndexCallback {
        public TriangleCallback callback;
        public final Vector3f aabbMin = new Vector3f();
        public final Vector3f aabbMax = new Vector3f();

        public FilteredCallback(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
            this.callback = triangleCallback;
            this.aabbMin.set(vector3f);
            this.aabbMax.set(vector3f2);
        }

        @Override
        public void internalProcessTriangleIndex(Vector3f[] vector3fArray, int n, int n2) {
            if (AabbUtil2.testTriangleAgainstAabb2(vector3fArray, this.aabbMin, this.aabbMax)) {
                this.callback.processTriangle(vector3fArray, n, n2);
            }
        }
    }

    private class SupportVertexCallback
    implements TriangleCallback {
        private final Vector3f supportVertexLocal = new Vector3f(0.0f, 0.0f, 0.0f);
        public final Transform worldTrans = new Transform();
        public float maxDot = -1.0E30f;
        public final Vector3f supportVecLocal = new Vector3f();

        public SupportVertexCallback(Vector3f vector3f, Transform transform) {
            this.worldTrans.set(transform);
            MatrixUtil.transposeTransform(this.supportVecLocal, vector3f, this.worldTrans.basis);
        }

        @Override
        public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
            int n3 = 0;
            while (n3 < 3) {
                float f = this.supportVecLocal.dot(vector3fArray[n3]);
                if (f > this.maxDot) {
                    this.maxDot = f;
                    this.supportVertexLocal.set(vector3fArray[n3]);
                }
                ++n3;
            }
        }

        public Vector3f getSupportVertexLocal(Vector3f vector3f) {
            vector3f.set(this.supportVertexLocal);
            return vector3f;
        }
    }
}

