/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class UniformScalingShape
implements ConvexShape {
    private final ConvexShape childConvexShape;
    private final float uniformScalingFactor;

    public UniformScalingShape(ConvexShape convexShape, float f) {
        this.childConvexShape = convexShape;
        this.uniformScalingFactor = f;
    }

    public float getUniformScalingFactor() {
        return this.uniformScalingFactor;
    }

    public ConvexShape getChildShape() {
        return this.childConvexShape;
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        this.childConvexShape.localGetSupportingVertex(vector3f, vector3f2);
        vector3f2.scale(this.uniformScalingFactor);
        return vector3f2;
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        this.childConvexShape.localGetSupportingVertexWithoutMargin(vector3f, vector3f2);
        vector3f2.scale(this.uniformScalingFactor);
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        this.childConvexShape.batchedUnitVectorGetSupportingVertexWithoutMargin(vector3fArray, vector3fArray2, n);
        int n2 = 0;
        while (n2 < n) {
            vector3fArray2[n2].scale(this.uniformScalingFactor);
            ++n2;
        }
    }

    @Override
    public void getAabbSlow(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.childConvexShape.getAabbSlow(transform, vector3f, vector3f2);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.add(vector3f2, vector3f);
        vector3f3.scale(0.5f);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f2, vector3f);
        vector3f4.scale(0.5f * this.uniformScalingFactor);
        vector3f.sub(vector3f3, vector3f4);
        vector3f2.add(vector3f3, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.childConvexShape.setLocalScaling(vector3f);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        this.childConvexShape.getLocalScaling(vector3f);
        return vector3f;
    }

    @Override
    public void setMargin(float f) {
        this.childConvexShape.setMargin(f);
    }

    @Override
    public float getMargin() {
        return this.childConvexShape.getMargin() * this.uniformScalingFactor;
    }

    @Override
    public int getNumPreferredPenetrationDirections() {
        return this.childConvexShape.getNumPreferredPenetrationDirections();
    }

    @Override
    public void getPreferredPenetrationDirection(int n, Vector3f vector3f) {
        this.childConvexShape.getPreferredPenetrationDirection(n, vector3f);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.childConvexShape.getAabb(transform, vector3f, vector3f2);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.add(vector3f2, vector3f);
        vector3f3.scale(0.5f);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f2, vector3f);
        vector3f4.scale(0.5f * this.uniformScalingFactor);
        vector3f.sub(vector3f3, vector3f4);
        vector3f2.add(vector3f3, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.UNIFORM_SCALING_SHAPE_PROXYTYPE;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        this.childConvexShape.calculateLocalInertia(f, vector3f);
        vector3f.scale(this.uniformScalingFactor);
    }

    @Override
    public String getName() {
        return "UniformScalingShape";
    }
}

