/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.BvhDataArray;

class BvhTreeNodeArray {
    private int size = 0;
    private float[] bound = new float[0];
    private int[] escapeIndexOrDataIndex = new int[0];

    BvhTreeNodeArray() {
    }

    public void clear() {
        this.size = 0;
    }

    public void resize(int n) {
        float[] fArray = new float[n * 6];
        int[] nArray = new int[n];
        System.arraycopy(this.bound, 0, fArray, 0, this.size * 6);
        System.arraycopy(this.escapeIndexOrDataIndex, 0, nArray, 0, this.size);
        this.bound = fArray;
        this.escapeIndexOrDataIndex = nArray;
        this.size = n;
    }

    public void set(int n, BvhTreeNodeArray bvhTreeNodeArray, int n2) {
        int n3 = n * 6;
        int n4 = n2 * 6;
        this.bound[n3 + 0] = bvhTreeNodeArray.bound[n4 + 0];
        this.bound[n3 + 1] = bvhTreeNodeArray.bound[n4 + 1];
        this.bound[n3 + 2] = bvhTreeNodeArray.bound[n4 + 2];
        this.bound[n3 + 3] = bvhTreeNodeArray.bound[n4 + 3];
        this.bound[n3 + 4] = bvhTreeNodeArray.bound[n4 + 4];
        this.bound[n3 + 5] = bvhTreeNodeArray.bound[n4 + 5];
        this.escapeIndexOrDataIndex[n] = bvhTreeNodeArray.escapeIndexOrDataIndex[n2];
    }

    public void set(int n, BvhDataArray bvhDataArray, int n2) {
        int n3 = n * 6;
        int n4 = n2 * 6;
        this.bound[n3 + 0] = bvhDataArray.bound[n4 + 0];
        this.bound[n3 + 1] = bvhDataArray.bound[n4 + 1];
        this.bound[n3 + 2] = bvhDataArray.bound[n4 + 2];
        this.bound[n3 + 3] = bvhDataArray.bound[n4 + 3];
        this.bound[n3 + 4] = bvhDataArray.bound[n4 + 4];
        this.bound[n3 + 5] = bvhDataArray.bound[n4 + 5];
        this.escapeIndexOrDataIndex[n] = bvhDataArray.data[n2];
    }

    public BoxCollision.AABB getBound(int n, BoxCollision.AABB aABB) {
        int n2 = n * 6;
        aABB.min.set(this.bound[n2 + 0], this.bound[n2 + 1], this.bound[n2 + 2]);
        aABB.max.set(this.bound[n2 + 3], this.bound[n2 + 4], this.bound[n2 + 5]);
        return aABB;
    }

    public void setBound(int n, BoxCollision.AABB aABB) {
        int n2 = n * 6;
        this.bound[n2 + 0] = aABB.min.x;
        this.bound[n2 + 1] = aABB.min.y;
        this.bound[n2 + 2] = aABB.min.z;
        this.bound[n2 + 3] = aABB.max.x;
        this.bound[n2 + 4] = aABB.max.y;
        this.bound[n2 + 5] = aABB.max.z;
    }

    public boolean isLeafNode(int n) {
        return this.escapeIndexOrDataIndex[n] >= 0;
    }

    public int getEscapeIndex(int n) {
        return -this.escapeIndexOrDataIndex[n];
    }

    public void setEscapeIndex(int n, int n2) {
        this.escapeIndexOrDataIndex[n] = -n2;
    }

    public int getDataIndex(int n) {
        return this.escapeIndexOrDataIndex[n];
    }

    public void setDataIndex(int n, int n2) {
        this.escapeIndexOrDataIndex[n] = n2;
    }
}

