/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.BvhDataArray;
import com.bulletphysics.extras.gimpact.BvhTree;
import com.bulletphysics.extras.gimpact.BvhTreeNodeArray;
import com.bulletphysics.extras.gimpact.PairSet;
import com.bulletphysics.extras.gimpact.PrimitiveManagerBase;
import com.bulletphysics.extras.gimpact.PrimitiveTriangle;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.IntArrayList;
import javax.vecmath.Vector3f;

class GImpactBvh {
    protected BvhTree box_tree = new BvhTree();
    protected PrimitiveManagerBase primitive_manager;

    public GImpactBvh() {
        this.primitive_manager = null;
    }

    public GImpactBvh(PrimitiveManagerBase primitiveManagerBase) {
        this.primitive_manager = primitiveManagerBase;
    }

    public BoxCollision.AABB getGlobalBox(BoxCollision.AABB aABB) {
        this.getNodeBound(0, aABB);
        return aABB;
    }

    public void setPrimitiveManager(PrimitiveManagerBase primitiveManagerBase) {
        this.primitive_manager = primitiveManagerBase;
    }

    public PrimitiveManagerBase getPrimitiveManager() {
        return this.primitive_manager;
    }

    protected void refit() {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
        BoxCollision.AABB aABB3 = (BoxCollision.AABB)Pools.AABBS.get();
        int n = this.getNodeCount();
        while (n-- != 0) {
            if (this.isLeafNode(n)) {
                this.primitive_manager.get_primitive_box(this.getNodeData(n), aABB);
                this.setNodeBound(n, aABB);
                continue;
            }
            aABB2.invalidate();
            int n2 = this.getLeftNode(n);
            if (n2 != 0) {
                this.getNodeBound(n2, aABB3);
                aABB2.merge(aABB3);
            }
            if ((n2 = this.getRightNode(n)) != 0) {
                this.getNodeBound(n2, aABB3);
                aABB2.merge(aABB3);
            }
            this.setNodeBound(n, aABB2);
        }
    }

    public void update() {
        this.refit();
    }

    public void buildSet() {
        BvhDataArray bvhDataArray = new BvhDataArray();
        bvhDataArray.resize(this.primitive_manager.get_primitive_count());
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        int n = 0;
        while (n < bvhDataArray.size()) {
            this.primitive_manager.get_primitive_box(n, aABB);
            bvhDataArray.setBound(n, aABB);
            bvhDataArray.setData(n, n);
            ++n;
        }
        this.box_tree.build_tree(bvhDataArray);
    }

    public boolean boxQuery(BoxCollision.AABB aABB, IntArrayList intArrayList) {
        int n = 0;
        int n2 = this.getNodeCount();
        BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
        while (n < n2) {
            this.getNodeBound(n, aABB2);
            boolean bl = aABB2.has_collision(aABB);
            boolean bl2 = this.isLeafNode(n);
            if (bl2 && bl) {
                intArrayList.add(this.getNodeData(n));
            }
            if (bl || bl2) {
                ++n;
                continue;
            }
            n += this.getEscapeNodeIndex(n);
        }
        return intArrayList.size() > 0;
    }

    public boolean boxQueryTrans(BoxCollision.AABB aABB, Transform transform, IntArrayList intArrayList) {
        BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get((Object)aABB);
        aABB2.appy_transform(transform);
        return this.boxQuery(aABB2, intArrayList);
    }

    public boolean rayQuery(Vector3f vector3f, Vector3f vector3f2, IntArrayList intArrayList) {
        int n = 0;
        int n2 = this.getNodeCount();
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        while (n < n2) {
            this.getNodeBound(n, aABB);
            boolean bl = aABB.collide_ray(vector3f2, vector3f);
            boolean bl2 = this.isLeafNode(n);
            if (bl2 && bl) {
                intArrayList.add(this.getNodeData(n));
            }
            if (bl || bl2) {
                ++n;
                continue;
            }
            n += this.getEscapeNodeIndex(n);
        }
        return intArrayList.size() > 0;
    }

    public boolean hasHierarchy() {
        return true;
    }

    public boolean isTrimesh() {
        return this.primitive_manager.is_trimesh();
    }

    public int getNodeCount() {
        return this.box_tree.getNodeCount();
    }

    public boolean isLeafNode(int n) {
        return this.box_tree.isLeafNode(n);
    }

    public int getNodeData(int n) {
        return this.box_tree.getNodeData(n);
    }

    public void getNodeBound(int n, BoxCollision.AABB aABB) {
        this.box_tree.getNodeBound(n, aABB);
    }

    public void setNodeBound(int n, BoxCollision.AABB aABB) {
        this.box_tree.setNodeBound(n, aABB);
    }

    public int getLeftNode(int n) {
        return this.box_tree.getLeftNode(n);
    }

    public int getRightNode(int n) {
        return this.box_tree.getRightNode(n);
    }

    public int getEscapeNodeIndex(int n) {
        return this.box_tree.getEscapeNodeIndex(n);
    }

    public void getNodeTriangle(int n, PrimitiveTriangle primitiveTriangle) {
        this.primitive_manager.get_primitive_triangle(this.getNodeData(n), primitiveTriangle);
    }

    public BvhTreeNodeArray get_node_pointer() {
        return this.box_tree.get_node_pointer();
    }

    private static boolean _node_collision(GImpactBvh gImpactBvh, GImpactBvh gImpactBvh2, BoxCollision.BoxBoxTransformCache boxBoxTransformCache, int n, int n2, boolean bl) {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        gImpactBvh.getNodeBound(n, aABB);
        BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
        gImpactBvh2.getNodeBound(n2, aABB2);
        return aABB.overlapping_trans_cache(aABB2, boxBoxTransformCache, bl);
    }

    private static void _find_collision_pairs_recursive(GImpactBvh gImpactBvh, GImpactBvh gImpactBvh2, PairSet pairSet, BoxCollision.BoxBoxTransformCache boxBoxTransformCache, int n, int n2, boolean bl) {
        if (!GImpactBvh._node_collision(gImpactBvh, gImpactBvh2, boxBoxTransformCache, n, n2, bl)) {
            return;
        }
        if (gImpactBvh.isLeafNode(n)) {
            if (gImpactBvh2.isLeafNode(n2)) {
                pairSet.push_pair(gImpactBvh.getNodeData(n), gImpactBvh2.getNodeData(n2));
                return;
            }
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, n, gImpactBvh2.getLeftNode(n2), false);
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, n, gImpactBvh2.getRightNode(n2), false);
        } else if (gImpactBvh2.isLeafNode(n2)) {
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getLeftNode(n), n2, false);
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getRightNode(n), n2, false);
        } else {
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getLeftNode(n), gImpactBvh2.getLeftNode(n2), false);
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getLeftNode(n), gImpactBvh2.getRightNode(n2), false);
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getRightNode(n), gImpactBvh2.getLeftNode(n2), false);
            GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, gImpactBvh.getRightNode(n), gImpactBvh2.getRightNode(n2), false);
        }
    }

    public static void find_collision(GImpactBvh gImpactBvh, Transform transform, GImpactBvh gImpactBvh2, Transform transform2, PairSet pairSet) {
        if (gImpactBvh.getNodeCount() == 0 || gImpactBvh2.getNodeCount() == 0) {
            return;
        }
        BoxCollision.BoxBoxTransformCache boxBoxTransformCache = (BoxCollision.BoxBoxTransformCache)Pools.BBTCS.get();
        boxBoxTransformCache.calc_from_homogenic(transform, transform2);
        GImpactBvh._find_collision_pairs_recursive(gImpactBvh, gImpactBvh2, pairSet, boxBoxTransformCache, 0, 0, true);
        Pools.BBTCS.release((Object[])new BoxCollision.BoxBoxTransformCache[]{boxBoxTransformCache});
    }
}

