/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.TriangleShape;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.ClipPolygon;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class TriangleShapeEx
extends TriangleShape {
    public TriangleShapeEx() {
    }

    public TriangleShapeEx(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        super(vector3f, vector3f2, vector3f3);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get((Object)this.vertices1[0]);
        transform.transform(vector3f3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)this.vertices1[1]);
        transform.transform(vector3f4);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)this.vertices1[2]);
        transform.transform(vector3f5);
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        aABB.init(vector3f3, vector3f4, vector3f5, this.collisionMargin);
        vector3f.set(aABB.min);
        vector3f2.set(aABB.max);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5, vector3f3});
    }

    public void applyTransform(Transform transform) {
        transform.transform(this.vertices1[0]);
        transform.transform(this.vertices1[1]);
        transform.transform(this.vertices1[2]);
    }

    public void buildTriPlane(Vector4f vector4f) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f.sub(this.vertices1[1], this.vertices1[0]);
        vector3f2.sub(this.vertices1[2], this.vertices1[0]);
        vector3f3.cross(vector3f, vector3f2);
        vector3f3.normalize();
        vector4f.set(vector3f3.x, vector3f3.y, vector3f3.z, this.vertices1[0].dot(vector3f3));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
    }

    public boolean overlap_test_conservative(TriangleShapeEx triangleShapeEx) {
        float f = this.getMargin() + triangleShapeEx.getMargin();
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        this.buildTriPlane(vector4f);
        Vector4f vector4f2 = (Vector4f)Pools.VECTORS4.get();
        triangleShapeEx.buildTriPlane(vector4f2);
        float f2 = ClipPolygon.distance_point_plane(vector4f, triangleShapeEx.vertices1[0]) - f;
        float f3 = ClipPolygon.distance_point_plane(vector4f, triangleShapeEx.vertices1[1]) - f;
        float f4 = ClipPolygon.distance_point_plane(vector4f, triangleShapeEx.vertices1[2]) - f;
        if (f2 > 0.0f && f3 > 0.0f && f4 > 0.0f) {
            return false;
        }
        f2 = ClipPolygon.distance_point_plane(vector4f2, this.vertices1[0]) - f;
        f3 = ClipPolygon.distance_point_plane(vector4f2, this.vertices1[1]) - f;
        f4 = ClipPolygon.distance_point_plane(vector4f2, this.vertices1[2]) - f;
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f, vector4f2});
        return !(f2 > 0.0f) || !(f3 > 0.0f) || !(f4 > 0.0f);
    }
}

