/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.common;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.Collector;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IPhysicalWorld;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.common.UniversalContactAddedListener;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.util.Map;

public abstract class AbstractPhysicalWorld<WorldType, ShapeType, VectorType>
implements IPhysicalWorld<WorldType, ShapeType, VectorType> {
    protected final PhysicalSimulationAgent simulation;
    protected WorldType world;
    private IShapeConverter<ShapeType, VectorType> shapeConverter;
    protected final UniversalContactAddedListener contactListener;
    protected final Collector.AsOrderedSet<IAgent> updatableAgents = Collector.getOrderedSet();
    SetMultimap<IBody, IBody> previousContacts = MultimapBuilder.linkedHashKeys().hashSetValues().build();
    protected SetMultimap<IBody, IBody> newContacts = MultimapBuilder.linkedHashKeys().hashSetValues().build();
    protected final boolean emitNotifications;

    protected AbstractPhysicalWorld(PhysicalSimulationAgent physicalSimulationAgent) {
        this.simulation = physicalSimulationAgent;
        this.emitNotifications = this.emitsNotifications((IAgent)this.simulation);
        this.contactListener = new UniversalContactAddedListener();
    }

    protected abstract WorldType createWorld();

    protected abstract IShapeConverter<ShapeType, VectorType> createShapeConverter();

    @Override
    public void doStep(Double d, int n) {
        this.updateEngine(d, n);
        if (this.emitNotifications) {
            this.updateContacts();
        }
        this.updateAgentsShape();
        this.updatePositionsAndRotations();
    }

    protected abstract void updateAgentsShape();

    protected final void updateContacts() {
        this.collectContacts((Multimap<IBody, IBody>)this.newContacts);
        this.newContacts.forEach((iBody, iBody2) -> {
            if (!this.previousContacts.containsEntry(iBody, iBody2)) {
                this.contactUpdate((IBody)iBody, (IBody)iBody2, true);
            } else {
                this.previousContacts.remove(iBody, iBody2);
            }
        });
        this.previousContacts.forEach((iBody, iBody2) -> this.contactUpdate((IBody)iBody, (IBody)iBody2, false));
        this.previousContacts.clear();
        this.previousContacts.putAll(this.newContacts);
        this.newContacts.clear();
    }

    public void collectContacts(Multimap<IBody, IBody> multimap) {
        multimap.putAll(this.contactListener.getCollectedContacts());
        this.contactListener.clear();
    }

    protected abstract void updateEngine(Double var1, int var2);

    protected boolean emitsNotifications(IAgent iAgent) {
        ModelDescription modelDescription = (ModelDescription)iAgent.getSpecies().getDescription();
        return modelDescription.visitMicroSpecies(speciesDescription -> {
            boolean bl;
            ActionDescription actionDescription = speciesDescription.getAction("contact_added_with");
            boolean bl2 = actionDescription == null || actionDescription.isBuiltIn();
            actionDescription = speciesDescription.getAction("contact_removed_with");
            boolean bl3 = bl = actionDescription == null || actionDescription.isBuiltIn();
            return bl2 || bl;
        });
    }

    protected void contactUpdate(IBody iBody, IBody iBody2, boolean bl) {
        IStatement.WithArgs withArgs;
        String string = bl ? "contact_added_with" : "contact_removed_with";
        IAgent iAgent = iBody.getAgent();
        IAgent iAgent2 = iBody2.getAgent();
        if (iAgent == null || iAgent2 == null) {
            return;
        }
        if (!iBody.isNoNotification()) {
            withArgs = iAgent.getSpecies().getAction(string);
            this.getSimulation().getScope().execute((IExecutable)withArgs, iAgent, new Arguments((IAgent)this.getSimulation(), Map.of("other", iAgent2)));
        }
        if (!iBody2.isNoNotification()) {
            withArgs = iAgent2.getSpecies().getAction(string);
            this.getSimulation().getScope().execute((IExecutable)withArgs, iAgent2, new Arguments((IAgent)this.getSimulation(), Map.of("other", iAgent)));
        }
    }

    @Override
    public IShapeConverter<ShapeType, VectorType> getShapeConverter() {
        if (this.shapeConverter == null) {
            this.shapeConverter = this.createShapeConverter();
        }
        return this.shapeConverter;
    }

    @Override
    public PhysicalSimulationAgent getSimulation() {
        return this.simulation;
    }

    @Override
    public void updateAgentShape(IAgent iAgent) {
        this.updatableAgents.add((Object)iAgent);
    }

    @Override
    public final WorldType getWorld() {
        if (this.world == null) {
            this.world = this.createWorld();
        }
        return this.world;
    }
}

