/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactPositionConstraint;
import org.jbox2d.dynamics.contacts.ContactVelocityConstraint;
import org.jbox2d.dynamics.contacts.Position;
import org.jbox2d.dynamics.contacts.PositionSolverManifold;
import org.jbox2d.dynamics.contacts.Velocity;

public class ContactSolver {
    public static final boolean DEBUG_SOLVER = false;
    public static final float k_errorTol = 0.001f;
    public static final int INITIAL_NUM_CONSTRAINTS = 256;
    public static final float k_maxConditionNumber = 100.0f;
    public TimeStep m_step;
    public Position[] m_positions;
    public Velocity[] m_velocities;
    public ContactPositionConstraint[] m_positionConstraints;
    public ContactVelocityConstraint[] m_velocityConstraints;
    public Contact[] m_contacts;
    public int m_count;
    private final Transform xfA = new Transform();
    private final Transform xfB = new Transform();
    private final WorldManifold worldManifold = new WorldManifold();
    private final PositionSolverManifold psolver = new PositionSolverManifold();

    public ContactSolver() {
        this.m_positionConstraints = new ContactPositionConstraint[256];
        this.m_velocityConstraints = new ContactVelocityConstraint[256];
        int n = 0;
        while (n < 256) {
            this.m_positionConstraints[n] = new ContactPositionConstraint();
            this.m_velocityConstraints[n] = new ContactVelocityConstraint();
            ++n;
        }
    }

    public final void init(ContactSolverDef contactSolverDef) {
        int n;
        Object[] objectArray;
        this.m_step = contactSolverDef.step;
        this.m_count = contactSolverDef.count;
        if (this.m_positionConstraints.length < this.m_count) {
            objectArray = this.m_positionConstraints;
            this.m_positionConstraints = new ContactPositionConstraint[MathUtils.max(objectArray.length * 2, this.m_count)];
            System.arraycopy(objectArray, 0, this.m_positionConstraints, 0, objectArray.length);
            n = objectArray.length;
            while (n < this.m_positionConstraints.length) {
                this.m_positionConstraints[n] = new ContactPositionConstraint();
                ++n;
            }
        }
        if (this.m_velocityConstraints.length < this.m_count) {
            objectArray = this.m_velocityConstraints;
            this.m_velocityConstraints = new ContactVelocityConstraint[MathUtils.max(objectArray.length * 2, this.m_count)];
            System.arraycopy(objectArray, 0, this.m_velocityConstraints, 0, objectArray.length);
            n = objectArray.length;
            while (n < this.m_velocityConstraints.length) {
                this.m_velocityConstraints[n] = new ContactVelocityConstraint();
                ++n;
            }
        }
        this.m_positions = contactSolverDef.positions;
        this.m_velocities = contactSolverDef.velocities;
        this.m_contacts = contactSolverDef.contacts;
        int n2 = 0;
        while (n2 < this.m_count) {
            Contact contact = this.m_contacts[n2];
            Fixture fixture = contact.m_fixtureA;
            Fixture fixture2 = contact.m_fixtureB;
            Shape shape = fixture.getShape();
            Shape shape2 = fixture2.getShape();
            float f = shape.m_radius;
            float f2 = shape2.m_radius;
            Body body = fixture.getBody();
            Body body2 = fixture2.getBody();
            Manifold manifold = contact.getManifold();
            int n3 = manifold.pointCount;
            assert (n3 > 0);
            ContactVelocityConstraint contactVelocityConstraint = this.m_velocityConstraints[n2];
            contactVelocityConstraint.friction = contact.m_friction;
            contactVelocityConstraint.restitution = contact.m_restitution;
            contactVelocityConstraint.tangentSpeed = contact.m_tangentSpeed;
            contactVelocityConstraint.indexA = body.m_islandIndex;
            contactVelocityConstraint.indexB = body2.m_islandIndex;
            contactVelocityConstraint.invMassA = body.m_invMass;
            contactVelocityConstraint.invMassB = body2.m_invMass;
            contactVelocityConstraint.invIA = body.m_invI;
            contactVelocityConstraint.invIB = body2.m_invI;
            contactVelocityConstraint.contactIndex = n2;
            contactVelocityConstraint.pointCount = n3;
            contactVelocityConstraint.K.setZero();
            contactVelocityConstraint.normalMass.setZero();
            ContactPositionConstraint contactPositionConstraint = this.m_positionConstraints[n2];
            contactPositionConstraint.indexA = body.m_islandIndex;
            contactPositionConstraint.indexB = body2.m_islandIndex;
            contactPositionConstraint.invMassA = body.m_invMass;
            contactPositionConstraint.invMassB = body2.m_invMass;
            contactPositionConstraint.localCenterA.set(body.m_sweep.localCenter);
            contactPositionConstraint.localCenterB.set(body2.m_sweep.localCenter);
            contactPositionConstraint.invIA = body.m_invI;
            contactPositionConstraint.invIB = body2.m_invI;
            contactPositionConstraint.localNormal.set(manifold.localNormal);
            contactPositionConstraint.localPoint.set(manifold.localPoint);
            contactPositionConstraint.pointCount = n3;
            contactPositionConstraint.radiusA = f;
            contactPositionConstraint.radiusB = f2;
            contactPositionConstraint.type = manifold.type;
            int n4 = 0;
            while (n4 < n3) {
                ManifoldPoint manifoldPoint = manifold.points[n4];
                ContactVelocityConstraint.VelocityConstraintPoint velocityConstraintPoint = contactVelocityConstraint.points[n4];
                if (this.m_step.warmStarting) {
                    velocityConstraintPoint.normalImpulse = this.m_step.dtRatio * manifoldPoint.normalImpulse;
                    velocityConstraintPoint.tangentImpulse = this.m_step.dtRatio * manifoldPoint.tangentImpulse;
                } else {
                    velocityConstraintPoint.normalImpulse = 0.0f;
                    velocityConstraintPoint.tangentImpulse = 0.0f;
                }
                velocityConstraintPoint.rA.setZero();
                velocityConstraintPoint.rB.setZero();
                velocityConstraintPoint.normalMass = 0.0f;
                velocityConstraintPoint.tangentMass = 0.0f;
                velocityConstraintPoint.velocityBias = 0.0f;
                contactPositionConstraint.localPoints[n4].x = manifoldPoint.localPoint.x;
                contactPositionConstraint.localPoints[n4].y = manifoldPoint.localPoint.y;
                ++n4;
            }
            ++n2;
        }
    }

    public void warmStart() {
        int n = 0;
        while (n < this.m_count) {
            ContactVelocityConstraint contactVelocityConstraint = this.m_velocityConstraints[n];
            int n2 = contactVelocityConstraint.indexA;
            int n3 = contactVelocityConstraint.indexB;
            float f = contactVelocityConstraint.invMassA;
            float f2 = contactVelocityConstraint.invIA;
            float f3 = contactVelocityConstraint.invMassB;
            float f4 = contactVelocityConstraint.invIB;
            int n4 = contactVelocityConstraint.pointCount;
            Vec2 vec2 = this.m_velocities[n2].v;
            float f5 = this.m_velocities[n2].w;
            Vec2 vec22 = this.m_velocities[n3].v;
            float f6 = this.m_velocities[n3].w;
            Vec2 vec23 = contactVelocityConstraint.normal;
            float f7 = 1.0f * vec23.y;
            float f8 = -1.0f * vec23.x;
            int n5 = 0;
            while (n5 < n4) {
                ContactVelocityConstraint.VelocityConstraintPoint velocityConstraintPoint = contactVelocityConstraint.points[n5];
                float f9 = f7 * velocityConstraintPoint.tangentImpulse + vec23.x * velocityConstraintPoint.normalImpulse;
                float f10 = f8 * velocityConstraintPoint.tangentImpulse + vec23.y * velocityConstraintPoint.normalImpulse;
                f5 -= f2 * (velocityConstraintPoint.rA.x * f10 - velocityConstraintPoint.rA.y * f9);
                vec2.x -= f9 * f;
                vec2.y -= f10 * f;
                f6 += f4 * (velocityConstraintPoint.rB.x * f10 - velocityConstraintPoint.rB.y * f9);
                vec22.x += f9 * f3;
                vec22.y += f10 * f3;
                ++n5;
            }
            this.m_velocities[n2].w = f5;
            this.m_velocities[n3].w = f6;
            ++n;
        }
    }

    public final void initializeVelocityConstraints() {
        int n = 0;
        while (n < this.m_count) {
            float f;
            float f2;
            float f3;
            float f4;
            ContactVelocityConstraint.VelocityConstraintPoint velocityConstraintPoint;
            ContactVelocityConstraint contactVelocityConstraint = this.m_velocityConstraints[n];
            ContactPositionConstraint contactPositionConstraint = this.m_positionConstraints[n];
            float f5 = contactPositionConstraint.radiusA;
            float f6 = contactPositionConstraint.radiusB;
            Manifold manifold = this.m_contacts[contactVelocityConstraint.contactIndex].getManifold();
            int n2 = contactVelocityConstraint.indexA;
            int n3 = contactVelocityConstraint.indexB;
            float f7 = contactVelocityConstraint.invMassA;
            float f8 = contactVelocityConstraint.invMassB;
            float f9 = contactVelocityConstraint.invIA;
            float f10 = contactVelocityConstraint.invIB;
            Vec2 vec2 = contactPositionConstraint.localCenterA;
            Vec2 vec22 = contactPositionConstraint.localCenterB;
            Vec2 vec23 = this.m_positions[n2].c;
            float f11 = this.m_positions[n2].a;
            Vec2 vec24 = this.m_velocities[n2].v;
            float f12 = this.m_velocities[n2].w;
            Vec2 vec25 = this.m_positions[n3].c;
            float f13 = this.m_positions[n3].a;
            Vec2 vec26 = this.m_velocities[n3].v;
            float f14 = this.m_velocities[n3].w;
            assert (manifold.pointCount > 0);
            Rot rot = this.xfA.q;
            Rot rot2 = this.xfB.q;
            rot.set(f11);
            rot2.set(f13);
            this.xfA.p.x = vec23.x - (rot.c * vec2.x - rot.s * vec2.y);
            this.xfA.p.y = vec23.y - (rot.s * vec2.x + rot.c * vec2.y);
            this.xfB.p.x = vec25.x - (rot2.c * vec22.x - rot2.s * vec22.y);
            this.xfB.p.y = vec25.y - (rot2.s * vec22.x + rot2.c * vec22.y);
            this.worldManifold.initialize(manifold, this.xfA, f5, this.xfB, f6);
            Vec2 vec27 = contactVelocityConstraint.normal;
            vec27.x = this.worldManifold.normal.x;
            vec27.y = this.worldManifold.normal.y;
            int n4 = contactVelocityConstraint.pointCount;
            int n5 = 0;
            while (n5 < n4) {
                velocityConstraintPoint = contactVelocityConstraint.points[n5];
                Vec2 vec28 = this.worldManifold.points[n5];
                Vec2 vec29 = velocityConstraintPoint.rA;
                Vec2 vec210 = velocityConstraintPoint.rB;
                vec29.x = vec28.x - vec23.x;
                vec29.y = vec28.y - vec23.y;
                vec210.x = vec28.x - vec25.x;
                vec210.y = vec28.y - vec25.y;
                f4 = vec29.x * vec27.y - vec29.y * vec27.x;
                f3 = vec210.x * vec27.y - vec210.y * vec27.x;
                f2 = f7 + f8 + f9 * f4 * f4 + f10 * f3 * f3;
                velocityConstraintPoint.normalMass = f2 > 0.0f ? 1.0f / f2 : 0.0f;
                f = 1.0f * vec27.y;
                float f15 = -1.0f * vec27.x;
                float f16 = vec29.x * f15 - vec29.y * f;
                float f17 = vec210.x * f15 - vec210.y * f;
                float f18 = f7 + f8 + f9 * f16 * f16 + f10 * f17 * f17;
                velocityConstraintPoint.tangentMass = f18 > 0.0f ? 1.0f / f18 : 0.0f;
                velocityConstraintPoint.velocityBias = 0.0f;
                float f19 = vec26.x + -f14 * vec210.y - vec24.x - -f12 * vec29.y;
                float f20 = vec26.y + f14 * vec210.x - vec24.y - f12 * vec29.x;
                float f21 = vec27.x * f19 + vec27.y * f20;
                if (f21 < -Settings.velocityThreshold) {
                    velocityConstraintPoint.velocityBias = -contactVelocityConstraint.restitution * f21;
                }
                ++n5;
            }
            if (contactVelocityConstraint.pointCount == 2) {
                ContactVelocityConstraint.VelocityConstraintPoint velocityConstraintPoint2 = contactVelocityConstraint.points[0];
                velocityConstraintPoint = contactVelocityConstraint.points[1];
                float f22 = velocityConstraintPoint2.rA.x * vec27.y - velocityConstraintPoint2.rA.y * vec27.x;
                float f23 = velocityConstraintPoint2.rB.x * vec27.y - velocityConstraintPoint2.rB.y * vec27.x;
                f3 = f7 + f8 + f9 * f22 * f22 + f10 * f23 * f23;
                float f24 = velocityConstraintPoint.rA.x * vec27.y - velocityConstraintPoint.rA.y * vec27.x;
                f4 = velocityConstraintPoint.rB.x * vec27.y - velocityConstraintPoint.rB.y * vec27.x;
                f2 = f7 + f8 + f9 * f24 * f24 + f10 * f4 * f4;
                f = f7 + f8 + f9 * f22 * f24 + f10 * f23 * f4;
                if (f3 * f3 < 100.0f * (f3 * f2 - f * f)) {
                    contactVelocityConstraint.K.ex.x = f3;
                    contactVelocityConstraint.K.ex.y = f;
                    contactVelocityConstraint.K.ey.x = f;
                    contactVelocityConstraint.K.ey.y = f2;
                    contactVelocityConstraint.K.invertToOut(contactVelocityConstraint.normalMass);
                } else {
                    contactVelocityConstraint.pointCount = 1;
                }
            }
            ++n;
        }
    }

    public final void solveVelocityConstraints() {
        int n = 0;
        while (n < this.m_count) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            Vec2 vec2;
            ContactVelocityConstraint.VelocityConstraintPoint velocityConstraintPoint;
            ContactVelocityConstraint contactVelocityConstraint = this.m_velocityConstraints[n];
            int n2 = contactVelocityConstraint.indexA;
            int n3 = contactVelocityConstraint.indexB;
            float f9 = contactVelocityConstraint.invMassA;
            float f10 = contactVelocityConstraint.invMassB;
            float f11 = contactVelocityConstraint.invIA;
            float f12 = contactVelocityConstraint.invIB;
            int n4 = contactVelocityConstraint.pointCount;
            Vec2 vec22 = this.m_velocities[n2].v;
            float f13 = this.m_velocities[n2].w;
            Vec2 vec23 = this.m_velocities[n3].v;
            float f14 = this.m_velocities[n3].w;
            Vec2 vec24 = contactVelocityConstraint.normal;
            float f15 = vec24.x;
            float f16 = vec24.y;
            float f17 = 1.0f * contactVelocityConstraint.normal.y;
            float f18 = -1.0f * contactVelocityConstraint.normal.x;
            float f19 = contactVelocityConstraint.friction;
            assert (n4 == 1 || n4 == 2);
            int n5 = 0;
            while (n5 < n4) {
                velocityConstraintPoint = contactVelocityConstraint.points[n5];
                vec2 = velocityConstraintPoint.rA;
                f8 = -f14 * velocityConstraintPoint.rB.y + vec23.x - vec22.x + f13 * vec2.y;
                f7 = f14 * velocityConstraintPoint.rB.x + vec23.y - vec22.y - f13 * vec2.x;
                f6 = f8 * f17 + f7 * f18 - contactVelocityConstraint.tangentSpeed;
                f5 = velocityConstraintPoint.tangentMass * -f6;
                f4 = f19 * velocityConstraintPoint.normalImpulse;
                f3 = MathUtils.clamp(velocityConstraintPoint.tangentImpulse + f5, -f4, f4);
                f5 = f3 - velocityConstraintPoint.tangentImpulse;
                velocityConstraintPoint.tangentImpulse = f3;
                f2 = f17 * f5;
                f = f18 * f5;
                vec22.x -= f2 * f9;
                vec22.y -= f * f9;
                f13 -= f11 * (velocityConstraintPoint.rA.x * f - velocityConstraintPoint.rA.y * f2);
                vec23.x += f2 * f10;
                vec23.y += f * f10;
                f14 += f12 * (velocityConstraintPoint.rB.x * f - velocityConstraintPoint.rB.y * f2);
                ++n5;
            }
            if (contactVelocityConstraint.pointCount == 1) {
                var20_20 = contactVelocityConstraint.points[0];
                float f20 = -f14 * var20_20.rB.y + vec23.x - vec22.x + f13 * var20_20.rA.y;
                float f21 = f14 * var20_20.rB.x + vec23.y - vec22.y - f13 * var20_20.rA.x;
                f8 = f20 * f15 + f21 * f16;
                f7 = -var20_20.normalMass * (f8 - var20_20.velocityBias);
                f6 = var20_20.normalImpulse + f7;
                f5 = f6 > 0.0f ? f6 : 0.0f;
                f7 = f5 - var20_20.normalImpulse;
                var20_20.normalImpulse = f5;
                f4 = f15 * f7;
                f3 = f16 * f7;
                vec22.x -= f4 * f9;
                vec22.y -= f3 * f9;
                f13 -= f11 * (var20_20.rA.x * f3 - var20_20.rA.y * f4);
                vec23.x += f4 * f10;
                vec23.y += f3 * f10;
                f14 += f12 * (var20_20.rB.x * f3 - var20_20.rB.y * f4);
            } else {
                var20_20 = contactVelocityConstraint.points[0];
                velocityConstraintPoint = contactVelocityConstraint.points[1];
                vec2 = var20_20.rA;
                Vec2 vec25 = var20_20.rB;
                Vec2 vec26 = velocityConstraintPoint.rA;
                Vec2 vec27 = velocityConstraintPoint.rB;
                f5 = var20_20.normalImpulse;
                f4 = velocityConstraintPoint.normalImpulse;
                assert (f5 >= 0.0f && f4 >= 0.0f);
                f3 = -f14 * vec25.y + vec23.x - vec22.x + f13 * vec2.y;
                f2 = f14 * vec25.x + vec23.y - vec22.y - f13 * vec2.x;
                f = -f14 * vec27.y + vec23.x - vec22.x + f13 * vec26.y;
                float f22 = f14 * vec27.x + vec23.y - vec22.y - f13 * vec26.x;
                float f23 = f3 * f15 + f2 * f16;
                float f24 = f * f15 + f22 * f16;
                float f25 = f23 - var20_20.velocityBias;
                float f26 = f24 - velocityConstraintPoint.velocityBias;
                Mat22 mat22 = contactVelocityConstraint.K;
                Mat22 mat222 = contactVelocityConstraint.normalMass;
                float f27 = mat222.ex.x * (f25 -= mat22.ex.x * f5 + mat22.ey.x * f4) + mat222.ey.x * (f26 -= mat22.ex.y * f5 + mat22.ey.y * f4);
                float f28 = mat222.ex.y * f25 + mat222.ey.y * f26;
                f27 *= -1.0f;
                f28 *= -1.0f;
                if (f27 >= 0.0f && f28 >= 0.0f) {
                    var40_46 = f27 - f5;
                    var41_47 = f28 - f4;
                    var42_48 = var40_46 * f15;
                    var43_49 = var40_46 * f16;
                    var44_50 = var41_47 * f15;
                    var45_51 = var41_47 * f16;
                    vec22.x -= f9 * (var42_48 + var44_50);
                    vec22.y -= f9 * (var43_49 + var45_51);
                    vec23.x += f10 * (var42_48 + var44_50);
                    vec23.y += f10 * (var43_49 + var45_51);
                    f13 -= f11 * (vec2.x * var43_49 - vec2.y * var42_48 + (vec26.x * var45_51 - vec26.y * var44_50));
                    f14 += f12 * (vec25.x * var43_49 - vec25.y * var42_48 + (vec27.x * var45_51 - vec27.y * var44_50));
                    var20_20.normalImpulse = f27;
                    velocityConstraintPoint.normalImpulse = f28;
                } else {
                    f27 = -var20_20.normalMass * f25;
                    f28 = 0.0f;
                    f23 = 0.0f;
                    f24 = contactVelocityConstraint.K.ex.y * f27 + f26;
                    if (f27 >= 0.0f && f24 >= 0.0f) {
                        var40_46 = f27 - f5;
                        var41_47 = f28 - f4;
                        var42_48 = f15 * var40_46;
                        var43_49 = f16 * var40_46;
                        var44_50 = f15 * var41_47;
                        var45_51 = f16 * var41_47;
                        vec22.x -= f9 * (var42_48 + var44_50);
                        vec22.y -= f9 * (var43_49 + var45_51);
                        vec23.x += f10 * (var42_48 + var44_50);
                        vec23.y += f10 * (var43_49 + var45_51);
                        f13 -= f11 * (vec2.x * var43_49 - vec2.y * var42_48 + (vec26.x * var45_51 - vec26.y * var44_50));
                        f14 += f12 * (vec25.x * var43_49 - vec25.y * var42_48 + (vec27.x * var45_51 - vec27.y * var44_50));
                        var20_20.normalImpulse = f27;
                        velocityConstraintPoint.normalImpulse = f28;
                    } else {
                        f27 = 0.0f;
                        f28 = -velocityConstraintPoint.normalMass * f26;
                        f23 = contactVelocityConstraint.K.ey.x * f28 + f25;
                        f24 = 0.0f;
                        if (f28 >= 0.0f && f23 >= 0.0f) {
                            var40_46 = f27 - f5;
                            var41_47 = f28 - f4;
                            var42_48 = f15 * var40_46;
                            var43_49 = f16 * var40_46;
                            var44_50 = f15 * var41_47;
                            var45_51 = f16 * var41_47;
                            vec22.x -= f9 * (var42_48 + var44_50);
                            vec22.y -= f9 * (var43_49 + var45_51);
                            vec23.x += f10 * (var42_48 + var44_50);
                            vec23.y += f10 * (var43_49 + var45_51);
                            f13 -= f11 * (vec2.x * var43_49 - vec2.y * var42_48 + (vec26.x * var45_51 - vec26.y * var44_50));
                            f14 += f12 * (vec25.x * var43_49 - vec25.y * var42_48 + (vec27.x * var45_51 - vec27.y * var44_50));
                            var20_20.normalImpulse = f27;
                            velocityConstraintPoint.normalImpulse = f28;
                        } else {
                            f27 = 0.0f;
                            f28 = 0.0f;
                            f23 = f25;
                            f24 = f26;
                            if (f23 >= 0.0f && f24 >= 0.0f) {
                                var40_46 = f27 - f5;
                                var41_47 = f28 - f4;
                                var42_48 = f15 * var40_46;
                                var43_49 = f16 * var40_46;
                                var44_50 = f15 * var41_47;
                                var45_51 = f16 * var41_47;
                                vec22.x -= f9 * (var42_48 + var44_50);
                                vec22.y -= f9 * (var43_49 + var45_51);
                                vec23.x += f10 * (var42_48 + var44_50);
                                vec23.y += f10 * (var43_49 + var45_51);
                                f13 -= f11 * (vec2.x * var43_49 - vec2.y * var42_48 + (vec26.x * var45_51 - vec26.y * var44_50));
                                f14 += f12 * (vec25.x * var43_49 - vec25.y * var42_48 + (vec27.x * var45_51 - vec27.y * var44_50));
                                var20_20.normalImpulse = f27;
                                velocityConstraintPoint.normalImpulse = f28;
                            }
                        }
                    }
                }
            }
            this.m_velocities[n2].w = f13;
            this.m_velocities[n3].w = f14;
            ++n;
        }
    }

    public void storeImpulses() {
        int n = 0;
        while (n < this.m_count) {
            ContactVelocityConstraint contactVelocityConstraint = this.m_velocityConstraints[n];
            Manifold manifold = this.m_contacts[contactVelocityConstraint.contactIndex].getManifold();
            int n2 = 0;
            while (n2 < contactVelocityConstraint.pointCount) {
                manifold.points[n2].normalImpulse = contactVelocityConstraint.points[n2].normalImpulse;
                manifold.points[n2].tangentImpulse = contactVelocityConstraint.points[n2].tangentImpulse;
                ++n2;
            }
            ++n;
        }
    }

    public final boolean solvePositionConstraints() {
        float f = 0.0f;
        int n = 0;
        while (n < this.m_count) {
            ContactPositionConstraint contactPositionConstraint = this.m_positionConstraints[n];
            int n2 = contactPositionConstraint.indexA;
            int n3 = contactPositionConstraint.indexB;
            float f2 = contactPositionConstraint.invMassA;
            float f3 = contactPositionConstraint.invIA;
            Vec2 vec2 = contactPositionConstraint.localCenterA;
            float f4 = vec2.x;
            float f5 = vec2.y;
            float f6 = contactPositionConstraint.invMassB;
            float f7 = contactPositionConstraint.invIB;
            Vec2 vec22 = contactPositionConstraint.localCenterB;
            float f8 = vec22.x;
            float f9 = vec22.y;
            int n4 = contactPositionConstraint.pointCount;
            Vec2 vec23 = this.m_positions[n2].c;
            float f10 = this.m_positions[n2].a;
            Vec2 vec24 = this.m_positions[n3].c;
            float f11 = this.m_positions[n3].a;
            int n5 = 0;
            while (n5 < n4) {
                Rot rot = this.xfA.q;
                Rot rot2 = this.xfB.q;
                rot.set(f10);
                rot2.set(f11);
                this.xfA.p.x = vec23.x - rot.c * f4 + rot.s * f5;
                this.xfA.p.y = vec23.y - rot.s * f4 - rot.c * f5;
                this.xfB.p.x = vec24.x - rot2.c * f8 + rot2.s * f9;
                this.xfB.p.y = vec24.y - rot2.s * f8 - rot2.c * f9;
                PositionSolverManifold positionSolverManifold = this.psolver;
                positionSolverManifold.initialize(contactPositionConstraint, this.xfA, this.xfB, n5);
                Vec2 vec25 = positionSolverManifold.normal;
                Vec2 vec26 = positionSolverManifold.point;
                float f12 = positionSolverManifold.separation;
                float f13 = vec26.x - vec23.x;
                float f14 = vec26.y - vec23.y;
                float f15 = vec26.x - vec24.x;
                float f16 = vec26.y - vec24.y;
                f = MathUtils.min(f, f12);
                float f17 = MathUtils.clamp(Settings.baumgarte * (f12 + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float f18 = f13 * vec25.y - f14 * vec25.x;
                float f19 = f15 * vec25.y - f16 * vec25.x;
                float f20 = f2 + f6 + f3 * f18 * f18 + f7 * f19 * f19;
                float f21 = f20 > 0.0f ? -f17 / f20 : 0.0f;
                float f22 = vec25.x * f21;
                float f23 = vec25.y * f21;
                vec23.x -= f22 * f2;
                vec23.y -= f23 * f2;
                f10 -= f3 * (f13 * f23 - f14 * f22);
                vec24.x += f22 * f6;
                vec24.y += f23 * f6;
                f11 += f7 * (f15 * f23 - f16 * f22);
                ++n5;
            }
            this.m_positions[n2].a = f10;
            this.m_positions[n3].a = f11;
            ++n;
        }
        return f >= -3.0f * Settings.linearSlop;
    }

    public boolean solveTOIPositionConstraints(int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        while (n3 < this.m_count) {
            ContactPositionConstraint contactPositionConstraint = this.m_positionConstraints[n3];
            int n4 = contactPositionConstraint.indexA;
            int n5 = contactPositionConstraint.indexB;
            Vec2 vec2 = contactPositionConstraint.localCenterA;
            Vec2 vec22 = contactPositionConstraint.localCenterB;
            float f2 = vec2.x;
            float f3 = vec2.y;
            float f4 = vec22.x;
            float f5 = vec22.y;
            int n6 = contactPositionConstraint.pointCount;
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (n4 == n || n4 == n2) {
                f6 = contactPositionConstraint.invMassA;
                f7 = contactPositionConstraint.invIA;
            }
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (n5 == n || n5 == n2) {
                f8 = contactPositionConstraint.invMassB;
                f9 = contactPositionConstraint.invIB;
            }
            Vec2 vec23 = this.m_positions[n4].c;
            float f10 = this.m_positions[n4].a;
            Vec2 vec24 = this.m_positions[n5].c;
            float f11 = this.m_positions[n5].a;
            int n7 = 0;
            while (n7 < n6) {
                Rot rot = this.xfA.q;
                Rot rot2 = this.xfB.q;
                rot.set(f10);
                rot2.set(f11);
                this.xfA.p.x = vec23.x - rot.c * f2 + rot.s * f3;
                this.xfA.p.y = vec23.y - rot.s * f2 - rot.c * f3;
                this.xfB.p.x = vec24.x - rot2.c * f4 + rot2.s * f5;
                this.xfB.p.y = vec24.y - rot2.s * f4 - rot2.c * f5;
                PositionSolverManifold positionSolverManifold = this.psolver;
                positionSolverManifold.initialize(contactPositionConstraint, this.xfA, this.xfB, n7);
                Vec2 vec25 = positionSolverManifold.normal;
                Vec2 vec26 = positionSolverManifold.point;
                float f12 = positionSolverManifold.separation;
                float f13 = vec26.x - vec23.x;
                float f14 = vec26.y - vec23.y;
                float f15 = vec26.x - vec24.x;
                float f16 = vec26.y - vec24.y;
                f = MathUtils.min(f, f12);
                float f17 = MathUtils.clamp(Settings.toiBaugarte * (f12 + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float f18 = f13 * vec25.y - f14 * vec25.x;
                float f19 = f15 * vec25.y - f16 * vec25.x;
                float f20 = f6 + f8 + f7 * f18 * f18 + f9 * f19 * f19;
                float f21 = f20 > 0.0f ? -f17 / f20 : 0.0f;
                float f22 = vec25.x * f21;
                float f23 = vec25.y * f21;
                vec23.x -= f22 * f6;
                vec23.y -= f23 * f6;
                f10 -= f7 * (f13 * f23 - f14 * f22);
                vec24.x += f22 * f8;
                vec24.y += f23 * f8;
                f11 += f9 * (f15 * f23 - f16 * f22);
                ++n7;
            }
            this.m_positions[n4].a = f10;
            this.m_positions[n5].a = f11;
            ++n3;
        }
        return f >= -1.5f * Settings.linearSlop;
    }

    public static class ContactSolverDef {
        public TimeStep step;
        public Contact[] contacts;
        public int count;
        public Position[] positions;
        public Velocity[] velocities;
    }
}

