/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.broadphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.DbvtAabbMm;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import javax.vecmath.Vector3f;

public class Dbvt {
    public static final int SIMPLE_STACKSIZE = 64;
    public static final int DOUBLE_STACKSIZE = 128;
    public Node root = null;
    public Node free = null;
    public int lkhd = -1;
    public int leaves = 0;
    public int opath = 0;
    private static Vector3f[] axis = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};

    public void clear() {
        if (this.root != null) {
            Dbvt.recursedeletenode(this, this.root);
        }
        this.free = null;
    }

    public boolean empty() {
        return this.root == null;
    }

    public void optimizeBottomUp() {
        if (this.root != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>(this.leaves);
            Dbvt.fetchleaves(this, this.root, arrayList);
            Dbvt.bottomup(this, arrayList);
            this.root = arrayList.get(0);
        }
    }

    public void optimizeTopDown() {
        this.optimizeTopDown(128);
    }

    public void optimizeTopDown(int n) {
        if (this.root != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>(this.leaves);
            Dbvt.fetchleaves(this, this.root, arrayList);
            this.root = Dbvt.topdown(this, arrayList, n);
        }
    }

    public void optimizeIncremental(int n) {
        if (n < 0) {
            n = this.leaves;
        }
        if (this.root != null && n > 0) {
            Node[] nodeArray = new Node[1];
            do {
                Node node = this.root;
                int n2 = 0;
                while (node.isinternal()) {
                    nodeArray[0] = this.root;
                    node = Dbvt.sort((Node)node, (Node[])nodeArray).childs[this.opath >>> n2 & 1];
                    this.root = nodeArray[0];
                    n2 = n2 + 1 & 0x1F;
                }
                this.update(node);
                ++this.opath;
            } while (--n != 0);
        }
    }

    public Node insert(DbvtAabbMm dbvtAabbMm, Object object) {
        Node node = Dbvt.createnode(this, null, dbvtAabbMm, object);
        Dbvt.insertleaf(this, this.root, node);
        ++this.leaves;
        return node;
    }

    public void update(Node node) {
        this.update(node, -1);
    }

    public void update(Node node, int n) {
        Node node2 = Dbvt.removeleaf(this, node);
        if (node2 != null) {
            if (n >= 0) {
                int n2 = 0;
                while (n2 < n && node2.parent != null) {
                    node2 = node2.parent;
                    ++n2;
                }
            } else {
                node2 = this.root;
            }
        }
        Dbvt.insertleaf(this, node2, node);
    }

    public void update(Node node, DbvtAabbMm dbvtAabbMm) {
        Node node2 = Dbvt.removeleaf(this, node);
        if (node2 != null) {
            if (this.lkhd >= 0) {
                int n = 0;
                while (n < this.lkhd && node2.parent != null) {
                    node2 = node2.parent;
                    ++n;
                }
            } else {
                node2 = this.root;
            }
        }
        node.volume.set(dbvtAabbMm);
        Dbvt.insertleaf(this, node2, node);
    }

    public boolean update(Node node, DbvtAabbMm dbvtAabbMm, Vector3f vector3f, float f) {
        if (node.volume.Contain(dbvtAabbMm)) {
            return false;
        }
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(f, f, f);
        dbvtAabbMm.Expand(vector3f2);
        dbvtAabbMm.SignedExpand(vector3f);
        this.update(node, dbvtAabbMm);
        return true;
    }

    public boolean update(Node node, DbvtAabbMm dbvtAabbMm, Vector3f vector3f) {
        if (node.volume.Contain(dbvtAabbMm)) {
            return false;
        }
        dbvtAabbMm.SignedExpand(vector3f);
        this.update(node, dbvtAabbMm);
        return true;
    }

    public boolean update(Node node, DbvtAabbMm dbvtAabbMm, float f) {
        if (node.volume.Contain(dbvtAabbMm)) {
            return false;
        }
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(f, f, f);
        dbvtAabbMm.Expand(vector3f);
        this.update(node, dbvtAabbMm);
        return true;
    }

    public void remove(Node node) {
        Dbvt.removeleaf(this, node);
        Dbvt.deletenode(this, node);
        --this.leaves;
    }

    public void write(IWriter iWriter) {
        throw new UnsupportedOperationException();
    }

    public void clone(Dbvt dbvt) {
        this.clone(dbvt, null);
    }

    public void clone(Dbvt dbvt, IClone iClone) {
        throw new UnsupportedOperationException();
    }

    public static int countLeaves(Node node) {
        if (node.isinternal()) {
            return Dbvt.countLeaves(node.childs[0]) + Dbvt.countLeaves(node.childs[1]);
        }
        return 1;
    }

    public static void extractLeaves(Node node, ArrayList<Node> arrayList) {
        if (node.isinternal()) {
            Dbvt.extractLeaves(node.childs[0], arrayList);
            Dbvt.extractLeaves(node.childs[1], arrayList);
        } else {
            arrayList.add(node);
        }
    }

    public static void enumNodes(Node node, ICollide iCollide) {
        iCollide.Process(node);
        if (node.isinternal()) {
            Dbvt.enumNodes(node.childs[0], iCollide);
            Dbvt.enumNodes(node.childs[1], iCollide);
        }
    }

    public static void enumLeaves(Node node, ICollide iCollide) {
        if (node.isinternal()) {
            Dbvt.enumLeaves(node.childs[0], iCollide);
            Dbvt.enumLeaves(node.childs[1], iCollide);
        } else {
            iCollide.Process(node);
        }
    }

    public static void collideTT(Node node, Node node2, ICollide iCollide) {
        if (node != null && node2 != null) {
            ArrayList<sStkNN> arrayList = new ArrayList<sStkNN>(128);
            arrayList.add(new sStkNN(node, node2));
            do {
                sStkNN sStkNN2 = (sStkNN)arrayList.remove(arrayList.size() - 1);
                if (sStkNN2.a == sStkNN2.b) {
                    if (!sStkNN2.a.isinternal()) continue;
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.a.childs[0]));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.a.childs[1]));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.a.childs[1]));
                    continue;
                }
                if (!DbvtAabbMm.Intersect(sStkNN2.a.volume, sStkNN2.b.volume)) continue;
                if (sStkNN2.a.isinternal()) {
                    if (sStkNN2.b.isinternal()) {
                        arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b.childs[0]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b.childs[0]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b.childs[1]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b.childs[1]));
                        continue;
                    }
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b));
                    continue;
                }
                if (sStkNN2.b.isinternal()) {
                    arrayList.add(new sStkNN(sStkNN2.a, sStkNN2.b.childs[0]));
                    arrayList.add(new sStkNN(sStkNN2.a, sStkNN2.b.childs[1]));
                    continue;
                }
                iCollide.Process(sStkNN2.a, sStkNN2.b);
            } while (arrayList.size() > 0);
        }
    }

    public static void collideTT(Node node, Node node2, Transform transform, ICollide iCollide) {
        if (node != null && node2 != null) {
            ArrayList<sStkNN> arrayList = new ArrayList<sStkNN>(128);
            arrayList.add(new sStkNN(node, node2));
            do {
                sStkNN sStkNN2 = (sStkNN)arrayList.remove(arrayList.size() - 1);
                if (sStkNN2.a == sStkNN2.b) {
                    if (!sStkNN2.a.isinternal()) continue;
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.a.childs[0]));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.a.childs[1]));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.a.childs[1]));
                    continue;
                }
                if (!DbvtAabbMm.Intersect(sStkNN2.a.volume, sStkNN2.b.volume, transform)) continue;
                if (sStkNN2.a.isinternal()) {
                    if (sStkNN2.b.isinternal()) {
                        arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b.childs[0]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b.childs[0]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b.childs[1]));
                        arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b.childs[1]));
                        continue;
                    }
                    arrayList.add(new sStkNN(sStkNN2.a.childs[0], sStkNN2.b));
                    arrayList.add(new sStkNN(sStkNN2.a.childs[1], sStkNN2.b));
                    continue;
                }
                if (sStkNN2.b.isinternal()) {
                    arrayList.add(new sStkNN(sStkNN2.a, sStkNN2.b.childs[0]));
                    arrayList.add(new sStkNN(sStkNN2.a, sStkNN2.b.childs[1]));
                    continue;
                }
                iCollide.Process(sStkNN2.a, sStkNN2.b);
            } while (arrayList.size() > 0);
        }
    }

    public static void collideTT(Node node, Transform transform, Node node2, Transform transform2, ICollide iCollide) {
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        transform3.inverse(transform);
        transform3.mul(transform2);
        Dbvt.collideTT(node, node2, transform3, iCollide);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3});
    }

    public static void collideTV(Node node, DbvtAabbMm dbvtAabbMm, ICollide iCollide) {
        if (node != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>(64);
            arrayList.add(node);
            do {
                Node node2 = (Node)arrayList.remove(arrayList.size() - 1);
                if (!DbvtAabbMm.Intersect(node2.volume, dbvtAabbMm)) continue;
                if (node2.isinternal()) {
                    arrayList.add(node2.childs[0]);
                    arrayList.add(node2.childs[1]);
                    continue;
                }
                iCollide.Process(node2);
            } while (arrayList.size() > 0);
        }
    }

    public static void collideRAY(Node node, Vector3f vector3f, Vector3f vector3f2, ICollide iCollide) {
        if (node != null) {
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.normalize(vector3f2);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.set(1.0f / vector3f3.x, 1.0f / vector3f3.y, 1.0f / vector3f3.z);
            int[] nArray = new int[]{vector3f2.x < 0.0f ? 1 : 0, vector3f2.y < 0.0f ? 1 : 0, vector3f2.z < 0.0f ? 1 : 0};
            ArrayList<Node> arrayList = new ArrayList<Node>(64);
            arrayList.add(node);
            do {
                Node node2 = (Node)arrayList.remove(arrayList.size() - 1);
                if (!DbvtAabbMm.Intersect(node2.volume, vector3f, vector3f4, nArray)) continue;
                if (node2.isinternal()) {
                    arrayList.add(node2.childs[0]);
                    arrayList.add(node2.childs[1]);
                    continue;
                }
                iCollide.Process(node2);
            } while (arrayList.size() != 0);
        }
    }

    public static void collideKDOP(Node node, Vector3f[] vector3fArray, float[] fArray, int n, ICollide iCollide) {
        if (node != null) {
            int n2 = (1 << n) - 1;
            ArrayList<sStkNP> arrayList = new ArrayList<sStkNP>(64);
            int[] nArray = new int[32];
            assert (n < 32);
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = (vector3fArray[n3].x >= 0.0f ? 1 : 0) + (vector3fArray[n3].y >= 0.0f ? 2 : 0) + (vector3fArray[n3].z >= 0.0f ? 4 : 0);
                ++n3;
            }
            arrayList.add(new sStkNP(node, 0));
            do {
                sStkNP sStkNP2 = (sStkNP)arrayList.remove(arrayList.size() - 1);
                boolean bl = false;
                int n4 = 0;
                int n5 = 1;
                while (!bl && n4 < n) {
                    if ((sStkNP2.mask & n5) == 0) {
                        int n6 = sStkNP2.node.volume.Classify(vector3fArray[n4], fArray[n4], nArray[n4]);
                        switch (n6) {
                            case -1: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                sStkNP2.mask |= n5;
                            }
                        }
                    }
                    ++n4;
                    n5 <<= 1;
                }
                if (bl) continue;
                if (sStkNP2.mask != n2 && sStkNP2.node.isinternal()) {
                    arrayList.add(new sStkNP(sStkNP2.node.childs[0], sStkNP2.mask));
                    arrayList.add(new sStkNP(sStkNP2.node.childs[1], sStkNP2.mask));
                    continue;
                }
                if (!iCollide.AllLeaves(sStkNP2.node)) continue;
                Dbvt.enumLeaves(sStkNP2.node, iCollide);
            } while (arrayList.size() != 0);
        }
    }

    public static void collideOCL(Node node, Vector3f[] vector3fArray, float[] fArray, Vector3f vector3f, int n, ICollide iCollide) {
        Dbvt.collideOCL(node, vector3fArray, fArray, vector3f, n, iCollide, true);
    }

    public static void collideOCL(Node node, Vector3f[] vector3fArray, float[] fArray, Vector3f vector3f, int n, ICollide iCollide, boolean bl) {
        if (node != null) {
            int n2 = (vector3f.x >= 0.0f ? 1 : 0) + (vector3f.y >= 0.0f ? 2 : 0) + (vector3f.z >= 0.0f ? 4 : 0);
            int n3 = (1 << n) - 1;
            ArrayList<sStkNPS> arrayList = new ArrayList<sStkNPS>();
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            int[] nArray = new int[32];
            assert (n < 32);
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = (vector3fArray[n4].x >= 0.0f ? 1 : 0) + (vector3fArray[n4].y >= 0.0f ? 2 : 0) + (vector3fArray[n4].z >= 0.0f ? 4 : 0);
                ++n4;
            }
            intArrayList2.add(Dbvt.allocate(intArrayList, arrayList, new sStkNPS(node, 0, node.volume.ProjectMinimum(vector3f, n2))));
            do {
                int n5;
                int n6;
                n4 = intArrayList2.remove(intArrayList2.size() - 1);
                sStkNPS sStkNPS2 = arrayList.get(n4);
                intArrayList.add(n4);
                if (sStkNPS2.mask != n3) {
                    boolean bl2 = false;
                    int n7 = 0;
                    n6 = 1;
                    while (!bl2 && n7 < n) {
                        if ((sStkNPS2.mask & n6) == 0) {
                            n5 = sStkNPS2.node.volume.Classify(vector3fArray[n7], fArray[n7], nArray[n7]);
                            switch (n5) {
                                case -1: {
                                    bl2 = true;
                                    break;
                                }
                                case 1: {
                                    sStkNPS2.mask |= n6;
                                }
                            }
                        }
                        ++n7;
                        n6 <<= 1;
                    }
                    if (bl2) continue;
                }
                if (!iCollide.Descent(sStkNPS2.node)) continue;
                if (sStkNPS2.node.isinternal()) {
                    Node[] nodeArray = new Node[]{sStkNPS2.node.childs[0], sStkNPS2.node.childs[1]};
                    sStkNPS[] sStkNPSArray = new sStkNPS[]{new sStkNPS(nodeArray[0], sStkNPS2.mask, nodeArray[0].volume.ProjectMinimum(vector3f, n2)), new sStkNPS(nodeArray[1], sStkNPS2.mask, nodeArray[1].volume.ProjectMinimum(vector3f, n2))};
                    n6 = sStkNPSArray[0].value < sStkNPSArray[1].value ? 1 : 0;
                    n5 = intArrayList2.size();
                    if (bl && n5 > 0) {
                        n5 = Dbvt.nearest(intArrayList2, arrayList, sStkNPSArray[n6].value, 0, intArrayList2.size());
                        intArrayList2.add(0);
                        int n8 = intArrayList2.size() - 1;
                        while (n8 > n5) {
                            intArrayList2.set(n8, intArrayList2.get(n8 - 1));
                            --n8;
                        }
                        intArrayList2.set(n5, Dbvt.allocate(intArrayList, arrayList, sStkNPSArray[n6]));
                        n5 = Dbvt.nearest(intArrayList2, arrayList, sStkNPSArray[1 - n6].value, n5, intArrayList2.size());
                        intArrayList2.add(0);
                        n8 = intArrayList2.size() - 1;
                        while (n8 > n5) {
                            intArrayList2.set(n8, intArrayList2.get(n8 - 1));
                            --n8;
                        }
                        intArrayList2.set(n5, Dbvt.allocate(intArrayList, arrayList, sStkNPSArray[1 - n6]));
                        continue;
                    }
                    intArrayList2.add(Dbvt.allocate(intArrayList, arrayList, sStkNPSArray[n6]));
                    intArrayList2.add(Dbvt.allocate(intArrayList, arrayList, sStkNPSArray[1 - n6]));
                    continue;
                }
                iCollide.Process(sStkNPS2.node, sStkNPS2.value);
            } while (intArrayList2.size() != 0);
        }
    }

    public static void collideTU(Node node, ICollide iCollide) {
        if (node != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>(64);
            arrayList.add(node);
            do {
                Node node2;
                if (!iCollide.Descent(node2 = (Node)arrayList.remove(arrayList.size() - 1))) continue;
                if (node2.isinternal()) {
                    arrayList.add(node2.childs[0]);
                    arrayList.add(node2.childs[1]);
                    continue;
                }
                iCollide.Process(node2);
            } while (arrayList.size() > 0);
        }
    }

    public static int nearest(IntArrayList intArrayList, ArrayList<sStkNPS> arrayList, float f, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 = n + n2 >> 1;
            if (arrayList.get((int)intArrayList.get((int)n3)).value >= f) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return n2;
    }

    public static int allocate(IntArrayList intArrayList, ArrayList<sStkNPS> arrayList, sStkNPS sStkNPS2) {
        int n;
        if (intArrayList.size() > 0) {
            n = intArrayList.get(intArrayList.size() - 1);
            intArrayList.remove(intArrayList.size() - 1);
            arrayList.get(n).set(sStkNPS2);
        } else {
            n = arrayList.size();
            arrayList.add(sStkNPS2);
        }
        return n;
    }

    private static int indexof(Node node) {
        return node.parent.childs[1] == node ? 1 : 0;
    }

    private static DbvtAabbMm merge(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2, DbvtAabbMm dbvtAabbMm3) {
        DbvtAabbMm.Merge(dbvtAabbMm, dbvtAabbMm2, dbvtAabbMm3);
        return dbvtAabbMm3;
    }

    private static float size(DbvtAabbMm dbvtAabbMm) {
        Vector3f vector3f = dbvtAabbMm.Lengths((Vector3f)Pools.VECTORS.get());
        float f = vector3f.x * vector3f.y * vector3f.z + vector3f.x + vector3f.y + vector3f.z;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        return f;
    }

    private static void deletenode(Dbvt dbvt, Node node) {
        dbvt.free = node;
    }

    private static void recursedeletenode(Dbvt dbvt, Node node) {
        if (!node.isleaf()) {
            Dbvt.recursedeletenode(dbvt, node.childs[0]);
            Dbvt.recursedeletenode(dbvt, node.childs[1]);
        }
        if (node == dbvt.root) {
            dbvt.root = null;
        }
        Dbvt.deletenode(dbvt, node);
    }

    private static Node createnode(Dbvt dbvt, Node node, DbvtAabbMm dbvtAabbMm, Object object) {
        Node node2;
        if (dbvt.free != null) {
            node2 = dbvt.free;
            dbvt.free = null;
        } else {
            node2 = new Node();
        }
        node2.parent = node;
        node2.volume.set(dbvtAabbMm);
        node2.data = object;
        node2.childs[1] = null;
        return node2;
    }

    private static void insertleaf(Dbvt dbvt, Node node, Node node2) {
        if (dbvt.root == null) {
            dbvt.root = node2;
            node2.parent = null;
        } else {
            if (!node.isleaf()) {
                while (!(node = DbvtAabbMm.Proximity(node.childs[0].volume, node2.volume) < DbvtAabbMm.Proximity(node.childs[1].volume, node2.volume) ? node.childs[0] : node.childs[1]).isleaf()) {
                }
            }
            Node node3 = node.parent;
            Node node4 = Dbvt.createnode(dbvt, node3, Dbvt.merge(node2.volume, node.volume, new DbvtAabbMm()), null);
            if (node3 != null) {
                node3.childs[Dbvt.indexof((Node)node)] = node4;
                node4.childs[0] = node;
                node.parent = node4;
                node4.childs[1] = node2;
                node2.parent = node4;
                while (!node3.volume.Contain(node4.volume)) {
                    DbvtAabbMm.Merge(node3.childs[0].volume, node3.childs[1].volume, node3.volume);
                    node4 = node3;
                    node3 = node4.parent;
                    if (node3 != null) continue;
                    break;
                }
            } else {
                node4.childs[0] = node;
                node.parent = node4;
                node4.childs[1] = node2;
                node2.parent = node4;
                dbvt.root = node4;
            }
        }
    }

    private static Node removeleaf(Dbvt dbvt, Node node) {
        if (node == dbvt.root) {
            dbvt.root = null;
            return null;
        }
        Node node2 = node.parent;
        Node node3 = node2.parent;
        Node node4 = node2.childs[1 - Dbvt.indexof(node)];
        if (node3 == null) {
            dbvt.root = node4;
            node4.parent = null;
            Dbvt.deletenode(dbvt, node2);
            return dbvt.root;
        }
        node3.childs[Dbvt.indexof((Node)node2)] = node4;
        node4.parent = node3;
        Dbvt.deletenode(dbvt, node2);
        while (node3 != null) {
            DbvtAabbMm dbvtAabbMm = node3.volume;
            DbvtAabbMm.Merge(node3.childs[0].volume, node3.childs[1].volume, node3.volume);
            if (!DbvtAabbMm.NotEqual(dbvtAabbMm, node3.volume)) break;
            node3 = node3.parent;
        }
        return node3 != null ? node3 : dbvt.root;
    }

    private static void fetchleaves(Dbvt dbvt, Node node, ArrayList<Node> arrayList) {
        Dbvt.fetchleaves(dbvt, node, arrayList, -1);
    }

    private static void fetchleaves(Dbvt dbvt, Node node, ArrayList<Node> arrayList, int n) {
        if (node.isinternal() && n != 0) {
            Dbvt.fetchleaves(dbvt, node.childs[0], arrayList, n - 1);
            Dbvt.fetchleaves(dbvt, node.childs[1], arrayList, n - 1);
            Dbvt.deletenode(dbvt, node);
        } else {
            arrayList.add(node);
        }
    }

    private static void split(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, ArrayList<Node> arrayList3, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        MiscUtil.resize(arrayList2, 0, Node.class);
        MiscUtil.resize(arrayList3, 0, Node.class);
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            arrayList.get((int)n).volume.Center(vector3f3);
            vector3f3.sub(vector3f);
            if (vector3f2.dot(vector3f3) < 0.0f) {
                arrayList2.add(arrayList.get(n));
            } else {
                arrayList3.add(arrayList.get(n));
            }
            ++n;
        }
    }

    private static DbvtAabbMm bounds(ArrayList<Node> arrayList) {
        DbvtAabbMm dbvtAabbMm = new DbvtAabbMm(arrayList.get((int)0).volume);
        int n = 1;
        int n2 = arrayList.size();
        while (n < n2) {
            Dbvt.merge(dbvtAabbMm, arrayList.get((int)n).volume, dbvtAabbMm);
            ++n;
        }
        return dbvtAabbMm;
    }

    private static void bottomup(Dbvt dbvt, ArrayList<Node> arrayList) {
        DbvtAabbMm dbvtAabbMm = new DbvtAabbMm();
        while (arrayList.size() > 1) {
            float f = Float.MAX_VALUE;
            int[] nArray = new int[]{-1, -1};
            int n = 0;
            while (n < arrayList.size()) {
                int n2 = n + 1;
                while (n2 < arrayList.size()) {
                    float f2 = Dbvt.size(Dbvt.merge(arrayList.get((int)n).volume, arrayList.get((int)n2).volume, dbvtAabbMm));
                    if (f2 < f) {
                        f = f2;
                        nArray[0] = n;
                        nArray[1] = n2;
                    }
                    ++n2;
                }
                ++n;
            }
            Node[] nodeArray = new Node[]{arrayList.get(nArray[0]), arrayList.get(nArray[1])};
            Node node = Dbvt.createnode(dbvt, null, Dbvt.merge(nodeArray[0].volume, nodeArray[1].volume, new DbvtAabbMm()), null);
            node.childs[0] = nodeArray[0];
            node.childs[1] = nodeArray[1];
            nodeArray[0].parent = node;
            nodeArray[1].parent = node;
            arrayList.set(nArray[0], node);
            Collections.swap(arrayList, nArray[1], arrayList.size() - 1);
            arrayList.remove(arrayList.size() - 1);
        }
    }

    private static Node topdown(Dbvt dbvt, ArrayList<Node> arrayList, int n) {
        if (arrayList.size() > 1) {
            if (arrayList.size() <= n) {
                Dbvt.bottomup(dbvt, arrayList);
                return arrayList.get(0);
            }
            DbvtAabbMm dbvtAabbMm = Dbvt.bounds(arrayList);
            Vector3f vector3f = dbvtAabbMm.Center((Vector3f)Pools.VECTORS.get());
            ArrayList[] arrayListArray = new ArrayList[2];
            int n2 = 0;
            while (n2 < arrayListArray.length) {
                arrayListArray[n2] = new ArrayList();
                ++n2;
            }
            n2 = -1;
            int n3 = arrayList.size();
            int[][] nArrayArray = new int[][]{new int[2], new int[2], new int[2]};
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            for (Node node : arrayList) {
                node.volume.Center(vector3f2);
                vector3f2.sub(vector3f);
                int n4 = 0;
                while (n4 < 3) {
                    int[] nArray = nArrayArray[n4];
                    int n5 = vector3f2.dot(axis[n4]) > 0.0f ? 1 : 0;
                    nArray[n5] = nArray[n5] + 1;
                    ++n4;
                }
            }
            int n6 = 0;
            while (n6 < 3) {
                int n7;
                if (nArrayArray[n6][0] > 0 && nArrayArray[n6][1] > 0 && (n7 = Math.abs(nArrayArray[n6][0] - nArrayArray[n6][1])) < n3) {
                    n2 = n6;
                    n3 = n7;
                }
                ++n6;
            }
            if (n2 >= 0) {
                Dbvt.split(arrayList, arrayListArray[0], arrayListArray[1], vector3f, axis[n2]);
            } else {
                n6 = 0;
                int n8 = arrayList.size();
                while (n6 < n8) {
                    arrayListArray[n6 & 1].add(arrayList.get(n6));
                    ++n6;
                }
            }
            Node node = Dbvt.createnode(dbvt, null, dbvtAabbMm, null);
            node.childs[0] = Dbvt.topdown(dbvt, arrayListArray[0], n);
            node.childs[1] = Dbvt.topdown(dbvt, arrayListArray[1], n);
            node.childs[0].parent = node;
            node.childs[1].parent = node;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
            return node;
        }
        return arrayList.get(0);
    }

    private static Node sort(Node node, Node[] nodeArray) {
        Node node2 = node.parent;
        assert (node.isinternal());
        if (node2 != null && node2.hashCode() > node.hashCode()) {
            int n = Dbvt.indexof(node);
            int n2 = 1 - n;
            Node node3 = node2.childs[n2];
            Node node4 = node2.parent;
            assert (node == node2.childs[n]);
            if (node4 != null) {
                node4.childs[Dbvt.indexof((Node)node2)] = node;
            } else {
                nodeArray[0] = node;
            }
            node3.parent = node;
            node2.parent = node;
            node.parent = node4;
            node2.childs[0] = node.childs[0];
            node2.childs[1] = node.childs[1];
            node.childs[0].parent = node2;
            node.childs[1].parent = node2;
            node.childs[n] = node2;
            node.childs[n2] = node3;
            DbvtAabbMm.swap(node2.volume, node.volume);
            return node2;
        }
        return node;
    }

    private static Node walkup(Node node, int n) {
        while (node != null && n-- != 0) {
            node = node.parent;
        }
        return node;
    }

    public static class IClone {
        public void CloneLeaf(Node node) {
        }
    }

    public static class ICollide {
        public void Process(Node node, Node node2) {
        }

        public void Process(Node node) {
        }

        public void Process(Node node, float f) {
            this.Process(node);
        }

        public boolean Descent(Node node) {
            return true;
        }

        public boolean AllLeaves(Node node) {
            return true;
        }
    }

    public static abstract class IWriter {
        public abstract void Prepare(Node var1, int var2);

        public abstract void WriteNode(Node var1, int var2, int var3, int var4, int var5);

        public abstract void WriteLeaf(Node var1, int var2, int var3);
    }

    public static class Node {
        public final DbvtAabbMm volume = new DbvtAabbMm();
        public Node parent;
        public final Node[] childs = new Node[2];
        public Object data;

        public boolean isleaf() {
            return this.childs[1] == null;
        }

        public boolean isinternal() {
            return !this.isleaf();
        }
    }

    public static class sStkCLN {
        public Node node;
        public Node parent;

        public sStkCLN(Node node, Node node2) {
            this.node = node;
            this.parent = node2;
        }
    }

    public static class sStkNN {
        public Node a;
        public Node b;

        public sStkNN(Node node, Node node2) {
            this.a = node;
            this.b = node2;
        }
    }

    public static class sStkNP {
        public Node node;
        public int mask;

        public sStkNP(Node node, int n) {
            this.node = node;
            this.mask = n;
        }
    }

    public static class sStkNPS {
        public Node node;
        public int mask;
        public float value;

        public sStkNPS() {
        }

        public sStkNPS(Node node, int n, float f) {
            this.node = node;
            this.mask = n;
            this.value = f;
        }

        public void set(sStkNPS sStkNPS2) {
            this.node = sStkNPS2.node;
            this.mask = sStkNPS2.mask;
            this.value = sStkNPS2.value;
        }
    }
}

