/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.IWorldPool;

public class DistanceJoint
extends Joint {
    private float m_frequencyHz;
    private float m_dampingRatio;
    private float m_bias;
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private float m_gamma;
    private float m_impulse;
    private float m_length;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_u = new Vec2();
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private float m_mass;

    protected DistanceJoint(IWorldPool iWorldPool, DistanceJointDef distanceJointDef) {
        super(iWorldPool, distanceJointDef);
        this.m_localAnchorA = distanceJointDef.localAnchorA.clone();
        this.m_localAnchorB = distanceJointDef.localAnchorB.clone();
        this.m_length = distanceJointDef.length;
        this.m_impulse = 0.0f;
        this.m_frequencyHz = distanceJointDef.frequencyHz;
        this.m_dampingRatio = distanceJointDef.dampingRatio;
        this.m_gamma = 0.0f;
        this.m_bias = 0.0f;
    }

    public void setFrequency(float f) {
        this.m_frequencyHz = f;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public float getLength() {
        return this.m_length;
    }

    public void setLength(float f) {
        this.m_length = f;
    }

    public void setDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.x = this.m_impulse * this.m_u.x * f;
        vec2.y = this.m_impulse * this.m_u.y * f;
    }

    @Override
    public float getReactionTorque(float f) {
        return 0.0f;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, this.m_u.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, this.m_u.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        this.m_u.set(vec23).addLocal(this.m_rB).subLocal(vec2).subLocal(this.m_rA);
        this.pool.pushRot(2);
        float f5 = this.m_u.length();
        if (f5 > Settings.linearSlop) {
            this.m_u.x *= 1.0f / f5;
            this.m_u.y *= 1.0f / f5;
        } else {
            this.m_u.set(0.0f, 0.0f);
        }
        float f6 = Vec2.cross(this.m_rA, this.m_u);
        float f7 = Vec2.cross(this.m_rB, this.m_u);
        float f8 = this.m_invMassA + this.m_invIA * f6 * f6 + this.m_invMassB + this.m_invIB * f7 * f7;
        float f9 = this.m_mass = f8 != 0.0f ? 1.0f / f8 : 0.0f;
        if (this.m_frequencyHz > 0.0f) {
            float f10 = f5 - this.m_length;
            float f11 = (float)Math.PI * 2 * this.m_frequencyHz;
            float f12 = 2.0f * this.m_mass * this.m_dampingRatio * f11;
            float f13 = this.m_mass * f11 * f11;
            float f14 = solverData.step.dt;
            this.m_gamma = f14 * (f12 + f14 * f13);
            this.m_gamma = this.m_gamma != 0.0f ? 1.0f / this.m_gamma : 0.0f;
            this.m_bias = f10 * f14 * f13 * this.m_gamma;
            this.m_mass = (f8 += this.m_gamma) != 0.0f ? 1.0f / f8 : 0.0f;
        } else {
            this.m_gamma = 0.0f;
            this.m_bias = 0.0f;
        }
        if (solverData.step.warmStarting) {
            this.m_impulse *= solverData.step.dtRatio;
            Vec2 vec25 = this.pool.popVec2();
            vec25.set(this.m_u).mulLocal(this.m_impulse);
            vec22.x -= this.m_invMassA * vec25.x;
            vec22.y -= this.m_invMassA * vec25.y;
            f2 -= this.m_invIA * Vec2.cross(this.m_rA, vec25);
            vec24.x += this.m_invMassB * vec25.x;
            vec24.y += this.m_invMassB * vec25.y;
            f4 += this.m_invIB * Vec2.cross(this.m_rB, vec25);
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0f;
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2.crossToOutUnsafe(f, this.m_rA, vec23);
        vec23.addLocal(vec2);
        Vec2.crossToOutUnsafe(f2, this.m_rB, vec24);
        vec24.addLocal(vec22);
        float f3 = Vec2.dot(this.m_u, vec24.subLocal(vec23));
        float f4 = -this.m_mass * (f3 + this.m_bias + this.m_gamma * this.m_impulse);
        this.m_impulse += f4;
        float f5 = f4 * this.m_u.x;
        float f6 = f4 * this.m_u.y;
        vec2.x -= this.m_invMassA * f5;
        vec2.y -= this.m_invMassA * f6;
        vec22.x += this.m_invMassB * f5;
        vec22.y += this.m_invMassB * f6;
        solverData.velocities[this.m_indexA].w = f -= this.m_invIA * (this.m_rA.x * f6 - this.m_rA.y * f5);
        solverData.velocities[this.m_indexB].w = f2 += this.m_invIB * (this.m_rB.x * f6 - this.m_rB.y * f5);
        this.pool.pushVec2(2);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        if (this.m_frequencyHz > 0.0f) {
            return true;
        }
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec25 = solverData.positions[this.m_indexB].c;
        float f2 = solverData.positions[this.m_indexB].a;
        rot.set(f);
        rot2.set(f2);
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec2);
        Rot.mulToOutUnsafe(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec22);
        vec23.set(vec25).addLocal(vec22).subLocal(vec24).subLocal(vec2);
        float f3 = vec23.normalize();
        float f4 = f3 - this.m_length;
        f4 = MathUtils.clamp(f4, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
        float f5 = -this.m_mass * f4;
        float f6 = f5 * vec23.x;
        float f7 = f5 * vec23.y;
        vec24.x -= this.m_invMassA * f6;
        vec24.y -= this.m_invMassA * f7;
        vec25.x += this.m_invMassB * f6;
        vec25.y += this.m_invMassB * f7;
        solverData.positions[this.m_indexA].a = f -= this.m_invIA * (vec2.x * f7 - vec2.y * f6);
        solverData.positions[this.m_indexB].a = f2 += this.m_invIB * (vec22.x * f7 - vec22.y * f6);
        this.pool.pushVec2(3);
        this.pool.pushRot(2);
        return MathUtils.abs(f4) < Settings.linearSlop;
    }
}

