/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ConvexTriangleCallback;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.ConvexCast;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.narrowphase.SubsimplexConvexCast;
import com.bulletphysics.collision.narrowphase.VoronoiSimplexSolver;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.collision.shapes.TriangleShape;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class ConvexConcaveCollisionAlgorithm
extends CollisionAlgorithm {
    private boolean isSwapped;
    private ConvexTriangleCallback btConvexTriangleCallback;

    public void init(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2, boolean bl) {
        super.init(collisionAlgorithmConstructionInfo);
        this.isSwapped = bl;
        this.btConvexTriangleCallback = new ConvexTriangleCallback(this.dispatcher, collisionObject, collisionObject2, bl);
    }

    @Override
    public void destroy() {
        this.btConvexTriangleCallback.destroy();
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        CollisionObject collisionObject3;
        CollisionObject collisionObject4 = this.isSwapped ? collisionObject2 : collisionObject;
        CollisionObject collisionObject5 = collisionObject3 = this.isSwapped ? collisionObject : collisionObject2;
        if (collisionObject3.getCollisionShape().isConcave()) {
            CollisionObject collisionObject6 = collisionObject3;
            ConcaveShape concaveShape = (ConcaveShape)collisionObject6.getCollisionShape();
            if (collisionObject4.getCollisionShape().isConvex()) {
                float f = concaveShape.getMargin();
                manifoldResult.setPersistentManifold(this.btConvexTriangleCallback.manifoldPtr);
                this.btConvexTriangleCallback.setTimeStepAndCounters(f, manifoldResult);
                this.btConvexTriangleCallback.manifoldPtr.setBodies(collisionObject4, collisionObject3);
                Vector3f vector3f = this.btConvexTriangleCallback.getAabbMin((Vector3f)Pools.VECTORS.get());
                Vector3f vector3f2 = this.btConvexTriangleCallback.getAabbMax((Vector3f)Pools.VECTORS.get());
                concaveShape.processAllTriangles(this.btConvexTriangleCallback, vector3f, vector3f2);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
                manifoldResult.refreshContactPoints();
            }
        }
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        CollisionObject collisionObject3 = this.isSwapped ? collisionObject2 : collisionObject;
        CollisionObject collisionObject4 = this.isSwapped ? collisionObject : collisionObject2;
        Transform transform = collisionObject3.getInterpolationWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = collisionObject3.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        vector3f.sub(transform.origin, transform2.origin);
        float f = vector3f.lengthSquared();
        if (f < collisionObject3.getCcdSquareMotionThreshold()) {
            return 1.0f;
        }
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = collisionObject4.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        transform4.inverse();
        Transform transform5 = (Transform)Pools.TRANSFORMS.get();
        transform5.mul(transform4, collisionObject3.getWorldTransform(transform3));
        Transform transform6 = (Transform)Pools.TRANSFORMS.get();
        transform6.mul(transform4, collisionObject3.getInterpolationWorldTransform(transform3));
        if (collisionObject4.getCollisionShape().isConcave()) {
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)transform5.origin);
            VectorUtil.setMin(vector3f2, transform6.origin);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get((Object)transform5.origin);
            VectorUtil.setMax(vector3f3, transform6.origin);
            float f2 = collisionObject3.getCcdSweptSphereRadius();
            vector3f.set(f2, f2, f2);
            vector3f2.sub(vector3f);
            vector3f3.add(vector3f);
            float f3 = 1.0f;
            LocalTriangleSphereCastCallback localTriangleSphereCastCallback = new LocalTriangleSphereCastCallback(transform5, transform6, collisionObject3.getCcdSweptSphereRadius(), f3);
            localTriangleSphereCastCallback.hitFraction = collisionObject3.getHitFraction();
            CollisionObject collisionObject5 = collisionObject4;
            ConcaveShape concaveShape = (ConcaveShape)collisionObject5.getCollisionShape();
            if (concaveShape != null) {
                concaveShape.processAllTriangles(localTriangleSphereCastCallback, vector3f2, vector3f3);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3});
            if (localTriangleSphereCastCallback.hitFraction < collisionObject3.getHitFraction()) {
                collisionObject3.setHitFraction(localTriangleSphereCastCallback.hitFraction);
                return localTriangleSphereCastCallback.hitFraction;
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform6, transform5, transform, transform2, transform3, transform4});
        return 1.0f;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        if (this.btConvexTriangleCallback.manifoldPtr != null) {
            arrayList.add(this.btConvexTriangleCallback.manifoldPtr);
        }
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            ConvexConcaveCollisionAlgorithm convexConcaveCollisionAlgorithm = (ConvexConcaveCollisionAlgorithm)Pools.CONVEX_CONCAVE_COLLISIONS.get();
            convexConcaveCollisionAlgorithm.init(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, false);
            return convexConcaveCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.CONVEX_CONCAVE_COLLISIONS.release((Object[])new ConvexConcaveCollisionAlgorithm[]{(ConvexConcaveCollisionAlgorithm)collisionAlgorithm});
        }
    }

    private static class LocalTriangleSphereCastCallback
    implements TriangleCallback {
        public final Transform ccdSphereFromTrans = new Transform();
        public final Transform ccdSphereToTrans = new Transform();
        public float ccdSphereRadius;
        public float hitFraction;
        private final Transform ident = new Transform();

        public LocalTriangleSphereCastCallback(Transform transform, Transform transform2, float f, float f2) {
            this.ccdSphereFromTrans.set(transform);
            this.ccdSphereToTrans.set(transform2);
            this.ccdSphereRadius = f;
            this.hitFraction = f2;
            this.ident.setIdentity();
        }

        @Override
        public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
            ConvexCast.CastResult castResult = new ConvexCast.CastResult();
            castResult.fraction = this.hitFraction;
            SphereShape sphereShape = new SphereShape(this.ccdSphereRadius);
            TriangleShape triangleShape = new TriangleShape(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
            VoronoiSimplexSolver voronoiSimplexSolver = new VoronoiSimplexSolver();
            SubsimplexConvexCast subsimplexConvexCast = new SubsimplexConvexCast(sphereShape, triangleShape, voronoiSimplexSolver);
            if (subsimplexConvexCast.calcTimeOfImpact(this.ccdSphereFromTrans, this.ccdSphereToTrans, this.ident, this.ident, castResult) && this.hitFraction > castResult.fraction) {
                this.hitFraction = castResult.fraction;
            }
        }
    }

    public static class SwappedCreateFunc
    implements CollisionAlgorithmCreateFunc {
        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            ConvexConcaveCollisionAlgorithm convexConcaveCollisionAlgorithm = (ConvexConcaveCollisionAlgorithm)Pools.CONVEX_CONCAVE_COLLISIONS.get();
            convexConcaveCollisionAlgorithm.init(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, true);
            return convexConcaveCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.CONVEX_CONCAVE_COLLISIONS.release((Object[])new ConvexConcaveCollisionAlgorithm[]{(ConvexConcaveCollisionAlgorithm)collisionAlgorithm});
        }
    }
}

