/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import com.bulletphysics.util.ObjectStackList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class GjkEpaSolver {
    protected final ObjectStackList<Mkv> stackMkv = new ObjectStackList<Mkv>(Mkv.class);
    protected final ObjectStackList<He> stackHe = new ObjectStackList<He>(He.class);
    protected final ObjectStackList<Face> stackFace = new ObjectStackList<Face>(Face.class);
    private static final float cstInf = Float.MAX_VALUE;
    private static final float cst2Pi = (float)Math.PI * 2;
    private static final int GJK_maxiterations = 128;
    private static final int GJK_hashsize = 64;
    private static final int GJK_hashmask = 63;
    private static final float GJK_insimplex_eps = 1.0E-4f;
    private static final float GJK_sqinsimplex_eps = 9.999999E-9f;
    private static final int EPA_maxiterations = 256;
    private static final float EPA_inface_eps = 0.01f;
    private static final float EPA_accuracy = 0.001f;
    private static int[] mod3;
    private static final int[][] tetrahedron_fidx;
    private static final int[][] tetrahedron_eidx;
    private static final int[][] hexahedron_fidx;
    private static final int[][] hexahedron_eidx;
    private final GJK gjk = new GJK();

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[4] = 1;
        mod3 = nArray;
        int[][] nArrayArray = new int[4][];
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[1] = 1;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 3;
        nArray3[2] = 1;
        nArrayArray[1] = nArray3;
        nArrayArray[2] = new int[]{3, 1, 2};
        int[] nArray4 = new int[3];
        nArray4[0] = 3;
        nArray4[1] = 2;
        nArrayArray[3] = nArray4;
        tetrahedron_fidx = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray5 = new int[4];
        nArray5[2] = 2;
        nArray5[3] = 1;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[1] = 2;
        nArray7[2] = 3;
        nArray7[3] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 1;
        nArray8[2] = 3;
        nArray8[3] = 2;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 2;
        nArray9[2] = 1;
        nArray9[3] = 2;
        nArrayArray2[4] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 3;
        nArray10[2] = 2;
        nArray10[3] = 2;
        nArrayArray2[5] = nArray10;
        tetrahedron_eidx = nArrayArray2;
        int[][] nArrayArray3 = new int[6][];
        int[] nArray11 = new int[3];
        nArray11[0] = 2;
        nArray11[2] = 4;
        nArrayArray3[0] = nArray11;
        nArrayArray3[1] = new int[]{4, 1, 2};
        int[] nArray12 = new int[3];
        nArray12[0] = 1;
        nArray12[1] = 4;
        nArrayArray3[2] = nArray12;
        int[] nArray13 = new int[3];
        nArray13[1] = 3;
        nArray13[2] = 1;
        nArrayArray3[3] = nArray13;
        int[] nArray14 = new int[3];
        nArray14[1] = 2;
        nArray14[2] = 3;
        nArrayArray3[4] = nArray14;
        nArrayArray3[5] = new int[]{1, 3, 2};
        hexahedron_fidx = nArrayArray3;
        int[][] nArrayArray4 = new int[9][];
        int[] nArray15 = new int[4];
        nArray15[2] = 4;
        nArrayArray4[0] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[1] = 1;
        nArray16[2] = 2;
        nArray16[3] = 1;
        nArrayArray4[1] = nArray16;
        int[] nArray17 = new int[4];
        nArray17[1] = 2;
        nArray17[2] = 1;
        nArray17[3] = 2;
        nArrayArray4[2] = nArray17;
        nArrayArray4[3] = new int[]{1, 1, 5, 2};
        int[] nArray18 = new int[4];
        nArray18[0] = 1;
        nArray18[2] = 2;
        nArrayArray4[4] = nArray18;
        nArrayArray4[5] = new int[]{2, 2, 3, 2};
        int[] nArray19 = new int[4];
        nArray19[0] = 3;
        nArray19[1] = 1;
        nArray19[2] = 5;
        nArrayArray4[6] = nArray19;
        int[] nArray20 = new int[4];
        nArray20[0] = 3;
        nArray20[2] = 4;
        nArray20[3] = 2;
        nArrayArray4[7] = nArray20;
        nArrayArray4[8] = new int[]{5, 1, 4, 1};
        hexahedron_eidx = nArrayArray4;
    }

    protected void pushStack() {
        this.stackMkv.push();
        this.stackHe.push();
        this.stackFace.push();
    }

    protected void popStack() {
        this.stackMkv.pop();
        this.stackHe.pop();
        this.stackFace.pop();
    }

    public boolean collide(ConvexShape convexShape, Transform transform, ConvexShape convexShape2, Transform transform2, float f, Results results) {
        results.witnesses[0].set(0.0f, 0.0f, 0.0f);
        results.witnesses[1].set(0.0f, 0.0f, 0.0f);
        results.normal.set(0.0f, 0.0f, 0.0f);
        results.depth = 0.0f;
        results.status = ResultsStatus.Separated;
        results.epa_iterations = 0;
        results.gjk_iterations = 0;
        this.gjk.init(transform.basis, transform.origin, convexShape, transform2.basis, transform2.origin, convexShape2, f + 0.001f);
        try {
            boolean bl = this.gjk.SearchOrigin();
            results.gjk_iterations = this.gjk.iterations + 1;
            if (bl) {
                EPA ePA = new EPA(this.gjk);
                float f2 = ePA.EvaluatePD();
                results.epa_iterations = ePA.iterations + 1;
                if (f2 > 0.0f) {
                    results.status = ResultsStatus.Penetrating;
                    results.normal.set(ePA.normal);
                    results.depth = f2;
                    results.witnesses[0].set(ePA.nearest[0]);
                    results.witnesses[1].set(ePA.nearest[1]);
                    return true;
                }
                if (ePA.failed) {
                    results.status = ResultsStatus.EPA_Failed;
                }
            } else if (this.gjk.failed) {
                results.status = ResultsStatus.GJK_Failed;
            }
            return false;
        }
        finally {
            this.gjk.destroy();
        }
    }

    protected class EPA {
        public GJK gjk;
        public Face root;
        public int nfaces;
        public int iterations;
        public final Vector3f[][] features = new Vector3f[2][3];
        public final Vector3f[] nearest = new Vector3f[]{new Vector3f(), new Vector3f()};
        public final Vector3f normal = new Vector3f();
        public float depth;
        public boolean failed;

        public EPA(GJK gJK) {
            int n = 0;
            while (n < this.features.length) {
                int n2 = 0;
                while (n2 < this.features[n].length) {
                    this.features[n][n2] = new Vector3f();
                    ++n2;
                }
                ++n;
            }
            this.gjk = gJK;
        }

        public Vector3f GetCoordinates(Face face, Vector3f vector3f) {
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
            vector3f5.scale(-face.d, face.n);
            float[] fArray = new float[3];
            vector3f3.sub(face.v[0].w, vector3f5);
            vector3f4.sub(face.v[1].w, vector3f5);
            vector3f2.cross(vector3f3, vector3f4);
            fArray[0] = vector3f2.length();
            vector3f3.sub(face.v[1].w, vector3f5);
            vector3f4.sub(face.v[2].w, vector3f5);
            vector3f2.cross(vector3f3, vector3f4);
            fArray[1] = vector3f2.length();
            vector3f3.sub(face.v[2].w, vector3f5);
            vector3f4.sub(face.v[0].w, vector3f5);
            vector3f2.cross(vector3f3, vector3f4);
            fArray[2] = vector3f2.length();
            float f = fArray[0] + fArray[1] + fArray[2];
            vector3f.set(fArray[1], fArray[2], fArray[0]);
            vector3f.scale(1.0f / (f > 0.0f ? f : 1.0f));
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4, vector3f5});
            return vector3f;
        }

        public Face FindBest() {
            Face face = null;
            if (this.root != null) {
                Face face2 = this.root;
                float f = Float.MAX_VALUE;
                do {
                    if (!(face2.d < f)) continue;
                    f = face2.d;
                    face = face2;
                } while ((face2 = face2.next) != null);
            }
            return face;
        }

        public boolean Set(Face face, Mkv mkv, Mkv mkv2, Mkv mkv3) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f.sub(mkv2.w, mkv.w);
            vector3f2.sub(mkv3.w, mkv.w);
            vector3f4.cross(vector3f, vector3f2);
            float f = vector3f4.length();
            vector3f.cross(mkv.w, mkv2.w);
            vector3f2.cross(mkv2.w, mkv3.w);
            vector3f3.cross(mkv3.w, mkv.w);
            boolean bl = vector3f.dot(vector3f4) >= -0.01f && vector3f2.dot(vector3f4) >= -0.01f && vector3f3.dot(vector3f4) >= -0.01f;
            face.v[0] = mkv;
            face.v[1] = mkv2;
            face.v[2] = mkv3;
            face.mark = 0;
            face.n.scale(1.0f / (f > 0.0f ? f : Float.MAX_VALUE), vector3f4);
            face.d = Math.max(0.0f, -face.n.dot(mkv.w));
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f, vector3f2, vector3f4});
            return bl;
        }

        public Face NewFace(Mkv mkv, Mkv mkv2, Mkv mkv3) {
            Face face = (Face)GjkEpaSolver.this.stackFace.get();
            if (this.Set(face, mkv, mkv2, mkv3)) {
                if (this.root != null) {
                    this.root.prev = face;
                }
                face.prev = null;
                face.next = this.root;
                this.root = face;
                ++this.nfaces;
            } else {
                face.next = null;
                face.prev = null;
            }
            return face;
        }

        public void Detach(Face face) {
            if (face.prev != null || face.next != null) {
                --this.nfaces;
                if (face == this.root) {
                    this.root = face.next;
                    this.root.prev = null;
                } else if (face.next == null) {
                    face.prev.next = null;
                } else {
                    face.prev.next = face.next;
                    face.next.prev = face.prev;
                }
                face.next = null;
                face.prev = null;
            }
        }

        public void Link(Face face, int n, Face face2, int n2) {
            face.f[n] = face2;
            face2.e[n2] = n;
            face2.f[n2] = face;
            face.e[n] = n2;
        }

        public Mkv Support(Vector3f vector3f) {
            Mkv mkv = (Mkv)GjkEpaSolver.this.stackMkv.get();
            this.gjk.Support(vector3f, mkv);
            return mkv;
        }

        public int BuildHorizon(int n, Mkv mkv, Face face, int n2, Face[] faceArray, Face[] faceArray2) {
            int n3 = 0;
            if (face.mark != n) {
                int n4 = mod3[n2 + 1];
                if (face.n.dot(mkv.w) + face.d > 0.0f) {
                    Face face2 = this.NewFace(face.v[n4], face.v[n2], mkv);
                    this.Link(face2, 0, face, n2);
                    if (faceArray[0] != null) {
                        this.Link(faceArray[0], 1, face2, 2);
                    } else {
                        faceArray2[0] = face2;
                    }
                    faceArray[0] = face2;
                    n3 = 1;
                } else {
                    int n5 = mod3[n2 + 2];
                    this.Detach(face);
                    face.mark = n;
                    n3 += this.BuildHorizon(n, mkv, face.f[n4], face.e[n4], faceArray, faceArray2);
                    n3 += this.BuildHorizon(n, mkv, face.f[n5], face.e[n5], faceArray, faceArray2);
                }
            }
            return n3;
        }

        public float EvaluatePD() {
            return this.EvaluatePD(0.001f);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public float EvaluatePD(float var1_1) {
            GjkEpaSolver.this.pushStack();
            var2_2 = (Vector3f)Pools.VECTORS.get();
            try {
                var3_3 = null;
                var4_4 = 1;
                this.depth = -3.4028235E38f;
                this.normal.set(0.0f, 0.0f, 0.0f);
                this.root = null;
                this.nfaces = 0;
                this.iterations = 0;
                this.failed = false;
                if (this.gjk.EncloseOrigin()) {
                    var5_5 = null;
                    var6_6 = 0;
                    var7_10 = 0;
                    var8_14 /* !! */  = null;
                    var9_17 = 0;
                    var10_19 = 0;
                    var11_20 = new Mkv[5];
                    var12_22 = new Face[6];
                    switch (this.gjk.order) {
                        case 3: {
                            var5_5 = GjkEpaSolver.tetrahedron_fidx;
                            var6_6 = 0;
                            var7_10 = 4;
                            var8_14 /* !! */  = GjkEpaSolver.tetrahedron_eidx;
                            var9_17 = 0;
                            var10_19 = 6;
                            break;
                        }
                        case 4: {
                            var5_5 = GjkEpaSolver.hexahedron_fidx;
                            var6_6 = 0;
                            var7_10 = 6;
                            var8_14 /* !! */  = GjkEpaSolver.hexahedron_eidx;
                            var9_17 = 0;
                            var10_19 = 9;
                        }
                    }
                    var13_23 = 0;
                    while (var13_23 <= this.gjk.order) {
                        var11_20[var13_23] = new Mkv();
                        var11_20[var13_23].set(this.gjk.simplex[var13_23]);
                        ++var13_23;
                    }
                    var13_23 = 0;
                    while (var13_23 < var7_10) {
                        var12_22[var13_23] = this.NewFace(var11_20[var5_5[var6_6][0]], var11_20[var5_5[var6_6][1]], var11_20[var5_5[var6_6][2]]);
                        ++var13_23;
                        ++var6_6;
                    }
                    var13_23 = 0;
                    while (var13_23 < var10_19) {
                        this.Link(var12_22[var8_14 /* !! */ [var9_17][0]], var8_14 /* !! */ [var9_17][1], var12_22[var8_14 /* !! */ [var9_17][2]], var8_14 /* !! */ [var9_17][3]);
                        ++var13_23;
                        ++var9_17;
                    }
                }
                if (this.nfaces != 0) ** GOTO lbl79
                var15_24 = this.depth;
                GjkEpaSolver.this.popStack();
            }
            catch (Throwable var14_26) {
                GjkEpaSolver.this.popStack();
                Pools.VECTORS.release((Object[])new Vector3f[]{var2_2});
                throw var14_26;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{var2_2});
            return var15_24;
            {
                while ((var5_5 = this.FindBest()) != null) {
                    var2_2.negate(var5_5.n);
                    var6_7 = this.Support(var2_2);
                    var7_11 = var5_5.n.dot(var6_7.w) + var5_5.d;
                    var3_3 = var5_5;
                    if (!(var7_11 < -var1_1)) break;
                    var8_14 /* !! */  = (int[][])new Face[1];
                    var9_18 = new Face[1];
                    var10_19 = 0;
                    this.Detach((Face)var5_5);
                    var5_5.mark = ++var4_4;
                    var11_21 = 0;
                    while (var11_21 < 3) {
                        var10_19 += this.BuildHorizon(var4_4, var6_7, var5_5.f[var11_21], var5_5.e[var11_21], (Face[])var8_14 /* !! */ , var9_18);
                        ++var11_21;
                    }
                    if (var10_19 <= 2) break;
                    this.Link((Face)var8_14 /* !! */ [0], 1, var9_18[0], 2);
                    ++this.iterations;
lbl79:
                    // 2 sources

                    if (this.iterations < 256) continue;
                }
                if (var3_3 != null) {
                    var5_5 = this.GetCoordinates((Face)var3_3, (Vector3f)Pools.VECTORS.get());
                    this.normal.set(var3_3.n);
                    this.depth = Math.max(0.0f, var3_3.d);
                    var6_8 = 0;
                    while (var6_8 < 2) {
                        var7_12 = var6_8 != 0 ? -1.0f : 1.0f;
                        var8_15 = 0;
                        while (var8_15 < 3) {
                            var2_2.scale(var7_12, var3_3.v[var8_15].r);
                            this.gjk.LocalSupport(var2_2, var6_8, this.features[var6_8][var8_15]);
                            ++var8_15;
                        }
                        ++var6_8;
                    }
                    var6_9 = (Vector3f)Pools.VECTORS.get();
                    var7_13 = (Vector3f)Pools.VECTORS.get();
                    var8_16 = (Vector3f)Pools.VECTORS.get();
                    var6_9.scale(var5_5.x, this.features[0][0]);
                    var7_13.scale(var5_5.y, this.features[0][1]);
                    var8_16.scale(var5_5.z, this.features[0][2]);
                    VectorUtil.add(this.nearest[0], var6_9, var7_13, var8_16);
                    var6_9.scale(var5_5.x, this.features[1][0]);
                    var7_13.scale(var5_5.y, this.features[1][1]);
                    var8_16.scale(var5_5.z, this.features[1][2]);
                    VectorUtil.add(this.nearest[1], var6_9, var7_13, var8_16);
                    Pools.VECTORS.release((Object[])new Vector3f[]{var6_9, var7_13, var8_16, var5_5});
                } else {
                    this.failed = true;
                }
                var15_25 = this.depth;
            }
            GjkEpaSolver.this.popStack();
            Pools.VECTORS.release((Object[])new Vector3f[]{var2_2});
            return var15_25;
        }
    }

    public static class Face {
        public final Mkv[] v = new Mkv[3];
        public final Face[] f = new Face[3];
        public final int[] e = new int[3];
        public final Vector3f n = new Vector3f();
        public float d;
        public int mark;
        public Face prev;
        public Face next;
    }

    protected class GJK {
        public final He[] table = new He[64];
        public final Matrix3f[] wrotations = new Matrix3f[]{new Matrix3f(), new Matrix3f()};
        public final Vector3f[] positions = new Vector3f[]{new Vector3f(), new Vector3f()};
        public final ConvexShape[] shapes = new ConvexShape[2];
        public final Mkv[] simplex = new Mkv[5];
        public final Vector3f ray = new Vector3f();
        public int order;
        public int iterations;
        public float margin;
        public boolean failed;

        public GJK() {
            int n = 0;
            while (n < this.simplex.length) {
                this.simplex[n] = new Mkv();
                ++n;
            }
        }

        public GJK(Matrix3f matrix3f, Vector3f vector3f, ConvexShape convexShape, Matrix3f matrix3f2, Vector3f vector3f2, ConvexShape convexShape2) {
            this(matrix3f, vector3f, convexShape, matrix3f2, vector3f2, convexShape2, 0.0f);
        }

        public GJK(Matrix3f matrix3f, Vector3f vector3f, ConvexShape convexShape, Matrix3f matrix3f2, Vector3f vector3f2, ConvexShape convexShape2, float f) {
            int n = 0;
            while (n < this.simplex.length) {
                this.simplex[n] = new Mkv();
                ++n;
            }
            this.init(matrix3f, vector3f, convexShape, matrix3f2, vector3f2, convexShape2, f);
        }

        public void init(Matrix3f matrix3f, Vector3f vector3f, ConvexShape convexShape, Matrix3f matrix3f2, Vector3f vector3f2, ConvexShape convexShape2, float f) {
            GjkEpaSolver.this.pushStack();
            this.wrotations[0].set(matrix3f);
            this.positions[0].set(vector3f);
            this.shapes[0] = convexShape;
            this.wrotations[1].set(matrix3f2);
            this.positions[1].set(vector3f2);
            this.shapes[1] = convexShape2;
            this.margin = f;
            this.failed = false;
        }

        public void destroy() {
            GjkEpaSolver.this.popStack();
        }

        public int Hash(Vector3f vector3f) {
            int n = (int)(vector3f.x * 15461.0f) ^ (int)(vector3f.y * 83003.0f) ^ (int)(vector3f.z * 15473.0f);
            return n * 169639 & 0x3F;
        }

        public Vector3f LocalSupport(Vector3f vector3f, int n, Vector3f vector3f2) {
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            MatrixUtil.transposeTransform(vector3f3, vector3f, this.wrotations[n]);
            this.shapes[n].localGetSupportingVertex(vector3f3, vector3f2);
            this.wrotations[n].transform(vector3f2);
            vector3f2.add(this.positions[n]);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
            return vector3f2;
        }

        public void Support(Vector3f vector3f, Mkv mkv) {
            mkv.r.set(vector3f);
            Vector3f vector3f2 = this.LocalSupport(vector3f, 0, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.set(vector3f);
            vector3f3.negate();
            Vector3f vector3f4 = this.LocalSupport(vector3f3, 1, (Vector3f)Pools.VECTORS.get());
            mkv.w.sub(vector3f2, vector3f4);
            mkv.w.scaleAdd(this.margin, vector3f, mkv.w);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f4, vector3f3});
        }

        public boolean FetchSupport() {
            int n = this.Hash(this.ray);
            He he = this.table[n];
            while (he != null) {
                if (he.v.equals(this.ray)) {
                    --this.order;
                    return false;
                }
                he = he.n;
            }
            he = (He)GjkEpaSolver.this.stackHe.get();
            he.v.set(this.ray);
            he.n = this.table[n];
            this.table[n] = he;
            this.Support(this.ray, this.simplex[++this.order]);
            return this.ray.dot(this.simplex[this.order].w) > 0.0f;
        }

        public boolean SolveSimplex2(Vector3f vector3f, Vector3f vector3f2) {
            if (vector3f2.dot(vector3f) >= 0.0f) {
                Vector3f vector3f3;
                block5: {
                    vector3f3 = (Vector3f)Pools.VECTORS.get();
                    try {
                        vector3f3.cross(vector3f2, vector3f);
                        if (!(vector3f3.lengthSquared() <= 9.999999E-9f)) break block5;
                    }
                    catch (Throwable throwable) {
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
                        throw throwable;
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
                    return true;
                }
                this.ray.cross(vector3f3, vector3f2);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
            } else {
                this.order = 0;
                this.simplex[0].set(this.simplex[1]);
                this.ray.set(vector3f);
            }
            return false;
        }

        public boolean SolveSimplex3(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.cross(vector3f2, vector3f3);
            boolean bl = this.SolveSimplex3a(vector3f, vector3f2, vector3f3, vector3f4);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
            return bl;
        }

        public boolean SolveSimplex3a(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
            Vector3f vector3f5;
            Vector3f vector3f6;
            block7: {
                block8: {
                    block6: {
                        block5: {
                            boolean bl;
                            vector3f6 = (Vector3f)Pools.VECTORS.get();
                            vector3f5 = (Vector3f)Pools.VECTORS.get();
                            try {
                                vector3f6.cross(vector3f4, vector3f2);
                                vector3f5.cross(vector3f4, vector3f3);
                                if (!(vector3f6.dot(vector3f) < -1.0E-4f)) break block5;
                                this.order = 1;
                                this.simplex[0].set(this.simplex[1]);
                                this.simplex[1].set(this.simplex[2]);
                                bl = this.SolveSimplex2(vector3f, vector3f2);
                            }
                            catch (Throwable throwable) {
                                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                                throw throwable;
                            }
                            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                            return bl;
                        }
                        if (!(vector3f5.dot(vector3f) > 1.0E-4f)) break block6;
                        this.order = 1;
                        this.simplex[1].set(this.simplex[2]);
                        boolean bl = this.SolveSimplex2(vector3f, vector3f3);
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                        return bl;
                    }
                    float f = vector3f4.dot(vector3f);
                    if (!(Math.abs(f) > 1.0E-4f)) break block7;
                    if (f > 0.0f) {
                        this.ray.set(vector3f4);
                        break block8;
                    }
                    this.ray.negate(vector3f4);
                    Mkv mkv = new Mkv();
                    mkv.set(this.simplex[0]);
                    this.simplex[0].set(this.simplex[1]);
                    this.simplex[1].set(mkv);
                }
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                return false;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
            return true;
        }

        public boolean SolveSimplex4(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
            Vector3f vector3f5;
            Vector3f vector3f6;
            Vector3f vector3f7;
            block6: {
                Vector3f vector3f8;
                block5: {
                    block4: {
                        boolean bl;
                        vector3f8 = (Vector3f)Pools.VECTORS.get();
                        vector3f7 = (Vector3f)Pools.VECTORS.get();
                        vector3f6 = (Vector3f)Pools.VECTORS.get();
                        vector3f5 = (Vector3f)Pools.VECTORS.get();
                        vector3f7.cross(vector3f2, vector3f3);
                        vector3f6.cross(vector3f3, vector3f4);
                        vector3f5.cross(vector3f4, vector3f2);
                        try {
                            if (!(vector3f7.dot(vector3f) > 1.0E-4f)) break block4;
                            vector3f8.set(vector3f7);
                            this.order = 2;
                            this.simplex[0].set(this.simplex[1]);
                            this.simplex[1].set(this.simplex[2]);
                            this.simplex[2].set(this.simplex[3]);
                            bl = this.SolveSimplex3a(vector3f, vector3f2, vector3f3, vector3f8);
                        }
                        catch (Throwable throwable) {
                            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
                            throw throwable;
                        }
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
                        return bl;
                    }
                    if (!(vector3f6.dot(vector3f) > 1.0E-4f)) break block5;
                    vector3f8.set(vector3f6);
                    this.order = 2;
                    this.simplex[2].set(this.simplex[3]);
                    boolean bl = this.SolveSimplex3a(vector3f, vector3f3, vector3f4, vector3f8);
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
                    return bl;
                }
                if (!(vector3f5.dot(vector3f) > 1.0E-4f)) break block6;
                vector3f8.set(vector3f5);
                this.order = 2;
                this.simplex[1].set(this.simplex[0]);
                this.simplex[0].set(this.simplex[2]);
                this.simplex[2].set(this.simplex[3]);
                boolean bl = this.SolveSimplex3a(vector3f, vector3f4, vector3f2, vector3f8);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
                return bl;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
            return true;
        }

        public boolean SearchOrigin() {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.set(1.0f, 0.0f, 0.0f);
            boolean bl = this.SearchOrigin(vector3f);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            return bl;
        }

        /*
         * Exception decompiling
         */
        public boolean SearchOrigin(Vector3f var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public boolean EncloseOrigin() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class He {
        public final Vector3f v = new Vector3f();
        public He n;
    }

    public static class Mkv {
        public final Vector3f w = new Vector3f();
        public final Vector3f r = new Vector3f();

        public void set(Mkv mkv) {
            this.w.set(mkv.w);
            this.r.set(mkv.r);
        }
    }

    public static class Results {
        public ResultsStatus status;
        public final Vector3f[] witnesses = new Vector3f[]{new Vector3f(), new Vector3f()};
        public final Vector3f normal = new Vector3f();
        public float depth;
        public int epa_iterations;
        public int gjk_iterations;
    }

    public static enum ResultsStatus {
        Separated,
        Penetrating,
        GJK_Failed,
        EPA_Failed;

    }
}

