/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public abstract class PolyhedralConvexShape
extends ConvexInternalShape {
    private static Vector3f[] _directions = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
    private static Vector3f[] _supporting = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
    protected final Vector3f localAabbMin = new Vector3f(1.0f, 1.0f, 1.0f);
    protected final Vector3f localAabbMax = new Vector3f(-1.0f, -1.0f, -1.0f);
    protected boolean isLocalAabbValid = false;

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3f2;
        vector3f3.set(0.0f, 0.0f, 0.0f);
        float f = -1.0E30f;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        float f2 = vector3f4.lengthSquared();
        if (f2 < 1.0E-4f) {
            vector3f4.set(1.0f, 0.0f, 0.0f);
        } else {
            float f3 = 1.0f / (float)Math.sqrt(f2);
            vector3f4.scale(f3);
        }
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        int n = 0;
        while (n < this.getNumVertices()) {
            this.getVertex(n, vector3f5);
            float f4 = vector3f4.dot(vector3f5);
            if (f4 > f) {
                f = f4;
                vector3f3 = vector3f5;
            }
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5});
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = -1.0E30f;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Vector3f vector3f2 = vector3fArray[n3];
            n2 = 0;
            while (n2 < this.getNumVertices()) {
                this.getVertex(n2, vector3f);
                float f = vector3f2.dot(vector3f);
                if (f > fArray[n3]) {
                    vector3fArray2[n3].set(vector3f);
                    fArray[n3] = f;
                }
                ++n2;
            }
            ++n3;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        float f2 = this.getMargin();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        this.getAabb(transform, vector3f2, vector3f3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f3, vector3f2);
        vector3f4.scale(0.5f);
        float f3 = 2.0f * (vector3f4.x + f2);
        float f4 = 2.0f * (vector3f4.y + f2);
        float f5 = 2.0f * (vector3f4.z + f2);
        float f6 = f3 * f3;
        float f7 = f4 * f4;
        float f8 = f5 * f5;
        float f9 = f * 0.08333333f;
        vector3f.set(f7 + f8, f6 + f8, f6 + f7);
        vector3f.scale(f9);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4});
    }

    private void getNonvirtualAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2, float f) {
        assert (this.isLocalAabbValid);
        AabbUtil2.transformAabb(this.localAabbMin, this.localAabbMax, f, transform, vector3f, vector3f2);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.getNonvirtualAabb(transform, vector3f, vector3f2, this.getMargin());
    }

    protected final void _PolyhedralConvexShape_getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.getNonvirtualAabb(transform, vector3f, vector3f2, this.getMargin());
    }

    public void recalcLocalAabb() {
        this.isLocalAabbValid = true;
        this.batchedUnitVectorGetSupportingVertexWithoutMargin(_directions, _supporting, 6);
        int n = 0;
        while (n < 3) {
            VectorUtil.setCoord(this.localAabbMax, n, VectorUtil.getCoord(_supporting[n], n) + this.collisionMargin);
            VectorUtil.setCoord(this.localAabbMin, n, VectorUtil.getCoord(_supporting[n + 3], n) - this.collisionMargin);
            ++n;
        }
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        super.setLocalScaling(vector3f);
        this.recalcLocalAabb();
    }

    public abstract int getNumVertices();

    public abstract int getNumEdges();

    public abstract void getEdge(int var1, Vector3f var2, Vector3f var3);

    public abstract void getVertex(int var1, Vector3f var2);

    public abstract int getNumPlanes();

    public abstract void getPlane(Vector3f var1, Vector3f var2, int var3);

    public abstract boolean isInside(Vector3f var1, float var2);
}

