/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintPersistentData;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.ContactConstraint;
import com.bulletphysics.dynamics.constraintsolver.ContactConstraintEnum;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverFunc;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverInfo;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.SolverBody;
import com.bulletphysics.dynamics.constraintsolver.SolverConstraint;
import com.bulletphysics.dynamics.constraintsolver.SolverConstraintType;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import com.bulletphysics.util.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SequentialImpulseConstraintSolver
implements ConstraintSolver {
    Vector3f tempVec = new Vector3f();
    Transform tempTrans = new Transform();
    Matrix3f tempMat = new Matrix3f();
    private static final int MAX_CONTACT_SOLVER_TYPES = ContactConstraintEnum.MAX_CONTACT_SOLVER_TYPES.ordinal();
    private static final int SEQUENTIAL_IMPULSE_MAX_SOLVER_POINTS = 16384;
    private final OrderIndex[] gOrder = new OrderIndex[16384];
    private int totalCpd = 0;
    private final ArrayList<SolverBody> tmpSolverBodyPool;
    private final ArrayList<SolverConstraint> tmpSolverConstraintPool;
    private final ArrayList<SolverConstraint> tmpSolverFrictionConstraintPool;
    private final IntArrayList orderTmpConstraintPool;
    private final IntArrayList orderFrictionConstraintPool;
    protected final ContactSolverFunc[][] contactDispatch;
    protected final ContactSolverFunc[][] frictionDispatch;
    protected long btSeed2;

    public SequentialImpulseConstraintSolver() {
        int n = 0;
        while (n < this.gOrder.length) {
            this.gOrder[n] = new OrderIndex();
            ++n;
        }
        this.tmpSolverBodyPool = new ArrayList();
        this.tmpSolverConstraintPool = new ArrayList();
        this.tmpSolverFrictionConstraintPool = new ArrayList();
        this.orderTmpConstraintPool = new IntArrayList();
        this.orderFrictionConstraintPool = new IntArrayList();
        this.contactDispatch = new ContactSolverFunc[MAX_CONTACT_SOLVER_TYPES][MAX_CONTACT_SOLVER_TYPES];
        this.frictionDispatch = new ContactSolverFunc[MAX_CONTACT_SOLVER_TYPES][MAX_CONTACT_SOLVER_TYPES];
        this.btSeed2 = 0L;
        n = 0;
        while (n < MAX_CONTACT_SOLVER_TYPES) {
            int n2 = 0;
            while (n2 < MAX_CONTACT_SOLVER_TYPES) {
                this.contactDispatch[n][n2] = ContactConstraint.resolveSingleCollision;
                this.frictionDispatch[n][n2] = ContactConstraint.resolveSingleFriction;
                ++n2;
            }
            ++n;
        }
    }

    public long rand2() {
        this.btSeed2 = 1664525L * this.btSeed2 + 1013904223L & 0xFFFFFFFFFFFFFFFFL;
        return this.btSeed2;
    }

    public int randInt2(int n) {
        long l = n;
        long l2 = this.rand2();
        if (l <= 65536L) {
            l2 ^= l2 >>> 16;
            if (l <= 256L) {
                l2 ^= l2 >>> 8;
                if (l <= 16L) {
                    l2 ^= l2 >>> 4;
                    if (l <= 4L) {
                        l2 ^= l2 >>> 2;
                        if (l <= 2L) {
                            l2 ^= l2 >>> 1;
                        }
                    }
                }
            }
        }
        return (int)Math.abs(l2 % l);
    }

    private void initSolverBody(SolverBody solverBody, CollisionObject collisionObject) {
        RigidBody rigidBody = RigidBody.upcast(collisionObject);
        if (rigidBody != null) {
            rigidBody.getAngularVelocity(solverBody.angularVelocity);
            solverBody.centerOfMassPosition.set(collisionObject.getWorldTransform((Transform)this.tempTrans).origin);
            solverBody.friction = collisionObject.getFriction();
            solverBody.invMass = rigidBody.getInvMass();
            rigidBody.getLinearVelocity(solverBody.linearVelocity);
            solverBody.originalBody = rigidBody;
            solverBody.angularFactor = rigidBody.getAngularFactor();
        } else {
            solverBody.angularVelocity.set(0.0f, 0.0f, 0.0f);
            solverBody.centerOfMassPosition.set(collisionObject.getWorldTransform((Transform)this.tempTrans).origin);
            solverBody.friction = collisionObject.getFriction();
            solverBody.invMass = 0.0f;
            solverBody.linearVelocity.set(0.0f, 0.0f, 0.0f);
            solverBody.originalBody = null;
            solverBody.angularFactor = 1.0f;
        }
        solverBody.pushVelocity.set(0.0f, 0.0f, 0.0f);
        solverBody.turnVelocity.set(0.0f, 0.0f, 0.0f);
    }

    private float restitutionCurve(float f, float f2) {
        float f3 = f2 * -f;
        return f3;
    }

    private void resolveSplitPenetrationImpulseCacheFriendly(SolverBody solverBody, SolverBody solverBody2, SolverConstraint solverConstraint, ContactSolverInfo contactSolverInfo) {
        if (solverConstraint.penetration < contactSolverInfo.splitImpulsePenetrationThreshold) {
            float f;
            float f2 = solverConstraint.appliedPushImpulse;
            float f3 = -solverConstraint.penetration * contactSolverInfo.erp2 / contactSolverInfo.timeStep;
            float f4 = f3 * solverConstraint.jacDiagABInv;
            float f5 = solverConstraint.contactNormal.dot(solverBody.pushVelocity) + solverConstraint.relpos1CrossNormal.dot(solverBody.turnVelocity);
            float f6 = f5 - (f = solverConstraint.contactNormal.dot(solverBody2.pushVelocity) + solverConstraint.relpos2CrossNormal.dot(solverBody2.turnVelocity));
            float f7 = solverConstraint.restitution - f6;
            float f8 = f7 * solverConstraint.jacDiagABInv;
            float f9 = f4 + f8;
            float f10 = f2 + f9;
            solverConstraint.appliedPushImpulse = 0.0f > f10 ? 0.0f : f10;
            f9 = solverConstraint.appliedPushImpulse - f2;
            this.tempVec.scale(solverBody.invMass, solverConstraint.contactNormal);
            solverBody.internalApplyPushImpulse(this.tempVec, solverConstraint.angularComponentA, f9);
            this.tempVec.scale(solverBody2.invMass, solverConstraint.contactNormal);
            solverBody2.internalApplyPushImpulse(this.tempVec, solverConstraint.angularComponentB, -f9);
        }
    }

    private float resolveSingleCollisionCombinedCacheFriendly(SolverBody solverBody, SolverBody solverBody2, SolverConstraint solverConstraint, ContactSolverInfo contactSolverInfo) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = solverConstraint.contactNormal.dot(solverBody.linearVelocity) + solverConstraint.relpos1CrossNormal.dot(solverBody.angularVelocity);
        float f8 = solverConstraint.contactNormal.dot(solverBody2.linearVelocity) + solverConstraint.relpos2CrossNormal.dot(solverBody2.angularVelocity);
        float f9 = f7 - f8;
        float f10 = 0.0f;
        if (!contactSolverInfo.splitImpulse || solverConstraint.penetration > contactSolverInfo.splitImpulsePenetrationThreshold) {
            f10 = -solverConstraint.penetration * contactSolverInfo.erp / contactSolverInfo.timeStep;
        }
        solverConstraint.appliedImpulse = 0.0f > (f6 = (f5 = solverConstraint.appliedImpulse) + (f4 = (f3 = f10 * solverConstraint.jacDiagABInv) + (f2 = (f = solverConstraint.restitution - f9) * solverConstraint.jacDiagABInv))) ? 0.0f : f6;
        f4 = solverConstraint.appliedImpulse - f5;
        this.tempVec.scale(solverBody.invMass, solverConstraint.contactNormal);
        solverBody.internalApplyImpulse(this.tempVec, solverConstraint.angularComponentA, f4);
        this.tempVec.scale(solverBody2.invMass, solverConstraint.contactNormal);
        solverBody2.internalApplyImpulse(this.tempVec, solverConstraint.angularComponentB, -f4);
        return f4;
    }

    private float resolveSingleFrictionCacheFriendly(SolverBody solverBody, SolverBody solverBody2, SolverConstraint solverConstraint, ContactSolverInfo contactSolverInfo, float f) {
        float f2 = solverConstraint.friction;
        float f3 = f * f2;
        if (f > 0.0f) {
            float f4 = solverConstraint.contactNormal.dot(solverBody.linearVelocity) + solverConstraint.relpos1CrossNormal.dot(solverBody.angularVelocity);
            float f5 = solverConstraint.contactNormal.dot(solverBody2.linearVelocity) + solverConstraint.relpos2CrossNormal.dot(solverBody2.angularVelocity);
            float f6 = f4 - f5;
            float f7 = -f6 * solverConstraint.jacDiagABInv;
            float f8 = solverConstraint.appliedImpulse;
            solverConstraint.appliedImpulse = f8 + f7;
            if (f3 < solverConstraint.appliedImpulse) {
                solverConstraint.appliedImpulse = f3;
            } else if (solverConstraint.appliedImpulse < -f3) {
                solverConstraint.appliedImpulse = -f3;
            }
            f7 = solverConstraint.appliedImpulse - f8;
            this.tempVec.scale(solverBody.invMass, solverConstraint.contactNormal);
            solverBody.internalApplyImpulse(this.tempVec, solverConstraint.angularComponentA, f7);
            this.tempVec.scale(solverBody2.invMass, solverConstraint.contactNormal);
            solverBody2.internalApplyImpulse(this.tempVec, solverConstraint.angularComponentB, -f7);
        }
        return 0.0f;
    }

    protected void addFrictionConstraint(Vector3f vector3f, int n, int n2, int n3, ManifoldPoint manifoldPoint, Vector3f vector3f2, Vector3f vector3f3, CollisionObject collisionObject, CollisionObject collisionObject2, float f) {
        float f2;
        RigidBody rigidBody = RigidBody.upcast(collisionObject);
        RigidBody rigidBody2 = RigidBody.upcast(collisionObject2);
        SolverConstraint solverConstraint = (SolverConstraint)Pools.CONSTRAINTS.get();
        this.tmpSolverFrictionConstraintPool.add(solverConstraint);
        solverConstraint.contactNormal.set(vector3f);
        solverConstraint.solverBodyIdA = n;
        solverConstraint.solverBodyIdB = n2;
        solverConstraint.constraintType = SolverConstraintType.SOLVER_FRICTION_1D;
        solverConstraint.frictionIndex = n3;
        solverConstraint.friction = manifoldPoint.combinedFriction;
        solverConstraint.originalContactPoint = null;
        solverConstraint.appliedImpulse = 0.0f;
        solverConstraint.appliedPushImpulse = 0.0f;
        solverConstraint.penetration = 0.0f;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.cross(vector3f2, solverConstraint.contactNormal);
        solverConstraint.relpos1CrossNormal.set(vector3f4);
        if (rigidBody != null) {
            solverConstraint.angularComponentA.set(vector3f4);
            rigidBody.getInvInertiaTensorWorld(this.tempMat).transform(solverConstraint.angularComponentA);
        } else {
            solverConstraint.angularComponentA.set(0.0f, 0.0f, 0.0f);
        }
        vector3f4.cross(vector3f3, solverConstraint.contactNormal);
        solverConstraint.relpos2CrossNormal.set(vector3f4);
        if (rigidBody2 != null) {
            solverConstraint.angularComponentB.set(vector3f4);
            rigidBody2.getInvInertiaTensorWorld(this.tempMat).transform(solverConstraint.angularComponentB);
        } else {
            solverConstraint.angularComponentB.set(0.0f, 0.0f, 0.0f);
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (rigidBody != null) {
            this.tempVec.cross(solverConstraint.angularComponentA, vector3f2);
            f3 = rigidBody.getInvMass() + vector3f.dot(this.tempVec);
        }
        if (rigidBody2 != null) {
            this.tempVec.cross(solverConstraint.angularComponentB, vector3f3);
            f4 = rigidBody2.getInvMass() + vector3f.dot(this.tempVec);
        }
        solverConstraint.jacDiagABInv = f2 = f / (f3 + f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
    }

    public float solveGroupCacheFriendlySetup(ArrayList<CollisionObject> arrayList, int n, ArrayList<PersistentManifold> arrayList2, int n2, int n3, ArrayList<TypedConstraint> arrayList3, int n4, int n5, ContactSolverInfo contactSolverInfo) {
        if (n5 + n3 == 0) {
            return 0.0f;
        }
        PersistentManifold persistentManifold = null;
        CollisionObject collisionObject = null;
        CollisionObject collisionObject2 = null;
        Object object = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        int n6 = 0;
        while (n6 < n3) {
            persistentManifold = arrayList2.get(n2 + n6);
            collisionObject = (CollisionObject)persistentManifold.getBody0();
            collisionObject2 = (CollisionObject)persistentManifold.getBody1();
            int n7 = -1;
            int n8 = -1;
            if (persistentManifold.getNumContacts() != 0) {
                SolverBody solverBody;
                if (collisionObject.getIslandTag() >= 0) {
                    if (collisionObject.getCompanionId() >= 0) {
                        n7 = collisionObject.getCompanionId();
                    } else {
                        n7 = this.tmpSolverBodyPool.size();
                        solverBody = (SolverBody)Pools.BODIES.get();
                        this.tmpSolverBodyPool.add(solverBody);
                        this.initSolverBody(solverBody, collisionObject);
                        collisionObject.setCompanionId(n7);
                    }
                } else {
                    n7 = this.tmpSolverBodyPool.size();
                    SolverBody solverBody2 = (SolverBody)Pools.BODIES.get();
                    this.tmpSolverBodyPool.add(solverBody2);
                    this.initSolverBody(solverBody2, collisionObject);
                }
                if (collisionObject2.getIslandTag() >= 0) {
                    if (collisionObject2.getCompanionId() >= 0) {
                        n8 = collisionObject2.getCompanionId();
                    } else {
                        n8 = this.tmpSolverBodyPool.size();
                        solverBody = (SolverBody)Pools.BODIES.get();
                        this.tmpSolverBodyPool.add(solverBody);
                        this.initSolverBody(solverBody, collisionObject2);
                        collisionObject2.setCompanionId(n8);
                    }
                } else {
                    n8 = this.tmpSolverBodyPool.size();
                    solverBody = (SolverBody)Pools.BODIES.get();
                    this.tmpSolverBodyPool.add(solverBody);
                    this.initSolverBody(solverBody, collisionObject2);
                }
            }
            int n9 = 0;
            while (n9 < persistentManifold.getNumContacts()) {
                ManifoldPoint manifoldPoint = persistentManifold.getContactPoint(n9);
                if (manifoldPoint.getDistance() <= 0.0f) {
                    float f;
                    manifoldPoint.getPositionWorldOnA(vector3f2);
                    manifoldPoint.getPositionWorldOnB(vector3f3);
                    ((Tuple3f)object).sub(vector3f2, collisionObject.getWorldTransform((Transform)this.tempTrans).origin);
                    vector3f.sub(vector3f3, collisionObject2.getWorldTransform((Transform)this.tempTrans).origin);
                    float f2 = 1.0f;
                    int n10 = this.tmpSolverConstraintPool.size();
                    SolverConstraint solverConstraint = (SolverConstraint)Pools.CONSTRAINTS.get();
                    this.tmpSolverConstraintPool.add(solverConstraint);
                    RigidBody rigidBody = RigidBody.upcast(collisionObject);
                    RigidBody rigidBody2 = RigidBody.upcast(collisionObject2);
                    solverConstraint.solverBodyIdA = n7;
                    solverConstraint.solverBodyIdB = n8;
                    solverConstraint.constraintType = SolverConstraintType.SOLVER_CONTACT_1D;
                    solverConstraint.originalContactPoint = manifoldPoint;
                    vector3f5.cross((Vector3f)object, manifoldPoint.normalWorldOnB);
                    if (rigidBody != null) {
                        solverConstraint.angularComponentA.set(vector3f5);
                        rigidBody.getInvInertiaTensorWorld(matrix3f).transform(solverConstraint.angularComponentA);
                    } else {
                        solverConstraint.angularComponentA.set(0.0f, 0.0f, 0.0f);
                    }
                    vector3f6.cross(vector3f, manifoldPoint.normalWorldOnB);
                    if (rigidBody2 != null) {
                        solverConstraint.angularComponentB.set(vector3f6);
                        rigidBody2.getInvInertiaTensorWorld(matrix3f).transform(solverConstraint.angularComponentB);
                    } else {
                        solverConstraint.angularComponentB.set(0.0f, 0.0f, 0.0f);
                    }
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    if (rigidBody != null) {
                        vector3f9.cross(solverConstraint.angularComponentA, (Vector3f)object);
                        f3 = rigidBody.getInvMass() + manifoldPoint.normalWorldOnB.dot(vector3f9);
                    }
                    if (rigidBody2 != null) {
                        vector3f9.cross(solverConstraint.angularComponentB, vector3f);
                        f4 = rigidBody2.getInvMass() + manifoldPoint.normalWorldOnB.dot(vector3f9);
                    }
                    solverConstraint.jacDiagABInv = f = f2 / (f3 + f4);
                    solverConstraint.contactNormal.set(manifoldPoint.normalWorldOnB);
                    solverConstraint.relpos1CrossNormal.cross((Vector3f)object, manifoldPoint.normalWorldOnB);
                    solverConstraint.relpos2CrossNormal.cross(vector3f, manifoldPoint.normalWorldOnB);
                    if (rigidBody != null) {
                        rigidBody.getVelocityInLocalPoint((Vector3f)object, vector3f7);
                    } else {
                        vector3f7.set(0.0f, 0.0f, 0.0f);
                    }
                    if (rigidBody2 != null) {
                        rigidBody2.getVelocityInLocalPoint(vector3f, vector3f8);
                    } else {
                        vector3f8.set(0.0f, 0.0f, 0.0f);
                    }
                    vector3f4.sub(vector3f7, vector3f8);
                    float f5 = manifoldPoint.normalWorldOnB.dot(vector3f4);
                    solverConstraint.penetration = Math.min(manifoldPoint.getDistance() + contactSolverInfo.linearSlop, 0.0f);
                    solverConstraint.friction = manifoldPoint.combinedFriction;
                    solverConstraint.restitution = this.restitutionCurve(f5, manifoldPoint.combinedRestitution);
                    if (solverConstraint.restitution <= 0.0f) {
                        solverConstraint.restitution = 0.0f;
                    }
                    if (solverConstraint.restitution > (f3 = -solverConstraint.penetration / contactSolverInfo.timeStep)) {
                        solverConstraint.penetration = 0.0f;
                    }
                    if ((contactSolverInfo.solverMode & 4) != 0) {
                        solverConstraint.appliedImpulse = manifoldPoint.appliedImpulse * contactSolverInfo.warmstartingFactor;
                        if (rigidBody != null) {
                            vector3f10.scale(rigidBody.getInvMass(), solverConstraint.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA).internalApplyImpulse(vector3f10, solverConstraint.angularComponentA, solverConstraint.appliedImpulse);
                        }
                        if (rigidBody2 != null) {
                            vector3f10.scale(rigidBody2.getInvMass(), solverConstraint.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB).internalApplyImpulse(vector3f10, solverConstraint.angularComponentB, -solverConstraint.appliedImpulse);
                        }
                    } else {
                        solverConstraint.appliedImpulse = 0.0f;
                    }
                    solverConstraint.appliedPushImpulse = 0.0f;
                    solverConstraint.frictionIndex = this.tmpSolverFrictionConstraintPool.size();
                    if (!manifoldPoint.lateralFrictionInitialized) {
                        manifoldPoint.lateralFrictionDir1.scale(f5, manifoldPoint.normalWorldOnB);
                        manifoldPoint.lateralFrictionDir1.sub(vector3f4, manifoldPoint.lateralFrictionDir1);
                        f4 = manifoldPoint.lateralFrictionDir1.lengthSquared();
                        if (f4 > 1.1920929E-7f) {
                            manifoldPoint.lateralFrictionDir1.scale(1.0f / (float)Math.sqrt(f4));
                            this.addFrictionConstraint(manifoldPoint.lateralFrictionDir1, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                            manifoldPoint.lateralFrictionDir2.cross(manifoldPoint.lateralFrictionDir1, manifoldPoint.normalWorldOnB);
                            manifoldPoint.lateralFrictionDir2.normalize();
                            this.addFrictionConstraint(manifoldPoint.lateralFrictionDir2, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                        } else {
                            TransformUtil.planeSpace1(manifoldPoint.normalWorldOnB, manifoldPoint.lateralFrictionDir1, manifoldPoint.lateralFrictionDir2);
                            this.addFrictionConstraint(manifoldPoint.lateralFrictionDir1, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                            this.addFrictionConstraint(manifoldPoint.lateralFrictionDir2, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                        }
                        manifoldPoint.lateralFrictionInitialized = true;
                    } else {
                        this.addFrictionConstraint(manifoldPoint.lateralFrictionDir1, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                        this.addFrictionConstraint(manifoldPoint.lateralFrictionDir2, n7, n8, n10, manifoldPoint, (Vector3f)object, vector3f, collisionObject, collisionObject2, f2);
                    }
                    SolverConstraint solverConstraint2 = this.tmpSolverFrictionConstraintPool.get(solverConstraint.frictionIndex);
                    if ((contactSolverInfo.solverMode & 4) != 0) {
                        solverConstraint2.appliedImpulse = manifoldPoint.appliedImpulseLateral1 * contactSolverInfo.warmstartingFactor;
                        if (rigidBody != null) {
                            vector3f10.scale(rigidBody.getInvMass(), solverConstraint2.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA).internalApplyImpulse(vector3f10, solverConstraint2.angularComponentA, solverConstraint2.appliedImpulse);
                        }
                        if (rigidBody2 != null) {
                            vector3f10.scale(rigidBody2.getInvMass(), solverConstraint2.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB).internalApplyImpulse(vector3f10, solverConstraint2.angularComponentB, -solverConstraint2.appliedImpulse);
                        }
                    } else {
                        solverConstraint2.appliedImpulse = 0.0f;
                    }
                    solverConstraint2 = this.tmpSolverFrictionConstraintPool.get(solverConstraint.frictionIndex + 1);
                    if ((contactSolverInfo.solverMode & 4) != 0) {
                        solverConstraint2.appliedImpulse = manifoldPoint.appliedImpulseLateral2 * contactSolverInfo.warmstartingFactor;
                        if (rigidBody != null) {
                            vector3f10.scale(rigidBody.getInvMass(), solverConstraint2.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA).internalApplyImpulse(vector3f10, solverConstraint2.angularComponentA, solverConstraint2.appliedImpulse);
                        }
                        if (rigidBody2 != null) {
                            vector3f10.scale(rigidBody2.getInvMass(), solverConstraint2.contactNormal);
                            this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB).internalApplyImpulse(vector3f10, solverConstraint2.angularComponentB, -solverConstraint2.appliedImpulse);
                        }
                    } else {
                        solverConstraint2.appliedImpulse = 0.0f;
                    }
                }
                ++n9;
            }
            ++n6;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{object, vector3f, vector3f2, vector3f3, vector3f4, vector3f5, vector3f6, vector3f7, vector3f8, vector3f9, vector3f10});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        n6 = 0;
        while (n6 < n5) {
            object = arrayList3.get(n4 + n6);
            ((TypedConstraint)object).buildJacobian();
            ++n6;
        }
        n6 = this.tmpSolverConstraintPool.size();
        int n11 = this.tmpSolverFrictionConstraintPool.size();
        MiscUtil.resize(this.orderTmpConstraintPool, n6, 0);
        MiscUtil.resize(this.orderFrictionConstraintPool, n11, 0);
        int n12 = 0;
        while (n12 < n6) {
            this.orderTmpConstraintPool.set(n12, n12);
            ++n12;
        }
        n12 = 0;
        while (n12 < n11) {
            this.orderFrictionConstraintPool.set(n12, n12);
            ++n12;
        }
        return 0.0f;
    }

    public float solveGroupCacheFriendlyIterations(ArrayList<CollisionObject> arrayList, int n, ArrayList<PersistentManifold> arrayList2, int n2, int n3, ArrayList<TypedConstraint> arrayList3, int n4, int n5, ContactSolverInfo contactSolverInfo) {
        int n6;
        int n7;
        int n8 = this.tmpSolverConstraintPool.size();
        int n9 = this.tmpSolverFrictionConstraintPool.size();
        int n10 = 0;
        while (n10 < contactSolverInfo.numIterations) {
            if ((contactSolverInfo.solverMode & 1) != 0 && (n10 & 7) == 0) {
                int n11;
                n7 = 0;
                while (n7 < n8) {
                    n6 = this.orderTmpConstraintPool.get(n7);
                    n11 = this.randInt2(n7 + 1);
                    this.orderTmpConstraintPool.set(n7, this.orderTmpConstraintPool.get(n11));
                    this.orderTmpConstraintPool.set(n11, n6);
                    ++n7;
                }
                n7 = 0;
                while (n7 < n9) {
                    n6 = this.orderFrictionConstraintPool.get(n7);
                    n11 = this.randInt2(n7 + 1);
                    this.orderFrictionConstraintPool.set(n7, this.orderFrictionConstraintPool.get(n11));
                    this.orderFrictionConstraintPool.set(n11, n6);
                    ++n7;
                }
            }
            n7 = 0;
            while (n7 < n5) {
                TypedConstraint typedConstraint = arrayList3.get(n4 + n7);
                if (typedConstraint.getRigidBodyA().getIslandTag() >= 0 && typedConstraint.getRigidBodyA().getCompanionId() >= 0) {
                    this.tmpSolverBodyPool.get(typedConstraint.getRigidBodyA().getCompanionId()).writebackVelocity();
                }
                if (typedConstraint.getRigidBodyB().getIslandTag() >= 0 && typedConstraint.getRigidBodyB().getCompanionId() >= 0) {
                    this.tmpSolverBodyPool.get(typedConstraint.getRigidBodyB().getCompanionId()).writebackVelocity();
                }
                typedConstraint.solveConstraint(contactSolverInfo.timeStep);
                if (typedConstraint.getRigidBodyA().getIslandTag() >= 0 && typedConstraint.getRigidBodyA().getCompanionId() >= 0) {
                    this.tmpSolverBodyPool.get(typedConstraint.getRigidBodyA().getCompanionId()).readVelocity();
                }
                if (typedConstraint.getRigidBodyB().getIslandTag() >= 0 && typedConstraint.getRigidBodyB().getCompanionId() >= 0) {
                    this.tmpSolverBodyPool.get(typedConstraint.getRigidBodyB().getCompanionId()).readVelocity();
                }
                ++n7;
            }
            n6 = this.tmpSolverConstraintPool.size();
            n7 = 0;
            while (n7 < n6) {
                SolverConstraint solverConstraint = this.tmpSolverConstraintPool.get(this.orderTmpConstraintPool.get(n7));
                this.resolveSingleCollisionCombinedCacheFriendly(this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA), this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB), solverConstraint, contactSolverInfo);
                ++n7;
            }
            n6 = this.tmpSolverFrictionConstraintPool.size();
            n7 = 0;
            while (n7 < n6) {
                SolverConstraint solverConstraint = this.tmpSolverFrictionConstraintPool.get(this.orderFrictionConstraintPool.get(n7));
                float f = this.tmpSolverConstraintPool.get((int)solverConstraint.frictionIndex).appliedImpulse + this.tmpSolverConstraintPool.get((int)solverConstraint.frictionIndex).appliedPushImpulse;
                this.resolveSingleFrictionCacheFriendly(this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA), this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB), solverConstraint, contactSolverInfo, f);
                ++n7;
            }
            ++n10;
        }
        if (contactSolverInfo.splitImpulse) {
            n10 = 0;
            while (n10 < contactSolverInfo.numIterations) {
                n7 = this.tmpSolverConstraintPool.size();
                n6 = 0;
                while (n6 < n7) {
                    SolverConstraint solverConstraint = this.tmpSolverConstraintPool.get(this.orderTmpConstraintPool.get(n6));
                    this.resolveSplitPenetrationImpulseCacheFriendly(this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdA), this.tmpSolverBodyPool.get(solverConstraint.solverBodyIdB), solverConstraint, contactSolverInfo);
                    ++n6;
                }
                ++n10;
            }
        }
        return 0.0f;
    }

    public float solveGroupCacheFriendly(ArrayList<CollisionObject> arrayList, int n, ArrayList<PersistentManifold> arrayList2, int n2, int n3, ArrayList<TypedConstraint> arrayList3, int n4, int n5, ContactSolverInfo contactSolverInfo) {
        this.solveGroupCacheFriendlySetup(arrayList, n, arrayList2, n2, n3, arrayList3, n4, n5, contactSolverInfo);
        this.solveGroupCacheFriendlyIterations(arrayList, n, arrayList2, n2, n3, arrayList3, n4, n5, contactSolverInfo);
        int n6 = this.tmpSolverConstraintPool.size();
        int n7 = 0;
        while (n7 < n6) {
            Iterator<Object> iterator = this.tmpSolverConstraintPool.get(n7);
            ManifoldPoint manifoldPoint = (ManifoldPoint)((SolverConstraint)((Object)iterator)).originalContactPoint;
            assert (manifoldPoint != null);
            manifoldPoint.appliedImpulse = ((SolverConstraint)((Object)iterator)).appliedImpulse;
            manifoldPoint.appliedImpulseLateral1 = this.tmpSolverFrictionConstraintPool.get((int)((SolverConstraint)((Object)iterator)).frictionIndex).appliedImpulse;
            manifoldPoint.appliedImpulseLateral1 = this.tmpSolverFrictionConstraintPool.get((int)(((SolverConstraint)((Object)iterator)).frictionIndex + 1)).appliedImpulse;
            ++n7;
        }
        if (contactSolverInfo.splitImpulse) {
            for (SolverBody solverBody : this.tmpSolverBodyPool) {
                solverBody.writebackVelocity(contactSolverInfo.timeStep);
                Pools.BODIES.release((Object[])new SolverBody[]{solverBody});
            }
        } else {
            for (SolverBody solverBody : this.tmpSolverBodyPool) {
                solverBody.writebackVelocity();
                Pools.BODIES.release((Object[])new SolverBody[]{solverBody});
            }
        }
        this.tmpSolverBodyPool.clear();
        for (SolverConstraint solverConstraint : this.tmpSolverConstraintPool) {
            Pools.CONSTRAINTS.release((Object[])new SolverConstraint[]{solverConstraint});
        }
        this.tmpSolverConstraintPool.clear();
        for (SolverConstraint solverConstraint : this.tmpSolverFrictionConstraintPool) {
            Pools.CONSTRAINTS.release((Object[])new SolverConstraint[]{solverConstraint});
        }
        this.tmpSolverFrictionConstraintPool.clear();
        return 0.0f;
    }

    @Override
    public float solveGroup(ArrayList<CollisionObject> arrayList, int n, ArrayList<PersistentManifold> arrayList2, int n2, int n3, ArrayList<TypedConstraint> arrayList3, int n4, int n5, ContactSolverInfo contactSolverInfo, Dispatcher dispatcher) {
        Object object;
        if ((contactSolverInfo.solverMode & 8) != 0) {
            assert (arrayList != null);
            assert (n != 0);
            float f = this.solveGroupCacheFriendly(arrayList, n, arrayList2, n2, n3, arrayList3, n4, n5, contactSolverInfo);
            return f;
        }
        ContactSolverInfo contactSolverInfo2 = new ContactSolverInfo(contactSolverInfo);
        int n6 = contactSolverInfo.numIterations;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            object = arrayList2.get(n2 + n8);
            this.prepareConstraints((PersistentManifold)object, contactSolverInfo2);
            int n9 = 0;
            while (n9 < arrayList2.get(n2 + n8).getNumContacts()) {
                this.gOrder[n7].manifoldIndex = n8;
                this.gOrder[n7].pointIndex = n9;
                ++n7;
                n9 = (short)(n9 + 1);
            }
            n8 = (short)(n8 + 1);
        }
        n8 = 0;
        while (n8 < n5) {
            object = arrayList3.get(n4 + n8);
            ((TypedConstraint)object).buildJacobian();
            ++n8;
        }
        n8 = 0;
        while (n8 < n6) {
            if ((contactSolverInfo.solverMode & 1) != 0 && (n8 & 7) == 0) {
                int n10 = 0;
                while (n10 < n7) {
                    OrderIndex orderIndex = this.gOrder[n10];
                    int n11 = this.randInt2(n10 + 1);
                    this.gOrder[n10] = this.gOrder[n11];
                    this.gOrder[n11] = orderIndex;
                    ++n10;
                }
            }
            int n12 = 0;
            while (n12 < n5) {
                TypedConstraint typedConstraint = arrayList3.get(n4 + n12);
                typedConstraint.solveConstraint(contactSolverInfo2.timeStep);
                ++n12;
            }
            n12 = 0;
            while (n12 < n7) {
                PersistentManifold persistentManifold = arrayList2.get(n2 + this.gOrder[n12].manifoldIndex);
                this.solve((RigidBody)persistentManifold.getBody0(), (RigidBody)persistentManifold.getBody1(), persistentManifold.getContactPoint(this.gOrder[n12].pointIndex), contactSolverInfo2, n8);
                ++n12;
            }
            n12 = 0;
            while (n12 < n7) {
                PersistentManifold persistentManifold = arrayList2.get(n2 + this.gOrder[n12].manifoldIndex);
                this.solveFriction((RigidBody)persistentManifold.getBody0(), (RigidBody)persistentManifold.getBody1(), persistentManifold.getContactPoint(this.gOrder[n12].pointIndex), contactSolverInfo2, n8);
                ++n12;
            }
            ++n8;
        }
        return 0.0f;
    }

    protected void prepareConstraints(PersistentManifold persistentManifold, ContactSolverInfo contactSolverInfo) {
        RigidBody rigidBody = (RigidBody)persistentManifold.getBody0();
        RigidBody rigidBody2 = (RigidBody)persistentManifold.getBody1();
        int n = persistentManifold.getNumContacts();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
        int n2 = 0;
        while (n2 < n) {
            ManifoldPoint manifoldPoint = persistentManifold.getContactPoint(n2);
            if (manifoldPoint.getDistance() <= 0.0f) {
                float f;
                float f2;
                manifoldPoint.getPositionWorldOnA(vector3f);
                manifoldPoint.getPositionWorldOnB(vector3f2);
                vector3f3.sub(vector3f, rigidBody.getCenterOfMassPosition(this.tempVec));
                vector3f4.sub(vector3f2, rigidBody2.getCenterOfMassPosition(this.tempVec));
                Matrix3f matrix3f = rigidBody.getCenterOfMassTransform((Transform)this.tempTrans).basis;
                matrix3f.transpose();
                Matrix3f matrix3f2 = rigidBody2.getCenterOfMassTransform((Transform)this.tempTrans).basis;
                matrix3f2.transpose();
                JacobianEntry jacobianEntry = (JacobianEntry)Pools.JACOBIANS.get();
                jacobianEntry.init(matrix3f, matrix3f2, vector3f3, vector3f4, manifoldPoint.normalWorldOnB, rigidBody.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), rigidBody.getInvMass(), rigidBody2.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), rigidBody2.getInvMass());
                float f3 = jacobianEntry.getDiagonal();
                Pools.JACOBIANS.release((Object[])new JacobianEntry[]{jacobianEntry});
                ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
                if (constraintPersistentData != null) {
                    ++constraintPersistentData.persistentLifeTime;
                    if (constraintPersistentData.persistentLifeTime != manifoldPoint.getLifeTime()) {
                        constraintPersistentData.reset();
                        constraintPersistentData.persistentLifeTime = manifoldPoint.getLifeTime();
                    }
                } else {
                    constraintPersistentData = new ConstraintPersistentData();
                    ++this.totalCpd;
                    manifoldPoint.userPersistentData = constraintPersistentData;
                    constraintPersistentData.persistentLifeTime = manifoldPoint.getLifeTime();
                }
                assert (constraintPersistentData != null);
                constraintPersistentData.jacDiagABInv = 1.0f / f3;
                constraintPersistentData.frictionSolverFunc = this.frictionDispatch[rigidBody.frictionSolverType][rigidBody2.frictionSolverType];
                constraintPersistentData.contactSolverFunc = this.contactDispatch[rigidBody.contactSolverType][rigidBody2.contactSolverType];
                rigidBody.getVelocityInLocalPoint(vector3f3, vector3f5);
                rigidBody2.getVelocityInLocalPoint(vector3f4, vector3f6);
                vector3f7.sub(vector3f5, vector3f6);
                float f4 = manifoldPoint.normalWorldOnB.dot(vector3f7);
                float f5 = manifoldPoint.combinedRestitution;
                constraintPersistentData.penetration = manifoldPoint.getDistance();
                constraintPersistentData.friction = manifoldPoint.combinedFriction;
                constraintPersistentData.restitution = this.restitutionCurve(f4, f5);
                if (constraintPersistentData.restitution <= 0.0f) {
                    constraintPersistentData.restitution = 0.0f;
                }
                if (constraintPersistentData.restitution > (f2 = -constraintPersistentData.penetration / contactSolverInfo.timeStep)) {
                    constraintPersistentData.penetration = 0.0f;
                }
                float f6 = contactSolverInfo.damping;
                constraintPersistentData.appliedImpulse = (contactSolverInfo.solverMode & 4) != 0 ? (constraintPersistentData.appliedImpulse *= f6) : 0.0f;
                constraintPersistentData.prevAppliedImpulse = constraintPersistentData.appliedImpulse;
                TransformUtil.planeSpace1(manifoldPoint.normalWorldOnB, constraintPersistentData.frictionWorldTangential0, constraintPersistentData.frictionWorldTangential1);
                constraintPersistentData.accumulatedTangentImpulse0 = 0.0f;
                constraintPersistentData.accumulatedTangentImpulse1 = 0.0f;
                float f7 = rigidBody.computeImpulseDenominator(vector3f, constraintPersistentData.frictionWorldTangential0);
                float f8 = rigidBody2.computeImpulseDenominator(vector3f2, constraintPersistentData.frictionWorldTangential0);
                constraintPersistentData.jacDiagABInvTangent0 = f = f6 / (f7 + f8);
                f7 = rigidBody.computeImpulseDenominator(vector3f, constraintPersistentData.frictionWorldTangential1);
                f8 = rigidBody2.computeImpulseDenominator(vector3f2, constraintPersistentData.frictionWorldTangential1);
                constraintPersistentData.jacDiagABInvTangent1 = f = f6 / (f7 + f8);
                vector3f8.scale(constraintPersistentData.appliedImpulse, manifoldPoint.normalWorldOnB);
                vector3f9.cross(vector3f3, manifoldPoint.normalWorldOnB);
                constraintPersistentData.angularComponentA.set(vector3f9);
                rigidBody.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.angularComponentA);
                vector3f10.cross(vector3f4, manifoldPoint.normalWorldOnB);
                constraintPersistentData.angularComponentB.set(vector3f10);
                rigidBody2.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.angularComponentB);
                vector3f11.cross(vector3f3, constraintPersistentData.frictionWorldTangential0);
                constraintPersistentData.frictionAngularComponent0A.set(vector3f11);
                rigidBody.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.frictionAngularComponent0A);
                vector3f12.cross(vector3f3, constraintPersistentData.frictionWorldTangential1);
                constraintPersistentData.frictionAngularComponent1A.set(vector3f12);
                rigidBody.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.frictionAngularComponent1A);
                vector3f11.cross(vector3f4, constraintPersistentData.frictionWorldTangential0);
                constraintPersistentData.frictionAngularComponent0B.set(vector3f11);
                rigidBody2.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.frictionAngularComponent0B);
                vector3f12.cross(vector3f4, constraintPersistentData.frictionWorldTangential1);
                constraintPersistentData.frictionAngularComponent1B.set(vector3f12);
                rigidBody2.getInvInertiaTensorWorld(this.tempMat).transform(constraintPersistentData.frictionAngularComponent1B);
                rigidBody.applyImpulse(vector3f8, vector3f3);
                this.tempVec.negate(vector3f8);
                rigidBody2.applyImpulse(this.tempVec, vector3f4);
            }
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4, vector3f5, vector3f6, vector3f7, vector3f8, vector3f9, vector3f10, vector3f11, vector3f12});
    }

    public float solveCombinedContactFriction(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo, int n) {
        float f;
        float f2 = 0.0f;
        if (manifoldPoint.getDistance() <= 0.0f && f2 < (f = ContactConstraint.resolveSingleCollisionCombined(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo))) {
            f2 = f;
        }
        return f2;
    }

    protected float solve(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo, int n) {
        float f = 0.0f;
        if (manifoldPoint.getDistance() <= 0.0f) {
            ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
            float f2 = constraintPersistentData.contactSolverFunc.resolveContact(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo);
            if (f < f2) {
                f = f2;
            }
        }
        return f;
    }

    protected float solveFriction(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo, int n) {
        if (manifoldPoint.getDistance() <= 0.0f) {
            ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
            constraintPersistentData.frictionSolverFunc.resolveContact(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo);
        }
        return 0.0f;
    }

    @Override
    public void reset() {
        this.btSeed2 = 0L;
    }

    public void setContactSolverFunc(ContactSolverFunc contactSolverFunc, int n, int n2) {
        this.contactDispatch[n][n2] = contactSolverFunc;
    }

    public void setFrictionSolverFunc(ContactSolverFunc contactSolverFunc, int n, int n2) {
        this.frictionDispatch[n][n2] = contactSolverFunc;
    }

    public void setRandSeed(long l) {
        this.btSeed2 = l;
    }

    public long getRandSeed() {
        return this.btSeed2;
    }

    private static class OrderIndex {
        public int manifoldIndex;
        public int pointIndex;

        private OrderIndex() {
        }
    }
}

