/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class QuaternionUtil {
    public static float getAngle(Quat4f quat4f) {
        float f = 2.0f * (float)Math.acos(quat4f.w);
        return f;
    }

    public static void setRotation(Quat4f quat4f, Vector3f vector3f, float f) {
        float f2 = vector3f.length();
        assert (f2 != 0.0f);
        float f3 = (float)Math.sin(f * 0.5f) / f2;
        quat4f.set(vector3f.x * f3, vector3f.y * f3, vector3f.z * f3, (float)Math.cos(f * 0.5f));
    }

    public static Quat4f shortestArcQuat(Vector3f vector3f, Vector3f vector3f2, Quat4f quat4f) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.cross(vector3f, vector3f2);
        float f = vector3f.dot(vector3f2);
        if ((double)f < -0.9999998807907104) {
            quat4f.set(0.0f, 1.0f, 0.0f, 0.0f);
            return quat4f;
        }
        float f2 = (float)Math.sqrt((1.0f + f) * 2.0f);
        float f3 = 1.0f / f2;
        quat4f.set(vector3f3.x * f3, vector3f3.y * f3, vector3f3.z * f3, f2 * 0.5f);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
        return quat4f;
    }

    public static void mul(Quat4f quat4f, Vector3f vector3f) {
        float f = quat4f.w * vector3f.x + quat4f.y * vector3f.z - quat4f.z * vector3f.y;
        float f2 = quat4f.w * vector3f.y + quat4f.z * vector3f.x - quat4f.x * vector3f.z;
        float f3 = quat4f.w * vector3f.z + quat4f.x * vector3f.y - quat4f.y * vector3f.x;
        float f4 = -quat4f.x * vector3f.x - quat4f.y * vector3f.y - quat4f.z * vector3f.z;
        quat4f.set(f, f2, f3, f4);
    }

    public static Vector3f quatRotate(Quat4f quat4f, Vector3f vector3f, Vector3f vector3f2) {
        Quat4f quat4f2 = (Quat4f)Pools.QUATS.get((Object)quat4f);
        QuaternionUtil.mul(quat4f2, vector3f);
        Quat4f quat4f3 = (Quat4f)Pools.QUATS.get();
        QuaternionUtil.inverse(quat4f3, quat4f);
        quat4f2.mul(quat4f3);
        vector3f2.set(quat4f2.x, quat4f2.y, quat4f2.z);
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f3, quat4f2});
        return vector3f2;
    }

    public static void inverse(Quat4f quat4f) {
        quat4f.x = -quat4f.x;
        quat4f.y = -quat4f.y;
        quat4f.z = -quat4f.z;
    }

    public static void inverse(Quat4f quat4f, Quat4f quat4f2) {
        quat4f.x = -quat4f2.x;
        quat4f.y = -quat4f2.y;
        quat4f.z = -quat4f2.z;
        quat4f.w = quat4f2.w;
    }

    public static void setEuler(Quat4f quat4f, float f, float f2, float f3) {
        float f4 = f * 0.5f;
        float f5 = f2 * 0.5f;
        float f6 = f3 * 0.5f;
        float f7 = (float)Math.cos(f4);
        float f8 = (float)Math.sin(f4);
        float f9 = (float)Math.cos(f5);
        float f10 = (float)Math.sin(f5);
        float f11 = (float)Math.cos(f6);
        float f12 = (float)Math.sin(f6);
        quat4f.x = f11 * f10 * f7 + f12 * f9 * f8;
        quat4f.y = f11 * f9 * f8 - f12 * f10 * f7;
        quat4f.z = f12 * f9 * f7 - f11 * f10 * f8;
        quat4f.w = f11 * f9 * f7 + f12 * f10 * f8;
    }
}

