/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Manifold;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class WorldManifold {
    public final Vec2 normal;
    public final Vec2[] points;
    public final float[] separations;
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();

    public WorldManifold() {
        this.normal = new Vec2();
        this.points = new Vec2[Settings.maxManifoldPoints];
        this.separations = new float[Settings.maxManifoldPoints];
        int n = 0;
        while (n < Settings.maxManifoldPoints) {
            this.points[n] = new Vec2();
            ++n;
        }
    }

    public final void initialize(Manifold manifold, Transform transform, float f, Transform transform2, float f2) {
        if (manifold.pointCount == 0) {
            return;
        }
        switch (manifold.type) {
            case CIRCLES: {
                Vec2 vec2 = this.pool3;
                Vec2 vec22 = this.pool4;
                this.normal.x = 1.0f;
                this.normal.y = 0.0f;
                Vec2 vec23 = manifold.localPoint;
                vec2.x = transform.q.c * vec23.x - transform.q.s * vec23.y + transform.p.x;
                vec2.y = transform.q.s * vec23.x + transform.q.c * vec23.y + transform.p.y;
                Vec2 vec24 = manifold.points[0].localPoint;
                vec22.x = transform2.q.c * vec24.x - transform2.q.s * vec24.y + transform2.p.x;
                vec22.y = transform2.q.s * vec24.x + transform2.q.c * vec24.y + transform2.p.y;
                if (MathUtils.distanceSquared(vec2, vec22) > 1.4210855E-14f) {
                    this.normal.x = vec22.x - vec2.x;
                    this.normal.y = vec22.y - vec2.y;
                    this.normal.normalize();
                }
                float f3 = this.normal.x * f + vec2.x;
                float f4 = this.normal.y * f + vec2.y;
                float f5 = -this.normal.x * f2 + vec22.x;
                float f6 = -this.normal.y * f2 + vec22.y;
                this.points[0].x = (f3 + f5) * 0.5f;
                this.points[0].y = (f4 + f6) * 0.5f;
                this.separations[0] = (f5 - f3) * this.normal.x + (f6 - f4) * this.normal.y;
                break;
            }
            case FACE_A: {
                Vec2 vec2 = this.pool3;
                Rot.mulToOutUnsafe(transform.q, manifold.localNormal, this.normal);
                Transform.mulToOut(transform, manifold.localPoint, vec2);
                Vec2 vec25 = this.pool4;
                int n = 0;
                while (n < manifold.pointCount) {
                    Transform.mulToOut(transform2, manifold.points[n].localPoint, vec25);
                    float f7 = f - ((vec25.x - vec2.x) * this.normal.x + (vec25.y - vec2.y) * this.normal.y);
                    float f8 = this.normal.x * f7 + vec25.x;
                    float f9 = this.normal.y * f7 + vec25.y;
                    float f10 = -this.normal.x * f2 + vec25.x;
                    float f11 = -this.normal.y * f2 + vec25.y;
                    this.points[n].x = (f8 + f10) * 0.5f;
                    this.points[n].y = (f9 + f11) * 0.5f;
                    this.separations[n] = (f10 - f8) * this.normal.x + (f11 - f9) * this.normal.y;
                    ++n;
                }
                break;
            }
            case FACE_B: {
                Vec2 vec2 = this.pool3;
                Rot.mulToOutUnsafe(transform2.q, manifold.localNormal, this.normal);
                Transform.mulToOut(transform2, manifold.localPoint, vec2);
                Vec2 vec26 = this.pool4;
                int n = 0;
                while (n < manifold.pointCount) {
                    Transform.mulToOut(transform, manifold.points[n].localPoint, vec26);
                    float f12 = f2 - ((vec26.x - vec2.x) * this.normal.x + (vec26.y - vec2.y) * this.normal.y);
                    float f13 = this.normal.x * f12 + vec26.x;
                    float f14 = this.normal.y * f12 + vec26.y;
                    float f15 = -this.normal.x * f + vec26.x;
                    float f16 = -this.normal.y * f + vec26.y;
                    this.points[n].x = (f15 + f13) * 0.5f;
                    this.points[n].y = (f16 + f14) * 0.5f;
                    this.separations[n] = (f15 - f13) * this.normal.x + (f16 - f14) * this.normal.y;
                    ++n;
                }
                this.normal.x = -this.normal.x;
                this.normal.y = -this.normal.y;
            }
        }
    }
}

