/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactPositionConstraint;

class PositionSolverManifold {
    public final Vec2 normal = new Vec2();
    public final Vec2 point = new Vec2();
    public float separation;

    PositionSolverManifold() {
    }

    public void initialize(ContactPositionConstraint contactPositionConstraint, Transform transform, Transform transform2, int n) {
        assert (contactPositionConstraint.pointCount > 0);
        Rot rot = transform.q;
        Rot rot2 = transform2.q;
        Vec2 vec2 = contactPositionConstraint.localPoints[n];
        switch (contactPositionConstraint.type) {
            case CIRCLES: {
                Vec2 vec22 = contactPositionConstraint.localPoint;
                Vec2 vec23 = contactPositionConstraint.localPoints[0];
                float f = rot.c * vec22.x - rot.s * vec22.y + transform.p.x;
                float f2 = rot.s * vec22.x + rot.c * vec22.y + transform.p.y;
                float f3 = rot2.c * vec23.x - rot2.s * vec23.y + transform2.p.x;
                float f4 = rot2.s * vec23.x + rot2.c * vec23.y + transform2.p.y;
                this.normal.x = f3 - f;
                this.normal.y = f4 - f2;
                this.normal.normalize();
                this.point.x = (f + f3) * 0.5f;
                this.point.y = (f2 + f4) * 0.5f;
                float f5 = f3 - f;
                float f6 = f4 - f2;
                this.separation = f5 * this.normal.x + f6 * this.normal.y - contactPositionConstraint.radiusA - contactPositionConstraint.radiusB;
                break;
            }
            case FACE_A: {
                Vec2 vec24 = contactPositionConstraint.localNormal;
                Vec2 vec25 = contactPositionConstraint.localPoint;
                this.normal.x = rot.c * vec24.x - rot.s * vec24.y;
                this.normal.y = rot.s * vec24.x + rot.c * vec24.y;
                float f = rot.c * vec25.x - rot.s * vec25.y + transform.p.x;
                float f7 = rot.s * vec25.x + rot.c * vec25.y + transform.p.y;
                float f8 = rot2.c * vec2.x - rot2.s * vec2.y + transform2.p.x;
                float f9 = rot2.s * vec2.x + rot2.c * vec2.y + transform2.p.y;
                float f10 = f8 - f;
                float f11 = f9 - f7;
                this.separation = f10 * this.normal.x + f11 * this.normal.y - contactPositionConstraint.radiusA - contactPositionConstraint.radiusB;
                this.point.x = f8;
                this.point.y = f9;
                break;
            }
            case FACE_B: {
                Vec2 vec26 = contactPositionConstraint.localNormal;
                Vec2 vec27 = contactPositionConstraint.localPoint;
                this.normal.x = rot2.c * vec26.x - rot2.s * vec26.y;
                this.normal.y = rot2.s * vec26.x + rot2.c * vec26.y;
                float f = rot2.c * vec27.x - rot2.s * vec27.y + transform2.p.x;
                float f12 = rot2.s * vec27.x + rot2.c * vec27.y + transform2.p.y;
                float f13 = rot.c * vec2.x - rot.s * vec2.y + transform.p.x;
                float f14 = rot.s * vec2.x + rot.c * vec2.y + transform.p.y;
                float f15 = f13 - f;
                float f16 = f14 - f12;
                this.separation = f15 * this.normal.x + f16 * this.normal.y - contactPositionConstraint.radiusA - contactPositionConstraint.radiusB;
                this.point.x = f13;
                this.point.y = f14;
                this.normal.x *= -1.0f;
                this.normal.y *= -1.0f;
            }
        }
    }
}

