/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;

public class CompoundCollisionAlgorithm
extends CollisionAlgorithm {
    private final ArrayList<CollisionAlgorithm> childCollisionAlgorithms = new ArrayList();
    private boolean isSwapped;

    public void init(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2, boolean bl) {
        CollisionObject collisionObject3;
        super.init(collisionAlgorithmConstructionInfo);
        this.isSwapped = bl;
        CollisionObject collisionObject4 = bl ? collisionObject2 : collisionObject;
        CollisionObject collisionObject5 = collisionObject3 = bl ? collisionObject : collisionObject2;
        assert (collisionObject4.getCollisionShape().isCompound());
        CompoundShape compoundShape = (CompoundShape)collisionObject4.getCollisionShape();
        int n = compoundShape.getNumChildShapes();
        int n2 = 0;
        while (n2 < n) {
            CollisionShape collisionShape = collisionObject4.getCollisionShape();
            CollisionShape collisionShape2 = compoundShape.getChildShape(n2);
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape2);
            this.childCollisionAlgorithms.add(collisionAlgorithmConstructionInfo.dispatcher1.findAlgorithm(collisionObject4, collisionObject3));
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape);
            ++n2;
        }
    }

    @Override
    public void destroy() {
        int n = this.childCollisionAlgorithms.size();
        int n2 = 0;
        while (n2 < n) {
            this.dispatcher.freeCollisionAlgorithm(this.childCollisionAlgorithms.get(n2));
            ++n2;
        }
        this.childCollisionAlgorithms.clear();
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        CollisionObject collisionObject3;
        CollisionObject collisionObject4 = this.isSwapped ? collisionObject2 : collisionObject;
        CollisionObject collisionObject5 = collisionObject3 = this.isSwapped ? collisionObject : collisionObject2;
        assert (collisionObject4.getCollisionShape().isCompound());
        CompoundShape compoundShape = (CompoundShape)collisionObject4.getCollisionShape();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = (Transform)Pools.TRANSFORMS.get();
        int n = this.childCollisionAlgorithms.size();
        int n2 = 0;
        while (n2 < n) {
            CollisionShape collisionShape = compoundShape.getChildShape(n2);
            collisionObject4.getWorldTransform(transform);
            collisionObject4.getInterpolationWorldTransform(transform3);
            compoundShape.getChildTransform(n2, transform2);
            transform4.mul(transform, transform2);
            collisionObject4.setWorldTransform(transform4);
            collisionObject4.setInterpolationWorldTransform(transform4);
            CollisionShape collisionShape2 = collisionObject4.getCollisionShape();
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape);
            this.childCollisionAlgorithms.get(n2).processCollision(collisionObject4, collisionObject3, manifoldResult);
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape2);
            collisionObject4.setWorldTransform(transform);
            collisionObject4.setInterpolationWorldTransform(transform3);
            ++n2;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform, transform2, transform4});
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        CollisionObject collisionObject3;
        CollisionObject collisionObject4 = this.isSwapped ? collisionObject2 : collisionObject;
        CollisionObject collisionObject5 = collisionObject3 = this.isSwapped ? collisionObject : collisionObject2;
        assert (collisionObject4.getCollisionShape().isCompound());
        CompoundShape compoundShape = (CompoundShape)collisionObject4.getCollisionShape();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        float f = 1.0f;
        int n = this.childCollisionAlgorithms.size();
        int n2 = 0;
        while (n2 < n) {
            CollisionShape collisionShape = compoundShape.getChildShape(n2);
            collisionObject4.getWorldTransform(transform2);
            compoundShape.getChildTransform(n2, transform3);
            transform.set(transform2);
            transform.mul(transform3);
            collisionObject4.setWorldTransform(transform);
            CollisionShape collisionShape2 = collisionObject4.getCollisionShape();
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape);
            float f2 = this.childCollisionAlgorithms.get(n2).calculateTimeOfImpact(collisionObject4, collisionObject3, manifoldResult);
            if (f2 < f) {
                f = f2;
            }
            collisionObject4.internalSetTemporaryCollisionShape(collisionShape2);
            collisionObject4.setWorldTransform(transform2);
            ++n2;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2, transform3});
        return f;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        for (CollisionAlgorithm collisionAlgorithm : this.childCollisionAlgorithms) {
            collisionAlgorithm.getAllContactManifolds(arrayList);
        }
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            CompoundCollisionAlgorithm compoundCollisionAlgorithm = (CompoundCollisionAlgorithm)Pools.COMPOUND_COLLISIONS.get();
            compoundCollisionAlgorithm.init(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, false);
            return compoundCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.COMPOUND_COLLISIONS.release((Object[])new CompoundCollisionAlgorithm[]{(CompoundCollisionAlgorithm)collisionAlgorithm});
        }
    }

    public static class SwappedCreateFunc
    implements CollisionAlgorithmCreateFunc {
        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            CompoundCollisionAlgorithm compoundCollisionAlgorithm = (CompoundCollisionAlgorithm)Pools.COMPOUND_COLLISIONS.get();
            compoundCollisionAlgorithm.init(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, true);
            return compoundCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.COMPOUND_COLLISIONS.release((Object[])new CompoundCollisionAlgorithm[]{(CompoundCollisionAlgorithm)collisionAlgorithm});
        }
    }
}

