/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.pooling.IWorldPool;

public class MouseJoint
extends Joint {
    private final Vec2 m_localAnchorB = new Vec2();
    private final Vec2 m_targetA = new Vec2();
    private float m_frequencyHz;
    private float m_dampingRatio;
    private float m_beta;
    private final Vec2 m_impulse = new Vec2();
    private float m_maxForce;
    private float m_gamma;
    private int m_indexB;
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassB;
    private float m_invIB;
    private final Mat22 m_mass = new Mat22();
    private final Vec2 m_C = new Vec2();

    protected MouseJoint(IWorldPool iWorldPool, MouseJointDef mouseJointDef) {
        super(iWorldPool, mouseJointDef);
        assert (mouseJointDef.target.isValid());
        assert (mouseJointDef.maxForce >= 0.0f);
        assert (mouseJointDef.frequencyHz >= 0.0f);
        assert (mouseJointDef.dampingRatio >= 0.0f);
        this.m_targetA.set(mouseJointDef.target);
        Transform.mulTransToOutUnsafe(this.m_bodyB.getTransform(), this.m_targetA, this.m_localAnchorB);
        this.m_maxForce = mouseJointDef.maxForce;
        this.m_impulse.setZero();
        this.m_frequencyHz = mouseJointDef.frequencyHz;
        this.m_dampingRatio = mouseJointDef.dampingRatio;
        this.m_beta = 0.0f;
        this.m_gamma = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        vec2.set(this.m_targetA);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse).mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * 0.0f;
    }

    public void setTarget(Vec2 vec2) {
        if (!this.m_bodyB.isAwake()) {
            this.m_bodyB.setAwake(true);
        }
        this.m_targetA.set(vec2);
    }

    public Vec2 getTarget() {
        return this.m_targetA;
    }

    public void setMaxForce(float f) {
        this.m_maxForce = f;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setFrequency(float f) {
        this.m_frequencyHz = f;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public void setDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexB].c;
        float f = solverData.positions[this.m_indexB].a;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        rot.set(f);
        float f3 = this.m_bodyB.getMass();
        float f4 = (float)Math.PI * 2 * this.m_frequencyHz;
        float f5 = 2.0f * f3 * this.m_dampingRatio * f4;
        float f6 = f3 * (f4 * f4);
        float f7 = solverData.step.dt;
        assert (f5 + f7 * f6 > 1.1920929E-7f);
        this.m_gamma = f7 * (f5 + f7 * f6);
        if (this.m_gamma != 0.0f) {
            this.m_gamma = 1.0f / this.m_gamma;
        }
        this.m_beta = f7 * f6 * this.m_gamma;
        Vec2 vec23 = this.pool.popVec2();
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        Mat22 mat22 = this.pool.popMat22();
        mat22.ex.x = this.m_invMassB + this.m_invIB * this.m_rB.y * this.m_rB.y + this.m_gamma;
        mat22.ey.x = mat22.ex.y = -this.m_invIB * this.m_rB.x * this.m_rB.y;
        mat22.ey.y = this.m_invMassB + this.m_invIB * this.m_rB.x * this.m_rB.x + this.m_gamma;
        mat22.invertToOut(this.m_mass);
        this.m_C.set(vec2).addLocal(this.m_rB).subLocal(this.m_targetA);
        this.m_C.mulLocal(this.m_beta);
        f2 *= 0.98f;
        if (solverData.step.warmStarting) {
            this.m_impulse.mulLocal(solverData.step.dtRatio);
            vec22.x += this.m_invMassB * this.m_impulse.x;
            vec22.y += this.m_invMassB * this.m_impulse.y;
            f2 += this.m_invIB * Vec2.cross(this.m_rB, this.m_impulse);
        } else {
            this.m_impulse.setZero();
        }
        solverData.velocities[this.m_indexB].w = f2;
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
        this.pool.pushRot(1);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        return true;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexB].v;
        float f = solverData.velocities[this.m_indexB].w;
        Vec2 vec22 = this.pool.popVec2();
        Vec2.crossToOutUnsafe(f, this.m_rB, vec22);
        vec22.addLocal(vec2);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec24.set(this.m_impulse).mulLocal(this.m_gamma).addLocal(this.m_C).addLocal(vec22).negateLocal();
        Mat22.mulToOutUnsafe(this.m_mass, vec24, vec23);
        Vec2 vec25 = vec24;
        vec25.set(this.m_impulse);
        this.m_impulse.addLocal(vec23);
        float f2 = solverData.step.dt * this.m_maxForce;
        if (this.m_impulse.lengthSquared() > f2 * f2) {
            this.m_impulse.mulLocal(f2 / this.m_impulse.length());
        }
        vec23.set(this.m_impulse).subLocal(vec25);
        vec2.x += this.m_invMassB * vec23.x;
        vec2.y += this.m_invMassB * vec23.y;
        solverData.velocities[this.m_indexB].w = f += this.m_invIB * Vec2.cross(this.m_rB, vec23);
        this.pool.pushVec2(3);
    }
}

