/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.pooling.IWorldPool;

public class WeldJoint
extends Joint {
    private float m_frequencyHz;
    private float m_dampingRatio;
    private float m_bias;
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private float m_referenceAngle;
    private float m_gamma;
    private final Vec3 m_impulse;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Mat33 m_mass = new Mat33();

    protected WeldJoint(IWorldPool iWorldPool, WeldJointDef weldJointDef) {
        super(iWorldPool, weldJointDef);
        this.m_localAnchorA = new Vec2(weldJointDef.localAnchorA);
        this.m_localAnchorB = new Vec2(weldJointDef.localAnchorB);
        this.m_referenceAngle = weldJointDef.referenceAngle;
        this.m_frequencyHz = weldJointDef.frequencyHz;
        this.m_dampingRatio = weldJointDef.dampingRatio;
        this.m_impulse = new Vec3();
        this.m_impulse.setZero();
    }

    public float getReferenceAngle() {
        return this.m_referenceAngle;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public void setFrequency(float f) {
        this.m_frequencyHz = f;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    public void setDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse.x, this.m_impulse.y);
        vec2.mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * this.m_impulse.z;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec23 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        Mat33 mat33 = this.pool.popMat33();
        mat33.ex.x = f5 + f6 + this.m_rA.y * this.m_rA.y * f7 + this.m_rB.y * this.m_rB.y * f8;
        mat33.ey.x = -this.m_rA.y * this.m_rA.x * f7 - this.m_rB.y * this.m_rB.x * f8;
        mat33.ez.x = -this.m_rA.y * f7 - this.m_rB.y * f8;
        mat33.ex.y = mat33.ey.x;
        mat33.ey.y = f5 + f6 + this.m_rA.x * this.m_rA.x * f7 + this.m_rB.x * this.m_rB.x * f8;
        mat33.ez.y = this.m_rA.x * f7 + this.m_rB.x * f8;
        mat33.ex.z = mat33.ez.x;
        mat33.ey.z = mat33.ez.y;
        mat33.ez.z = f7 + f8;
        if (this.m_frequencyHz > 0.0f) {
            mat33.getInverse22(this.m_mass);
            float f9 = f7 + f8;
            float f10 = f9 > 0.0f ? 1.0f / f9 : 0.0f;
            float f11 = f3 - f - this.m_referenceAngle;
            float f12 = (float)Math.PI * 2 * this.m_frequencyHz;
            float f13 = 2.0f * f10 * this.m_dampingRatio * f12;
            float f14 = f10 * f12 * f12;
            float f15 = solverData.step.dt;
            this.m_gamma = f15 * (f13 + f15 * f14);
            this.m_gamma = this.m_gamma != 0.0f ? 1.0f / this.m_gamma : 0.0f;
            this.m_bias = f11 * f15 * f14 * this.m_gamma;
            this.m_mass.ez.z = (f9 += this.m_gamma) != 0.0f ? 1.0f / f9 : 0.0f;
        } else {
            mat33.getSymInverse33(this.m_mass);
            this.m_gamma = 0.0f;
            this.m_bias = 0.0f;
        }
        if (solverData.step.warmStarting) {
            Vec2 vec24 = this.pool.popVec2();
            this.m_impulse.mulLocal(solverData.step.dtRatio);
            vec24.set(this.m_impulse.x, this.m_impulse.y);
            vec2.x -= f5 * vec24.x;
            vec2.y -= f5 * vec24.y;
            f2 -= f7 * (Vec2.cross(this.m_rA, vec24) + this.m_impulse.z);
            vec22.x += f6 * vec24.x;
            vec22.y += f6 * vec24.y;
            f4 += f8 * (Vec2.cross(this.m_rB, vec24) + this.m_impulse.z);
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
        this.pool.pushMat33(1);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        float f3 = this.m_invMassA;
        float f4 = this.m_invMassB;
        float f5 = this.m_invIA;
        float f6 = this.m_invIB;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        if (this.m_frequencyHz > 0.0f) {
            float f7 = f2 - f;
            float f8 = -this.m_mass.ez.z * (f7 + this.m_bias + this.m_gamma * this.m_impulse.z);
            this.m_impulse.z += f8;
            Vec2.crossToOutUnsafe(f2 += f6 * f8, this.m_rB, vec23);
            Vec2.crossToOutUnsafe(f -= f5 * f8, this.m_rA, vec25);
            vec23.addLocal(vec22).subLocal(vec2).subLocal(vec25);
            Vec2 vec26 = vec24;
            Mat33.mul22ToOutUnsafe(this.m_mass, vec23, vec26);
            vec26.negateLocal();
            this.m_impulse.x += vec26.x;
            this.m_impulse.y += vec26.y;
            vec2.x -= f3 * vec24.x;
            vec2.y -= f3 * vec24.y;
            f -= f5 * Vec2.cross(this.m_rA, vec24);
            vec22.x += f4 * vec24.x;
            vec22.y += f4 * vec24.y;
            f2 += f6 * Vec2.cross(this.m_rB, vec24);
        } else {
            Vec2.crossToOutUnsafe(f, this.m_rA, vec25);
            Vec2.crossToOutUnsafe(f2, this.m_rB, vec23);
            vec23.addLocal(vec22).subLocal(vec2).subLocal(vec25);
            float f9 = f2 - f;
            Vec3 vec3 = this.pool.popVec3();
            vec3.set(vec23.x, vec23.y, f9);
            Vec3 vec32 = this.pool.popVec3();
            Mat33.mulToOutUnsafe(this.m_mass, vec3, vec32);
            vec32.negateLocal();
            this.m_impulse.addLocal(vec32);
            vec24.set(vec32.x, vec32.y);
            vec2.x -= f3 * vec24.x;
            vec2.y -= f3 * vec24.y;
            f -= f5 * (Vec2.cross(this.m_rA, vec24) + vec32.z);
            vec22.x += f4 * vec24.x;
            vec22.y += f4 * vec24.y;
            f2 += f6 * (Vec2.cross(this.m_rB, vec24) + vec32.z);
            this.pool.pushVec3(2);
        }
        solverData.velocities[this.m_indexA].w = f;
        solverData.velocities[this.m_indexB].w = f2;
        this.pool.pushVec2(3);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        float f;
        float f2;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f3 = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.positions[this.m_indexB].c;
        float f4 = solverData.positions[this.m_indexB].a;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        rot.set(f3);
        rot2.set(f4);
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec24);
        Rot.mulToOutUnsafe(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec25);
        Mat33 mat33 = this.pool.popMat33();
        Vec2 vec26 = this.pool.popVec2();
        Vec2 vec27 = this.pool.popVec2();
        mat33.ex.x = f5 + f6 + vec24.y * vec24.y * f7 + vec25.y * vec25.y * f8;
        mat33.ey.x = -vec24.y * vec24.x * f7 - vec25.y * vec25.x * f8;
        mat33.ez.x = -vec24.y * f7 - vec25.y * f8;
        mat33.ex.y = mat33.ey.x;
        mat33.ey.y = f5 + f6 + vec24.x * vec24.x * f7 + vec25.x * vec25.x * f8;
        mat33.ez.y = vec24.x * f7 + vec25.x * f8;
        mat33.ex.z = mat33.ez.x;
        mat33.ey.z = mat33.ez.y;
        mat33.ez.z = f7 + f8;
        if (this.m_frequencyHz > 0.0f) {
            vec26.set(vec22).addLocal(vec25).subLocal(vec2).subLocal(vec24);
            f2 = vec26.length();
            f = 0.0f;
            mat33.solve22ToOut(vec26, vec27);
            vec27.negateLocal();
            vec2.x -= f5 * vec27.x;
            vec2.y -= f5 * vec27.y;
            f3 -= f7 * Vec2.cross(vec24, vec27);
            vec22.x += f6 * vec27.x;
            vec22.y += f6 * vec27.y;
            f4 += f8 * Vec2.cross(vec25, vec27);
        } else {
            vec26.set(vec22).addLocal(vec25).subLocal(vec2).subLocal(vec24);
            float f9 = f4 - f3 - this.m_referenceAngle;
            f2 = vec26.length();
            f = MathUtils.abs(f9);
            Vec3 vec3 = this.pool.popVec3();
            Vec3 vec32 = this.pool.popVec3();
            vec3.set(vec26.x, vec26.y, f9);
            mat33.solve33ToOut(vec3, vec32);
            vec32.negateLocal();
            vec27.set(vec32.x, vec32.y);
            vec2.x -= f5 * vec27.x;
            vec2.y -= f5 * vec27.y;
            f3 -= f7 * (Vec2.cross(vec24, vec27) + vec32.z);
            vec22.x += f6 * vec27.x;
            vec22.y += f6 * vec27.y;
            f4 += f8 * (Vec2.cross(vec25, vec27) + vec32.z);
            this.pool.pushVec3(2);
        }
        solverData.positions[this.m_indexA].a = f3;
        solverData.positions[this.m_indexB].a = f4;
        this.pool.pushVec2(5);
        this.pool.pushRot(2);
        this.pool.pushMat33(1);
        return f2 <= Settings.linearSlop && f <= Settings.angularSlop;
    }
}

