/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.broadphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dbvt;
import com.bulletphysics.collision.broadphase.DbvtAabbMm;
import com.bulletphysics.collision.broadphase.DbvtProxy;
import com.bulletphysics.collision.broadphase.DbvtTreeCollider;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.HashedOverlappingPairCache;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import javax.vecmath.Vector3f;

public class DbvtBroadphase
implements BroadphaseInterface {
    public static final float DBVT_BP_MARGIN = 0.05f;
    public static final int DYNAMIC_SET = 0;
    public static final int FIXED_SET = 1;
    public static final int STAGECOUNT = 2;
    public final Dbvt[] sets = new Dbvt[2];
    public DbvtProxy[] stageRoots = new DbvtProxy[3];
    public OverlappingPairCache paircache;
    public float predictedframes;
    public int stageCurrent;
    public int fupdates;
    public int dupdates;
    public int pid;
    public int gid;
    public boolean releasepaircache;

    public DbvtBroadphase() {
        this(null);
    }

    public DbvtBroadphase(OverlappingPairCache overlappingPairCache) {
        this.sets[0] = new Dbvt();
        this.sets[1] = new Dbvt();
        this.releasepaircache = overlappingPairCache == null;
        this.predictedframes = 2.0f;
        this.stageCurrent = 0;
        this.fupdates = 1;
        this.dupdates = 1;
        this.paircache = overlappingPairCache != null ? overlappingPairCache : new HashedOverlappingPairCache();
        this.gid = 0;
        this.pid = 0;
        int n = 0;
        while (n <= 2) {
            this.stageRoots[n] = null;
            ++n;
        }
    }

    public void collide(Dispatcher dispatcher) {
        Object object;
        this.sets[0].optimizeIncremental(1 + this.sets[0].leaves * this.dupdates / 100);
        this.sets[1].optimizeIncremental(1 + this.sets[1].leaves * this.fupdates / 100);
        this.stageCurrent = (this.stageCurrent + 1) % 2;
        DbvtProxy dbvtProxy = this.stageRoots[this.stageCurrent];
        if (dbvtProxy != null) {
            DbvtProxy dbvtProxy2;
            object = new DbvtTreeCollider(this);
            do {
                dbvtProxy2 = dbvtProxy.links[1];
                this.stageRoots[dbvtProxy.stage] = DbvtBroadphase.listremove(dbvtProxy, this.stageRoots[dbvtProxy.stage]);
                this.stageRoots[2] = DbvtBroadphase.listappend(dbvtProxy, this.stageRoots[2]);
                Dbvt.collideTT(this.sets[1].root, dbvtProxy.leaf, (Dbvt.ICollide)object);
                this.sets[0].remove(dbvtProxy.leaf);
                dbvtProxy.leaf = this.sets[1].insert(dbvtProxy.aabb, dbvtProxy);
                dbvtProxy.stage = 2;
            } while ((dbvtProxy = dbvtProxy2) != null);
        }
        object = new DbvtTreeCollider(this);
        Dbvt.collideTT(this.sets[0].root, this.sets[1].root, (Dbvt.ICollide)object);
        Dbvt.collideTT(this.sets[0].root, this.sets[0].root, (Dbvt.ICollide)object);
        object = this.paircache.getOverlappingPairArray();
        if (object.size() > 0) {
            int n = 0;
            int n2 = object.size();
            while (n < n2) {
                BroadphasePair broadphasePair = (BroadphasePair)object.get(n);
                DbvtProxy dbvtProxy3 = (DbvtProxy)broadphasePair.pProxy0;
                DbvtProxy dbvtProxy4 = (DbvtProxy)broadphasePair.pProxy1;
                if (!DbvtAabbMm.Intersect(dbvtProxy3.aabb, dbvtProxy4.aabb)) {
                    if (dbvtProxy3.hashCode() > dbvtProxy4.hashCode()) {
                        DbvtProxy dbvtProxy5 = dbvtProxy3;
                        dbvtProxy3 = dbvtProxy4;
                        dbvtProxy4 = dbvtProxy5;
                    }
                    this.paircache.removeOverlappingPair(dbvtProxy3, dbvtProxy4, dispatcher);
                    --n2;
                    --n;
                }
                ++n;
            }
        }
        ++this.pid;
    }

    private static DbvtProxy listappend(DbvtProxy dbvtProxy, DbvtProxy dbvtProxy2) {
        dbvtProxy.links[0] = null;
        dbvtProxy.links[1] = dbvtProxy2;
        if (dbvtProxy2 != null) {
            dbvtProxy2.links[0] = dbvtProxy;
        }
        dbvtProxy2 = dbvtProxy;
        return dbvtProxy2;
    }

    private static DbvtProxy listremove(DbvtProxy dbvtProxy, DbvtProxy dbvtProxy2) {
        if (dbvtProxy.links[0] != null) {
            dbvtProxy.links[0].links[1] = dbvtProxy.links[1];
        } else {
            dbvtProxy2 = dbvtProxy.links[1];
        }
        if (dbvtProxy.links[1] != null) {
            dbvtProxy.links[1].links[0] = dbvtProxy.links[0];
        }
        return dbvtProxy2;
    }

    @Override
    public BroadphaseProxy createProxy(Vector3f vector3f, Vector3f vector3f2, BroadphaseNativeType broadphaseNativeType, Object object, short s, short s2, Dispatcher dispatcher, Object object2) {
        DbvtProxy dbvtProxy = new DbvtProxy(object, s, s2);
        DbvtAabbMm.FromMM(vector3f, vector3f2, dbvtProxy.aabb);
        dbvtProxy.leaf = this.sets[0].insert(dbvtProxy.aabb, dbvtProxy);
        dbvtProxy.stage = this.stageCurrent;
        dbvtProxy.uniqueId = ++this.gid;
        this.stageRoots[this.stageCurrent] = DbvtBroadphase.listappend(dbvtProxy, this.stageRoots[this.stageCurrent]);
        return dbvtProxy;
    }

    @Override
    public void destroyProxy(BroadphaseProxy broadphaseProxy, Dispatcher dispatcher) {
        DbvtProxy dbvtProxy = (DbvtProxy)broadphaseProxy;
        if (dbvtProxy.stage == 2) {
            this.sets[1].remove(dbvtProxy.leaf);
        } else {
            this.sets[0].remove(dbvtProxy.leaf);
        }
        this.stageRoots[dbvtProxy.stage] = DbvtBroadphase.listremove(dbvtProxy, this.stageRoots[dbvtProxy.stage]);
        this.paircache.removeOverlappingPairsContainingProxy(dbvtProxy, dispatcher);
    }

    @Override
    public void setAabb(BroadphaseProxy broadphaseProxy, Vector3f vector3f, Vector3f vector3f2, Dispatcher dispatcher) {
        DbvtProxy dbvtProxy = (DbvtProxy)broadphaseProxy;
        DbvtAabbMm dbvtAabbMm = DbvtAabbMm.FromMM(vector3f, vector3f2, new DbvtAabbMm());
        if (dbvtProxy.stage == 2) {
            this.sets[1].remove(dbvtProxy.leaf);
            dbvtProxy.leaf = this.sets[0].insert(dbvtAabbMm, dbvtProxy);
        } else if (DbvtAabbMm.Intersect(dbvtProxy.leaf.volume, dbvtAabbMm)) {
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.add(vector3f, vector3f2);
            vector3f3.scale(0.5f);
            Vector3f vector3f4 = dbvtProxy.aabb.Center((Vector3f)Pools.VECTORS.get());
            vector3f3.sub(vector3f4);
            vector3f3.scale(this.predictedframes);
            this.sets[0].update(dbvtProxy.leaf, dbvtAabbMm, vector3f3, 0.05f);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
        } else {
            this.sets[0].update(dbvtProxy.leaf, dbvtAabbMm);
        }
        this.stageRoots[dbvtProxy.stage] = DbvtBroadphase.listremove(dbvtProxy, this.stageRoots[dbvtProxy.stage]);
        dbvtProxy.aabb.set(dbvtAabbMm);
        dbvtProxy.stage = this.stageCurrent;
        this.stageRoots[this.stageCurrent] = DbvtBroadphase.listappend(dbvtProxy, this.stageRoots[this.stageCurrent]);
    }

    @Override
    public void calculateOverlappingPairs(Dispatcher dispatcher) {
        this.collide(dispatcher);
    }

    @Override
    public OverlappingPairCache getOverlappingPairCache() {
        return this.paircache;
    }

    @Override
    public void getBroadphaseAabb(Vector3f vector3f, Vector3f vector3f2) {
        DbvtAabbMm dbvtAabbMm = new DbvtAabbMm();
        if (!this.sets[0].empty()) {
            if (!this.sets[1].empty()) {
                DbvtAabbMm.Merge(this.sets[0].root.volume, this.sets[1].root.volume, dbvtAabbMm);
            } else {
                dbvtAabbMm.set(this.sets[0].root.volume);
            }
        } else if (!this.sets[1].empty()) {
            dbvtAabbMm.set(this.sets[1].root.volume);
        } else {
            DbvtAabbMm.FromCR(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, dbvtAabbMm);
        }
        vector3f.set(dbvtAabbMm.Mins());
        vector3f2.set(dbvtAabbMm.Maxs());
    }

    @Override
    public void printStats() {
    }
}

