/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.NodeOverlapCallback;
import com.bulletphysics.collision.shapes.OptimizedBvh;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.collision.shapes.TriangleMeshShape;
import com.bulletphysics.collision.shapes.VertexData;
import com.bulletphysics.linearmath.VectorUtil;
import gama.core.common.util.PoolUtils;
import javax.vecmath.Vector3f;

public class BvhTriangleMeshShape
extends TriangleMeshShape {
    public static final PoolUtils.ObjectPool<MyNodeOverlapCallback> NODE_OVERLAPS = PoolUtils.create((String)"MyNodeOverlapCallbacks", (boolean)true, () -> new MyNodeOverlapCallback(), null, null);
    private OptimizedBvh bvh = null;
    private boolean useQuantizedAabbCompression;
    private boolean ownsBvh;

    public BvhTriangleMeshShape() {
        super(null);
        this.ownsBvh = false;
    }

    public BvhTriangleMeshShape(StridingMeshInterface stridingMeshInterface, boolean bl) {
        this(stridingMeshInterface, bl, true);
    }

    public BvhTriangleMeshShape(StridingMeshInterface stridingMeshInterface, boolean bl, boolean bl2) {
        super(stridingMeshInterface);
        this.useQuantizedAabbCompression = bl;
        this.ownsBvh = false;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        stridingMeshInterface.calculateAabbBruteForce(vector3f, vector3f2);
        if (bl2) {
            this.bvh = new OptimizedBvh();
            this.bvh.build(stridingMeshInterface, bl, vector3f, vector3f2);
            this.ownsBvh = true;
            this.recalcLocalAabb();
        }
    }

    public BvhTriangleMeshShape(StridingMeshInterface stridingMeshInterface, boolean bl, Vector3f vector3f, Vector3f vector3f2) {
        this(stridingMeshInterface, bl, vector3f, vector3f2, true);
    }

    public BvhTriangleMeshShape(StridingMeshInterface stridingMeshInterface, boolean bl, Vector3f vector3f, Vector3f vector3f2, boolean bl2) {
        super(stridingMeshInterface);
        this.useQuantizedAabbCompression = bl;
        this.ownsBvh = false;
        if (bl2) {
            this.bvh = new OptimizedBvh();
            this.bvh.build(stridingMeshInterface, bl, vector3f, vector3f2);
            this.ownsBvh = true;
        }
        this.recalcLocalAabb();
    }

    public boolean getOwnsBvh() {
        return this.ownsBvh;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.TRIANGLE_MESH_SHAPE_PROXYTYPE;
    }

    public void performRaycast(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        MyNodeOverlapCallback myNodeOverlapCallback = (MyNodeOverlapCallback)NODE_OVERLAPS.get();
        myNodeOverlapCallback.init(triangleCallback, this.meshInterface);
        this.bvh.reportRayOverlappingNodex(myNodeOverlapCallback, vector3f, vector3f2);
        NODE_OVERLAPS.release((Object[])new MyNodeOverlapCallback[]{myNodeOverlapCallback});
    }

    public void performConvexcast(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        MyNodeOverlapCallback myNodeOverlapCallback = (MyNodeOverlapCallback)NODE_OVERLAPS.get();
        myNodeOverlapCallback.init(triangleCallback, this.meshInterface);
        this.bvh.reportBoxCastOverlappingNodex(myNodeOverlapCallback, vector3f, vector3f2, vector3f3, vector3f4);
        NODE_OVERLAPS.release((Object[])new MyNodeOverlapCallback[]{myNodeOverlapCallback});
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        MyNodeOverlapCallback myNodeOverlapCallback = (MyNodeOverlapCallback)NODE_OVERLAPS.get();
        myNodeOverlapCallback.init(triangleCallback, this.meshInterface);
        this.bvh.reportAabbOverlappingNodex(myNodeOverlapCallback, vector3f, vector3f2);
        NODE_OVERLAPS.release((Object[])new MyNodeOverlapCallback[]{myNodeOverlapCallback});
    }

    public void refitTree(Vector3f vector3f, Vector3f vector3f2) {
        this.bvh.refit(this.meshInterface);
        this.recalcLocalAabb();
    }

    public void partialRefitTree(Vector3f vector3f, Vector3f vector3f2) {
        this.bvh.refitPartial(this.meshInterface, vector3f, vector3f2);
        VectorUtil.setMin(this.localAabbMin, vector3f);
        VectorUtil.setMax(this.localAabbMax, vector3f2);
    }

    @Override
    public String getName() {
        return "BVHTRIANGLEMESH";
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = this.getLocalScaling((Vector3f)Pools.VECTORS.get());
        vector3f2.sub(vector3f3, vector3f);
        if (vector3f2.lengthSquared() > 1.1920929E-7f) {
            super.setLocalScaling(vector3f);
            this.bvh = new OptimizedBvh();
            this.bvh.build(this.meshInterface, this.useQuantizedAabbCompression, this.localAabbMin, this.localAabbMax);
            this.ownsBvh = true;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3});
    }

    public OptimizedBvh getOptimizedBvh() {
        return this.bvh;
    }

    public void setOptimizedBvh(OptimizedBvh optimizedBvh) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(1.0f, 1.0f, 1.0f);
        this.setOptimizedBvh(optimizedBvh, vector3f);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    public void setOptimizedBvh(OptimizedBvh optimizedBvh, Vector3f vector3f) {
        assert (this.bvh == null);
        assert (!this.ownsBvh);
        this.bvh = optimizedBvh;
        this.ownsBvh = false;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = this.getLocalScaling((Vector3f)Pools.VECTORS.get());
        vector3f2.sub(vector3f3, vector3f);
        if (vector3f2.lengthSquared() > 1.1920929E-7f) {
            super.setLocalScaling(vector3f);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3});
    }

    public boolean usesQuantizedAabbCompression() {
        return this.useQuantizedAabbCompression;
    }

    protected static class MyNodeOverlapCallback
    implements NodeOverlapCallback {
        public StridingMeshInterface meshInterface;
        public TriangleCallback callback;
        private final Vector3f[] triangle = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};

        public void init(TriangleCallback triangleCallback, StridingMeshInterface stridingMeshInterface) {
            this.meshInterface = stridingMeshInterface;
            this.callback = triangleCallback;
        }

        @Override
        public void processNode(int n, int n2) {
            VertexData vertexData = this.meshInterface.getLockedReadOnlyVertexIndexBase(n);
            Vector3f vector3f = this.meshInterface.getScaling((Vector3f)Pools.VECTORS.get());
            vertexData.getTriangle(n2 * 3, vector3f, this.triangle);
            this.callback.processTriangle(this.triangle, n, n2);
            this.meshInterface.unLockReadOnlyVertexBase(n);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        }
    }
}

