/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.vehicle;

import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleRaycasterResult;
import javax.vecmath.Vector3f;

public class DefaultVehicleRaycaster
extends VehicleRaycaster {
    protected DynamicsWorld dynamicsWorld;

    public DefaultVehicleRaycaster(DynamicsWorld dynamicsWorld) {
        this.dynamicsWorld = dynamicsWorld;
    }

    @Override
    public Object castRay(Vector3f vector3f, Vector3f vector3f2, VehicleRaycasterResult vehicleRaycasterResult) {
        RigidBody rigidBody;
        CollisionWorld.ClosestRayResultCallback closestRayResultCallback = new CollisionWorld.ClosestRayResultCallback(vector3f, vector3f2);
        this.dynamicsWorld.rayTest(vector3f, vector3f2, closestRayResultCallback);
        if (closestRayResultCallback.hasHit() && (rigidBody = RigidBody.upcast(closestRayResultCallback.collisionObject)) != null && rigidBody.hasContactResponse()) {
            vehicleRaycasterResult.hitPointInWorld.set(closestRayResultCallback.hitPointWorld);
            vehicleRaycasterResult.hitNormalInWorld.set(closestRayResultCallback.hitNormalWorld);
            vehicleRaycasterResult.hitNormalInWorld.normalize();
            vehicleRaycasterResult.distFraction = closestRayResultCallback.closestHitFraction;
            return rigidBody;
        }
        return null;
    }
}

