/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class SphereSphereCollisionAlgorithm
extends CollisionAlgorithm {
    private boolean ownManifold;
    private PersistentManifold manifoldPtr;
    private final Transform tmpTrans1 = (Transform)Pools.TRANSFORMS.get();
    private final Transform tmpTrans2 = (Transform)Pools.TRANSFORMS.get();
    private final Vector3f tmp = (Vector3f)Pools.VECTORS.get();
    private final Vector3f pos0 = (Vector3f)Pools.VECTORS.get();
    private final Vector3f pos1 = (Vector3f)Pools.VECTORS.get();

    public void init(PersistentManifold persistentManifold, CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
        super.init(collisionAlgorithmConstructionInfo);
        this.manifoldPtr = persistentManifold;
        if (this.manifoldPtr == null) {
            this.manifoldPtr = this.dispatcher.getNewManifold(collisionObject, collisionObject2);
            this.ownManifold = true;
        }
    }

    @Override
    public void init(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo) {
        super.init(collisionAlgorithmConstructionInfo);
    }

    @Override
    public void destroy() {
        if (this.ownManifold) {
            if (this.manifoldPtr != null) {
                this.dispatcher.releaseManifold(this.manifoldPtr);
            }
            this.manifoldPtr = null;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{this.tmpTrans1, this.tmpTrans2});
        Pools.VECTORS.release((Object[])new Vector3f[]{this.tmp, this.pos0, this.pos1});
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        if (this.manifoldPtr == null) {
            return;
        }
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        manifoldResult.setPersistentManifold(this.manifoldPtr);
        SphereShape sphereShape = (SphereShape)collisionObject.getCollisionShape();
        SphereShape sphereShape2 = (SphereShape)collisionObject2.getCollisionShape();
        vector3f.sub(collisionObject.getWorldTransform((Transform)this.tmpTrans1).origin, collisionObject2.getWorldTransform((Transform)this.tmpTrans2).origin);
        float f = vector3f.length();
        float f2 = sphereShape.getRadius();
        float f3 = sphereShape2.getRadius();
        if (f > f2 + f3) {
            manifoldResult.refreshContactPoints();
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            return;
        }
        float f4 = f - (f2 + f3);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(1.0f, 0.0f, 0.0f);
        if (f > 1.1920929E-7f) {
            vector3f2.scale(1.0f / f, vector3f);
        }
        this.tmp.scale(f2, vector3f2);
        this.pos0.sub(collisionObject.getWorldTransform((Transform)this.tmpTrans1).origin, this.tmp);
        this.tmp.scale(f3, vector3f2);
        this.pos1.add(collisionObject2.getWorldTransform((Transform)this.tmpTrans2).origin, this.tmp);
        manifoldResult.addContactPoint(vector3f2, this.pos1, f4);
        manifoldResult.refreshContactPoints();
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f});
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        return 1.0f;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        if (this.manifoldPtr != null && this.ownManifold) {
            arrayList.add(this.manifoldPtr);
        }
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            SphereSphereCollisionAlgorithm sphereSphereCollisionAlgorithm = (SphereSphereCollisionAlgorithm)Pools.SPHERE_SPHERE_COLLISIONS.get();
            sphereSphereCollisionAlgorithm.init(null, collisionAlgorithmConstructionInfo, collisionObject, collisionObject2);
            return sphereSphereCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.SPHERE_SPHERE_COLLISIONS.release((Object[])new SphereSphereCollisionAlgorithm[]{(SphereSphereCollisionAlgorithm)collisionAlgorithm});
        }
    }
}

