/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.narrowphase.ConvexPenetrationDepthSolver;
import com.bulletphysics.collision.narrowphase.DiscreteCollisionDetectorInterface;
import com.bulletphysics.collision.narrowphase.SimplexSolverInterface;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class GjkPairDetector
implements DiscreteCollisionDetectorInterface {
    private static final float REL_ERROR2 = 1.0E-6f;
    private final Vector3f cachedSeparatingAxis = new Vector3f();
    private ConvexPenetrationDepthSolver penetrationDepthSolver;
    private SimplexSolverInterface simplexSolver;
    private ConvexShape minkowskiA;
    private ConvexShape minkowskiB;
    private boolean ignoreMargin;
    public int lastUsedMethod;
    public int curIter;
    public int degenerateSimplex;
    public int catchDegeneracies;

    public void init(ConvexShape convexShape, ConvexShape convexShape2, SimplexSolverInterface simplexSolverInterface, ConvexPenetrationDepthSolver convexPenetrationDepthSolver) {
        this.cachedSeparatingAxis.set(0.0f, 0.0f, 1.0f);
        this.ignoreMargin = false;
        this.lastUsedMethod = -1;
        this.catchDegeneracies = 1;
        this.penetrationDepthSolver = convexPenetrationDepthSolver;
        this.simplexSolver = simplexSolverInterface;
        this.minkowskiA = convexShape;
        this.minkowskiB = convexShape2;
    }

    @Override
    public void getClosestPoints(DiscreteCollisionDetectorInterface.ClosestPointInput closestPointInput, DiscreteCollisionDetectorInterface.Result result, boolean bl) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        float f = 0.0f;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get((Object)closestPointInput.transformA);
        Transform transform2 = (Transform)Pools.TRANSFORMS.get((Object)closestPointInput.transformB);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.add(transform.origin, transform2.origin);
        vector3f5.scale(0.5f);
        transform.origin.sub(vector3f5);
        transform2.origin.sub(vector3f5);
        float f2 = this.minkowskiA.getMargin();
        float f3 = this.minkowskiB.getMargin();
        if (this.ignoreMargin) {
            f2 = 0.0f;
            f3 = 0.0f;
        }
        this.curIter = 0;
        int n = 1000;
        this.cachedSeparatingAxis.set(0.0f, 1.0f, 0.0f);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        this.degenerateSimplex = 0;
        this.lastUsedMethod = -1;
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f15 = (Vector3f)Pools.VECTORS.get();
        try {
            boolean bl5;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            block23: {
                boolean bl6;
                f8 = Float.MAX_VALUE;
                float f9 = 0.0f;
                f7 = f2 + f3;
                this.simplexSolver.reset();
                do {
                    vector3f6.negate(this.cachedSeparatingAxis);
                    MatrixUtil.transposeTransform(vector3f6, vector3f6, closestPointInput.transformA.basis);
                    vector3f7.set(this.cachedSeparatingAxis);
                    MatrixUtil.transposeTransform(vector3f7, vector3f7, closestPointInput.transformB.basis);
                    this.minkowskiA.localGetSupportingVertexWithoutMargin(vector3f6, vector3f8);
                    this.minkowskiB.localGetSupportingVertexWithoutMargin(vector3f7, vector3f9);
                    vector3f10.set(vector3f8);
                    transform.transform(vector3f10);
                    vector3f11.set(vector3f9);
                    transform2.transform(vector3f11);
                    vector3f12.sub(vector3f10, vector3f11);
                    f9 = this.cachedSeparatingAxis.dot(vector3f12);
                    if (f9 > 0.0f && f9 * f9 > f8 * closestPointInput.maximumDistanceSquared) {
                        bl4 = false;
                        break block23;
                    }
                    if (this.simplexSolver.inSimplex(vector3f12)) {
                        this.degenerateSimplex = 1;
                        bl3 = true;
                        break block23;
                    }
                    f6 = f8 - f9;
                    f5 = f8 * 1.0E-6f;
                    if (f6 <= f5) {
                        if (f6 <= 0.0f) {
                            this.degenerateSimplex = 2;
                        }
                        bl3 = true;
                        break block23;
                    }
                    this.simplexSolver.addVertex(vector3f12, vector3f10, vector3f11);
                    if (!this.simplexSolver.closest(this.cachedSeparatingAxis)) {
                        this.degenerateSimplex = 3;
                        bl3 = true;
                        break block23;
                    }
                    if (this.cachedSeparatingAxis.lengthSquared() < 1.0E-6f) {
                        this.degenerateSimplex = 6;
                        bl3 = true;
                        break block23;
                    }
                    f4 = f8;
                    if (f4 - (f8 = this.cachedSeparatingAxis.lengthSquared()) <= 1.1920929E-7f * f4) {
                        this.simplexSolver.backup_closest(this.cachedSeparatingAxis);
                        bl3 = true;
                        break block23;
                    }
                    if (this.curIter++ > n) break block23;
                } while (bl6 = !this.simplexSolver.fullSimplex());
                this.simplexSolver.backup_closest(this.cachedSeparatingAxis);
            }
            if (bl3) {
                this.simplexSolver.compute_points(vector3f3, vector3f4);
                vector3f2.sub(vector3f3, vector3f4);
                f6 = this.cachedSeparatingAxis.lengthSquared();
                if (f6 < 1.0E-4f) {
                    this.degenerateSimplex = 5;
                }
                if (f6 > 1.4210855E-14f) {
                    f5 = 1.0f / (float)Math.sqrt(f6);
                    vector3f2.scale(f5);
                    f4 = (float)Math.sqrt(f8);
                    assert (f4 > 0.0f);
                    vector3f.scale(f2 / f4, this.cachedSeparatingAxis);
                    vector3f3.sub(vector3f);
                    vector3f.scale(f3 / f4, this.cachedSeparatingAxis);
                    vector3f4.add(vector3f);
                    f = 1.0f / f5 - f7;
                    bl2 = true;
                    this.lastUsedMethod = 1;
                } else {
                    this.lastUsedMethod = 2;
                }
            }
            boolean bl7 = bl5 = this.catchDegeneracies != 0 && this.penetrationDepthSolver != null && this.degenerateSimplex != 0 && f + f7 < 0.01f;
            if (bl4 && (!bl2 || bl5) && this.penetrationDepthSolver != null) {
                boolean bl8 = this.penetrationDepthSolver.calcPenDepth(this.simplexSolver, this.minkowskiA, this.minkowskiB, transform, transform2, this.cachedSeparatingAxis, vector3f13, vector3f14);
                if (bl8) {
                    vector3f15.sub(vector3f14, vector3f13);
                    f4 = vector3f15.lengthSquared();
                    if (f4 > 1.4210855E-14f) {
                        vector3f15.scale(1.0f / (float)Math.sqrt(f4));
                        vector3f.sub(vector3f13, vector3f14);
                        float f10 = -vector3f.length();
                        if (!bl2 || f10 < f) {
                            f = f10;
                            vector3f3.set(vector3f13);
                            vector3f4.set(vector3f14);
                            vector3f2.set(vector3f15);
                            bl2 = true;
                            this.lastUsedMethod = 3;
                        }
                    } else {
                        this.lastUsedMethod = 4;
                    }
                } else {
                    this.lastUsedMethod = 5;
                }
            }
        }
        catch (Throwable throwable) {
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f8, vector3f9, vector3f10, vector3f11, vector3f12, vector3f13, vector3f14, vector3f15, vector3f, vector3f2, vector3f3, vector3f4, vector3f5});
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
            throw throwable;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f8, vector3f9, vector3f10, vector3f11, vector3f12, vector3f13, vector3f14, vector3f15, vector3f, vector3f2, vector3f3, vector3f4, vector3f5});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        if (bl2) {
            vector3f.add(vector3f4, vector3f5);
            result.addContactPoint(vector3f2, vector3f, f);
        }
    }

    public void setMinkowskiA(ConvexShape convexShape) {
        this.minkowskiA = convexShape;
    }

    public void setMinkowskiB(ConvexShape convexShape) {
        this.minkowskiB = convexShape;
    }

    public void setCachedSeperatingAxis(Vector3f vector3f) {
        this.cachedSeparatingAxis.set(vector3f);
    }

    public void setPenetrationDepthSolver(ConvexPenetrationDepthSolver convexPenetrationDepthSolver) {
        this.penetrationDepthSolver = convexPenetrationDepthSolver;
    }

    public void setIgnoreMargin(boolean bl) {
        this.ignoreMargin = bl;
    }
}

