/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dom;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class HeightfieldTerrainShape
extends ConcaveShape {
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int ZAXIS = 2;
    protected Vector3f m_localAabbMin = new Vector3f();
    protected Vector3f m_localAabbMax = new Vector3f();
    protected Vector3f m_localOrigin = new Vector3f();
    protected int m_heightStickWidth;
    protected int m_heightStickLength;
    protected float m_minHeight;
    protected float m_maxHeight;
    protected float m_width;
    protected float m_length;
    protected float m_heightScale;
    protected float[] m_heightfieldDataFloat;
    protected ScalarType m_heightDataType;
    protected boolean m_flipQuadEdges;
    protected boolean m_useDiamondSubdivision;
    protected int m_upAxis;
    protected Vector3f m_localScaling = new Vector3f();

    public HeightfieldTerrainShape(int n, int n2, float[] fArray, float f, float f2, float f3, int n3, boolean bl) {
        this.initialize(n, n2, fArray, f, f2, f3, n3, ScalarType.FLOAT, bl);
    }

    private void initialize(int n, int n2, float[] fArray, float f, float f2, float f3, int n3, ScalarType scalarType, boolean bl) {
        this.m_heightStickWidth = n;
        this.m_heightStickLength = n2;
        this.m_minHeight = f2 * f;
        this.m_maxHeight = f3 * f;
        this.m_width = n - 1;
        this.m_length = n2 - 1;
        this.m_heightScale = f;
        this.m_heightfieldDataFloat = fArray;
        this.m_heightDataType = ScalarType.FLOAT;
        this.m_flipQuadEdges = bl;
        this.m_useDiamondSubdivision = false;
        this.m_upAxis = n3;
        this.m_localScaling.set(1.0f, 1.0f, 1.0f);
        switch (this.m_upAxis) {
            case 0: {
                this.m_localAabbMin.set(this.m_minHeight, 0.0f, 0.0f);
                this.m_localAabbMax.set(this.m_maxHeight, this.m_width, this.m_length);
                break;
            }
            case 1: {
                this.m_localAabbMin.set(0.0f, this.m_minHeight, 0.0f);
                this.m_localAabbMax.set(this.m_width, this.m_maxHeight, this.m_length);
                break;
            }
            case 2: {
                this.m_localAabbMin.set(0.0f, 0.0f, this.m_minHeight);
                this.m_localAabbMax.set(this.m_width, this.m_length, this.m_maxHeight);
            }
        }
        this.m_localOrigin.set(this.m_localAabbMin);
        this.m_localOrigin.add(this.m_localAabbMax);
        this.m_localOrigin.x *= 0.5f;
        this.m_localOrigin.y *= 0.5f;
        this.m_localOrigin.z *= 0.5f;
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f3.x = vector3f.x * (1.0f / this.m_localScaling.x);
        vector3f3.y = vector3f.y * (1.0f / this.m_localScaling.y);
        vector3f3.z = vector3f.z * (1.0f / this.m_localScaling.z);
        vector3f4.x = vector3f2.x * (1.0f / this.m_localScaling.x);
        vector3f4.y = vector3f2.y * (1.0f / this.m_localScaling.y);
        vector3f4.z = vector3f2.z * (1.0f / this.m_localScaling.z);
        vector3f3.add(this.m_localOrigin);
        vector3f4.add(this.m_localOrigin);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        this.quantizeWithClamp(nArray, vector3f3);
        this.quantizeWithClamp(nArray2, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
        int n = 0;
        while (n < 3) {
            int n2 = n;
            nArray[n2] = nArray[n2] - 1;
            int n3 = n++;
            nArray2[n3] = nArray2[n3] + 1;
        }
        n = 0;
        int n4 = this.m_heightStickWidth - 1;
        int n5 = 0;
        int n6 = this.m_heightStickLength - 1;
        switch (this.m_upAxis) {
            case 0: {
                if (nArray[1] > n) {
                    n = nArray[1];
                }
                if (nArray2[1] < n4) {
                    n4 = nArray2[1];
                }
                if (nArray[2] > n5) {
                    n5 = nArray[2];
                }
                if (nArray2[2] >= n6) break;
                n6 = nArray2[2];
                break;
            }
            case 1: {
                if (nArray[0] > n) {
                    n = nArray[0];
                }
                if (nArray2[0] < n4) {
                    n4 = nArray2[0];
                }
                if (nArray[2] > n5) {
                    n5 = nArray[2];
                }
                if (nArray2[2] >= n6) break;
                n6 = nArray2[2];
                break;
            }
            case 2: {
                if (nArray[0] > n) {
                    n = nArray[0];
                }
                if (nArray2[0] < n4) {
                    n4 = nArray2[0];
                }
                if (nArray[1] > n5) {
                    n5 = nArray[1];
                }
                if (nArray2[1] >= n6) break;
                n6 = nArray2[1];
            }
        }
        int n7 = n5;
        while (n7 < n6) {
            int n8 = n;
            while (n8 < n4) {
                Object[] objectArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
                if (this.m_flipQuadEdges || this.m_useDiamondSubdivision && (n7 + n8 & 1) != 0) {
                    this.getVertex(n8, n7, objectArray[0]);
                    this.getVertex(n8 + 1, n7, objectArray[1]);
                    this.getVertex(n8 + 1, n7 + 1, objectArray[2]);
                    triangleCallback.processTriangle((Vector3f[])objectArray, n8, n7);
                    this.getVertex(n8, n7, objectArray[0]);
                    this.getVertex(n8 + 1, n7 + 1, objectArray[1]);
                    this.getVertex(n8, n7 + 1, objectArray[2]);
                    triangleCallback.processTriangle((Vector3f[])objectArray, n8, n7);
                } else {
                    this.getVertex(n8, n7, objectArray[0]);
                    this.getVertex(n8, n7 + 1, objectArray[1]);
                    this.getVertex(n8 + 1, n7, objectArray[2]);
                    triangleCallback.processTriangle((Vector3f[])objectArray, n8, n7);
                    this.getVertex(n8 + 1, n7, objectArray[0]);
                    this.getVertex(n8, n7 + 1, objectArray[1]);
                    this.getVertex(n8 + 1, n7 + 1, objectArray[2]);
                    triangleCallback.processTriangle((Vector3f[])objectArray, n8, n7);
                }
                Pools.VECTORS.release(objectArray);
                ++n8;
            }
            ++n7;
        }
    }

    private void getVertex(int n, int n2, Vector3f vector3f) {
        float f = this.getRawHeightFieldValue(n, n2);
        switch (this.m_upAxis) {
            case 0: {
                vector3f.set(f - this.m_localOrigin.x, -this.m_width / 2.0f + (float)n, -this.m_length / 2.0f + (float)n2);
                break;
            }
            case 1: {
                vector3f.set(-this.m_width / 2.0f + (float)n, f - this.m_localOrigin.y, -this.m_length / 2.0f + (float)n2);
                break;
            }
            case 2: {
                vector3f.set(-this.m_width / 2.0f + (float)n, -this.m_length / 2.0f + (float)n2, f - this.m_localOrigin.z);
            }
        }
        vector3f.x *= this.m_localScaling.x;
        vector3f.y *= this.m_localScaling.y;
        vector3f.z *= this.m_localScaling.z;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        vector3f.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get((Object)this.m_localAabbMax);
        vector3f3.sub(this.m_localAabbMin);
        vector3f3.x = vector3f3.x * this.m_localScaling.x * 0.5f;
        vector3f3.y = vector3f3.y * this.m_localScaling.y * 0.5f;
        vector3f3.z = vector3f3.z * this.m_localScaling.z * 0.5f;
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f4);
        vector3f6.x = vector3f4.dot(vector3f3);
        matrix3f.getRow(1, vector3f4);
        vector3f6.y = vector3f4.dot(vector3f3);
        matrix3f.getRow(2, vector3f4);
        vector3f6.z = vector3f4.dot(vector3f3);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.set(this.getMargin(), this.getMargin(), this.getMargin());
        vector3f6.add(vector3f7);
        vector3f.sub(vector3f5, vector3f6);
        vector3f2.add(vector3f5, vector3f6);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5, vector3f6, vector3f7, vector3f3});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        return this.m_localScaling;
    }

    @Override
    public String getName() {
        return "Terrain";
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.TERRAIN_SHAPE_PROXYTYPE;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.m_localScaling = vector3f;
    }

    private float getRawHeightFieldValue(int n, int n2) {
        return this.m_heightfieldDataFloat[n2 * this.m_heightStickWidth + n] * this.m_heightScale;
    }

    public static int getQuantized(float f) {
        if ((double)f < 0.0) {
            return (int)((double)f - 0.5);
        }
        return (int)((double)f + 0.5);
    }

    private void quantizeWithClamp(int[] nArray, Vector3f vector3f) {
        nArray[0] = HeightfieldTerrainShape.getQuantized(vector3f.x);
        nArray[1] = HeightfieldTerrainShape.getQuantized(vector3f.y);
        nArray[2] = HeightfieldTerrainShape.getQuantized(vector3f.z);
    }
}

