/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class SliderConstraint
extends TypedConstraint {
    public static final float SLIDER_CONSTRAINT_DEF_SOFTNESS = 1.0f;
    public static final float SLIDER_CONSTRAINT_DEF_DAMPING = 1.0f;
    public static final float SLIDER_CONSTRAINT_DEF_RESTITUTION = 0.7f;
    protected final Transform frameInA = new Transform();
    protected final Transform frameInB = new Transform();
    protected boolean useLinearReferenceFrameA;
    protected float lowerLinLimit;
    protected float upperLinLimit;
    protected float lowerAngLimit;
    protected float upperAngLimit;
    protected float softnessDirLin;
    protected float restitutionDirLin;
    protected float dampingDirLin;
    protected float softnessDirAng;
    protected float restitutionDirAng;
    protected float dampingDirAng;
    protected float softnessLimLin;
    protected float restitutionLimLin;
    protected float dampingLimLin;
    protected float softnessLimAng;
    protected float restitutionLimAng;
    protected float dampingLimAng;
    protected float softnessOrthoLin;
    protected float restitutionOrthoLin;
    protected float dampingOrthoLin;
    protected float softnessOrthoAng;
    protected float restitutionOrthoAng;
    protected float dampingOrthoAng;
    protected boolean solveLinLim;
    protected boolean solveAngLim;
    protected JacobianEntry[] jacLin = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    protected float[] jacLinDiagABInv = new float[3];
    protected JacobianEntry[] jacAng = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    protected float timeStep;
    protected final Transform calculatedTransformA = new Transform();
    protected final Transform calculatedTransformB = new Transform();
    protected final Vector3f sliderAxis = new Vector3f();
    protected final Vector3f realPivotAInW = new Vector3f();
    protected final Vector3f realPivotBInW = new Vector3f();
    protected final Vector3f projPivotInW = new Vector3f();
    protected final Vector3f delta = new Vector3f();
    protected final Vector3f depth = new Vector3f();
    protected final Vector3f relPosA = new Vector3f();
    protected final Vector3f relPosB = new Vector3f();
    protected float linPos;
    protected float angDepth;
    protected float kAngle;
    protected boolean poweredLinMotor;
    protected float targetLinMotorVelocity;
    protected float maxLinMotorForce;
    protected float accumulatedLinMotorImpulse;
    protected boolean poweredAngMotor;
    protected float targetAngMotorVelocity;
    protected float maxAngMotorForce;
    protected float accumulatedAngMotorImpulse;

    public SliderConstraint() {
        super(TypedConstraintType.SLIDER_CONSTRAINT_TYPE);
        this.useLinearReferenceFrameA = true;
        this.initParams();
    }

    public SliderConstraint(RigidBody rigidBody, RigidBody rigidBody2, Transform transform, Transform transform2, boolean bl) {
        super(TypedConstraintType.SLIDER_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.frameInA.set(transform);
        this.frameInB.set(transform2);
        this.useLinearReferenceFrameA = bl;
        this.initParams();
    }

    protected void initParams() {
        this.lowerLinLimit = 1.0f;
        this.upperLinLimit = -1.0f;
        this.lowerAngLimit = 0.0f;
        this.upperAngLimit = 0.0f;
        this.softnessDirLin = 1.0f;
        this.restitutionDirLin = 0.7f;
        this.dampingDirLin = 0.0f;
        this.softnessDirAng = 1.0f;
        this.restitutionDirAng = 0.7f;
        this.dampingDirAng = 0.0f;
        this.softnessOrthoLin = 1.0f;
        this.restitutionOrthoLin = 0.7f;
        this.dampingOrthoLin = 1.0f;
        this.softnessOrthoAng = 1.0f;
        this.restitutionOrthoAng = 0.7f;
        this.dampingOrthoAng = 1.0f;
        this.softnessLimLin = 1.0f;
        this.restitutionLimLin = 0.7f;
        this.dampingLimLin = 1.0f;
        this.softnessLimAng = 1.0f;
        this.restitutionLimAng = 0.7f;
        this.dampingLimAng = 1.0f;
        this.poweredLinMotor = false;
        this.targetLinMotorVelocity = 0.0f;
        this.maxLinMotorForce = 0.0f;
        this.accumulatedLinMotorImpulse = 0.0f;
        this.poweredAngMotor = false;
        this.targetAngMotorVelocity = 0.0f;
        this.maxAngMotorForce = 0.0f;
        this.accumulatedAngMotorImpulse = 0.0f;
    }

    @Override
    public void buildJacobian() {
        if (this.useLinearReferenceFrameA) {
            this.buildJacobianInt(this.rbA, this.rbB, this.frameInA, this.frameInB);
        } else {
            this.buildJacobianInt(this.rbB, this.rbA, this.frameInB, this.frameInA);
        }
    }

    @Override
    public void solveConstraint(float f) {
        this.timeStep = f;
        if (this.useLinearReferenceFrameA) {
            this.solveConstraintInt(this.rbA, this.rbB);
        } else {
            this.solveConstraintInt(this.rbB, this.rbA);
        }
    }

    public Transform getCalculatedTransformA(Transform transform) {
        transform.set(this.calculatedTransformA);
        return transform;
    }

    public Transform getCalculatedTransformB(Transform transform) {
        transform.set(this.calculatedTransformB);
        return transform;
    }

    public Transform getFrameOffsetA(Transform transform) {
        transform.set(this.frameInA);
        return transform;
    }

    public Transform getFrameOffsetB(Transform transform) {
        transform.set(this.frameInB);
        return transform;
    }

    public float getLowerLinLimit() {
        return this.lowerLinLimit;
    }

    public void setLowerLinLimit(float f) {
        this.lowerLinLimit = f;
    }

    public float getUpperLinLimit() {
        return this.upperLinLimit;
    }

    public void setUpperLinLimit(float f) {
        this.upperLinLimit = f;
    }

    public float getLowerAngLimit() {
        return this.lowerAngLimit;
    }

    public void setLowerAngLimit(float f) {
        this.lowerAngLimit = f;
    }

    public float getUpperAngLimit() {
        return this.upperAngLimit;
    }

    public void setUpperAngLimit(float f) {
        this.upperAngLimit = f;
    }

    public boolean getUseLinearReferenceFrameA() {
        return this.useLinearReferenceFrameA;
    }

    public float getSoftnessDirLin() {
        return this.softnessDirLin;
    }

    public float getRestitutionDirLin() {
        return this.restitutionDirLin;
    }

    public float getDampingDirLin() {
        return this.dampingDirLin;
    }

    public float getSoftnessDirAng() {
        return this.softnessDirAng;
    }

    public float getRestitutionDirAng() {
        return this.restitutionDirAng;
    }

    public float getDampingDirAng() {
        return this.dampingDirAng;
    }

    public float getSoftnessLimLin() {
        return this.softnessLimLin;
    }

    public float getRestitutionLimLin() {
        return this.restitutionLimLin;
    }

    public float getDampingLimLin() {
        return this.dampingLimLin;
    }

    public float getSoftnessLimAng() {
        return this.softnessLimAng;
    }

    public float getRestitutionLimAng() {
        return this.restitutionLimAng;
    }

    public float getDampingLimAng() {
        return this.dampingLimAng;
    }

    public float getSoftnessOrthoLin() {
        return this.softnessOrthoLin;
    }

    public float getRestitutionOrthoLin() {
        return this.restitutionOrthoLin;
    }

    public float getDampingOrthoLin() {
        return this.dampingOrthoLin;
    }

    public float getSoftnessOrthoAng() {
        return this.softnessOrthoAng;
    }

    public float getRestitutionOrthoAng() {
        return this.restitutionOrthoAng;
    }

    public float getDampingOrthoAng() {
        return this.dampingOrthoAng;
    }

    public void setSoftnessDirLin(float f) {
        this.softnessDirLin = f;
    }

    public void setRestitutionDirLin(float f) {
        this.restitutionDirLin = f;
    }

    public void setDampingDirLin(float f) {
        this.dampingDirLin = f;
    }

    public void setSoftnessDirAng(float f) {
        this.softnessDirAng = f;
    }

    public void setRestitutionDirAng(float f) {
        this.restitutionDirAng = f;
    }

    public void setDampingDirAng(float f) {
        this.dampingDirAng = f;
    }

    public void setSoftnessLimLin(float f) {
        this.softnessLimLin = f;
    }

    public void setRestitutionLimLin(float f) {
        this.restitutionLimLin = f;
    }

    public void setDampingLimLin(float f) {
        this.dampingLimLin = f;
    }

    public void setSoftnessLimAng(float f) {
        this.softnessLimAng = f;
    }

    public void setRestitutionLimAng(float f) {
        this.restitutionLimAng = f;
    }

    public void setDampingLimAng(float f) {
        this.dampingLimAng = f;
    }

    public void setSoftnessOrthoLin(float f) {
        this.softnessOrthoLin = f;
    }

    public void setRestitutionOrthoLin(float f) {
        this.restitutionOrthoLin = f;
    }

    public void setDampingOrthoLin(float f) {
        this.dampingOrthoLin = f;
    }

    public void setSoftnessOrthoAng(float f) {
        this.softnessOrthoAng = f;
    }

    public void setRestitutionOrthoAng(float f) {
        this.restitutionOrthoAng = f;
    }

    public void setDampingOrthoAng(float f) {
        this.dampingOrthoAng = f;
    }

    public void setPoweredLinMotor(boolean bl) {
        this.poweredLinMotor = bl;
    }

    public boolean getPoweredLinMotor() {
        return this.poweredLinMotor;
    }

    public void setTargetLinMotorVelocity(float f) {
        this.targetLinMotorVelocity = f;
    }

    public float getTargetLinMotorVelocity() {
        return this.targetLinMotorVelocity;
    }

    public void setMaxLinMotorForce(float f) {
        this.maxLinMotorForce = f;
    }

    public float getMaxLinMotorForce() {
        return this.maxLinMotorForce;
    }

    public void setPoweredAngMotor(boolean bl) {
        this.poweredAngMotor = bl;
    }

    public boolean getPoweredAngMotor() {
        return this.poweredAngMotor;
    }

    public void setTargetAngMotorVelocity(float f) {
        this.targetAngMotorVelocity = f;
    }

    public float getTargetAngMotorVelocity() {
        return this.targetAngMotorVelocity;
    }

    public void setMaxAngMotorForce(float f) {
        this.maxAngMotorForce = f;
    }

    public float getMaxAngMotorForce() {
        return this.maxAngMotorForce;
    }

    public float getLinearPos() {
        return this.linPos;
    }

    public boolean getSolveLinLimit() {
        return this.solveLinLim;
    }

    public float getLinDepth() {
        return this.depth.x;
    }

    public boolean getSolveAngLimit() {
        return this.solveAngLim;
    }

    public float getAngDepth() {
        return this.angDepth;
    }

    public void buildJacobianInt(RigidBody rigidBody, RigidBody rigidBody2, Transform transform, Transform transform2) {
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = (Transform)Pools.TRANSFORMS.get();
        Transform transform5 = (Transform)Pools.TRANSFORMS.get();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        try {
            Matrix3f matrix3f;
            Matrix3f matrix3f2;
            this.calculatedTransformA.mul(rigidBody.getCenterOfMassTransform(transform3), transform);
            this.calculatedTransformB.mul(rigidBody2.getCenterOfMassTransform(transform3), transform2);
            this.realPivotAInW.set(this.calculatedTransformA.origin);
            this.realPivotBInW.set(this.calculatedTransformB.origin);
            this.calculatedTransformA.basis.getColumn(0, vector3f);
            this.sliderAxis.set(vector3f);
            this.delta.sub(this.realPivotBInW, this.realPivotAInW);
            this.projPivotInW.scaleAdd(this.sliderAxis.dot(this.delta), this.sliderAxis, this.realPivotAInW);
            this.relPosA.sub(this.projPivotInW, rigidBody.getCenterOfMassPosition(vector3f));
            this.relPosB.sub(this.realPivotBInW, rigidBody2.getCenterOfMassPosition(vector3f));
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            int n = 0;
            while (n < 3) {
                this.calculatedTransformA.basis.getColumn(n, vector3f3);
                matrix3f2 = rigidBody.getCenterOfMassTransform((Transform)transform4).basis;
                matrix3f2.transpose();
                matrix3f = rigidBody2.getCenterOfMassTransform((Transform)transform5).basis;
                matrix3f.transpose();
                this.jacLin[n].init(matrix3f2, matrix3f, this.relPosA, this.relPosB, vector3f3, rigidBody.getInvInertiaDiagLocal(vector3f), rigidBody.getInvMass(), rigidBody2.getInvInertiaDiagLocal(vector3f2), rigidBody2.getInvMass());
                this.jacLinDiagABInv[n] = 1.0f / this.jacLin[n].getDiagonal();
                VectorUtil.setCoord(this.depth, n, this.delta.dot(vector3f3));
                ++n;
            }
            this.testLinLimits();
            n = 0;
            while (n < 3) {
                this.calculatedTransformA.basis.getColumn(n, vector3f3);
                matrix3f2 = rigidBody.getCenterOfMassTransform((Transform)transform4).basis;
                matrix3f2.transpose();
                matrix3f = rigidBody2.getCenterOfMassTransform((Transform)transform5).basis;
                matrix3f.transpose();
                this.jacAng[n].init(vector3f3, matrix3f2, matrix3f, rigidBody.getInvInertiaDiagLocal(vector3f), rigidBody2.getInvInertiaDiagLocal(vector3f2));
                ++n;
            }
            this.testAngLimits();
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            this.calculatedTransformA.basis.getColumn(0, vector3f4);
            this.kAngle = 1.0f / (rigidBody.computeAngularImpulseDenominator(vector3f4) + rigidBody2.computeAngularImpulseDenominator(vector3f4));
            this.accumulatedLinMotorImpulse = 0.0f;
            this.accumulatedAngMotorImpulse = 0.0f;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3});
        }
        catch (Throwable throwable) {
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform4, transform5});
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
            throw throwable;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform4, transform5});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    public void solveConstraintInt(RigidBody rigidBody, RigidBody rigidBody2) {
        float f;
        float f2;
        float f3;
        Vector3f vector3f;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = rigidBody.getVelocityInLocalPoint(this.relPosA, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = rigidBody2.getVelocityInLocalPoint(this.relPosB, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f3, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        int n = 0;
        while (n < 3) {
            float f4;
            float f5;
            vector3f = this.jacLin[n].linearJointAxis;
            float f6 = vector3f.dot(vector3f5);
            float f7 = VectorUtil.getCoord(this.depth, n);
            float f8 = n != 0 ? this.softnessOrthoLin : (f5 = this.solveLinLim ? this.softnessLimLin : this.softnessDirLin);
            float f9 = n != 0 ? this.restitutionOrthoLin : (f4 = this.solveLinLim ? this.restitutionLimLin : this.restitutionDirLin);
            float f10 = n != 0 ? this.dampingOrthoLin : (this.solveLinLim ? this.dampingLimLin : this.dampingDirLin);
            float f11 = f5 * (f4 * f7 / this.timeStep - f10 * f6) * this.jacLinDiagABInv[n];
            vector3f6.scale(f11, vector3f);
            rigidBody.applyImpulse(vector3f6, this.relPosA);
            vector3f2.negate(vector3f6);
            rigidBody2.applyImpulse(vector3f2, this.relPosB);
            if (this.poweredLinMotor && n == 0 && this.accumulatedLinMotorImpulse < this.maxLinMotorForce) {
                float f12 = this.targetLinMotorVelocity;
                f3 = f12 + f6;
                f11 = -f3 * this.jacLinDiagABInv[n];
                float f13 = this.accumulatedLinMotorImpulse + Math.abs(f11);
                if (f13 > this.maxLinMotorForce) {
                    f13 = this.maxLinMotorForce;
                }
                f2 = f13 - this.accumulatedLinMotorImpulse;
                f11 = f11 < 0.0f ? -f2 : f2;
                this.accumulatedLinMotorImpulse = f13;
                vector3f6.scale(f11, vector3f);
                rigidBody.applyImpulse(vector3f6, this.relPosA);
                vector3f2.negate(vector3f6);
                rigidBody2.applyImpulse(vector3f2, this.relPosB);
            }
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f5});
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        this.calculatedTransformA.basis.getColumn(0, vector3f7);
        vector3f = (Vector3f)Pools.VECTORS.get();
        this.calculatedTransformB.basis.getColumn(0, vector3f);
        Vector3f vector3f8 = rigidBody.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f9 = rigidBody2.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        vector3f10.scale(vector3f7.dot(vector3f8), vector3f7);
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        vector3f11.scale(vector3f.dot(vector3f9), vector3f);
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
        vector3f12.sub(vector3f8, vector3f10);
        Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get();
        vector3f13.sub(vector3f9, vector3f11);
        Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
        vector3f14.sub(vector3f12, vector3f13);
        f3 = vector3f14.length();
        if (f3 > 1.0E-5f) {
            Vector3f vector3f15 = (Vector3f)Pools.VECTORS.get();
            vector3f15.normalize(vector3f14);
            f2 = rigidBody.computeAngularImpulseDenominator(vector3f15) + rigidBody2.computeAngularImpulseDenominator(vector3f15);
            vector3f14.scale(1.0f / f2 * this.dampingOrthoAng * this.softnessOrthoAng);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f15});
        }
        Vector3f vector3f16 = (Vector3f)Pools.VECTORS.get();
        vector3f16.cross(vector3f7, vector3f);
        vector3f16.scale(1.0f / this.timeStep);
        f2 = vector3f16.length();
        if (f2 > 1.0E-5f) {
            Vector3f vector3f17 = (Vector3f)Pools.VECTORS.get();
            vector3f17.normalize(vector3f16);
            float f14 = rigidBody.computeAngularImpulseDenominator(vector3f17) + rigidBody2.computeAngularImpulseDenominator(vector3f17);
            vector3f16.scale(1.0f / f14 * this.restitutionOrthoAng * this.softnessOrthoAng);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f17});
        }
        vector3f2.negate(vector3f14);
        vector3f2.add(vector3f16);
        rigidBody.applyTorqueImpulse(vector3f2);
        vector3f2.sub(vector3f14, vector3f16);
        rigidBody2.applyTorqueImpulse(vector3f2);
        if (this.solveAngLim) {
            vector3f2.sub(vector3f9, vector3f8);
            f = vector3f2.dot(vector3f7) * this.dampingLimAng + this.angDepth * this.restitutionLimAng / this.timeStep;
            f *= this.kAngle * this.softnessLimAng;
        } else {
            vector3f2.sub(vector3f9, vector3f8);
            f = vector3f2.dot(vector3f7) * this.dampingDirAng + this.angDepth * this.restitutionDirAng / this.timeStep;
            f *= this.kAngle * this.softnessDirAng;
        }
        Vector3f vector3f18 = (Vector3f)Pools.VECTORS.get();
        vector3f18.scale(f, vector3f7);
        rigidBody.applyTorqueImpulse(vector3f18);
        vector3f2.negate(vector3f18);
        rigidBody2.applyTorqueImpulse(vector3f2);
        if (this.poweredAngMotor && this.accumulatedAngMotorImpulse < this.maxAngMotorForce) {
            Vector3f vector3f19 = (Vector3f)Pools.VECTORS.get();
            vector3f19.sub(vector3f10, vector3f11);
            float f15 = vector3f19.dot(vector3f7);
            float f16 = this.targetAngMotorVelocity;
            float f17 = f16 - f15;
            float f18 = this.kAngle * f17;
            float f19 = this.accumulatedAngMotorImpulse + Math.abs(f18);
            if (f19 > this.maxAngMotorForce) {
                f19 = this.maxAngMotorForce;
            }
            float f20 = f19 - this.accumulatedAngMotorImpulse;
            f18 = f18 < 0.0f ? -f20 : f20;
            this.accumulatedAngMotorImpulse = f19;
            Vector3f vector3f20 = (Vector3f)Pools.VECTORS.get();
            vector3f20.scale(f18, vector3f7);
            rigidBody.applyTorqueImpulse(vector3f20);
            vector3f2.negate(vector3f20);
            rigidBody2.applyTorqueImpulse(vector3f2);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f18, vector3f16, vector3f8, vector3f9, vector3f10, vector3f11, vector3f12, vector3f13, vector3f14, vector3f7, vector3f});
    }

    public void calculateTransforms() {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        if (this.useLinearReferenceFrameA) {
            this.calculatedTransformA.mul(this.rbA.getCenterOfMassTransform(transform), this.frameInA);
            this.calculatedTransformB.mul(this.rbB.getCenterOfMassTransform(transform), this.frameInB);
        } else {
            this.calculatedTransformA.mul(this.rbB.getCenterOfMassTransform(transform), this.frameInB);
            this.calculatedTransformB.mul(this.rbA.getCenterOfMassTransform(transform), this.frameInA);
        }
        this.realPivotAInW.set(this.calculatedTransformA.origin);
        this.realPivotBInW.set(this.calculatedTransformB.origin);
        this.calculatedTransformA.basis.getColumn(0, this.sliderAxis);
        this.delta.sub(this.realPivotBInW, this.realPivotAInW);
        this.projPivotInW.scaleAdd(this.sliderAxis.dot(this.delta), this.sliderAxis, this.realPivotAInW);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int n = 0;
        while (n < 3) {
            this.calculatedTransformA.basis.getColumn(n, vector3f);
            VectorUtil.setCoord(this.depth, n, this.delta.dot(vector3f));
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void testLinLimits() {
        this.solveLinLim = false;
        this.linPos = this.depth.x;
        if (this.lowerLinLimit <= this.upperLinLimit) {
            if (this.depth.x > this.upperLinLimit) {
                this.depth.x -= this.upperLinLimit;
                this.solveLinLim = true;
            } else if (this.depth.x < this.lowerLinLimit) {
                this.depth.x -= this.lowerLinLimit;
                this.solveLinLim = true;
            } else {
                this.depth.x = 0.0f;
            }
        } else {
            this.depth.x = 0.0f;
        }
    }

    public void testAngLimits() {
        this.angDepth = 0.0f;
        this.solveAngLim = false;
        if (this.lowerAngLimit <= this.upperAngLimit) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            this.calculatedTransformA.basis.getColumn(1, vector3f);
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            this.calculatedTransformA.basis.getColumn(2, vector3f2);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            this.calculatedTransformB.basis.getColumn(1, vector3f3);
            float f = (float)Math.atan2(vector3f3.dot(vector3f2), vector3f3.dot(vector3f));
            if (f < this.lowerAngLimit) {
                this.angDepth = f - this.lowerAngLimit;
                this.solveAngLim = true;
            } else if (f > this.upperAngLimit) {
                this.angDepth = f - this.upperAngLimit;
                this.solveAngLim = true;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
        }
    }

    public Vector3f getAncorInA(Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Vector3f vector3f2 = vector3f;
        vector3f2.scaleAdd((this.lowerLinLimit + this.upperLinLimit) * 0.5f, this.sliderAxis, this.realPivotAInW);
        this.rbA.getCenterOfMassTransform(transform);
        transform.inverse();
        transform.transform(vector3f2);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        return vector3f2;
    }

    public Vector3f getAncorInB(Vector3f vector3f) {
        Vector3f vector3f2 = vector3f;
        vector3f2.set(this.frameInB.origin);
        return vector3f2;
    }
}

