/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.common;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.extension.physics.common.IPhysicalEntity;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.species.ISpecies;

public interface IBody<WorldType, BodyType, ShapeType, VectorType>
extends IPhysicalEntity<VectorType> {
    default public float clamp(Double d) {
        float f;
        float f2 = f = d == null ? 0.0f : d.floatValue();
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    public BodyType getBody();

    public BodyType createAndInitializeBody(ShapeType var1, WorldType var2);

    default public boolean noContactNotificationWanted(IAgent iAgent) {
        ISpecies iSpecies = iAgent.getSpecies();
        SpeciesDescription speciesDescription = iSpecies.getDescription();
        return speciesDescription.getAction("contact_added_with").isBuiltIn() && speciesDescription.getAction("contact_removed_with").isBuiltIn();
    }

    default public void transferLocationAndRotationToAgent() {
    }

    public float getMass();

    public float getFriction();

    public float getRestitution();

    public float getLinearDamping();

    public float getAngularDamping();

    public float getContactDamping();

    public GamaPoint getAngularVelocity(GamaPoint var1);

    public GamaPoint getLinearVelocity(GamaPoint var1);

    public IShape getAABB();

    public void setMass(Double var1);

    public void setCCD(boolean var1);

    public void setFriction(Double var1);

    public void setRestitution(Double var1);

    public void setDamping(Double var1);

    public void setAngularDamping(Double var1);

    public void setContactDamping(Double var1);

    public void setAngularVelocity(GamaPoint var1);

    public void setLinearVelocity(GamaPoint var1);

    public void setLocation(GamaPoint var1);

    public void clearForces();

    public void applyImpulse(GamaPoint var1);

    public void applyTorque(GamaPoint var1);

    public void applyForce(GamaPoint var1);

    default public boolean isNoNotification() {
        return true;
    }

    public IAgent getAgent();
}

