/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IPhysicalConstants;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import gama.gaml.skills.Skill;
import java.util.HashMap;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="mass", type=2, init="1.0", doc={@GamlAnnotations.doc(value="The mass of the agent. Should be equal to 0.0 for static, motionless agents")}), @GamlAnnotations.variable(name="rotation", type=9, of=7, index=2, init="0.0::{0,0,1}", doc={@GamlAnnotations.doc(value="The rotation of the physical body, expressed as a pair which key is the angle in degrees and value the axis around which it is measured")}), @GamlAnnotations.variable(name="friction", type=2, init="0.5", doc={@GamlAnnotations.doc(value="Between 0 and 1. The coefficient of friction of the agent (how much it decelerates the agents in contact with him). Default is 0.5")}), @GamlAnnotations.variable(name="restitution", type=2, init="0.0", doc={@GamlAnnotations.doc(value="Between 0 and 1. The coefficient of restitution of the agent (defines the 'bounciness' of the agent). Default is 0")}), @GamlAnnotations.variable(name="aabb", type=13, doc={@GamlAnnotations.doc(value="The axis-aligned bounding box. A box used to evaluate the probability of contacts between objects. Can be displayed as any other GAMA shapes/geometries in order to verify that the physical representation of the agent corresponds to its geometry in the model")})})
@GamlAnnotations.skill(name="static_body", concept={"skill", "3d"}, doc={@GamlAnnotations.doc(value="A skill allowing an agent to b a static object in a physical 3D world (if it is also registered in a model inheriting from 'physical_world'). Proposes a number of new attributes ('friction', 'restitution',...) and the actions called 'contact_added_with'/'contact_removed_with' in order for the agent to be informed when it is in physical contact with an other. These actions will be called in turn for each colliding agent. ")})
public class StaticBodySkill
extends Skill
implements IPhysicalConstants {
    protected IBody getBody(IAgent iAgent) {
        IBody iBody = (IBody)iAgent.getAttribute("%%rigid_body%%");
        if (iBody == null) {
            iBody = new FakeBody();
            iAgent.setAttribute("%%rigid_body%%", (Object)iBody);
        }
        return iBody;
    }

    @GamlAnnotations.getter(value="mass", initializer=true)
    public Double getMass(IAgent iAgent) {
        return 0.0;
    }

    @GamlAnnotations.setter(value="mass")
    public void setMass(IAgent iAgent, Double d) {
    }

    @GamlAnnotations.listener(value="location")
    public void changeInLocation(IAgent iAgent, GamaPoint gamaPoint) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setLocation(gamaPoint);
    }

    @GamlAnnotations.listener(value="heading")
    public void changeInHeading(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        GamaPoint gamaPoint = new GamaPoint();
        iBody.getLinearVelocity(gamaPoint);
        double d2 = Math.toRadians(d);
        double d3 = gamaPoint.norm();
        gamaPoint.setLocation(d3 * Math.cos(d2), d3 * Math.sin(d2), 0.0);
        iBody.setLinearVelocity(gamaPoint);
    }

    @GamlAnnotations.listener(value="speed")
    public void changeInSpeed(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        if (d <= 0.0) {
            iBody.setLinearVelocity(new GamaPoint());
            return;
        }
        GamaPoint gamaPoint = new GamaPoint();
        iBody.getLinearVelocity(gamaPoint);
        double d2 = Math.atan2(gamaPoint.x, gamaPoint.y);
        if (d2 <= 0.0) {
            iBody.setLinearVelocity(new GamaPoint(0.7 * d, 0.7 * d));
        } else {
            double d3 = d / d2;
            gamaPoint.setLocation(d3 * gamaPoint.x, d3 * gamaPoint.y, 0.0);
            iBody.setLinearVelocity(gamaPoint);
        }
    }

    @GamlAnnotations.getter(value="aabb")
    public IShape getAABB(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return null;
        }
        return iBody.getAABB();
    }

    @GamlAnnotations.getter(value="friction")
    public Double getFriction(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getFriction();
    }

    @GamlAnnotations.setter(value="friction")
    public void setFriction(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setFriction(d);
    }

    @GamlAnnotations.getter(value="restitution")
    public Double getRestitution(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getRestitution();
    }

    @GamlAnnotations.setter(value="restitution")
    public void setRestitution(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setRestitution(d);
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="This action must be called when the geometry of the agent changes in the simulation world and this change must be propagated to the physical world. The change of location (in either worlds) or the rotation due to physical forces do not count as changes, as they are already taken into account. However, a rotation in the simulation world need to be handled by calling this action. As it involves long operations (removing the agent from the physical world, then reinserting it with its new shape), this action should not be called too often.")}, name="update_body", args={})
    public Object primUpdateGeometry(IScope iScope) {
        SimulationAgent simulationAgent = iScope.getSimulation();
        if (simulationAgent instanceof PhysicalSimulationAgent) {
            ((PhysicalSimulationAgent)simulationAgent).updateAgent(iScope, iScope.getAgent());
        }
        return null;
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="This action can be redefined in order for the agent to implement a specific behavior when it comes into contact (collision) with another agent. It is automatically called by the physics simulation engine on both colliding agents. The default built-in behavior does nothing.")}, name="contact_added_with", args={@GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="represents the other agent with which a collision has been detected")}, name="other", optional=false, type=11)})
    public Object primContactAdded(IScope iScope) {
        return null;
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="This action can be redefined in order for the agent to implement a specific behavior when a previous contact with another agent is removed. It is automatically called by the physics simulation engine on both colliding agents. The default built-in behavior does nothing.")}, name="contact_removed_with", args={@GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="represents the other agent with which a collision has been detected")}, name="other", optional=false, type=11)})
    public Object primContactDestroyed(IScope iScope) {
        return null;
    }

    public class FakeBody
    implements IBody<Object, Object, Object, GamaPoint> {
        public final Map<String, Object> values = new HashMap<String, Object>();

        @Override
        public float getFriction() {
            Double d = (Double)this.values.get("friction");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public float getRestitution() {
            Double d = (Double)this.values.get("restitution");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public float getLinearDamping() {
            Double d = (Double)this.values.get("damping");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public float getAngularDamping() {
            Double d = (Double)this.values.get("angular_damping");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public GamaPoint getAngularVelocity(GamaPoint gamaPoint) {
            GamaPoint gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
            GamaPoint gamaPoint3 = (GamaPoint)this.values.get("angular_velocity");
            if (gamaPoint3 == null) {
                gamaPoint2.setLocation(0.0, 0.0, 0.0);
            } else {
                gamaPoint2.setLocation(gamaPoint3);
            }
            return gamaPoint2;
        }

        @Override
        public GamaPoint getLinearVelocity(GamaPoint gamaPoint) {
            GamaPoint gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
            GamaPoint gamaPoint3 = (GamaPoint)this.values.get("velocity");
            if (gamaPoint3 == null) {
                gamaPoint2.setLocation(0.0, 0.0, 0.0);
            } else {
                gamaPoint2.setLocation(gamaPoint3);
            }
            return gamaPoint2;
        }

        @Override
        public void setCCD(boolean bl) {
            this.values.put("CCD", bl);
        }

        @Override
        public void setFriction(Double d) {
            this.values.put("friction", d);
        }

        @Override
        public void setRestitution(Double d) {
            this.values.put("restitution", d);
        }

        @Override
        public void setDamping(Double d) {
            this.values.put("damping", d);
        }

        @Override
        public void setAngularDamping(Double d) {
            this.values.put("angular_damping", d);
        }

        @Override
        public void setAngularVelocity(GamaPoint gamaPoint) {
            this.values.put("angular_velocity", gamaPoint);
        }

        @Override
        public void setLinearVelocity(GamaPoint gamaPoint) {
            this.values.put("velocity", gamaPoint);
        }

        @Override
        public void setLocation(GamaPoint gamaPoint) {
        }

        @Override
        public void clearForces() {
        }

        @Override
        public void applyImpulse(GamaPoint gamaPoint) {
        }

        @Override
        public void applyTorque(GamaPoint gamaPoint) {
        }

        @Override
        public void applyForce(GamaPoint gamaPoint) {
        }

        @Override
        public void setMass(Double d) {
            this.values.put("mass", d);
        }

        @Override
        public float getMass() {
            Double d = (Double)this.values.get("mass");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public IShape getAABB() {
            return null;
        }

        @Override
        public float getContactDamping() {
            Double d = (Double)this.values.get("contact_damping");
            return d != null ? d.floatValue() : 0.0f;
        }

        @Override
        public void setContactDamping(Double d) {
            this.values.put("contact_damping", d);
        }

        @Override
        public Object getBody() {
            return this;
        }

        @Override
        public IAgent getAgent() {
            return null;
        }

        @Override
        public GamaPoint toVector(GamaPoint gamaPoint) {
            return gamaPoint;
        }

        @Override
        public GamaPoint toGamaPoint(GamaPoint gamaPoint) {
            return gamaPoint;
        }

        @Override
        public Object createAndInitializeBody(Object object, Object object2) {
            return this;
        }
    }
}

